/* Console Csound using the Csound API. */

#include <cstdio>
#include <cstdarg>
#include <cstdlib>
#include <cstring>
#include <csound/csound.h>

#if defined HAVE_FLTK
#include <FL/Fl.H>

namespace {
  int yield(void *data)
  {
    Fl::check();
    return 1;
  }
}
#endif

int main(int argc, char **argv)
{
  /* set stdout to non buffering if not outputting to console window */
  if(!isatty(fileno(stdout))) {
    setvbuf(stdout, (char *)NULL, _IONBF, 0);
  }

  void *csound = csoundCreate(0);
#if defined HAVE_FLTK
  csoundSetYieldCallback(csound, yield);
#endif
  int rc = csoundPerform(csound, argc, argv);
  csoundCleanup(csound);
  csoundReset(csound);
  csoundDestroy(csound);
  return rc;
}
