
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: stmt.m,v 1.14 2001/03/14 19:17:56 stes Exp $
 */

#include <assert.h>
#include <stdlib.h>
#include <curses.h>
#include <signal.h>
#ifdef HAVE_REGEX_H
#include <regex.h>
#endif
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <unistd.h>
#include <Object.h>
#include <ordcltn.h>
#include <ocstring.h>
#include "process.h"
#include "var.h"
#include "frame.h"
#include "stmt.h"
#include "cursel.h"
#include "doubleq.h"
#include "singleq.h"
#include "redirect.h"
#include "coroute.h"

@implementation Statement

- maketest
{
  if (!words) words=[OrdCltn new];
  [words addFirst:[String str:"test "]];
  return self;
}

- add:x
{
  if (!words) words=[OrdCltn new];
  [words add:x];
  return self;
}

- setargv
{
  int i,n;

  if (!words) return self;
  tokens = splitwords(words);

  return self;
}

- changedir
{
  int ok;
  if ([tokens size] == 1) {
    ok=chdir(getenv("HOME"));
  }
  if ([tokens size] == 2) {
    ok=chdir([[tokens at:1] str]);
  } 
  return self;
}

- printdir
{
  char buf[PATH_MAX+1];
  getcwd(buf,PATH_MAX);
  [self dstwrite:buf];
  return self;
}

static int maxline;

- readfile
{
  int linesize;
  int i,n,len,ok;
  char buf[BUFSIZ+1];
  for(i=1,n=[tokens size];i<n;i++) {
     int fd = open([[tokens at:i] str],O_RDONLY);
     if (!fd) { exitcode=1;return self; }
     linesize = 0;
     while ((len=read(fd,buf,BUFSIZ))) {
       int j;
       for(j=0;j<len;j++) {
         linesize++;
         if (buf[j]=='\n') {
           if (linesize>maxline) maxline=linesize;
           linesize=0;
         }
       }
       buf[len]='\0';
       [self dstwrite:buf];
     }
     ok=close(fd);
     assert(ok == 0);
  } 
  return self;
}

- longline
{
  int ok;
  char buf[BUFSIZ+1];
  sprintf(buf,"%i",maxline);
  [self dstwrite:buf];
  return self;
}

- echo
{
  return self;
}

- regex
{
#ifdef HAVE_REGEX_H
  int ok;
  int es;
  int cmd;
  id s,pat;
  char *buf = "false"; 
  int i,n = [tokens size];

  for(i=1;i<n;i++) {
    char *t = [[tokens at:i] str];
    if (!strcmp(t,"-e")) { es++; continue; }
    if (!strcmp(t,"-v")) { cmd++; continue; }
    break;
  }

  if (cmd) {
     s = (i<n)?[tokens at:i++]:nil;
  } else {
     s = strfromfd([String new],srcfd);
  }

  pat = (i<n)?[tokens at:i++]:nil;
 
  if (s!=nil && pat!=nil) {
    regex_t preg;
    if (0 == regcomp(&preg,[pat str],REG_EXTENDED)) {
      if (REG_NOMATCH != regexec(&preg,[s str],0,NULL,0)) {
        buf = "true";
      }
    }
    dbg("regex %s %s %s\n",[s str],[pat str],buf);
  }

  [self dstwrite:buf];
#endif
  return self;
}

- dupfds:c
{
  [c setsrcfd:srcfd];
  if (dstbuf) {
  [c setdstbuf:dstbuf];
  } else {
  [c setdstfd:dstfd];
  }
  if (errbuf) {
  [c seterrbuf:errbuf];
  } else {
  [c seterrfd:errfd];
  }
  return self;
}

- cocreate
{
  id c = [Coroutine new];
  [self dupfds:c];
  [c cocreate:tokens];
  return self;
}

- cosend
{
  id c = [Coroutine findidentifier:tokens];
  [self dupfds:c];
  [c cosend:tokens];
  return self;
}

- cocheck
{
  id c = [Coroutine findidentifier:tokens];
  [self dupfds:c];
  [c cocheck:tokens];
  return self;
}

- coreceive
{
  id c = [Coroutine findidentifier:tokens];
  [self dupfds:c];
  [c coreceive:tokens];
  return self;
}

- codestroy
{
  id c = [Coroutine findidentifier:tokens];
  [self dupfds:c];
  [c codestroy:tokens];
  return self;
}

- message
{
  id s;
  int numbell = 0;
  BOOL frame = NO;
  BOOL permanent = NO;
  BOOL transient = YES;
  BOOL duptostdout = NO;
  
  int i,n = [tokens size];

  for(i=1;i<n;i++) {
    char *t = [[tokens at:i] str];
    if (!strcmp(t,"-t")) { transient++; continue; }
    if (!strcmp(t,"-p")) { permanent++; continue; }
    if (!strcmp(t,"-f")) { frame++; continue; }
    if (!strcmp(t,"-o")) { duptostdout++; continue; }
    if (!strcmp(t,"-b")) {
      if (i+1==n) {
        numbell++;
      } else {
        i++;numbell = atoi([[tokens at:i] str]);
      }
      continue;
    }
    break;
  }

  if (i<n) {
     s = [String new];
     [s concat:[tokens at:i]];
     for(++i;i<n;i++) { [s concatSTR:" "];[s concat:[tokens at:i]]; }
  } else {
     s = strfromfd([String new],srcfd);
  }

  if (transient) showtransientmessage([s str]);
  if (permanent) g_permanentmsg=s;
  if (frame && activeframe!=nil) [activeframe setframemsg:mkdesc([s str])];
  while (numbell--) {
    beep();
    sleep(1);
  }
  if (duptostdout) [self dstwrite:[s str]];

  return self;
}

- setvar
{
  int i,n;
  char *q;
  BOOL env = NO;
  char *fn = NULL;
  for(i=1,n=[tokens size];i<n;i++) {
    char *s = [[tokens at:i] str];
    if (!strncmp(s,"-f",2)) { fn = s+2;continue; }
    if (!strncmp(s,"-l",2)) continue;
    if (!strncmp(s,"-e",2)) { env=YES;continue; }
    if ((q=strchr(s,'='))) {
      id v;
      v = [String str:q+1];
      *q = '\0';
      [Var define:s as:v env:env filename:fn];
    } else {
      [Var define:s as:strfromfd([String new],srcfd) env:env filename:fn];
    }
  } 
  return self;
}

- unsetvar
{
  int i,n;
  for(i=1,n=[tokens size];i<n;i++) {
    char *s = [[tokens at:i] str];
    if (!strncmp(s,"-f",2)) continue;
    if (!strncmp(s,"-l",2)) continue;
    [Var undefine:s];
  } 
  return self;
}

- getfrm
{
  char buf[128];
  sprintf(buf,"%i",[curframe num]);
  [self dstwrite:buf];
  return self;
}

- getitems
{
  char *delim = "\n";
  if ([tokens size] == 2) delim = [[tokens at:1] str];
  [curframe writeOn:self delim:delim];
  return self;
}

- run
{
  doruncommand(tokens);
  return self;
}

- btincmd
{
  char *s;
  if (words == nil || [tokens size] == 0) return self;

  s=[[tokens at:0] str];
  if (!strcmp(s,"cd")) { return [self changedir]; }
  if (!strcmp(s,"pwd")) { return [self printdir]; }
  if (!strcmp(s,"message")) { return [self message]; }
  if (!strcmp(s,"regex")) { return [self regex]; }
  if (!strcmp(s,"cocreate")) { return [self cocreate]; }
  if (!strcmp(s,"cosend")) { return [self cosend]; }
  if (!strcmp(s,"cocheck")) { return [self cocheck]; }
  if (!strcmp(s,"coreceive")) { return [self coreceive]; }
  if (!strcmp(s,"codestroy")) { return [self codestroy]; }
  if (!strcmp(s,"readfile")) { return [self readfile]; }
  if (!strcmp(s,"longline")) { return [self longline]; }
  if (!strcmp(s,"set")) { return [self setvar]; }
  if (!strcmp(s,"run")) { return [self run]; }
  if (!strcmp(s,"unset")) { return [self unsetvar]; }
  if (!strcmp(s,"getfrm")) { return [self getfrm]; }
  if (!strcmp(s,"getitems")) { return [self getitems]; }

  return nil;
}

- go
{
  int fd[2];
  int dfd[2];
  int efd[2];
  int i,n,ok;

  fd[1]=-1; efd[1]=-1; dfd[1]=-1;

  /* first statement in a pipeline */
  if (makepipe) {
    assert(dstbuf == nil);
    ok = pipe(fd);
    assert(ok == 0);
    pipefd = fd[0];
    dstfd = fd[1];
  }

  /* set srcfd,dstfd,errfd if redirected */
  [self openredirs];

  [self setargv];

  if (words == nil || [self btincmd]) {
    pid = 0;ok = 1;
  } else {

    if (background) [self setsigchldhandler];

    if (dstbuf) { ok=pipe(dfd);assert(ok == 0);dstfd = dfd[1]; }
    if (errbuf) { ok=pipe(efd);assert(ok == 0);errfd = efd[1]; }

    ok = fork();
    assert(ok != -1);

    pid = (background)?0:ok;
  }

  if (ok) {
    if (fd[1]>=0) {
      ok = close(dstfd);assert(ok == 0);
    }
    if (dfd[1]>=0) {
      ok = close(dstfd);assert(ok == 0);
      dstbuf = strfromfd(dstbuf,dfd[0]);
      ok = close(dfd[0]);assert(ok == 0);
    }
    if (efd[1]>=0) {
      ok = close(errfd);assert(ok == 0);
      errbuf = strfromfd(errbuf,efd[0]);
      ok = close(efd[0]);assert(ok == 0);
    }
  } else {
    char **argv;

    ok = dup2(srcfd,0);assert(ok == 0);
    ok = dup2(dstfd,1);assert(ok == 1);
    ok = dup2(errfd,2);assert(ok == 2);

    n = [tokens size];
    argv = (char**)malloc(sizeof(char*) * (n+1));
    for(i=0;i<n;i++) {
     argv[i] = [[tokens at:i] str];
    }
    argv[n]=NULL;
    [Frame unblockalarm];
    signal(SIGINT,(u_interrupt)?SIG_DFL:SIG_IGN);
    ok = execvp(argv[0],argv);
    if (ok == -1) {
      sfwrite(2,"cursel: ");
      sfwrite(2,argv[0]);
      sfwrite(2,": ");
      sfwrite(2,strerror(errno));
    }
    _exit(0);
  }

  [self closeredirs];
  return self;
}

@end

