/* MP3.h - this file is part of Cynthiune
 *
 * Copyright (C) 2002, 2003, 2004 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef MP3_H
#define MP3_H

@protocol Format;

#define IBUFFER_SIZE 8192

typedef mad_fixed_t MadFixed;

typedef struct _audioDither {
  MadFixed error[3];
  MadFixed random;
} audioDither;

typedef enum _InputBufferStatus
{
  BufferHasUnrecoverableError = -2,
  BufferHasRecoverableError = -1,
  BufferHasNoError = 0
} InputBufferStatus;

typedef struct mad_frame MadFrame;
typedef struct mad_stream MadStream;
typedef struct mad_synth MadSynth;
typedef struct mad_bitptr MadBitPtr;

typedef id3_ucs4_t Id3UCS4;

typedef union id3_field Id3Field;
typedef struct id3_file Id3File;
typedef struct id3_frame Id3Frame;
typedef struct id3_tag Id3Tag;

@interface MP3 : NSObject <CynthiuneBundle, Format>
{
  unsigned int channels;
  unsigned long rate;
  unsigned int duration;
  unsigned int size;

  BOOL opened;

  FILE *mf;

  Id3File *id3File;
  Id3Tag *id3Tag;

  MadFrame frame;
  MadStream stream;
  MadSynth synth;

  int iRemain, oRemain;
  unsigned char iBuffer[IBUFFER_SIZE];
  struct xing xing;

  audioDither leftDither, rightDither;
}

@end

typedef struct {
    @defs (MP3);
} CMp3;

#endif /* MP3_H */
