/* Playlist.h - this file is part of Cynthiune
 *
 * Copyright (C) 2003, 2004  Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <Wolfgang@Contre.COM>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef Playlist_H
#define Playlist_H

@class NSMutableArray;
@class Song;

@interface Playlist : NSObject
{
  id delegate;

  BOOL shuffle;
  BOOL repeat;

  int currentSongNumber;

  NSMutableArray *_regularList;
  NSMutableArray *_shuffleList;
}

- (id) init;

- (void) setDelegate: (id) anObject;
- (id) delegate;

- (BOOL) shuffle;
- (void) setShuffle: (BOOL) aBool;
- (void) reShuffle;
- (BOOL) repeat;
- (void) setRepeat: (BOOL) aBool;

- (unsigned int) count;

- (NSArray *) getSongs;
- (NSArray *) getSongsAsFilenames;

- (void) appendSong: (Song *) newSong;
- (void) insertSong: (Song *) newSong
            atIndex: (unsigned int) aPos;

- (void) firstSong;
- (void) lastSong;
- (void) prevSong;
- (void) nextSong;

- (void) selectSongNumber: (int) anInt;

- (int) currentSongNumber;
/* - (Song *) currentSong; */

- (int) songIndex: (Song *) aSong;
- (Song *) songAtIndex: (int) anIndex;
- (Song *) songAtNSIndex: (NSNumber *) anIndex;

- (unsigned int) moveSongsWithRows: (NSArray *) aRowsList
                                to: (unsigned int) newPos;

- (void) removeArrayOfSongs: (NSArray *) anArray;
- (void) removeAll;
- (void) removeBadEntries;

- (void) sortByPlaylistRepresentation: (BOOL) ascending;
- (void) sortByDuration: (BOOL) ascending;

- (void) loadFromDefaults;
- (void) saveToDefaults;

- (void) loadFromFile: (NSString *) aFilename;
- (void) saveToFile: (NSString *) aFilename;
 
@end

@interface NSObject (PlaylistDelegate)

- (void) playlistChanged: (NSNotification*) aNotification;

@end

#endif /* Playlist_H */
