/* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 */

#ifndef __APushParser_hh__
#define __APushParser_hh__

#include <string>

class APushParser
{
public:
  APushParser(class ALogger& l) : logger(l), factory(0), freeze_level(0) { };
  APushParser(class ALogger& l, class AMathMLFactory& f) : logger(l), factory(&f), freeze_level(0) { };
  virtual ~APushParser() { };

  virtual void reset(void) = 0;
  virtual void push(const class TToken&) = 0;
  virtual std::string drop(bool) = 0;
  virtual void setCursorHint(const std::string&) = 0;
  virtual bool hideCursor(void) = 0;
  virtual bool showCursor(void) = 0;

  virtual bool freeze(void);
  virtual bool thaw(void);
  bool frozen(void) const { return freeze_level > 0; };

protected:
  class ALogger& logger;
  class AMathMLFactory* factory;

private:
  unsigned freeze_level;
};

#endif // __APushParser_hh__
