/* BTP library - Banana Tree Protocol
 * Copyright (C) 1999-2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#ifndef _UTIL_H
#define _UTIL_H


#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <limits.h>

#ifndef G_MAXUINT
#define G_MAXUINT UINT_MAX
#endif

#ifndef G_MAXUINT16
#define G_MAXUINT16 65535
#endif

#ifndef G_MAXUINT32
#define G_MAXUINT32 4294967295U
#endif


/* ******************************************** */
/* General functions/macros			*/

/**

   Round n up to the nearest base.

*/
#define ROUNDUP(n, base)   ( (((n) % (base)) == 0) ? \
			     (n) :\
			     ((n) + ((base) - ((n) % (base)))) )




/* ********************************************	*/
/* Time related macros and functions.		*/

#ifndef timersub
#define	timersub(a, b, result)				\
  do {							\
    (result)->tv_sec = (a)->tv_sec - (b)->tv_sec;	\
    (result)->tv_usec = (a)->tv_usec - (b)->tv_usec;	\
    if ((result)->tv_usec < 0) {			\
      --(result)->tv_sec;				\
      (result)->tv_usec += 1000000;			\
    }							\
  } while (0)
#endif

/* Some systems also call timersub 'timerdiff' */
#ifndef timerdiff
#define timerdiff timersub
#endif

#define timernormalize(tvp)						\
       do {								\
           (tvp)->tv_sec  += (tvp)->tv_usec / 1000000; 			\
	   (tvp)->tv_usec %= 1000000;					\
       } while (0)

#define timeraddusec(tvp, usec)					\
       do {								\
           (tvp)->tv_usec += usec;					\
           if ((tvp)->tv_usec < 0)					\
           {								\
             (tvp)->tv_sec -= (-((tvp)->tv_usec / 1000000) + 1);	\
             (tvp)->tv_usec = (1000000 + ((tvp)->tv_usec % 1000000));	\
           }								\
           timernormalize(tvp);					\
       } while (0)

#define timerusec(tvp) (((tvp)->tv_sec * 1000000) + (tvp)->tv_usec)

/* if negative, round up to zero */
#define timermakepos(tvp) (((tvp)->tv_sec < 0))				\
                              ?((tvp)->tv_sec = 0, (tvp)->tv_usec = 0)	\
			      :(0)




/* Get the time in milliseconds.  This is like ((time() * 1000) %
   UINT_MAX), but we use gettimeofday, so it's more accurate. */
unsigned int millitime (void);



/* ****************************** */
/* Timers with random delay util functions (so timeout at time +
   rand() % delay) */

void rand_timer_set (guint* timer, guint time, guint delay, 
		     GSourceFunc func, gpointer user_data);
void rand_timer_cancel (guint* timer);
void rand_timer_reset (guint* timer, guint time, guint delay, 
		       GSourceFunc func, gpointer user_data);


/* ******************************************** */
/* String functions				*/

size_t strnlen (const char* s, size_t len);


#endif /* _UTIL_H */
