/*
                           Endeavour Status Bar
 */

#ifndef STATUSBAR_H
#define STATUSBAR_H

#include <gtk/gtk.h>


typedef struct _edv_statusbar_struct	edv_statusbar_struct;


/*
 *	Status Bar:
 */
struct _edv_statusbar_struct {

	GtkWidget	*toplevel;	/* GtkFrame */
	gint		busy_count,
			freeze_count;
	gpointer	core_ptr;

	GtkWidget	*write_protect_enabled_eb,
			*write_protect_disabled_eb,
			*delete_method_recycle_eb,
			*delete_method_purge_eb,
			*progress_bar,	/* GtkProgressBar */
			*label;		/* GtkLabel */

	gfloat		progress_pos_last;
};
#define EDV_STATUSBAR(p)	((edv_statusbar_struct *)(p))


extern edv_statusbar_struct *EDVStatusBarNew(
	gpointer core_ptr, GtkWidget *parent
);
extern void EDVStatusBarUpdate(edv_statusbar_struct *sb);
extern void EDVStatusBarSetBusy(
	edv_statusbar_struct *sb, gboolean busy
);
extern void EDVStatusBarMap(edv_statusbar_struct *sb);
extern void EDVStatusBarUnmap(edv_statusbar_struct *sb);
extern void EDVStatusBarDelete(edv_statusbar_struct *sb);

extern void EDVStatusBarMessage(
	edv_statusbar_struct *sb, const gchar *message,
	gboolean allow_gtk_iteration
);
extern void EDVStatusBarProgress(
	edv_statusbar_struct *sb, gfloat percent,
	gboolean allow_gtk_iteration
);


#endif	/* VMASTATUSBAR_H */
