"""

Interface to bchunk (.cue/.bin to .iso converter)

"""

from tools import which, FALSE
from log4py import Logger, LOGLEVEL_NORMAL

class bchunk:

    def __init__(self, loglevel = LOGLEVEL_NORMAL):
        self.__bchunk_logger = Logger().get_instance(self)
        self.__bchunk_logger.set_loglevel(loglevel)
        self.__bchunk_command = which("bchunk")
        if (self.__bchunk_command == ""):
            self.__bchunk_logger.debug("bchunk executable not found.")
        self.__bchunk_cue_file = None
        self.__bchunk_bin_file = None
        self.__bchunk_basename = None

    def available(self):
        return (self.__bchunk_command != "")

    def set_cue_file(self, filename):
        self.__bchunk_cue_file = filename

    def set_bin_file(self, filename):
        self.__bchunk_bin_file = filename

    def set_basename(self, basename):
        self.__bchunk_basename = basename

    def command_line(self):
        if (self.available() == FALSE):
            return None
        elif (self.__bchunk_basename == None) or (self.__bchunk_bin_file == None) or (self.__bchunk_cue_file == None):
            return None
        else:
            command_line = self.__bchunk_command
            command_line = "%s %s %s %s" % (command_line, self.__bchunk_bin_file, self.__bchunk_cue_file, self.__bchunk_basename)
            return command_line

def test():
    bchunk_test = bchunk()
    print bchunk_test.available()
    bchunk_test.set_cue_file("x.cue")
    bchunk_test.set_bin_file("x.bin")
    bchunk_test.set_basename("output")
    print bchunk_test.command_line()

if (__name__ == "__main__"):
    test()
