/*
 * EveryBuddy
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */ 

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>  
#include <gtk/gtk.h>
#include "about.h"
#include "dialog.h"

#include "pixmaps/eblogo.xpm"

static GtkWidget *aboutbox = NULL;

static void destroy_about()
{
	if (aboutbox)
		gtk_widget_destroy(aboutbox);
	aboutbox = NULL;
}

void show_about(GtkWidget *w, void *null)
{
	GtkWidget *logo;
	GtkWidget *ok;
	GtkWidget *label;
	GtkWidget *vbox;
	GtkStyle *style;
	GdkPixmap *pm;
	GdkBitmap *bm;
	char abouttitle[45];

	if (aboutbox) {
		gtk_widget_show(aboutbox);
		return;
	}
	
	aboutbox = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize(aboutbox);

	vbox = gtk_vbox_new(FALSE, 0);

	style = gtk_widget_get_style(aboutbox);
	pm = gdk_pixmap_create_from_xpm_d(aboutbox->window, &bm,
                 &style->bg[GTK_STATE_NORMAL], (gchar **)eblogo_xpm);
	logo = gtk_pixmap_new(pm, bm);
	gtk_box_pack_start(GTK_BOX(vbox), logo, TRUE, TRUE, 0);
	gtk_widget_show(logo);		


	label = gtk_label_new("Everybuddy is designed to become a Universal Instant Messaging client designed \nto seamlessly integrate all existing Instant Messaging clients and provide a \nsingle consistent user interface. \n\nEverybuddy is brought to you by the heart-felt contributions of the following:\n\nTorrey Searle     <tsearle@uci.edu>           Creator\nBen Rigas         <ben@flygroup.org>          Web Design & GUI Devel\nJared Peterson    <jared@tgflinux.com>        GUI Devel\nTroy Morrison     <troy@akropolys.com>        Yahoo Devel\nShane Brady       <shane@jxie.com>            MSN Devel\nAlex Wheeler      <awheeler@speakeasy.org>    Jabber Devel & Much More :)\nRobert Lazzurs    <lazzurs@lazzurs.co.uk>     Maintainer\nMeredydd	<m_luff@mail.wincoll.ac.uk	MSN Devel\nErikB	<knan@mo.himolde.mo>	IRC Devel");


	gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);

	ok = gtk_button_new_with_label("Close");
	gtk_signal_connect_object(GTK_OBJECT(ok), "clicked",
		                  GTK_SIGNAL_FUNC(destroy_about), GTK_OBJECT(aboutbox));

	gtk_box_pack_start(GTK_BOX(vbox), ok, TRUE, FALSE, 0);
	GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(ok);
	gtk_widget_show(ok);

	
	gtk_signal_connect_object(GTK_OBJECT(aboutbox), "destroy",
                                  GTK_SIGNAL_FUNC(destroy_about), GTK_OBJECT(aboutbox));

	gtk_widget_show(label);
	gtk_widget_show(vbox);

	g_snprintf(abouttitle, sizeof(abouttitle), "About EveryBuddy v%s", VERSION);
	gtk_window_set_title(GTK_WINDOW(aboutbox), abouttitle);
	eb_icon(aboutbox->window);
	gtk_container_border_width(GTK_CONTAINER(aboutbox), 2);
	gtk_container_add(GTK_CONTAINER(aboutbox), vbox);
	gtk_widget_show(aboutbox);
}

