;;  castor.asm : Extended-IPL/Gemini, 2nd stage.
;;
;;	multi OS boot utility for IBM PC/AT and compatibles, Since 1993
;;
;;					Auther : takamiti@tsden.org
;;					last update : 2001/06/29
;;
;;	This program requires NASM - "The Netwide Assembler"
;;		(http://www.web-sites.co.uk/nasm/)
;;
;;  $Id: castor.asm,v 1.5 2001/07/02 15:35:12 takamiti Exp $
;;

%include	"biosdef.inc"
%include	"gemini.inc"

mbr_buff	equ	BOOT_LOC + PART_TBL_OFS
diskbuff	equ	BIOS_LOC
digbuffer	equ	0x8000

		bits	16
		section .text
;; =====================================================
;;		call from Gemini/pollux-module
;; =====================================================
%ifdef COM_DEBUG
  KeyBlkLen	equ	(0x700 +  64)
  ParamBlkGap	equ	(0x700 + 124)
%include 	"debugmcr.inc"
		org	0x100
;;		xor	dx,dx
		mov	dx,0x80
		call	start
		xor	ax,ax
		int	0x21
  		times	0x700 - ($ - $$) db 0x90
%else
  KeyBlkLen	equ	(SECTOR_SIZE +  64)
  ParamBlkGap	equ	(SECTOR_SIZE + 124)
		org	0x600
		times	SECTOR_SIZE db 0x90
%endif

ParamBuff:
%include	"gemini.key"
		jmp	start
		times	KeyBlkLen - ($ - $$) db 0
PauseTimeout:	dw	TIMEOUT_SEC
		times	ParamBlkGap - ($ - $$) db 0xff
label_buff:	times	(32 * 12) db 0xee
label_buffln	equ	$ - label_buff
Label_crc:	dd	0

;;;
;;;
start:		mov	[wake_drv],dx			;; save orignal drive
		xor	ax,ax
%ifdef COM_DEBUG
		push	es
		mov	es,ax
		mov	al,[es:0x0475]
		pop	es
		mov	[nr_hdds],ax
%else
		mov	al,[nr_hdds]
%endif
		mov	dx,0x80
		cmp	al,1
		jg	init_read
		mov	byte [Right_menu1],ah

init_read:	mov	dx,0x80
		call	disk_probe
		call	read_mbr
		jnc	mbr_check
abort:
		mov	dx,DEBUG_MsgPos
		mov	si,Abort_msg
		call	putstr_norm
		hlt
		jmp	short $ - 1

mbr_check:	mov	cx,4
		mov	bx,mbr_buff
mbr_chkloop:	test	byte [bx],0x80
		jnz	ext_check
		add	bx,byte MBR_PART_SIZE
		loop	mbr_chkloop
		jmp	short main

ext_check:	mov	al,[bx + 4]
		call	is_extid
		jnz	pause_usrkey
		mov	bp,bx
		call	dig_partition
		cmp	word [dig_level],byte 0
		jz	pause_usrkey
		call	search_extflg
		or	bx,bx
		jz	main

pause_usrkey:	mov	ax,[PauseTimeout]
		or	ax,ax
		jz	main
		call	pause_Nsec
		or	ax,ax
		jnz	main
		mov	dx,[wake_drv]
		ret				;; return to pollux->boot_active

main:		xor	bh,bh
		mov	ah,3
		int	VIDEOBIOS
		mov	[save_curstype],cx
		call	menu_frame
main_loopz:	call	init_labelbuf
		call	diskInfo
		mov	byte [Cond_flag],0		;; clear all flag
		mov	byte [RightCursParam],4
main_loopy:	call	init_digparam
		call	show_mbr
main_loopx:	call	init_left
		mov	ax,leftCmd_ptr
		mov	[mainCmd_ptr],ax
main_loop:	and	byte [Cond_flag],(Cond_UpParam | Cond_DispMBR)
		call	cursor_off
		call	main_getch
		jc	main_loop
		xor	si,si
		mov	bx,[mainCmd_ptr]
		mov	di,curs_mvkey
		mov	cx,curs_mvkey_ln / 2
curs_mv_loop:	cmp	ax,[di]
		jz	moveCursor
		add	di,byte 2
		inc	si
		loop	curs_mv_loop
		shr	si,1
		cmp	ax,ENTER_SCAN
		jz	do_mainCmd
		cmp	ax,LF_SCAN
		jz	do_mainCmd
		cmp	bx,rightCmd_ptr
		jz	cmd_unknown
		inc	si			; if Left-regon 
		cmp	ax,SPACE_SCAN
		jz	do_mainCmd
		inc	si
		cmp	ax,END_SCAN
		jz	do_mainCmd
		inc	si
		cmp	ax,KEY_0
		jz	do_mainCmd
		cmp	ax,KEYPAD_0
		jz	do_mainCmd
		cmp	word [dig_level],byte 0
		jz	cmd_unknown
		inc	si			; if (Left && Extend-part)
		cmp	ax,BS_SCAN
		jz	do_mainCmd
boot_fail:
cmd_unknown:	call	bell
		jmp	short main_loop

moveCursor:	shr	si,1
do_mainCmdx:	mov	ax,main_loop
		push	ax
do_mainCmd:	shl	si,1
		add	si,bx
		lodsw
		jmp	ax

do_altCmd:	sub	bx,alt_cmdkeys
		add	bx,alt_cmdtab
		mov	ax,[bx]
		push	ax
		mov	bl,Attr_HiGreen
		call	curs_attr
		mov	dx,AltCmdEntPos
		call	cursor_on
		pop	ax
		call	ax
		call	cursor_off
		mov	di,[CursParams]
		call	curs_set
		stc
		ret

alt_Command:	mov	bx,alt_cmdkeys
		mov	cx,alt_cmdkey_ln / 2
alt_cmdloop:	cmp	ax,[bx]
		jz	do_altCmd
		inc	bx
		inc	bx
		loop	alt_cmdloop
alt_cmdret:	clc
		ret

main_getch:	call	getchar
		push	ax
		mov	ah,2
		int	KEYBIOS
		and	al,0x0f
		mov	[keybd_stat],al
		push	ax
		call	clear_msgln
		pop	ax			;; shift status
		test	al,ALT_BIT
		pop	ax			;; key data
		jnz	alt_Command
		mov	bx,helpmsg
		cmp	al,'?'			;; help message(very simple)
		jz	show_message
		mov	bx,versionmsg
		cmp	al,'!'			;; version message
		jnz	alt_cmdret

;;	Enter: bx = char **message
show_message:	push	bx
		call	curs_attr_norm
		pop	bx
		mov	dx,(Left_Y - 1) * 256 + (Left_X - 1)
		mov	cx,9 * 256 + Left_Width + 1
		mov	di,vrambuff
		push	di
		push	cx
		push	dx
		push	bx
		call	vram_save
		call	clear_left
		pop	bx
		pop	dx
		push	dx
showmsg_loop:	mov	si,[bx]
		or	si,si
		jz	showmsg_end
		lodsb
		push	dx
		push	bx
		add	dl,al
		call	putstr_norm
		pop	bx
		pop	dx
		inc	dh
		inc	bx
		inc	bx
		jmp	short showmsg_loop
showmsg_end:	call	getchar
		pop	dx
		pop	cx
		pop	si
		call	vram_restore
		mov	di,[CursParams]
		call	curs_set
		stc
		ret

;; ======================================================
;;	Right regon
;; ======================================================
init_right:	mov	di,RightCursParam
		jmp	short init_comm

init_left:	mov	di,LeftCursParam0
		cmp	word [dig_level],byte 0
		jz	init_comm
init_left1:	mov	di,LeftCursParam1
init_comm:	mov	[CursParams],di
		call	curs_set
		ret

Right_Enter:	mov	ax,[RightCursParam]	; cursor position
		dec	ax
		mov	ah,Right_menu_ln
		mul	ah
		add	ax,Right_menu_tab + 4
		mov	bx,ax
		mov	ax,[bx]
		or	ax,ax
		jnz	do_proc
		mov	ax,main_loop
do_proc:	jmp	ax

Right_Tab:	call	curs_attr_norm
		mov	word [mainCmd_ptr],leftCmd_ptr
		call	init_left
		ret

r_menuChk:	push	ax
		dec	ax
		mov	ah,Right_menu_ln
		mul	ah
		mov	bx,ax
		add	bx,Right_menu_tab
		mov	bx,[bx]
		mov	al,[bx]
		or	al,al
		pop	ax
		ret

;; ========================================================
;;	Cursor move
;; ========================================================
Left_Up:	cmp	word [dig_level],byte 0
		jz	cursorUp
		mov	di,[CursParams]
		mov	ax,[di]
		mov	dx,ax
		cmp	ax,1
		jg	curs_up1
		dec	ax
		add	ax,[di + 6]		; display index
		or	ax,ax
		jz	left_up9
		push	ax
		dec	word [di + 6]
		mov	ah,7			; scroll-up
		jmp	short leftScrollComm
left_up9:	ret

Right_Up:
cursorUp:	mov	di,[CursParams]
		mov	ax,[di]			; current-cursor position
		mov	dx,ax
curs_up1:	dec	ax
		or	ax,ax
		jnz	curs_upchk
		cmp	di,RightCursParam
		jz	curs_up2
		cmp	word [dig_level],byte 0
		jnz	left_up9
curs_up2:	mov	ax,[di + 2]		; nr items
curs_upchk:	mov	bx,[di + 8]
		or	bx,bx
		jz	curs_upskp
		call	bx
		jz	curs_up1
curs_upskp:	jmp	short curs_setComm

Left_Down:	cmp	word [dig_level],byte 0
		jz	cursorDown
		mov	di,[CursParams]
		mov	ax,[di]
		mov	dx,ax
		cmp	ax,Frame_ItemCnt
		jle	curs_dn0
		inc	ax
		add	ax,[di + 6]		; display index
		cmp	ax,[di + 2]		; max items
		jg	left_dwn9
		push	ax
		inc	word [di + 6]
		mov	ah,6
leftScrollComm:
		push	ax
		mov	bl,Attr_normal
		call	curs_set1
		call	regon_param
		mov	bh,Attr_normal
		pop	ax
		mov	al,1
		int	VIDEOBIOS		; scroll
		pop	ax			; index
		push	ax
		call	dig_index_one
		pop	ax
		push	di
		call	dig_show_one
		pop	di
		call	curs_set
left_dwn9:	ret

Right_Down:
cursorDown:	mov	di,[CursParams]
		mov	ax,[di]
curs_dn0:	mov	dx,ax
curs_dn1:	inc	ax
		cmp	ax,[di + 2]
		jle	curs_dnchk
		cmp	di,RightCursParam
		jz	curs_dn2
		cmp	word [dig_level],byte 0
		jnz	left_dwn9
curs_dn2:	mov	ax,1
curs_dnchk:	mov	bx,[di + 8]
		or	bx,bx
		jz	curs_setComm
		call	bx
		jz	curs_dn1

curs_setComm:	mov	[di],ax
		or	dx,dx
		jz	curs_set
curs_erase:	mov	bl,Attr_normal		; erase old cursor
		call	curs_set1
curs_set:	mov	bl,Attr_active
curs_set0:	mov	dx,[di]
		or	dx,dx
		jz	curs_set9
curs_set1:	dec	dx
		mov	cx,[di + 4]
		shl	dx,cl
		mov	ax,[di + 10]
		add	ah,dl
		xchg	ax,dx
		mov	cx,[di + 12]
		call	set_attr
curs_set9:	ret

curs_attr_norm:	mov	bl,Attr_normal
curs_attr:	mov	di,[CursParams]
		jmp	short curs_set0

;; ======================================================
;;	switch to another disk
;; ======================================================
Left_Zero:
switch_HD:	xor	ch,ch
		mov	cl,[nr_hdds]
		cmp	cl,1
		jnz	nextHD
		jmp	main_loop

nextHD:		;;push	cx
		;;call	Save_Param
		;;pop	cx
		mov	ax,[current_drv]
		mov	bx,ax
		and	al,0x7f
		inc	ax
		cmp	ax,cx
		jc	sw_hdd
		xor	ax,ax
sw_hdd:		or	al,0x80
		push	ax
		mov	dx,ax
		call	disk_probe
		call	read_mbr
		pop	ax
		jnc	sw_hdd9
		mov	di,skipHD_unit
		mov	cx,1
		and	ax,0x7f
		inc	ax
		call	ax2digit
		mov	dx,MoreMsgPos
		call	cursor_on
		mov	si,skipHD_msg
		call	pause_continue
		call	clear_msgln
		jmp	short switch_HD

sw_hdd9:	call	load_param
		mov	di,RightCursParam
		mov	bl,Attr_normal
		call	curs_set0
		jmp	main_loopz

;; ======================================================
;;	Kick OS
;; ======================================================
kick_fail:	xchg	ax,si
		call	put_Errmsg
kick_fail1:	jmp	boot_fail

kickOS:		call	take_bootptr		;; bp = boot ptr
		or	bp,bp
		mov	ax,CannotBoot
		jz	kick_fail

kickOS2:	;;mov	al,[bp + 4]
		;;call	search_sysidnt
		;;mov	ax,[bx]
		;;or	ax,ax			; this is unknown system
		;;jz	load_osipl		;   but, boot for your own risks.
		;;test	ah,Boot_Enable		; is bootable SysID?
		;;jz	load_osipl		;   yes.
		;;jmp	short kick_fail1
load_osipl:	;;mov	[Cond_flag + 1],ah
%ifdef COM_DEBUG
		DebugDump 0,bp,1		;; boot partition ptr
		;;DebugDump 0,si,1
%endif
		mov	ax,0x0201
		mov	bx,diskbuff
		mov	si,offset
		call	diskio
		mov	si,[base_slice]
		or	si,si
		jnz	final_chk1
		mov	si,bp
final_chk1:	call	chk_iplmagic
		jc	kick_fail1

final_chk2:	cmp	word [bx],byte 0
		mov	ax,CorruptedIPL
		jz	kick_fail

update_flag:	mov	di,mbr_buff
update_flgloop:	mov	byte [di],0
		cmp	di,si
		jnz	update_flgnxt
		or	byte [di],0x80
update_flgnxt:	add	di,byte MBR_PART_SIZE
		cmp	di,mbr_buff + MBR_TABLE_SIZE
		jl	update_flgloop

%ifdef COM_DEBUG
		test	byte [Cond_flag],Cond_SetActive
		jz	dump_exit
		call	mark_active
dump_exit:	DebugDump 0,diskbuff,8
%ifdef HOOKUP13
		mov	dl,[current_drv]
		cmp	dl,0x80
		jz	skip_13hook
		cmp	byte [keybd_stat],RIGHT_SHIFT
		jz	force_13hook
		push	bx
		mov	al,[bp + 4]
		call	search_sysidnt
		mov	ax,[bx]
		test	ah,Boot_SwapDrv
		pop	bx
		;;test	byte [Cond_flag + 1],Boot_SwapDrv
		jz	skip_13hook
		cmp	byte [keybd_stat],(CTRL_BIT | RIGHT_SHIFT)
		jz	skip_13hook
force_13hook:	mov	si,int13hook_msg
		call	tty_outmsg
		call	CRLF
skip_13hook:
%endif
		mov	dx,DEBUG_MsgPos
		call	cursor_on
		ReturnDos
%else
		push	si
		push	bx
%ifdef WRTBL_ENABLE
		;;call	Save_Param
		test	byte [Cond_flag],Cond_SetActive
		jz	run_loader
		push	bp
		call	mark_active
		pop	bp
%endif
run_loader:	call	initCRT
		mov	dl,[current_drv]
%ifdef HOOKUP13
		cmp	dl,0x80
		jz	skip_13hook
		cmp	byte [keybd_stat],RIGHT_SHIFT
		jz	force_13hook
		mov	al,[bp + 4]
		call	search_sysidnt
		mov	ax,[bx]
		test	ah,Boot_SwapDrv
		;;test	byte [Cond_flag + 1],Boot_SwapDrv
		jz	skip_13hook
		cmp	byte [keybd_stat],(CTRL_BIT | RIGHT_SHIFT)
		jz	skip_13hook
force_13hook:
		call	set_int13hook
		mov	dl,0x80
skip_13hook:
%endif
		pop	bx
		pop	si
		mov	[si],dl
		jmp	bx
%endif

;; ======================================================
;;	sub routines for Boot-proc
;; ======================================================
take_bootptr:	cmp	word [dig_level],byte 0	;; boot from MBR ??
		jnz	take_extptr
mbr_index_one:	mov	ax,[LeftCursParam0]
		push	ax
		dec	ax
		mov	cl,4
		shl	ax,cl
		mov	bp,mbr_buff
		add	bp,ax			;; boot ptr
		pop	ax
		ret

take_extptr:	mov	ax,[LeftCursParam1]	;; cursor pointer
		add	ax,[LeftCursParam1 + 6]	;; display index
		push	ax
		call	dig_index_one		;; bp = boot pointer
		pop	ax
take_extofs:	mov	di,offset
take_offset:	dec	ax
		or	ax,ax			;; 1st extend part?
		jnz	take_prevext
		mov	si,[base_slice]
		add	si,byte 8
		push	ax			;; DO NOT touch ax-regs
		lodsw
		stosw
		lodsw
		stosw
		pop	ax
		stosw
		stosw
		ret

take_prevext:	dec	ax
		mov	cl,6
		shl	ax,cl
		mov	si,digbuffer
		add	si,ax
		mov	cx,4
take_prev_loop:	mov	al,[si + 4]
		call	is_extid
		jz	take_prev
		add	si,byte MBR_PART_SIZE
		loop	take_prev_loop
		xor	bp,bp
		ret

take_prev:	add	si,byte 8
		xor	ax,ax
		push	ax
		mov	bx,[base_slice]
		lodsw
		add	ax,[bx + 8]
		stosw
		lodsw
		adc	ax,[bx + 10]
		stosw
		pop	ax
		adc	ax,ax
		stosw
		xor	ax,ax
		stosw
		ret

;;	marking active flag
mark_active:	push	si
		push	bp
		mov	bx,BOOT_LOC		;; write master-table
		mov	ax,0x0301
		xor	bp,bp
		xor	si,si
%ifdef COM_DEBUG
		call	debug_fout
%else
		call	diskio
%endif
		pop	bp
		pop	si
		mov	al,[si + 4]
		call	is_extid
		jnz	mark_ret
		test	byte [Cond_flag],Cond_DispMBR
		jz	mark_ext
mark_ret:	ret

;;
;;	update extpart
mark_ext:	mov	bp,si
		xor	ax,ax
		mov	di,offset
		mov	si,di
		times 4 stosw
		push	word digbuffer
		xor	dx,dx
mrk_extloop:	inc	dx
		mov	bx,workbuff
		mov	ax,0x0201
		call	diskio
		jc	mark_done
		mov	di,workbuff + PART_TBL_OFS
		push	di
		mov	cx,MBR_NR_PART
		push	cx
;;		call	mark_clear
mrk_clrloop:	and	byte [di],0x7f
		add	di,byte MBR_PART_SIZE
		loop	mrk_clrloop
		pop	cx
		pop	di
		cmp	dx,[LeftCursParam1]
		jg	mrk_update
		mov	ax,mark_this
		jz	mrk_setfunc
		mov	ax,mark_chain
mrk_setfunc:	call	ax
mrk_update:	mov	ax,0x0301
%ifdef COM_DEBUG
		call	debug_fout
%else
		call	diskio
%endif
		jc	mark_done
		cmp	dx,1
		jg	mrk_extnext
		mov	di,si
		mov	ax,[bp + 8]
		stosw
		mov	ax,[bp + 10]
		stosw
		xor	ax,ax
		times 2 stosw
mrk_extnext:	pop	bx
		push	bx
		mov	cx,MBR_NR_PART
mrk_findloop:	mov	al,[bx + 4]
		call	is_extid
		jz	mrk_finded
		add	bx,byte MBR_PART_SIZE
		loop	mrk_findloop
		xor	bx,bx
mrk_finded:	mov	bp,bx
		pop	bx
		add	bx,byte MBR_TABLE_SIZE
		push	bx
		or	bp,bp
		jz	mark_done
		cmp	dx,[LeftCursParam1 + 2]
		jle	mrk_extloop
mark_done:	pop	ax			; adjust stack
		ret

;;	di = pattition table ptr
;mark_clear:	;mov	cx,MBR_NR_PART
;mrk_clrloop:	and	byte [di],0x7f
;		add	di,byte MBR_PART_SIZE
;		loop	mrk_clrloop
;		ret

;;	di = pattition table ptr
mark_chain:	;mov	cx,MBR_NR_PART
mrk_chnloop:	mov	al,[di + 4]
		call	is_extid
		jnz	mrk_chnnxt
		or	byte [di],0x80
mrk_chnnxt:	add	di,byte MBR_PART_SIZE
		loop	mrk_chnloop
		ret

;;	di = pattition table ptr
mark_this:	;mov	cx,MBR_NR_PART
mrk_thisloop:	mov	al,[di + 4]
		or	al,al
		jz	mrk_thisnxt
		call	is_extid
		jz	mrk_thisnxt
		or	byte [di],0x80
mrk_thisnxt:	add	di,byte MBR_PART_SIZE
		loop	mrk_thisloop
		ret

;; ======================================================
;;	Left regon
;; ======================================================
Left_Spc:	xor	ax,ax				;; bind <Space> key
		cmp	[dig_level],ax
		jz	left_ent1
		jmp	short left_entfail

Boot1:
Left_End:	or	byte [Cond_flag],Cond_SetActive	;; bind <End> key

Boot0:
Left_Enter:	mov	al,Cond_FindBoot		;; bind <Enter> Key
		cmp	word [dig_level],byte 0
		jz	left_ent1
left_ent0:	jmp	kickOS

left_ent1:	or	byte [Cond_flag],al
		call	mbr_index_one
		mov	dx,ax
		mov	al,[bp + 4]
		call	is_extid
		jz	left_ent2
		test	byte [Cond_flag],Cond_FindBoot
		jnz	left_ent4
left_entfail:	jmp	boot_fail

left_ent2:	;;and	byte [Cond_flag],(0xff ^ Cond_SetActive)
		mov	[dig_part],dx
		push	bp
		call	dig_partition
		pop	bp
		cmp	word [dig_level],byte 0
		jz	left_entfail

left_ent3:	call	search_extflg
		or	bx,bx				; active flag not found
		jz	alt_left
		test	byte [Cond_flag],Cond_FindBoot
		jz	alt_left
		mov	[base_slice],bp
		mov	bp,bx
		xchg	ax,bx
		sub	ax,digbuffer
		mov	cl,6
		shr	ax,cl
		inc	ax
		call	take_extofs
left_ent4:	jmp	kickOS2

alt_left:	call	clear_left
		call	dig_header
		call	dig_show
		mov	al,[Right_menu2s]
		mov	si,Right_menu2
		mov	[si],al
		mov	dx,Right_Y2 * 256 + Right_X
		call	putstr_norm
		call	curs_attr_norm
		mov	di,LeftCursParam1
		mov	[CursParams],di
		mov	ax,[dig_level]
		mov	[di + 2],ax
		jmp	main_loopx

search_extflg:	mov	bx,digbuffer
se_extflgloop:	mov	al,[bx + 4]
		or	al,al
		jz	se_extflgnext
		call	is_extid
		jz	se_extflgnext
		test	byte [bx],0x80
		jnz	se_extflg9
se_extflgnext:	add	bx,byte MBR_PART_SIZE
		cmp	bx,[digbuf_ptr]
		jl	se_extflgloop
		xor	bx,bx
se_extflg9:	ret

%if 0
;;	Enter:di = cursor parameter
;;		dx = old cursor position
;;		ah = scroll direction
;;	Return:	none
left_scroll:	push	ax
		mov	bl,Attr_normal
		call	curs_set1
		call	regon_param
		mov	bh,Attr_normal
		pop	ax
		mov	al,1
		int	VIDEOBIOS
		ret
%endif

Left_Tab:	pop	ax			;; bind <- or -> (arrow)key
		mov	bl,Attr_invers
		call	curs_attr
		mov	word [mainCmd_ptr],rightCmd_ptr
		call	init_right
		jmp	main_loop

Left_Bs:	call	clear_left
		mov	word [CursParams],LeftCursParam0
		jmp	main_loopy

l_itemChk:	push	ax
		mov	cl,4
		dec	ax
		shl	ax,cl
		mov	bx,mbr_buff
		add	bx,ax
		mov	al,[bx + 4]
		or	al,al
		pop	ax
		ret

;; ==========================================================
;;	sub routines for master boot record
;; ==========================================================
;;	Enter:	al = sys-id
;;	Return:	bx = sys-info-ptr
search_sysidnt:	mov	bx,SysInd_tab
		mov	cx,SysInd_tab_len / sysind_tab_ln
se_next:	mov	ah,[bx]
		cmp	al,ah
		jz	se_found
		add	bx,sysind_tab_ln
		loop	se_next
se_unknown:	mov	bx,sysUnknown
se_found:	ret

;;	Enter:	si = partition ptr
;;		ah = index(0:mbr, 1..n ext)
;;		al = sys-id
;;	Return:	si = system name str
sys_name:	push	ax
		call	search_label
		pop	ax
		mov	si,bx
		add	si,byte 10
		or	bx,bx
		jnz	sys_name9
		call	search_sysidnt
		mov	si,[bx + 2]		;; system-id table ptr
sys_name9:	ret

make_bootmk:	mov	al,' '
		test	byte [bp],0x80
		jz	mk_bootmk9
		mov	al,'*'
mk_bootmk9:	ret

;;	Enter:	al = index number
make_partInfoN:	mov	di,linebuff
		push	ax
		call	make_bootmk
		stosb
		mov	al,'['
		stosb
		pop	ax
		push	ax
		mov	cx,2
		call	ax2digit
		mov	ax,'] '
		stosw
		jmp	short make_partInfo1

;;	Enter:	bp = partition table address
;;		al = index
;;	Return:	none
make_partInfo:	mov	di,linebuff
		push	ax
		call	make_bootmk
		stosb
make_partInfo1:	pop	ax
		mov	ah,al
		mov	al,[bp + 4]		; system-id
		or	al,al
		jz	mk_partinfo9
		mov	si,bp
		push	ax
		call	sys_name
		pop	ax
		call	byte2hex
		xchg	al,ah
		stosb
		xchg	al,ah
		stosb
		mov	ax,': '
		stosw
mkinf2_loop:	lodsb
		stosb
		or	al,al
		jnz	mkinf2_loop
		dec	di
		mov	ax,di
		sub	ax,linebuff
		mov	cx,Left_Width - 7
		cmp	ax,cx
		jl	mkinf_fill
		mov	di,linebuff - 1
		add	di,cx
		mov	ax,cx
		dec	ax
mkinf_fill:	sub	cx,ax
		add	cx,byte 5
		mov	al,' '
		rep stosb
		mov	al,[bp + 4]
		call	is_extid
		mov	ax,'--'
		jz	mk_partinfo8
mkinf_size:	sub	di,byte 5
		mov	ax,[bp + 12]		; size
		mov	dx,[bp + 14]
		mov	cx,11
mkinf_sizshr:	clc
		shr	dx,1
		rcr	ax,1
		loop	mkinf_sizshr
		mov	cx,5
		call	ax2digit
		mov	ax,'MB'
mk_partinfo8:	stosw
mk_partinfo9:	xor	ax,ax			; str terminater
		stosb
		ret

;;	Enter:	bx = buffer address
;;	Return:	if (exists) cf=0, else cf=1
chk_iplmagic:	clc
		cmp	word [bx + IPL_MAGIC_OFS],IPL_MAGIC
		jz	ipl_magic_ok
		push	si
		mov	si,NoIPLMagic
		call	put_Errmsg
		pop	si
		stc
ipl_magic_ok:	ret

read_mbr:	mov	bx,diskbuff
		mov	ax,0x0202
		xor	bp,bp
		xor	si,si
		call	diskio
		jc	rd_mbr9
		call	chk_iplmagic
		jc	rd_mbr9
move_mbr:	mov	si,bx
		mov	di,BOOT_LOC
		mov	cx,256
		rep movsw
		clc
rd_mbr9:	ret

show_mbr:	call	clear_dighead
		call	clear_left
		mov	word [LeftCursParam0],0
		mov	bp,mbr_buff
		mov	cx,4
show_mbr2:	push	cx
		mov	dx,[LeftCursParam0 + 10]
		mov	ax,5
		sub	ax,cx
		cmp	byte [bp + 4],0
		jz	show_mbr5
		test	byte [bp],0x80			;; check active flag
		jnz	show_mbr3
		cmp	byte [LeftCursParam0],0
		jnz	show_mbr4
show_mbr3:	mov	[LeftCursParam0],ax
show_mbr4:	dec	ax
		mov	cl,[LeftCursParam0 + 4]
		shl	ax,cl
		add	dh,al
		push	dx
		xor	ax,ax
		call	make_partInfo
		pop	dx
		call	putstr_norm_ln
show_mbr5:	pop	cx
		add	bp,byte MBR_PART_SIZE
		loop	show_mbr2
		or	byte [Cond_flag],Cond_DispMBR
		ret

;; ==========================================================
;;	sub routines for extended-part
;; ==========================================================
init_digparam:	xor	ax,ax
		mov	di,base_slice
		mov	cx,dig_initparamln / 2
		rep stosw
		mov	[LeftCursParam1 + 6],ax
		mov	word [digbuf_ptr],digbuffer
		ret

is_extid:	cmp	al,EXTDOS_PART
		jz	is_extid9
		cmp	al,EXTLINUX_PART
		jz	is_extid9
		cmp	al,EXTDOSLBA_PART
is_extid9:	ret

	;;	bp = extend-part pointer in MBR
dig_partition:	call	init_digparam
dig_more:	inc	word [dig_level]
		mov	ax,0x0201
		mov	bx,diskbuff
		mov	si,offset
		call	diskio
		jc	init_digparam
		mov	si,bx
		call	chk_iplmagic
		jc	init_digparam
		add	si,PART_TBL_OFS
		mov	di,[digbuf_ptr]
		push	di
		mov	cx,MBR_TABLE_SIZE / 2
		rep movsw
		mov	[digbuf_ptr],di		; set next buffer pointer
		pop	bx
		mov	cx,MBR_NR_PART
dig_chk_loop:	mov	al,[bx + 4]
		or	al,al
		jz	dig_chknxt
		call	is_extid
		jnz	dig_chknxt
		cmp	word [base_slice],byte 0
		jnz	dig_chklimit
		mov	[base_slice],bp
		mov	si,bp
		add	si,byte 8
		mov	di,offset
		lodsw
		stosw
		lodsw
		stosw
dig_chklimit:	mov	bp,bx				;; chain ptr
		cmp	word [dig_level],byte DIG_LIMIT
		jge	dig_end
		jmp	short dig_more
dig_chknxt:	add	bx,byte MBR_PART_SIZE
		loop	dig_chk_loop
dig_end:	ret

;;	Enter:	ax = index
;;	Return: bp = table address
dig_index_one:	dec	ax
		mov	cl,6
		shl	ax,cl
		mov	bp,digbuffer
		add	bp,ax
		mov	cx,4
dig_idx_loop:	mov	al,[bp + 4]
		or	al,al
		jz	dig_idx_next
		call	is_extid
		jnz	dig_idx9
dig_idx_next:	add	bp,byte MBR_PART_SIZE
		loop	dig_idx_loop
dig_idx8:	xor	bp,bp
dig_idx9:	ret

;;	Enter:	ax = item count
;;		bp = buffer address
;;	Return:	none
dig_show_one:	push	ax
		call	make_partInfoN
		pop	dx
		mov	bx,LeftCursParam1
		mov	ax,[bx + 10]
		mov	cx,[bx + 4]
		dec	dx
		sub	dx,[bx + 6]
		shl	dx,cl
		add	ah,dl
		mov	dx,ax
		call	putstr_norm_ln
		ret

dig_show:	mov	bp,digbuffer
		xor	dx,dx
		mov	[LeftCursParam1],dx
dig_showloop:	mov	al,[bp + 4]
		or	al,al
		jz	dig_shownxt
		call	is_extid
		jz	dig_shownxt
		inc	dx
		mov	ax,dx
		push	dx
		call	dig_show_one
		pop	dx
		test	byte [bp],0x80
		jnz	dig_flgfound
		cmp	word [LeftCursParam1],byte 0
		jnz	dig_shownxt
dig_flgfound:	mov	[LeftCursParam1],dx
dig_shownxt:	add	bp,byte MBR_PART_SIZE
		cmp	dx,Frame_ItemCnt
		jg	dig_show9
		cmp	dx,[dig_level]
		jl	dig_showloop
dig_show9:	and	byte [Cond_flag],(0xff ^ Cond_DispMBR)
		ret

dig_header:	push	si
		push	di
		xchg	si,bp
		call	mbr_index_one
		xchg	si,bp
		mov	al,[si + 4]
		xor	ah,ah
		call	sys_name
		mov	bx,si
		push	bx
		mov	di,linebuff
		mov	byte [di],'('
		inc	di
		mov	si,Head_dig
		mov	cx,Head_dig_ln
		rep movsb
		mov	ax,[dig_part]
		add	al,'0'
		stosb
		mov	ax,', '
		stosw
		pop	si
dig_head4:	lodsb
		or	al,al
		jz	dig_head5
		stosb
		jmp	short dig_head4
dig_head5:	mov	ax,')'
		stosw
		mov	dx,Head_digInfo
		call	putstr_norm_ln
dig_head8:	pop	di
		pop	si
dig_head9:	ret

clear_dighead:	mov	dx,Head_digInfo
		mov	cx,Head_digInfoLn
		call	clear_line
		mov	dx,Right_Y2 * 256 + Right_X - 1
		mov	cx,Right_Width
		call	clear_line
		xor	ax,ax
		mov	[Right_menu2],al
		mov	ax,[RightCursParam]
		cmp	ax,2
		jnz	clr_dighead9
		mov	ax,4
		mov	[RightCursParam],ax
clr_dighead9:	ret

;; ==========================================================
;;	make basic frame
;; ==========================================================
menu_frame:	call	initCRT
		call	cursor_off
		mov	dx,(Frame_Y * 256 + Frame_X)
		mov	cx,0xbbc9
		call	hline0
		mov	dx,(Frame_Y + Frame_High) * 256 + Frame_X
		mov	cx,0xbcc8
		call	hline0
		mov	dx,(Frame_Y + 1) * 256 + Frame_X
		call	vline0
		mov	dx,(Frame_Y + 1) * 256 + (Frame_X + Frame_Width + 1)
		call	vline0
		mov	dx,(Frame_Y + 2) * 256 + Frame_X
		mov	cx,0xb6c7
		mov	al,0xc4
		call	hline
		mov	dx,(Frame_Y + 2) * 256 + Frame_X + Frame_Wall
		mov	al,0xb3
		call	vline
		mov	al,0xc2
		call	putch_at
		mov	dh,(Frame_Y + Frame_High)
		mov	al,0xcf
		call	putch_at
		;; infomation
		mov	dx,Title_YX
		mov	si,Information
		mov	bl,Attr_HiWhite
		call	putstr
		;; right menu
		mov	si,Right_menu_tab
		mov	cx,4
		cld
menu_right1:	push	cx
		push	si
		lodsw				; str pointer
		push	ax
		lodsw
		xchg	ax,dx			; YX address
		pop	ax
		xchg	ax,si
		call	putstr_norm
		pop	si
		add	si,Right_menu_ln
		pop	cx
		loop	menu_right1
		;; guid msg
		mov	dx,Guid_YX
		mov	si,Guid_msg
		call	putstr_norm
		ret

regon_param:	mov	cx,[di + 10]
		mov	dx,cx
		add	dh,Frame_ItemCnt
		add	dl,[di + 12]
		mov	bh,Attr_normal
		ret

clear_left:	mov	di,LeftCursParam0
clear_regon:	call	regon_param
		mov	ax,0x0600
		int	VIDEOBIOS
		ret

;;	Enter:	dx = YX:
;;		cx = line length
;;	Return:	none
clear_line:	push	es
		push	di
		call	vram_ofs
		mov	ax,Attr_normal * 256 + ' '
		rep stosw
		pop	di
		pop	es
		ret

hline0:		mov	al,0xcd
hline:		mov	bl,Attr_normal
		push	es
		push	di
		push	cx
		push	ax
		call	vram_ofs
		mov	ah,bl
		mov	al,cl
		cld
		stosw
		mov	cx,Frame_Width
		pop	ax
		mov	ah,bl
		rep stosw
		pop	cx
		mov	al,ch
		stosw
		pop	di
		pop	es
		ret

putch_at:	mov	cx,1
		jmp	short vline_a
vline0:		mov	al,0xba
vline:		mov	cx,Frame_High - 1
vline_a:	mov	ah,Attr_normal
		push	es
		push	di
		push	ax
		call	vram_ofs
		pop	ax
vline_loop:	stosw
		add	di,158
		loop	vline_loop
		pop	di
		pop	es
		ret

byte2hex:	push	ax
		push	cx
		mov	cl,4
		shr	al,cl
		pop	cx
		call	byte2hex1
		mov	bh,al
		pop	ax
byte2hex1:	and	al,0x0f
		add	al,0x30
		cmp	al,0x3a
		jc	byte2hex9
		add	al,7
byte2hex9:	mov	ah,bh
		ret

;;	Enter:	ax = word
;;		cx = columns
;;		di = strbuff
;;	Return:	none
ax2digit:	push	dx
		push	bx
		push	si
		or	ax,ax
		jnz	ax2dig
		mov	al,' '
		dec	cx
		rep stosb
		mov	al,'0'
		stosb
		jmp	short ax2dig9
ax2dig:		mov	si,cx			; save
		mov	bx,10
ax2dig_loop1:	xor	dx,dx
		div	bx
		push	dx
		loop	ax2dig_loop1
		xor	dx,dx
		mov	cx,si
ax2dig_loop2:	pop	ax
		or	ax,ax
		jnz	ax2dig3
		or	dx,dx
		jnz	ax2dig4
		mov	al, ' '
		jmp	short ax2dig5
ax2dig3:	inc	dx
ax2dig4:	add	al,'0'
ax2dig5:	stosb
		loop	ax2dig_loop2
ax2dig9:	pop	si
		pop	bx
		pop	dx
		ret

;; =====================================================
;;		pause n sec
;; =====================================================
;;	Enter:	ax = timeout(sec)
;;	Return:	ax = 0/1 (0: timeout or Hit <Enter>key, 1: touch any key)
pause_Nsec:	push	ax
%ifdef VERBOSE
		mov	si,Pause_msg
		call	tty_outmsg
%endif
pause:		pop	ax
		push	ax
		mov	ah,2
		int	TIMERBIOS
		mov	bx,dx
pause_loop:	push	bx
		mov	ah,1
		int	KEYBIOS
		jnz	pause_keybrk
		mov	ah,2
		int	KEYBIOS
		and	al,0x0f
		jnz	pause_touch
		mov	ah,2
		int	TIMERBIOS
		pop	bx
		cmp	bh,dh
		jz	pause_loop
		mov	bx,dx
		pop	ax
		dec	ax
		or	ax,ax
		jz	pause_tout
		push	ax
%ifdef VERBOSE
		push	bx
		mov	cx,3
		mov	di,linebuff
		push	di
		push	cx
		call	ax2digit
		pop	cx
		call	rep_BSout
		pop	si
pause_cntloop:	lodsb
		cmp	al,' '
		jnz	pause_cntx
		mov	al,'.'
pause_cntx:	call	tty_out
		loop	pause_cntloop
		pop	bx
%endif
		jmp	short pause_loop
pause_keybrk:	call	getchar			; drop data
		cmp	ax,0x1c0d		; <Enter> key
		jnz	pause_touch
		xor	ax,ax
		jmp	short pause_ret
pause_touch:	mov	ax,1
pause_ret:	pop	bx
		pop	bx
pause_tout:
%ifdef VERBOSE
		push	ax
		mov	cx,3
		call	rep_BSout
		mov	al,' '
		call	rep_ttyout
		call	CRLF
		pop	ax
%endif
		ret

rep_BSout:	mov	al,8
rep_ttyout:	push	cx
reptty_loop:	call	tty_out
		loop	reptty_loop
		pop	cx
		ret

;; =====================================================
;;		Console I/O sub routines
;; =====================================================
;;	Enter:	none
;;	Return:	ax = key scan code
getchar:	mov	ah,0
		int	KEYBIOS
%ifdef COM_DEBUG
		cmp	ax,0x2D00	;	"<Alt> - x"
		jnz	getchar9
		mov	dx,DEBUG_MsgPos
		call	cursor_on
		ReturnDos
%endif
getchar9:	ret

cursor_off:	mov	ah,1
		mov	cx,0x2000
		int	VIDEOBIOS
		ret

;;	Enter:	dx = cursor pos Y:X
cursor_on:	push	dx
		mov	cx,[save_curstype]
		mov	ah,1
		int	VIDEOBIOS		;; cursor on
		pop	dx			;;  and set cursor position
;;	Enter:	dx = Y:X
move_cursor:
		xor	bh,bh
		mov	ah,2
		int	VIDEOBIOS
		ret

CRLF:		mov	al,CR
		call	tty_out
		mov	al,LF
		jmp	short tty_out

initCRT:	mov	ax,2				; mode 2
		jmp	short intVideo
bell:		mov	al,BELL
tty_out:	mov	ah,14
intVideo:	int	VIDEOBIOS
		ret

tty_outloop:	call	tty_out
tty_outmsg:	lodsb
		or	al,al
		jnz	tty_outloop
		ret

;;	Enter:	dx = Y:X
;;	Return: es:di = VRAM Offset address
vram_ofs:	push	dx
		mov	ax,0xb800
		mov	es,ax
		mov	al,dh
		mov	ah,80
		mul	ah
		xor	dh,dh
		add	ax,dx
		shl	ax,1
		xchg	ax,di
		pop	dx
		ret

;;	Enter:	dx = Y:X
;;		cx = Y-len:X-len
;;		di = buffer
vram_save:	push	es
		push	di
		call	vram_ofs
		mov	si,di
		pop	di
		mov	ax,es
		pop	es
		push	ds
		mov	ds,ax
		mov	ax,cx
vram_svloop:	xor	ch,ch
		push	si
		rep movsw
		pop	si
		add	si,160
		mov	cx,ax
		dec	ah
		or	ah,ah
		jnz	vram_svloop
		pop	ds
		ret

;;	Enter:	dx = Y:X
;;		cx = Y-len:X-len
;;		si = buffer
vram_restore:	push	es
		call	vram_ofs
		mov	ax,cx
vram_rsloop:	xor	ch,ch
		push	di
		rep movsw
		pop	di
		add	di,160
		mov	cx,ax
		dec	ah
		or	ah,ah
		jnz	vram_rsloop
		pop	es
		ret

putstr_norm_ln:	mov	si,linebuff
putstr_norm:	mov	bl,Attr_normal
;;	Enter:	si = string buff address
;;		bl = char attr
;;		dx = cursor position
;;	Return:	none
putstr:		push	es
		push	di
		push	cx
		call	vram_ofs
		xor	cx,cx
		mov	ah,bl
		cld
puts_nxt:	lodsb
		or	al,al
		jz	puts_end
		stosw
		inc	cx
		jmp	short puts_nxt
puts_end:	mov	ax,cx
		pop	cx
		pop	di
		pop	es
		ret

set_attr_norm:	mov	bl,Attr_normal
;;	Enter:	dx = Y:X
;;		bl = char attr
;;		cx = length
;;	Return:	none
set_attr:	push	es
		push	di
		call	vram_ofs
		mov	al,bl
set_attr_loop:	inc	di
		stosb
		loop	set_attr_loop
		pop	di
		pop	es
		ret

;; =====================================================
;;		DISK I/O sub routines
;; =====================================================
dsk_reset:	push	dx
		mov	dl,[current_drv]
		mov	ah,0
		int	DISKBIOS
		pop	dx
		ret

;;	Enter:	dl = drive
;;	Return:	none
disk_probe:	mov	dh,0
		mov	[current_drv],dx
%ifndef ONLY_LEGACY_ACCESS
		mov	bx,0x55aa
		mov	ah,0x41
		int	DISKBIOS
		jc	dsk_probe8
		and	cx,1
		jz	dsk_probe8
		mov	ax,lba_dskio
		jmp	short dsk_probe9
%endif
dsk_probe8:	call	dsk_reset
		mov	ax,legacy_dskio
dsk_probe9:	mov	[diskio_func],ax
		ret

;;	Enter/Return:	none
diskInfo:	mov	di,linebuff
		push	di
		mov	ax,'  '
		mov	cx,Frame_Width
		rep stosw
		xor	ax,ax
		stosb
		pop	di
		push	di
		mov	dx,di
		mov	si,Head_drive
		mov	cx,Head_drive_e - Head_drive
		rep movsb
		mov	ax,[current_drv]
		and	al,0x7f
		inc	al
		add	al,'0'
		stosb
		mov	al,'/'
		stosb
		mov	al,[nr_hdds]
		add	al,'0'
		stosb
		pop	di
		add	di,Head_modeOfs
		mov	cx,Head_mode_e - Head_mode
		mov	si,Head_mode
		rep movsb
		mov	si,Head_LBA
		mov	ax,[diskio_func]
		cmp	ax,lba_dskio
		jz	dsk_info1
		mov	si,Head_CHS
dsk_info1:	mov	cx,3			; strlen("CHS");
		rep movsb
		mov	al,ch
		stosb
		mov	dx,Head_Info
		call	putstr_norm_ln
		ret

;;	Enter:	bp = parameter 
;; 		bx = buffer address
;; 		ax = mode + sectors of transfer
;;		si = offset ptr
;;	Return:	if (error) cf=1, elxe cf=0
diskio:		push	dx
		push	cx
		push	bx
		push	ax
		push	di
		push	si
		push	bp
		mov	cx,5
diskio_loop:	push	cx
		call	word [diskio_func]
		pop	cx
		jnc	diskio_ret
		push	ax			; error code
		call	dsk_reset
		pop	ax
		clc
		cmp	ah,0x11			; Correctable ECC Err
		jz	diskio_ret
		cmp	ah,0x10			; CRC error
		jnz	diskio_err
		loop	diskio_loop
diskio_err:	call	diskerr_msg
diskio_ret:	pop	bp
		pop	si
		pop	di
		pop	ax
		pop	bx
		pop	cx
		pop	dx
		ret

;;	Enter:	ah = error code
;;		dl = drive
diskerr_msg:	mov	si,DiskErrmsg
		mov	cx,DiskErrmsg_ln
		mov	di,linebuff
		rep movsb
		push	ax
		mov	al,dl
		call	byte2hex
		xchg	ah,al
		stosw
		pop	ax
		mov	al,ah
		call	byte2hex
		xchg	ah,al
		stosw
		xor	ax,ax
		stosb
		mov	dx,ErrMsgPos
		call	putstr_norm_ln
		stc
		ret

;;	Enter:	bp = parameter 
;; 		bx = buffer address
;; 		ax = mode + sectors of transfer
;;	Return:	if (error) cf=1, else cf=0
legacy_dskio:	or	bp,bp
		jnz	lgcy_dsk0
		mov	cx,1
		xor	dh,dh
		jmp	short lgcy_io
lgcy_dsk0:	mov	dx,[bp]
		mov	cx,[bp + 2]
lgcy_io:	mov	dl,[current_drv]
		int	DISKBIOS
lgcy_dsk9:	ret

;;	Enter:	bp = param address
;;		bx = buffer address
;;		ax = mode + setors of transfer
;;		si = offset ptr
lba_dskio:	mov	di,lba_packet
		push	ax
		mov	dx,ax
		mov	cx,LBA_PACKET_SIZE
		xor	ax,ax
		push	di
		cld
		rep stosw			;; REMEMBER! cx = 0
		pop	di			;; do not touch cx regs.
		mov	al,16
		stosw				;; size of packet
		mov	al,dl
		stosw				;; blocks of transfer
		mov	ax,bx
		stosw
		mov	ax,ds
		stosw				;; transfer buffer address
		or	bp,bp
		jz	lba_dsk5
		mov	ax,[bp + 8]		;; block address Lo
		mov	dx,[bp + 10]		;; block address Hi
		or	si,si
		jz	zero_ofs
		add	ax,[si]
		adc	dx,[si + 2]
		adc	cx,[si + 4]
zero_ofs:	stosw
		xchg	ax,dx
		stosw
		xchg	ax,cx
		stosw
lba_dsk5:	pop	ax
		or	ah,0x40
		mov	si,lba_packet
		mov	dl,[current_drv]
		int	DISKBIOS
		ret

put_Errmsg:	push	si
		mov	dx,ErrMsgPos
		push	dx
		mov	cx,76
		call	clear_line
		pop	dx
		mov	si,ErrMsgHead
		call	putstr_norm
		add	dl,al
		pop	si
		call	putstr_norm
		ret

;;===========================================================
;;		Alt Commands
;;===========================================================
;;	si = prompt str
;;	dx = YX
;;	cx = length
;;	bx = get between BL to BH
get_line:	push	bp
		mov	bp,sp
		sub	sp,byte 4
		mov	[bp - 2],cx
		mov	[bp - 4],bx
		call	putstr_norm
		add	dl,al
		inc	dx
		call	move_cursor
		xor	cx,cx
		mov	di,linebuff
getln_loop:	call	getchar
		cmp	al,0x0D			;; <Enter>
		jz	getln_Enter
		cmp	al,0x08			;; <BS>
		jz	getln_Bs
		cmp	al,0x1B			;; <Esc>
		jz	getln_Esc
		cmp	cx,[bp - 2]
		jge	getln_err
		mov	bx,[bp - 4]
		cmp	al,bl
		jl	getln_err
		cmp	al,bh
		jg	getln_err
		stosb
		inc	cx
getln_dsp:	call	tty_out
		jmp	short getln_loop
getln_err:	call	bell
getln_err1:	jmp	short getln_loop

getln_Bs:	jcxz	getln_loop
		dec	di
		dec	cx
		mov	al,8
		call	tty_out
		mov	al,' '
		call	tty_out
		mov	al,8
		jmp	short getln_dsp

getln_Esc:	xor	ax,ax
		jmp	short getln_ret
getln_Enter:	xor	ax,ax
		stosb
		mov	ax,linebuff
getln_ret:	mov	sp,bp
		pop	bp
		ret

;;	Enter:	si = string address
;;	Return:	ax
str2int:	xor	ax,ax
str2int_loop:	xchg	ax,cx
		lodsb
		or	al,al
		jz	str2int9
		push	ax
		xchg	ax,cx
		mov	cx,10
		mul	cx
		pop	cx
		sub	cl,'0'
		xor	ch,ch
		add	ax,cx
		jmp	short str2int_loop
str2int9:	xchg	ax,cx
		ret

;;
;;	Change timeout
;;
Chg_Timeout:	cmp	byte [current_drv],0x80
		jnz	chg_timout9
		mov	si,timer_prompt
		mov	cx,timer_prompt_ln
		mov	di,linebuff
		rep movsb
		mov	cx,5
		mov	ax,[PauseTimeout]
		call	ax2digit
		mov	al,' '
		push	ax
		stosb
		mov	ax,'->'
		stosw
		pop	ax
		stosb
		xor	ax,ax
		stosb
		mov	dx,AltCmdEntPos
		mov	si,linebuff
		mov	cx,3
		mov	bx,'09'
		call	get_line
		or	ax,ax
		jz	chgtime_can
		mov	si,ax
		mov	al,[si]
		or	al,al
		jz	chgtime_ret
		call	str2int
		push	ax
		mov	dx,AltCmdResPos
		mov	si,ok_msg
		call	pause_continue
		pop	ax
		mov	[PauseTimeout],ax
		or	byte [Cond_flag],Cond_UpParam
chgtime_can:
chgtime_ret:
clear_msgln:	mov	dx,20 * 256
		mov	cx,320
		call	clear_line
chg_timout9:	ret

pause_continue:	call	putstr_norm
		add	dl,al
		mov	si,continue_msg
		call	putstr_norm
		add	dl,al
		call	move_cursor
		call	getchar
		ret

LABEL_SIZE	equ	32

init_labelbuf:	call	labelbuf_crc
		cmp	ax,[Label_crc]
		jnz	clr_labelbuf
		cmp	dx,[Label_crc + 2]
		jz	chk_labelbuf
clr_labelbuf:	mov	di,label_buff
		mov	cx,label_buffln / 2
		xor	ax,ax
		rep stosw
set_labelcrc:	call	labelbuf_crc
		mov	[Label_crc],ax
		mov	[Label_crc + 2],dx
		ret

chk_labelbuf:	mov	cx,4
		mov	si,mbr_buff
chklbl_loop:	push	cx
		mov	al,[si + 4]
		or	al,al
		jz	chklbl_next
		call	is_extid
		jnz	chklbl_mbr
		push	ax
		call	chk_extlabel
		pop	ax
chklbl_mbr:	xor	ah,ah
		call	is_lblenable
chklbl_next:	add	si,byte MBR_PART_SIZE
		pop	cx
		loop	chklbl_loop
		mov	bx,label_buff
		xor	cx,cx
		xor	ax,ax
lblmark_loop:	cmp	[bx],al
		jz	lblmark_next
		cmp	[bx + 2],al
		jnz	lblmark_next
		mov	[bx],ax
		inc	cx
lblmark_next:	mov	byte [bx + 2],al
		add	bx,byte LABEL_SIZE
		cmp	bx,Label_crc
		jl	lblmark_loop
		jcxz	lblmark9
		call	set_labelcrc
lblmark9:	ret

is_lblenable:	call	search_label
		or	bx,bx
		jz	lbl_disable
		mov	byte [bx + 2],1
lbl_disable:	ret

chk_extlabel:	push	bp
		push	si
		mov	bp,si
		call	dig_partition
		cmp	word [dig_level],byte 0
		jz	chkextlbl9
		mov	si,digbuffer
		xor	ax,ax
chkextlbl1:	mov	al,[si + 4]
		or	al,al
		jz	chkextlbl2
		call	is_extid
		jz	chkextlbl2
		inc	ah
		push	ax
		call	is_lblenable
		pop	ax
chkextlbl2:	add	si,byte MBR_PART_SIZE
		cmp	si,[digbuf_ptr]
		jl	chkextlbl1
chkextlbl9:	call	init_digparam
		pop	si
		pop	bp
		ret

;;	Enter:	si = partition table
;;		ah = table_index(0:mbr, 1 ... n: ext)
;;		al = sys-id
;;	Return:	bx = label address
search_label:	push	si
		push	ax
		call	table_crc
		pop	cx
		mov	bx,label_buff
selbl_loop:	;;cmp	cl,[bx]
		cmp	cx,[bx]
		jnz	selbl_next
		cmp	ax,[bx + 6]
		jnz	selbl_next
		cmp	dx,[bx + 8]
		jz	selbl_found
selbl_next:	add	bx,byte LABEL_SIZE
		cmp	bx,Label_crc
		jl	selbl_loop
		xor	bx,bx
selbl_found:	pop	si
		ret

label_newptr:	mov	bx,label_buff
lblnew_loop:	cmp	byte [bx],0
		jz	lblnew_found
		add	bx,byte LABEL_SIZE
		cmp	bx,Label_crc
		jl	lblnew_loop
		xor	bx,bx
lblnew_found:	ret

;;	Enter:	bx = label ptr
label_flush:	push	bp
		mov	bp,si
		cmp	word [dig_level],byte 0
		jnz	lblfls_ext
		xor	ax,ax
		call	make_partInfo
		mov	bx,LeftCursParam0
		mov	ax,[bx]
		jmp	short lblfls_out
lblfls_ext:
		mov	bx,LeftCursParam1
		mov	ax,[bx]
		push	ax
		push	bx
		add	ax,[bx + 6]
		call	make_partInfoN
		pop	bx
		pop	ax
lblfls_out:	mov	dx,[bx + 10]
		mov	cx,[bx + 4]
		dec	ax
		shl	ax,cl
		add	dh,al
		call	putstr_norm_ln
		pop	bp
		ret

Label_Name:	cmp	word [mainCmd_ptr],leftCmd_ptr
		jnz	lblnam_ret
%ifndef SAVE_EACH_HDD
		cmp	byte [current_drv],0x80
		jnz	lblnam_ret
%endif
		cmp	word [dig_level],byte 0
		jnz	lblnam_ext
		xchg	si,bp
		call	mbr_index_one
		xchg	si,bp
		xor	ax,ax
		jmp	short lblnam_old
lblnam_ext:
		mov	ax,[LeftCursParam1]
		add	ax,[LeftCursParam1 + 6]
		push	ax
		xchg	si,bp
		call	dig_index_one
		xchg	si,bp
		pop	ax
		xchg	al,ah
lblnam_old:	mov	al,[si + 4]
		call	search_label
		or	bx,bx
		jnz	lblnam_get
		call	label_newptr
		or	bx,bx
		jnz	lblnam_get
		mov	dx,AltCmdResPos
		mov	si,no_table_entry
		call	putstr_norm
lblnam_ret:	ret

;;	Enter:	bx = label entry
;;		si = table ptr
;;	Return: ax = str address (if <Esc> ax == 0)
lblnam_get:	push	bp
		mov	bp,sp
		sub	sp,byte 4
		mov	[bp - 2],bx
		mov	[bp - 4],si
		mov	dx,AltCmdEntPos
		mov	si,label_prompt
		mov	cx,20
		mov	bx,' ~'
		call	get_line
		or	ax,ax
		jz	lblnam_can
		mov	bx,[bp - 2]
		mov	di,bx
		add	di,byte 10
		mov	si,ax
		mov	al,[si]
		or	al,al
		jz	lblnam_clr
lblnam_set:	lodsb
		stosb
		or	al,al
		jnz	lblnam_set
		mov	si,[bp - 4]
		xor	ax,ax
		cmp	[dig_level],ax
		jz	lblnam_crc
		mov	ax,[LeftCursParam1]
		add	ax,[LeftCursParam1 + 6]
		mov	ah,al
lblnam_crc:	mov	al,[si + 4]
		push	ax
		push	bx
		call	table_crc
		pop	bx
		mov	[bx + 6],ax
		mov	[bx + 8],dx
		pop	ax
		mov	[bx],ax
		jmp	short lblnam_update
lblnam_clr:	mov	[bx],al
		mov	si,[bp - 4]
lblnam_update:	call	label_flush
		call	set_labelcrc
		or	byte [Cond_flag],Cond_UpParam
lblnam_can:	call	clear_msgln
		mov	sp,bp
		pop	bp
		ret

;;	Enter:	si = pattition table ptr
;;		ah = table index
;;	Return:	dx.ax
table_crc:	push	di
		push	si
		mov	di,workbuff
		mov	bx,di
		or	ah,ah
		jnz	tblcrc2
		xor	ax,ax
		times 4 stosw
		jmp	short tblcrc4
tblcrc2:	mov	al,ah
		xor	ah,ah
		push	bp
		call	take_offset
		pop	bp
tblcrc4:	pop	si
		push	si
		add	si,byte 8
		times 4 movsw
		mov	cx,16		;; 8 + 8
		pop	si
		pop	di
		jmp	short crc32

labelbuf_crc:	mov	bx,label_buff
		mov	cx,label_buffln

CRCPOLY_L	equ	0x8320
CRCPOLY_H	equ	0xedb8

;;	Enter:	cx = length
;;		bx = buffer address
;;	Return:	dx.ax = crc32
crc32:		push	si
		mov	si,bx
		mov	bx,0xffff	; res.lo
		mov	dx,bx		; res.hi
		push	bx
crc32a:		lodsb			; char
		xor	ah,ah
		xor	bx,ax
		xor	ax,ax
		xor	dx,ax
		push	cx
		mov	cx,8
crc32b:		shr	dx,1
		rcr	bx,1
		jnc	crc32c
		xor	bx,CRCPOLY_L
		xor	dx,CRCPOLY_H
crc32c:		loop	crc32b
		pop	cx
		loop	crc32a
		pop	ax
		xor	dx,ax
		xor	ax,bx
		pop	si
		ret

load_param:
%ifndef COM_DEBUG
		mov	ax,[wake_drv]
		test	al,0x80
		jnz	copy_param
		cmp	byte [current_drv],0x80
		jnz	copy_param

		xor	dh,dh
		mov	dl,al
		mov	bx,BOOT_LOC + SECTOR_SIZE
		mov	cx,2
		mov	ax,0x0201
		int	DISKBIOS
		jnc	load_fd9
		call	diskerr_msg
		stc
load_fd9:	ret
%endif
copy_param:	mov	si,diskbuff + SECTOR_SIZE
copy_param1:	mov	di,BOOT_LOC + SECTOR_SIZE
		mov	cx,256
		rep movsw
		ret

Save_Param:	test	byte [Cond_flag],Cond_UpParam
		jz	save_param9
		mov	ax,saveto_hd
		test	byte [wake_drv],0x80
%ifdef SAVE_EACH_HDD
		jnz	save_param8
%else
		jnz	save_param7
%endif
		mov	ax,saveto_fd
save_param7:	cmp	byte [current_drv],0x80
		jnz	save_param9
save_param8:	call	do_saveparm
save_param9:	ret

do_saveparm:	push	si
		push	bx
		push	bp
		push	ax
		mov	dx,AltCmdResPos
		mov	si,saveparam_msg
		call	putstr_norm
		add	dl,al
		pop	ax
		push	dx			;; next cursor position
		push	ax
		call	move_cursor
		mov	ax,0x301
		mov	bx,ParamBuff
		mov	bp,ParamPtr
		pop	dx			;; call address
		call	dx
		pop	dx
		mov	si,fail_msg
		jc	do_saveprm8
		and	byte [Cond_flag],(0xff ^ Cond_UpParam)
		mov	si,ok_msg
do_saveprm8:	call	putstr_norm
		pop	bp
		pop	bx
		pop	si
		ret

saveto_hd:
%ifdef COM_DEBUG
		call	debug_fout
		clc
%else
		xor	si,si
		call	diskio
%endif
		ret

saveto_fd:
%ifdef COM_DEBUG
		call	debug_fout
		clc
%else
		mov	cx,2
		mov	dl,[wake_drv]
		xor	dh,dh
		int	DISKBIOS
		jnc	saveto_fd9
		call	diskerr_msg
		stc
%endif
saveto_fd9:	ret

%ifdef HOOKUP13
%include	"hookup13.inc"
%endif

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
%ifdef COM_DEBUG
%include	"debugsub.inc"
%endif
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;		section	.data
		align	2
%ifdef COM_DEBUG
nr_hdds:	dw	1
%else
nr_hdds		equ	0x0475
%endif

;;	function table
CursParams:	dw	RightCursParam
RightCursParam:	dw	4, 4, 1, 0, r_menuChk,
		dw	Right_Y1 * 256 + Right_X - 1, Right_Width
LeftCursParam0:	dw	0, MBR_NR_PART, 1, 0, l_itemChk,
		dw	Left_Y * 256 + Left_X - 1, Left_Width
LeftCursParam1:	dw	0, 0, 0, 0, 0,
		dw	Left_Y * 256 + Left_X - 1, Left_Width
		dw	digbuffer, MBR_PART_SIZE, dig_show_one
Right_menu_tab:	dw	Right_menu1, Right_Y1 * 256 + Right_X, switch_HD
Right_menu_ln	equ	$ - Right_menu_tab
		dw	Right_menu2, Right_Y2 * 256 + Right_X, Left_Bs
		dw	Right_menu3, Right_Y3 * 256 + Right_X, Boot1
		dw	Right_menu4, Right_Y4 * 256 + Right_X, Boot0
leftCmd_ptr:	dw	Left_Up, Left_Down, Left_Tab, Left_Tab, Left_Enter
		dw	Left_Spc, Left_End, Left_Zero, Left_Bs
rightCmd_ptr:	dw	Right_Up, Right_Down, Right_Tab, Right_Tab, Right_Enter
mainCmd_ptr:	dw	leftCmd_ptr
curs_mvkey:	dw	UP_SCAN, KEY_k
		dw	DOWN_SCAN, KEY_j
		dw	LEFT_SCAN, KEY_h
		dw	RIGHT_SCAN, KEY_l
curs_mvkey_ln	equ	$ - curs_mvkey
alt_cmdkeys:	dw	0x1400, 0x3100, 0x1f00
		;;;;	Alt_t,  Alt_n,  Alt_s
alt_cmdkey_ln	equ	$ - alt_cmdkeys
alt_cmdtab:	dw	Chg_Timeout, Label_Name, Save_Param
nullmsg:
ParamPtr:	db	0, 0, 2, 0, 0, 0, 0, 0,
		dw	1, 0, 0, 0
helpmsg:	dw	help1,help2,help3,help4,help5,help6,help7,help8,help9,0
versionmsg:	dw	nullmsg,version1,nullmsg,version2  ;;,version3,version4
		dw	version5,nullmsg,help9,0
;;
;;	messages
Head_drive:	db	"Drive: "
Head_drive_e:	equ 	$
Head_mode:	db	"mode: "
Head_mode_e:	equ	$
Head_CHS:	db	"CHS"
Head_LBA:	db	"LBA"
Head_dig:	db	"Inside:#"
Head_dig_ln	equ	$ - Head_dig
Right_menu1:	db	"Change target Drive",0
Right_menu2:	db	0, "eturn to MBR",0
Right_menu2s:	db	'R'
Right_menu3:	db	"Mark active and Boot",0
Right_menu4:	db	"Boot",0
Guid_msg:	db	0x1b, 0x18, 0x19, 0x1a,
		db	":move cursor, <Enter>:Action, ?:Help",0
ErrMsgHead:	db	"Error:",0
ErrMsgHead_ln	equ	$ - ErrMsgHead
DiskErrmsg:	db	"Disk BIOS Error, code=0x"
DiskErrmsg_ln	equ	$ - DiskErrmsg
NoIPLMagic:	db	"No IPL Magic",0
CorruptedIPL:	db	"Corrupted IPL",0
CannotBoot:	db	"Impossible to boot", 0
Abort_msg:	db	"Aborted.",0
timer_prompt:	db	"Time to pause before boot:"
timer_prompt_ln	equ	$ - timer_prompt
label_prompt:	db	"Enter Name (20 chars max):", 0
no_table_entry:	db	"No table for new entry", 0
saveparam_msg	db	"Saving.. ",0
help9:		db	16
continue_msg:	db	" Hit <Enter> to continue",0
ok_msg:		db	"Ok.",0
fail_msg:	db	"Fail.",0
skipHD_msg:	db	"HD#"
skipHD_unit:	db	" :Invalid MBR,",0
%ifdef VERBOSE
Pause_msg:	db	"extipl....",0
%endif
help1:		db	0,"Cursor in this area,",0
help2:		db	8,"following keys recognized:",0
help3:		db	2,'<Enter>:same as "Boot"',0
help4:		db	4,'<End>:same as "Mark active and Boot"',0
help5:		db	5,'<BS>:same as "Return to MBR"',0
help6:		db	7,'0 :same as "Change target Drive"',0
help7:		db	2,"<Space>:show content extended-partition",0
help8:		db	0,"Please read document for more details.",0

%include	"version.inc"
%include	"sysidtbl.inc"

%ifdef COM_DEBUG
int13hook_msg	db	"DISK BIOS hooked.",0
%endif

		;;section .bss
begin_bss	equ	$
Cond_flag	equ	begin_bss + 0
diskio_func	equ	Cond_flag + 2
current_drv	equ	diskio_func + 2
save_curstype	equ	current_drv + 2
keybd_stat	equ	save_curstype + 2
base_slice	equ	keybd_stat + 2
offset		equ	base_slice + 2
dig_level	equ	offset + 8
dig_part	equ	dig_level + 2
dig_initparamln	equ	dig_part - base_slice
digbuf_ptr	equ	dig_part + 2
wake_drv	equ	digbuf_ptr + 2
lba_packet	equ	wake_drv + 2
linebuff	equ	lba_packet + LBA_PACKET_SIZE
workbuff	equ	linebuff + 512
vrambuff	equ	workbuff + 1024

;;
;;	end of extipl/Gemini*castor
