;;  altair.asm: Extended-IPL/aquila
;;
;;					Auther : takamiti@tsden.org
;;					last update : 2001/07/01
;;
;;	This program requires NASM - "The Netwide Assembler"
;;	You can get the NASM from http://www.web-sites.co.uk/nasm/
;;
;;  $Id: altair.asm,v 1.2 2001/07/02 15:35:12 takamiti Exp $
;;

%include	"biosdef.inc"
%include	"ipldef.inc"

TRIGGER_BIT	equ	CAPS_BIT
; TRIGGER_BIT	equ	SHIFT_BIT

lba_packet	equ	BOOT_LOC + SECTOR_SIZE
lba_blkaddr	equ	lba_packet + 8
tableptr	equ	lba_packet + 20


		bits	16
		section .text

		org	0x0600

;=======================================================
;		LBA/CHS supported extendedIPL
;=======================================================
base:		xor	ax,ax
		mov	ss,ax
		mov	es,ax
		mov	ds,ax
		mov	sp,BIOS_LOC
		mov	si,sp
		cld
		mov	di,BOOT_LOC
		mov	cx,256
		repnz	movsw
%ifdef FDTEST
		jmp	launcher - BIOS_LOC + BOOT_LOC
%else
		jmp	start - BIOS_LOC + BOOT_LOC
%endif

start:		mov	al,[kbd_stat]
		and	al,TRIGGER_BIT
start_com:
		push	ax				;; save autoboot-flag
chkTable0:	mov	di,lba_blkaddr
		xor	ax,ax
		times 4 stosw
		mov	bx,mbrselect
		mov	[bx],ax				;; set 0 to mbrselect
		xchg	ax,bp
		mov	byte [bx + 2],0x30		;; set "0,0" to prompt
		;;mov	byte [bx + 2],0x60
		mov	di,BOOT_LOC + PART_TBL_OFS
chkTable:	call	initCRT
		mov	[tableptr],di			;; set pointer to patition-table
		mov	cx,4
		mov	byte [bx],'1'			;; set '1' to mbrselect
		mov	si,guid_msg
		call	putstr
		mov	dl,'0'
chtabloop:	inc	dx
		test	byte [di],0x80			;; check active flag
		jz	prntab
		mov	[bx],dl				;; set 'partition-number' to mbrselect
		pop	ax
		push	ax
		or	ax,ax				; check autoboot-flag
		jz	bootProc			; yes -> Boot!!
		and	byte [di],0x7F			; mask active flag
prntab:		mov	al,dl				; display table contents
		call	putch
		mov	al,[di + 4]
		or	al,al
		jz	nosys
		push	cx
		mov	cl,3
		call	spaceHex
		pop	cx
nosys:		add	di,byte 16
		call	putCRLF
		loop	chtabloop

keyin_loop:	mov	si,prompt_msg
		call	putstr
keyin:		xor	ah,ah
		int	KEYBIOS				; get char
		cmp	al,0x31				; '1'
		jc	chk_actionkey
		cmp	al,0x34				; '4'
		ja	keyin
		mov	[bx],al
		jmp	short keyin_loop

chk_actionkey:	cmp	al,0x08				; <BS> key to show MBR
		jz	chkTable0
		cmp	al,0x0d				; <Enter> to boot
		jz	bootProc
bell_continue:	call	bell
		jmp	short keyin_loop

bootProc:	mov	ah,[bx]
		sub	ah,0x31
		mov	al,16
		mul	ah
		add	ax,[tableptr]
		xchg	ax,si				; boot-ptr in si-regs
		mov	al,[si + 4]			; get sysID
		or	al,al
		jz	bell_continue			; this is empty partition

		cmp	al,EXTDOS_PART
		jz	ext_proc
		cmp	al,EXTLINUX_PART
		jz	ext_proc
		cmp	al,EXTDOSLBA_PART
		jnz	boot_0
ext_proc:	or	bp,bp
		jz	ext_baseset
		mov	di,lba_blkaddr
		mov	ax,[bp + 8]
		stosw
		mov	ax,[bp + 10]
		stosw
		xor	ax,ax
		times 2 stosw
		jmp	short ext_read

ext_baseset:	mov	bp,si
ext_read:	call	disk_read
		mov	di,BIOS_LOC + PART_TBL_OFS	; make extended-part prompt
		mov	bx,extselect
		mov	byte [bx - 3],'.'
		inc	byte [bx - 2]
		jmp	chkTable

boot_0:		call	disk_read
		cmp	word [BIOS_LOC + IPL_MAGIC_OFS],IPL_MAGIC
		jz	boot_1
		pop	ax
		push	ax
		or	ax,ax
		jnz	bell_continue
		pop	ax
		inc	ax
		jmp	start_com

boot_1:		or	bp,bp
		jz	boot_2
		mov	si,bp
boot_2:		mov	byte [si],dl				; set active flag
		call	initCRT
		jmp	BIOS_LOC				; exec loader

;; ==============================================
;;	sub routines
;; ==============================================
disk_read:	push	si
		push	bx
		mov	bx,0x55aa
		mov	dl,0x80
		mov	ah,0x41					; check BIOS extention
		int	DISKBIOS
		jc	rd_legacy				;
		shr	cx,1					;
		jnc	rd_legacy				;

rd_extention:	mov	di,lba_packet
		push	di
		mov	ax,16					; packet length
		stosw
		mov	al,1					; transfer blocks
		stosw
		mov	ax,BIOS_LOC				; buffer address(Lo)
		stosw
		mov	ax,ds					; buffer address(Hi)
		stosw
		add	si,byte 8
		lodsw
		add	ax,[di]
		stosw						; block address(0)
		lodsw
		adc	ax,[di]
		stosw						; block address(1)
		mov	ax,0
		adc	ax,0
		stosw						; block address(2)
		xor	ax,ax
		stosw						; block address(3)
		pop	si					; packet address
		mov	ah,0x42
		jmp	short int13func

rd_legacy:	lodsw
		mov	dh,ah
		lodsw
		xchg	ax,cx
		mov	ax,0x0201
int13func:	mov	bx,BIOS_LOC
		int	DISKBIOS
		pop	bx
		pop	si
		jnc	return

		push	ax					; disk-BIOS error
		mov	si,diskerr_msg
		call	putstr
		pop	ax
		mov	al,ah
		call	hex2
giveup:		;;hlt
		jmp	short giveup

initCRT:	mov	ax,2
		jmp	short putch1

bell:		mov	al,BELL
putch:		mov	ah,14
putch1:		int	VIDEOBIOS
return:		ret

spaceHex:	push	ax
put_spc_loop:	mov	al,' '
		call	putch
		loop	put_spc_loop
		pop	ax
hex2:		push	ax
		mov	cl,4
		shr	al,cl
		call	hex1
		pop	ax
hex1:		and	al,0x0F
		add	al,0x30
		cmp	al,0x3A
		jc	putch
		add	al,7
		jmp	short putch

putCRLF:	mov	si,crlf_msg
putstr:		lodsb
		or	al,al
		jz	return
		call	putch
		jmp	short putstr

guid_msg:	db	"No Sys"
crlf_msg:	db	CR, LF, NULL
prompt_msg:	db	CR, "Boot>"
mbrselect:	db	'0', NULL
depth:		db	0x30, ','
extselect:	db	NULL, NULL
diskerr_msg:	db	BELL," ?:",0


%ifdef FDTEST
launcher:	mov	si,launcher_1
		mov	di,BOOT_LOC + SECTOR_SIZE
		push	di
		mov	cx,launcher_ln
		inc	cx
		shr	cx,1
		rep movsw
		ret
launcher_1:	mov	ax,0x201
		mov	bx,BIOS_LOC
		mov	cx,1
		mov	dx,0x80
		int	DISKBIOS
		mov	si,BIOS_LOC + PART_TBL_OFS
		mov	di,BOOT_LOC + PART_TBL_OFS
		mov	cx,32
		rep movsw
		push	word start
		ret
launcher_ln	equ	$ - launcher_1
%endif

;;
;;	end of altair.asm
;;
