#!/bin/sh
echo "Creating symbolic links and setting permissions as needed."
chmod 660 site.ini
if [ -f "override/site.ini" ]; then
    chmod 660 override/site.ini
fi
if [ -f "override/site.ini.append" ]; then
    chmod 660 override/site.ini.append
fi

touch error.log
chmod 660 error.log

# [cache section]
# This part will create the cache dirs which are needed and make sure
# that they are writeable by php.

dirs="
admin/tmp
classes/cache
ezad/admin/cache
ezaddress/admin/cache
ezarticle/admin/cache
ezarticle/cache
ezbug/admin/cache
ezbug/user/cache
ezbulkmail/admin/cache
ezcalendar/admin/cache
ezcalendar/user/cache
ezcontact/admin/cache
ezfilemanager/admin/cache
ezfilemanager/files
ezform/admin/cache
ezforum/admin/cache
ezforum/cache
ezimagecatalogue/admin/cache
ezimagecatalogue/catalogue
ezimagecatalogue/catalogue/variations
ezlink/admin/cache
ezlink/cache
ezmediacatalogue/admin/cache
ezmediacatalogue/cache
ezmediacatalogue/catalogue
ezmessage/admin/cache
eznewsfeed/admin/cache
eznewsfeed/cache
ezpoll/admin/cache
ezpoll/cache
ezquiz/admin/cache
ezquiz/cache
ezsitemanager/admin/cache
ezsitemanager/staticfiles
ezsitemanager/staticfiles/images
ezstats/admin/cache
eztodo/admin/cache
eztrade/admin/cache
eztrade/cache
ezurltranslator/admin/cache
ezuser/admin/cache
"

for dir in $dirs
do
    if [ -d $dir ]; then
	    echo "$dir already exist"
    else
        echo "Creating $dir"
	    mkdir -p $dir
    fi
    chmod 770 $dir   
done

for dir in $dirs
do
    override_dir="override/"$dir
    if [ -d $override_dir ]; then
	chmod 770 $override_dir
    fi
done

# [admin section]
# This part will link the modules into the admin directory
#
# Obsolete as of version 2.0.1

#  files="
#  error.log
#  ezlink
#  site.ini
#  ezforum
#  ezarticle
#  ezad
#  classes
#  ezclassified
#  ezimagecatalogue
#  ezfilemanager
#  ezpoll
#  ezuser
#  ezsession
#  ezcontact
#  ezstats
#  eztodo
#  eznewsfeed
#  eztrade
#  ezaddress
#  ezbug
#  ezcalendar
#  ezerror
#  checkout
#  "

#  for file in $files
#  do
#      if [ -e $file ]; then
#  	if [ -e admin/$file ]; then
#  	    echo "admin/$file already exist"
#  	else
#  	    echo "Linking ./$file to admin/$file"
#  	    ln -s ../$file admin/$file
#  	fi
#      fi
#  done

#  if [ -d "override" ]; then
#      if [ ! -d "admin/override" ]; then
#  	echo "Linking override to admin/override"
#  	ln -sf ../override admin/override
#      fi
#  fi
