/* $Id$
 * AttributeSpecification: contains the combination of AttributeSpecification 
 * to it's initializer Expression (AST node).
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ATTRIBUTE_SPECIFICATION_HPP_INCLUDED
#define __ATTRIBUTE_SPECIFICATION_HPP_INCLUDED

#include "frontend/ast/Expression.hpp"
#include "frontend/ast/AttributeDeclaration.hpp"

namespace ast {

class AttributeSpecification : public SymbolDeclaration {
public:
	//! c'tor
	/** @param initializer initializer Expression
	 *  @param decl corresponding attribute declaration 
	 *  @param loc Location of the specification
	 */
	AttributeSpecification(
		Expression *initializer,
		AttributeDeclaration *decl,
		Location loc
		) : 	SymbolDeclaration(NULL, loc),
			init(initializer),
			declaration(decl) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const;

	/** initializer */
	Expression *init;

	/** corresponding attribute declaration */
	AttributeDeclaration *declaration;

protected:
	/** destructor */
	virtual ~AttributeSpecification() {
		util::MiscUtil::terminate(this->init);
		util::MiscUtil::terminate(this->declaration);
	}
	
};

}; /* namespace ast */

#endif /* __ATTRIBUTE_SPECIFICATION_HPP_INCLUDED */
