/*
 * $Id: loudspeaker_aui_gen.c,v 1.5 2009-06-03 11:34:09 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue-aui-gen.h"

#include "loudspeaker_aui.h"

struct cpssp {
	AuiGenChannel *channel;
};

/*
 * Simulator Callbacks
 */
static void
loudspeaker_aui_audio_sound_samples_set(void *_cpssp, int16_t *samples)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	aui_gen_channel_play(cpssp->channel, samples);
}

void *
loudspeaker_aui_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_sound *port_sound_in,
	struct sig_sound *port_audio_sound
)
{
	static const struct sig_sound_funcs audio_sound_funcs = {
		.samples_set = loudspeaker_aui_audio_sound_samples_set,
	};
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->channel = aui_gen_channel_new();

	sig_sound_connect(port_audio_sound, cpssp, &audio_sound_funcs);

	return cpssp;
}

void
loudspeaker_aui_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
