/*
 * $Id: conv_zero.c,v 1.1 2009-10-26 09:02:06 vrsieh Exp $
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

void *
conv_zero_open(const char *filename)
{
	return (void *) 1;
}

int
conv_zero_close(void *_c)
{
	assert(_c == (void *) 1);

	return 0;
}

long long
conv_zero_read(
	void *_c,
        void *_buf,
	unsigned long long buflen,
	unsigned long long pos
)
{
	assert(_c == (void *) 1);
	
	memset(_buf, 0, buflen);

	return buflen;
}
