/*
 *  Software MMU support
 * 
 *  Copyright (c) 2005-2009 FAUmachine Team.
 *  Copyright (c) 2003 Fabrice Bellard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */
#if DATA_SIZE == 8
#define SUFFIX q
#define USUFFIX q
#define DATA_TYPE uint64_t
#elif DATA_SIZE == 4
#define SUFFIX l
#define USUFFIX l
#define DATA_TYPE uint32_t
#elif DATA_SIZE == 2
#define SUFFIX w
#define USUFFIX uw
#define DATA_TYPE uint16_t
#define DATA_STYPE int16_t
#elif DATA_SIZE == 1
#define SUFFIX b
#define USUFFIX ub
#define DATA_TYPE uint8_t
#define DATA_STYPE int8_t
#else
#error unsupported data size
#endif

#if ACCESS_TYPE == 0

#define CPU_MEM_INDEX 0
#define MMUSUFFIX _mmu

#elif ACCESS_TYPE == 1

#define CPU_MEM_INDEX 1
#define MMUSUFFIX _mmu

#elif ACCESS_TYPE == 2

#define CPU_MEM_INDEX ((env->hflags & HF_CPL_MASK) == 3)
#define MMUSUFFIX _mmu

#elif ACCESS_TYPE == 3

#define CPU_MEM_INDEX ((env->hflags & HF_CPL_MASK) == 3)
#define MMUSUFFIX _cmmu

#else
#error invalid ACCESS_TYPE
#endif

#if DATA_SIZE == 8
#define RES_TYPE uint64_t
#else
#define RES_TYPE int
#endif


#if ACCESS_TYPE == 0 || ACCESS_TYPE == 3	/* FIXME VOSSI */
DATA_TYPE REGPARM(1) glue(glue(NAME_(__ld), SUFFIX), MMUSUFFIX)(Vaddr addr,
                                                         int is_user);
void REGPARM(2) glue(glue(NAME_(__st), SUFFIX), MMUSUFFIX)(Vaddr addr, DATA_TYPE v, int is_user);
#endif

static inline __attribute__((__always_inline__)) RES_TYPE
glue(glue(ld, USUFFIX), MEMSUFFIX)(Vaddr ptr)
{
    int index_;
    RES_TYPE res;
    Vaddr addr;
    Haddr hostaddr;
    int is_user;
    struct CPUTLBEntry *tlb_entry;

    addr = ptr;
    index_ = (addr >> TARGET_PAGE_BITS) & (CPU_TLB_SIZE - 1);
    is_user = CPU_MEM_INDEX;
#if ACCESS_TYPE == 3
	tlb_entry = &env->tlb_code[is_user][index_];
#else
	tlb_entry = &env->tlb_read[is_user][index_];
#endif
    if (__builtin_expect(tlb_entry->address != 
                         (addr & (TARGET_PAGE_MASK | (DATA_SIZE - 1))), 0)) {
        res = glue(glue(NAME_(__ld), SUFFIX), MMUSUFFIX)(addr, is_user);
    } else {
        hostaddr = addr + tlb_entry->host_addend;
        res = glue(glue(ld, USUFFIX), _raw)(hostaddr);
    }
    return res;
}

#if DATA_SIZE <= 2
static inline __attribute__((__always_inline__)) int
glue(glue(lds, SUFFIX), MEMSUFFIX)(Vaddr ptr)
{
    int res, index_;
    Vaddr addr;
    Haddr hostaddr;
    int is_user;
    struct CPUTLBEntry *tlb_entry;

    addr = ptr;
    index_ = (addr >> TARGET_PAGE_BITS) & (CPU_TLB_SIZE - 1);
    is_user = CPU_MEM_INDEX;
#if ACCESS_TYPE == 3
	tlb_entry = &env->tlb_code[is_user][index_];
#else
	tlb_entry = &env->tlb_read[is_user][index_];
#endif
    if (__builtin_expect(tlb_entry->address != 
                         (addr & (TARGET_PAGE_MASK | (DATA_SIZE - 1))), 0)) {
        res = (DATA_STYPE)glue(glue(NAME_(__ld), SUFFIX), MMUSUFFIX)(addr, is_user);
    } else {
        hostaddr = addr + tlb_entry->host_addend;
        res = glue(glue(lds, SUFFIX), _raw)(hostaddr);
    }
    return res;
}
#endif /* DATA_SIZE <= 2 */

/* generic store macro */

static inline __attribute__((__always_inline__)) void
glue(glue(st, SUFFIX), MEMSUFFIX)(Vaddr ptr, RES_TYPE v)
{
    int index_;
    Vaddr addr;
    Haddr hostaddr;
    int is_user;

    addr = ptr;
    index_ = (addr >> TARGET_PAGE_BITS) & (CPU_TLB_SIZE - 1);
    is_user = CPU_MEM_INDEX;
    if (__builtin_expect(env->tlb_write[is_user][index_].address != 
                         (addr & (TARGET_PAGE_MASK | (DATA_SIZE - 1))), 0)) {
        glue(glue(NAME_(__st), SUFFIX), MMUSUFFIX)(addr, v, is_user);
    } else {
        hostaddr = addr + env->tlb_write[is_user][index_].host_addend;
        glue(glue(st, SUFFIX), _raw)(hostaddr, v);
    }
}

#if DATA_SIZE == 8
static inline __attribute__((__always_inline__)) double
glue(ldfq, MEMSUFFIX)(Vaddr ptr)
{
    union {
        double d;
        uint64_t i;
    } u;
    u.i = glue(ldq, MEMSUFFIX)(ptr);
    return u.d;
}

static inline __attribute__((__always_inline__)) void
glue(stfq, MEMSUFFIX)(Vaddr ptr, double v)
{
    union {
        double d;
        uint64_t i;
    } u;
    u.d = v;
    glue(stq, MEMSUFFIX)(ptr, u.i);
}
#endif /* DATA_SIZE == 8 */

#if DATA_SIZE == 4
static inline __attribute__((__always_inline__)) float
glue(ldfl, MEMSUFFIX)(Vaddr ptr)
{
    union {
        float f;
        uint32_t i;
    } u;
    u.i = glue(ldl, MEMSUFFIX)(ptr);
    return u.f;
}

static inline __attribute__((__always_inline__)) void
glue(stfl, MEMSUFFIX)(Vaddr ptr, float v)
{
    union {
        float f;
        uint32_t i;
    } u;
    u.f = v;
    glue(stl, MEMSUFFIX)(ptr, u.i);
}
#endif /* DATA_SIZE == 4 */

#undef RES_TYPE
#undef DATA_TYPE
#undef DATA_STYPE
#undef SUFFIX
#undef USUFFIX
#undef DATA_SIZE
#undef CPU_MEM_INDEX
#undef MMUSUFFIX
