/*
 * Copyright (C) 2007-2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define DEBUG_IO	0

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

// struct {
// } NAME;

#endif /* STATE */
#ifdef EXPORT


#endif /* EXPORT */
#ifdef BEHAVIOR

uint8_t
CHIP_(inb)(struct cpssp *cpssp, paddr_t port)
{
	uint8_t val8;

#if defined(CONFIG_CPU_SOCKET_ISA)
	/* 16 Bit Data Bus */
	uint16_t val16;

	NAME_(bus_ior)(cpssp, port & ~1, 1 << (port & 1), &val16);
	val8 = (val16 >> ((port & 1) * 8)) & 0xff;

#elif defined(CONFIG_CPU_SOCKET_HOST) \
	|| defined(CONFIG_CPU_SOCKET_SLOT1)
	/* 32 Bit Data Bus */
	uint32_t val32;

	NAME_(bus_ior)(cpssp, port & ~3, 1 << (port & 3), &val32);
	val8 = (val32 >> ((port & 3) * 8)) & 0xff;

#elif defined(CONFIG_CPU_SOCKET_HOST775)
	/* 64 Bit Data Bus */
	uint64_t val64;

	NAME_(bus_ior)(cpssp, port & ~7, 1 << (port & 7), &val64);
	val8 = (val64 >> ((port & 7) * 8)) & 0xff;

#else
#error "Unknown socket."
#endif

	if (2 <= DEBUG_IO + loglevel) {
		fprintf(stderr, "%s: 0x%04x -> 0x%02x\n", __FUNCTION__,
				port, val8);
	}
	return val8;
}

uint16_t
CHIP_(inw)(struct cpssp *cpssp, paddr_t port)
{
	uint16_t val16;

#if defined(CONFIG_CPU_SOCKET_ISA)
	/* 16 Bit Data Bus */
	if (0 < (port & 1)) {
		uint16_t val0;
		uint16_t val1;

		NAME_(bus_ior)(cpssp, (port & ~1) + 0, (0x3 << (port & 1)) & 0x3, &val0);
		NAME_(bus_ior)(cpssp, (port & ~1) + 2, (0x3 << (port & 1)) >> 2, &val1);
		val16 = val0 | (val1 << 8);

	} else {
		NAME_(bus_ior)(cpssp, port, 0x3, &val16);
	}

#elif defined(CONFIG_CPU_SOCKET_HOST) \
	|| defined(CONFIG_CPU_SOCKET_SLOT1)
	/* 32 Bit Data Bus */
	if (2 < (port & 3)) {
		uint32_t val0;
		uint32_t val1;

		NAME_(bus_ior)(cpssp, (port & ~3) + 0, (0x3 << (port & 3)) & 0xf, &val0);
		NAME_(bus_ior)(cpssp, (port & ~3) + 4, (0x3 << (port & 3)) >> 4, &val1);
		val16 = (val0 >> ((port & 3) * 8))
		      | (val1 << ((4 - (port & 3)) * 8));

	} else {
		uint32_t val32;

		NAME_(bus_ior)(cpssp, port & ~3, 3 << (port & 3), &val32);
		val16 = (val32 >> ((port & 3) * 8)) & 0xffff;
	}

#elif defined(CONFIG_CPU_SOCKET_HOST775)
	/* 64 Bit Data Bus */
	if (6 < (port & 7)) {
		uint64_t val0;
		uint64_t val1;

		NAME_(bus_ior)(cpssp, (port & ~7) + 0, (0x3 << (port & 7)) & 0xff, &val0);
		NAME_(bus_ior)(cpssp, (port & ~7) + 8, (0x3 << (port & 7)) >> 8, &val1);
		val16 = (val0 >> ((port & 7) * 8))
		      | (val1 << ((8 - (port & 7)) * 8));

	} else {
		uint64_t val64;

		NAME_(bus_ior)(cpssp, port & ~7, 3 << (port & 7), &val64);
		val16 = (val64 >> ((port & 7) * 8)) & 0xffff;
	}
#else
#error "Unknown socket."
#endif

	if (2 <= DEBUG_IO + loglevel) {
		fprintf(stderr, "%s: 0x%04x -> 0x%04x\n", __FUNCTION__,
				port, val16);
	}
	return val16;
}

#if 80386 <= CONFIG_CPU
uint32_t
CHIP_(inl)(struct cpssp *cpssp, paddr_t port)
{
	uint32_t val32;

#if defined(CONFIG_CPU_SOCKET_HOST) \
	|| defined(CONFIG_CPU_SOCKET_SLOT1)
	/* 32 Bit Data Bus */
	if (0 < (port & 3)) {
		uint32_t val0;
		uint32_t val1;

		NAME_(bus_ior)(cpssp, (port & ~3) + 0, (0xf << (port & 3)) & 0xf, &val0);
		NAME_(bus_ior)(cpssp, (port & ~3) + 4, (0xf << (port & 3)) >> 4, &val1);
		val32 = (val0 >> ((port & 3) * 8))
		      | (val1 << ((4 - (port & 3)) * 8));

	} else {
		NAME_(bus_ior)(cpssp, port, 0xf, &val32);
	}

#elif defined(CONFIG_CPU_SOCKET_HOST775)
	/* 64 Bit Data Bus */
	if (4 < (port & 7)) {
		uint64_t val0;
		uint64_t val1;

		NAME_(bus_ior)(cpssp, (port & ~7) + 0, (0xf << (port & 7)) & 0xff, &val0);
		NAME_(bus_ior)(cpssp, (port & ~7) + 8, (0xf << (port & 7)) >> 8, &val1);
		val32 = (val0 >> ((port & 7) * 8))
		      | (val1 << ((8 - (port & 7)) * 8));

	} else {
		uint64_t val64;

		NAME_(bus_ior)(cpssp, port & ~7, 0xf << (port & 7), &val64);
		val32 = (val64 >> ((port & 7) * 8)) & 0xffffffff;
	}
#else
#error "Unknown socket."
#endif

	if (2 <= DEBUG_IO + loglevel) {
		fprintf(stderr, "%s: 0x%04x -> 0x%08x\n", __FUNCTION__,
				port, val32);
	}
	return val32;
}
#endif /* 80386 <= CONFIG_CPU */

void
CHIP_(outb)(struct cpssp *cpssp, uint8_t value, paddr_t port)
{
	if (2 <= DEBUG_IO + loglevel) {
		fprintf(stderr, "%s: 0x%04x <- 0x%02x\n", __FUNCTION__,
				port, value);
	}

#if DEBUG_BIOS_POST_CODE
	if (port == 0x0080
	 || port == 0x0300) {
		/* BIOS Post code. */
		fprintf(stderr, "BIOS: Post code 0x%02x.\n", value);

	}
#endif
	if (port == 0xffff) {
		/* System BIOS / VGA BIOS output port. */
		fprintf(stderr, "%c", value);
		return;
	}

#if defined(CONFIG_CPU_SOCKET_ISA)
	/* 16 Bit Data Bus */
	uint16_t val16;

	val16 = value << ((port & 1) * 8);
	NAME_(bus_iow)(cpssp, port & ~1, 1 << (port & 1), val16);

#elif defined(CONFIG_CPU_SOCKET_HOST) \
	|| defined(CONFIG_CPU_SOCKET_SLOT1)
	/* 32 Bit Data Bus */
	uint32_t val32;

	val32 = value << ((port & 3) * 8);
	NAME_(bus_iow)(cpssp, port & ~3, 1 << (port & 3), val32);

#elif defined(CONFIG_CPU_SOCKET_HOST775)
	/* 64 Bit Data Bus */
	uint64_t val64;

	val64 = (uint64_t) value << ((port & 7) * 8);
	NAME_(bus_iow)(cpssp, port & ~7, 1 << (port & 7), val64);
#else
#error "Unknown socket."
#endif
}

void
CHIP_(outw)(struct cpssp *cpssp, uint16_t value, paddr_t port)
{
	if (2 <= DEBUG_IO + loglevel) {
		fprintf(stderr, "%s: 0x%04x <- 0x%04x\n", __FUNCTION__,
				port, value);
	}

#if DEBUG_BIOS_POST_CODE
	if (port == 0x0080
	 || port == 0x0300) {
		/* BIOS Post code. */
		fprintf(stderr, "BIOS: Post code 0x%04x.\n", value);
	}
#endif

#if defined(CONFIG_CPU_SOCKET_ISA)
	/* 16 Bit Data Bus */
	if (0 < (port & 1)) {
		unsigned char value0 = (value >> 0) & 0xff;
		unsigned char value8 = (value >> 8) & 0xff;

		fprintf(stderr, "%s: WARNING: outw->outb port 0x%04x "
				"value 0x%x\n", __FUNCTION__, port, value);

		CHIP_(outb)(cpssp, value0, port + 0);
		CHIP_(outb)(cpssp, value8, port + 1);

	} else {
		NAME_(bus_iow)(cpssp, port, 3, value);
	}

#elif defined(CONFIG_CPU_SOCKET_HOST) \
	|| defined(CONFIG_CPU_SOCKET_SLOT1)
	/* 32 Bit Data Bus */
	uint32_t val32;

	if (2 < (port & 3)) {
		unsigned char value0 = (value >> 0) & 0xff;
		unsigned char value8 = (value >> 8) & 0xff;

		fprintf(stderr, "%s: WARNING: outw->outb port 0x%04x "
				"value 0x%x\n", __FUNCTION__, port, value);

		CHIP_(outb)(cpssp, value0, port + 0);
		CHIP_(outb)(cpssp, value8, port + 1);

	} else {
		val32 = value << ((port & 3) * 8);
		NAME_(bus_iow)(cpssp, port & ~3, 3 << (port & 3), val32);
	}

#elif defined(CONFIG_CPU_SOCKET_HOST775)
	/* 64 Bit Data Bus */
	uint64_t val64;

	if (6 < (port & 7)) {
		unsigned char value0 = (value >> 0) & 0xff;
		unsigned char value8 = (value >> 8) & 0xff;

		fprintf(stderr, "%s: WARNING: outw->outb port 0x%04x "
				"value 0x%x\n", __FUNCTION__, port, value);

		CHIP_(outb)(cpssp, value0, port + 0);
		CHIP_(outb)(cpssp, value8, port + 1);

	} else {
		val64 = (uint64_t) value << ((port & 7) * 8);
		NAME_(bus_iow)(cpssp, port & ~7, 3 << (port & 7), val64);
	}
#else
#error "Unknown socket."
#endif
}

#if 80386 <= CONFIG_CPU
void
CHIP_(outl)(struct cpssp *cpssp, uint32_t value, paddr_t port)
{
	if (2 <= DEBUG_IO + loglevel) {
		fprintf(stderr, "%s: 0x%04x <- 0x%08x\n", __FUNCTION__,
				port, value);
	}

#if DEBUG_BIOS_POST_CODE
	if (port == 0x0080
	 || port == 0x0300) {
		/* BIOS Post code. */
		fprintf(stderr, "BIOS: Post code 0x%08x.\n", value);
	}
#endif

#if defined(CONFIG_CPU_SOCKET_HOST) \
	|| defined(CONFIG_CPU_SOCKET_SLOT1)
	/* 32 Bit Data Bus */
	if (0 < (port & 3)) {
		uint32_t val0;
		uint32_t val1;

		fprintf(stderr, "%s: WARNING: outl->outw port 0x%04x "
			"value 0x%08lx\n", __FUNCTION__, port, (long)value);

		val0 = value << ((port & 3) * 8);
		val1 = value << ((4 - (port & 3)) * 8);

		NAME_(bus_iow)(cpssp, port & ~3, (0xf << (port & 3)) & 0xf, val0);
		NAME_(bus_iow)(cpssp, (port & ~3) + 4, 0xf >> (4 - (port & 3)), val1);

	} else {
		NAME_(bus_iow)(cpssp, port & ~3, 0xf, value);
	}

#elif defined(CONFIG_CPU_SOCKET_HOST775)
	/* 64 Bit Data Bus */
	if (4 < (port & 7)) {
		uint64_t val0;
		uint64_t val1;

		fprintf(stderr, "%s: WARNING: outl->outw port 0x%04x "
			"value 0x%08lx\n", __FUNCTION__, port, (long)value);

		val0 = (uint64_t) value << ((port & 7) * 8);
		val1 = (uint64_t) value << ((8 - (port & 7)) * 8);

		NAME_(bus_iow)(cpssp, port & ~7, (0xf << (port & 7)) & 0xff, val0);
		NAME_(bus_iow)(cpssp, (port & ~7) + 8, 0xf >> (8 - (port & 7)), val1);

	} else {
		uint64_t val64;

		val64 = (uint64_t) value << ((port & 7) * 8);
		NAME_(bus_iow)(cpssp, port & ~7, 0xf << (port & 7), val64);
	}
#else
#error "Unknown socket."
#endif
}
#endif /* 80386 <= CONFIG_CPU */

#endif /* BEHAVIOR */
