--
-- Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.ALL;
use expect.procedures.ALL;
library ieee;
use ieee.std_logic_1164.ALL;

entity test_bench is
end test_bench;

architecture structural of test_bench is
	signal vcc : std_logic;
	signal val : std_logic;
	signal gnd : std_logic;
	signal  voltage_1 : std_logic;
	signal  voltage_2 : std_logic;
	signal  voltage_3 : std_logic;
	signal  voltage_4 : std_logic;
	signal  voltage_5 : std_logic;
	signal  voltage_6 : std_logic;
	signal  voltage_7 : std_logic;
	signal  voltage_8 : std_logic;
	signal  voltage_9 : std_logic;
	signal  voltage_10 : std_logic;
	signal  digi_1 : std_logic;
	signal  digi_2 : std_logic;
	signal  digi_3 : std_logic;
	signal  digi_4 : std_logic;
	signal  digi_5 : std_logic;
	signal  digi_6 : std_logic;
	signal  digi_7 : std_logic;
	signal  digi_8 : std_logic;
	signal  digi_9 : std_logic;
	signal  digi_10 : std_logic;
	signal	sample_rate_gui_sim : integer;
	signal	sample_rate_sim_gui : integer;
	signal	sec_div_gui_sim : integer;
	signal	sec_div_sim_gui : integer;
	signal	volt_div_gui_sim: integer;
	signal	volt_div_sim_gui: integer;
	signal	channel_select:	integer;
	signal	trigger_sim_gui : integer;
	signal	trigger_gui_sim : integer;
	signal	vert_offset_sim_gui : integer;
	signal	vert_offset_gui_sim : integer;
	signal	monitor : opt_rgb;
	signal	start : std_logic;
	signal	stop : std_logic;
	signal	scroll_left : std_logic;
	signal	scroll_right : std_logic;
	signal export : std_logic;
	signal trigger_channel_gui_sim : integer;
	signal trigger_channel_sim_gui : integer;
	signal trigger_edge_gui_sim : integer;
	signal trigger_edge_sim_gui : integer;
	signal trigger_level_gui_sim : integer;
	signal trigger_level_sim_gui : integer;
	signal amp_div_gui_sim: integer;
	signal	amp_div_sim_gui: integer;
begin

	potentiometer : potentiometer
		port map (
			left => vcc,
			mid => val,
			right => gnd
		);

	red_pitaya : red_pitaya
		port map (
			voltage_1 => val,
			voltage_2 => voltage_1,
			voltage_3 => voltage_1,
			voltage_4 => voltage_1,
			voltage_5 => voltage_1,
			voltage_6 => voltage_1,
			voltage_7 => voltage_1,
			voltage_8 => voltage_1,
			voltage_9 => voltage_1,
			voltage_10 => voltage_1,
			digi_1 => val,
			digi_2 => voltage_1,
			digi_3 => voltage_1,
			digi_4 => voltage_1,
			digi_5 => voltage_1,
			digi_6 => voltage_1,
			digi_7 => voltage_1,
			digi_8 => voltage_1,
			digi_9 => voltage_1,
			digi_10 => voltage_1,
			sample_rate_gui_sim => sample_rate_gui_sim,
			sample_rate_sim_gui => sample_rate_sim_gui,
			sec_div_gui_sim => sec_div_gui_sim,
			sec_div_sim_gui => sec_div_sim_gui,
			volt_div_gui_sim => volt_div_gui_sim,
			volt_div_sim_gui => volt_div_sim_gui,
			channel_select => channel_select,
			trigger_sim_gui => trigger_sim_gui,
			trigger_gui_sim => trigger_gui_sim,
			vert_offset_sim_gui => vert_offset_sim_gui,
			vert_offset_gui_sim => vert_offset_gui_sim,
			monitor => monitor,
			vcc => vcc,
			gnd => gnd,
			start => start,
			stop => stop,
			scroll_left => scroll_left,
			scroll_right => scroll_right,
			export => export,
			trigger_channel_gui_sim => trigger_channel_gui_sim,
			trigger_channel_sim_gui => trigger_channel_sim_gui,
			trigger_edge_gui_sim => trigger_edge_gui_sim,
			trigger_edge_sim_gui => trigger_edge_sim_gui,
			trigger_level_gui_sim => trigger_level_gui_sim,
			trigger_level_sim_gui => trigger_level_sim_gui,
			amp_div_gui_sim => amp_div_gui_sim,
 			amp_div_sim_gui	=> amp_div_sim_gui
		);

	sinusgen : sinusgen
		port map (
			gnd => gnd,
			vcc => vcc,
			output => voltage_1
		);

	
	battery : battery
		generic map (
			voltage => 5000
		)
		port map (
			vdd => gnd,
			vss => vcc
		);
	
end structural;
