/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __FERITE_H__
#define __FERITE_H__

#include <ferite/freq.h>
#include <ferite/fstructs.h>

#ifdef __cplusplus
extern "C"
{
#endif

#include <ferite/fglobals.h>
#include <ferite/fhash.h>
#include <ferite/fdebug.h>
#include <ferite/fstack.h>
#include <ferite/fns.h>
#include <ferite/fvariables.h>
#include <ferite/fregex.h>
#include <ferite/fops.h>
#include <ferite/fopcode.h>
#include <ferite/futils.h>
#include <ferite/fmem_jedi.h>
#include <ferite/fmem.h>
#include <ferite/fgc.h>
#include <ferite/ffunction.h>
#include <ferite/fmodule.h>
#include <ferite/fcompile.h>
#include <ferite/foop.h>
#include <ferite/ferror.h>
#include <ferite/farray.h>
	
#define FERITE_NAME       "ferite"
#define FERITE_VERSION    "0.99.4"
#define FERITE_MAJOR      0
#define FERITE_MINOR      99
#define FERITE_RELEASE    4
   
   FeriteEnvironment *ferite_init( int argc, char *argv[] );
   int                ferite_deinit();
   FeriteScript      *ferite_new_script();
   int                ferite_script_load( FeriteScript *script, char *filename );
   int                ferite_script_load_from_stream( FeriteScript *script, FILE *file );
   FeriteScript      *ferite_script_compile( char *filename );
   int                ferite_script_execute( FeriteScript *script );
   int                ferite_script_delete( FeriteScript *script );
   void               ferite_add_search_path( char *path );
   void               ferite_delete_search_paths();
   
#define ferite_register_class( script, ns, name ) ferite_register_inherited_class( script, ns, name, NULL )
   FeriteClass *ferite_register_inherited_class( FeriteScript *script, FeriteNamespace *ns, char *name, char *parent );
   int ferite_register_class_function( FeriteScript *script, FeriteClass *classptr, FeriteFunction *f );
   int ferite_register_class_variable( FeriteScript *script, FeriteClass *classptr, FeriteVariable *variable, int is_static );
   
   /* user functions for getting parameters */
   int ferite_get_parameters( FeriteVariable **list, int num_args, ... );
   int ferite_get_parameter_count( FeriteVariable **list );
   void *ferite_get_parameter( FeriteVariable **list, int num );
   
   /* macros to cover internal functions */
#define fe_new_lng( name, val )           __ferite_create_number_long_variable( name, val )
#define fe_new_dbl( name, val )           __ferite_create_number_double_variable( name, val )
#define fe_new_str( name, val )           __ferite_create_string_variable( name, val )               
#define fe_new_obj( name )                __ferite_create_object_variable( name )
#define fe_new_array( name, size )        __ferite_create_uarray_variable( name, size )
#define fe_new_void( name )               __ferite_create_void_variable( name )
   
#define fe_create_ns_fnc( script, namespace, name, function, signature ) __ferite_register_ns_function( script, namespace, __ferite_create_external_function( script, name, function, signature, 0 ) )
#define fe_create_cls_fnc( script, class, name, function, signature, static ) ferite_register_class_function( script, class, __ferite_create_external_function( script, name, function, signature, static ) )
   
   /* macros to make writing functions easier */
#define REDUCEREF( obj ) obj->refcount--
#define INCRREF( obj )   obj->refcount++
   
#define FE_NS_FUNCTION( func_name ) void *func_name ( FeriteScript *script, FeriteVariable **params )
#define FE_CLASS_FUNCTION( func_name ) void *func_name ( FeriteScript *script, FeriteVariable **params )
   
#define FE_RETURN_VAR( var ) { \
   FeriteVariable *__ferite_function_return; \
   __ferite_function_return = var; \
   MARK_VARIABLE_AS_DISPOSABLE( __ferite_function_return ); \
   return __ferite_function_return; }
   
#define FE_RETURN_LONG( val ) \
   FE_RETURN_VAR( fe_new_lng( "external_function_return_int", val ) )
   
#define FE_RETURN_DOUBLE( val ) \
       FE_RETURN_VAR( fe_new_dbl( "external_function_return_float", val ) )
   
#define FE_RETURN_VOID { \
   FeriteVariable *__ferite_function_return; \
   __ferite_function_return = __ferite_create_void_variable( "external_function_return_void" ); \
   MARK_VARIABLE_AS_DISPOSABLE( __ferite_function_return ); \
   return __ferite_function_return; }

#define FE_RETURN_STR( str, freeme ) { \
   FeriteVariable *__ferite_function_return; \
   __ferite_function_return = fe_new_str( "external_function_return_string", str ); \
   if( freeme > 0 ) { ffree( str ); } \
   MARK_VARIABLE_AS_DISPOSABLE( __ferite_function_return ); \
   return __ferite_function_return; }

#define FE_RETURN_TRUE    FE_RETURN_LONG(1)
#define FE_RETURN_FALSE   FE_RETURN_LONG(0)

#define FE_CLEAN_STRING(s)   fcalloc( s, sizeof(char) )
   
#ifdef __cplusplus
}
#endif

#endif /* __FERITE_H__ */
