/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __FERITE_HASH_H__
#define __FERITE_HASH_H__

FeriteHashBucket *__ferite_create_hash_bucket( FeriteScript *script, char *key, void *value );
FeriteHash       *__ferite_create_hash( FeriteScript *script, int size );
FeriteHash       *__ferite_hash_dup( FeriteScript *script, FeriteHash *hash, void *(*ddup)( FeriteScript *script, void *data ) );
void __ferite_delete_hash_bucket_list( FeriteScript *script, FeriteHashBucket *b, void (*cb)( FeriteScript *script,void *data) );
void __ferite_delete_hash( FeriteScript *script, FeriteHash *hash, void (*cb)( FeriteScript *script,void *data) );
void __ferite_process_hash( FeriteScript *script, FeriteHash *hash, void (*cb)( FeriteScript *script,void *data,char *key) );
void __ferite_hash_add( FeriteScript *script, FeriteHash *hash, char *key, void *data );
void __ferite_hash_delete( FeriteScript *script, FeriteHash *hash, char *key );
void *__ferite_hash_get( FeriteScript *script, FeriteHash *hash, char *key );
FeriteHashBucket *__ferite_hash_get_bucket( FeriteScript *script, FeriteHash *hash, char *key );
void *__ferite_hash_get_index( FeriteScript *script, FeriteHash *hash, int );
void __ferite_hash_compress( FeriteScript *script, FeriteHash *hash );
void *__ferite_hash_walk(FeriteScript *script, FeriteHash *hash, FeriteIterator *iter);

#endif /* __FERITE_HASH_H__ */
