/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __FERITE_CLASS_H__
#define __FERITE_CLASS_H__

void __ferite_delete_class( FeriteScript *script, FeriteClass *classp );
FeriteClass *__ferite_find_class( FeriteScript *script, FeriteNamespace *ns, char *name );
long __ferite_find_class_id( FeriteScript *script, FeriteNamespace *ns, char *name );

FeriteObject *__ferite_find_object( FeriteScript *script, FeriteObject *parent, char *obj );
FeriteFunction *__ferite_find_function_in_object( FeriteScript *script, FeriteObject *obj, char *function );
FeriteFunction *__ferite_find_object_function( FeriteScript *script, FeriteVariableHash *hash, char *functionstr );
FeriteVariable *__ferite_find_object_variable( FeriteScript *script, FeriteVariableHash *hash, char *variablestr );

void __ferite_delete_object( FeriteObject *obj );
void __ferite_delete_class_object( FeriteObject *obj );
void __ferite_delete_objects( FeriteObject *obj );

void __ferite_object_call_super( FeriteScript *script, FeriteObject *object, FeriteVariable **params );

#endif /* __FERITE_CLASS_H__ */
