/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __FERITE_REGEX_H__
#define __FERITE_REGEX_H__

#define F_RGX_MATCH  1
#define F_RGX_SWAP   2

/* intern specific options */
#define F_RGX_COMPILE    0x0001
#define F_RGX_GLOBAL     0x0002
#define F_RGX_EVAL_SWP   0x0004

void           *__ferite_regex_malloc( size_t size);
void            __ferite_regex_free( void *ptr );
void            __ferite_init_regex();
FeriteRegex    *__ferite_create_regex();
FeriteRegex    *__ferite_generate_regex( char *pattern );
void            __ferite_delete_regex( FeriteRegex *rgx );
void           *__ferite_compile_regex( char *pattern, int options );
FeriteVariable *__ferite_execute_regex( FeriteRegex *rgx, FeriteVariable *target, FeriteScript *script );
FeriteVariable *__ferite_execute_match_regex( FeriteRegex *rgx, FeriteVariable *target, int global, FeriteNamespace *ns, FeriteScript *script );
FeriteVariable *__ferite_execute_swap_regex( FeriteRegex *rgx, FeriteVariable *target, int global, FeriteNamespace *ns, FeriteScript *script );

#endif /* __FERITE_REGEX_H__ */
