/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef __FERITE_STRUCTS_H__
#define __FERITE_STRUCTS_H__

typedef struct __ferite_stack
{
   int    stack_ptr;
   int    size;
   void **stack;
} FeriteStack;

typedef struct __ferite_string
{
   int length;
   int encoding; /* reserved */
   char *data;
} FeriteString;

typedef struct _ferite_object FeriteObject;
typedef struct _unified_array FeriteUnifiedArray;

typedef struct __ferite_variable
{
   int   type;
   char *name;
   int   refcount;
   union {
      long                 lval;
      double               dval;
      char                *sval;
      FeriteObject        *oval;
      FeriteUnifiedArray  *aval;
      void                *pval;
   } data;
   struct {
      char disposable; /* if we can nuke it */
      char constant;   /* if it is a final variable */
      char compiled;   /* if it's a compiled in constant */
	  char is_static;  /* if the varaible is a static variable */
   } flags;
} FeriteVariable;

typedef struct __ferite_op
{
   int   OP_TYPE;
   void *op;
   void *opdata;
   long  addr;
   int   line;
} FeriteOp;

typedef struct __ferite_opcode_list
{
   long       size;
   long       current_op_loc;
   char      *filename;
   FeriteOp  *current_op;
   FeriteOp **list;
} FeriteOpcodeList;

struct __ferite_memory_block
{
   void   *data;
   int     size;
   char   *file;
   int     line;
   struct __ferite_memory_block *next;
};

typedef struct __ferite_bk_req
{
   FeriteOp *reqop;
   int       addr;
   int       type;
} FeriteBkRequest;

typedef struct _ferite_hash_bucket FeriteHashBucket;
struct _ferite_hash_bucket
{
   char *id;
   int   hashval;
   void *data;
   int   index;
   FeriteHashBucket *next;
   FeriteHashBucket *prev;
};

typedef struct _ferite_hash
{
   int size;
   int numitems;
   FeriteHashBucket **hash;
} FeriteHash;

typedef FeriteHash FeriteVariableHash;

typedef struct _ferite_iterator
{
   int curindex;
   FeriteHashBucket *curbucket;
} FeriteIterator;

typedef struct _ferite_array_bucket FeriteArrayBucket;
struct _ferite_array_bucket 
{
   FeriteHashBucket *bucket;
   FeriteArrayBucket *next;
   int index;
};

typedef struct _ferite_script FeriteScript;

typedef struct _ferite_parameter_record FeriteParameterRecord;
struct _ferite_parameter_record
{
   FeriteVariable *variable;
   int             has_default_value;
};

typedef struct _ferite_function FeriteFunction;
struct _ferite_function
{
   char                   *name;
   int                     type;
   int                     return_type;
   void                   *(*fncPtr)( FeriteScript *, FeriteVariable ** );
   void                   *object;
   int                     arg_count;
   int                     is_static;
   FeriteParameterRecord **signature;
   FeriteVariableHash     *localvars;
   FeriteOpcodeList       *ccode;  
   FeriteVariable         *returnt;
   FeriteFunction         *next;
};

/* built using either and external object or a script */
typedef struct _ferite_class FeriteClass;
struct _ferite_class
{
   char               *name;
   long                id;
   FeriteClass        *parent;
   FeriteVariableHash *variables;
   FeriteHash         *functions;
   FeriteClass        *next;
};

struct _ferite_object /* an actual instance */
{
   char               *name;
   int                 oid;
   void               *odata;
   int                 refcount;
   FeriteClass        *tmpl; /* the class template used */
   FeriteVariableHash *variables;
   FeriteHash         *functions;
   FeriteObject       *child;
   FeriteObject       *parent;
   FeriteObject       *next;
};

typedef struct _ferite_execute_rec
{
   FeriteFunction     *function;
   FeriteVariableHash *variable_hash;
   FeriteStack        *stack;
} FeriteExecuteRec;

typedef struct _ferite_event FeriteEvent;
typedef struct _ferite_namespace FeriteNamespace;

struct _ferite_script
{
   /* once compiled these variables never change */
   char               *filename;
   char               *scripttext;
   FeriteFunction     *current_function;
   FeriteVariableHash *current_variable_hash;
   FeriteNamespace    *mainns;
   
   /* only these variables are altered */
   FeriteStack        *exec_stack;
   
   /* error stuff */
   char               *current_op_file;
   int                 current_op_line;
   int                 error_state;
   int                 keep_execution;
   int                 is_executing;
   int                 (*error_cb)( FeriteScript *, char *, int );
   int                 (*warning_cb)( FeriteScript *, char * );
   
   /* we need to get rid of these */
   FeriteEvent       **events;
   int                 event_count;

   /* the next script */
   FeriteScript       *next;
};

struct _ferite_event
{
   FeriteScript   *script;
   FeriteFunction *handler;
   void           *target;
};

typedef FeriteObject **FeriteGC;

typedef struct _ferite_namespace_bucket FeriteNamespaceBucket;
struct _ferite_namespace_bucket 
{
   int   type;
   void *data;
};

struct _ferite_namespace 
{
   int         num;
   FeriteHash *space;
};

typedef struct _ferite_environment 
{
   FeriteGC         gc;
/*   FeriteScript    *scripts;*/
/*   FeriteScript    *current_script; */
   int              total_ops_run;
} FeriteEnvironment;

typedef struct _ferite_module FeriteModule;
struct _ferite_module
{
   char *name;
   char *filename;
   void *handle;
   void (*module_init)( FeriteScript *script, FeriteNamespace *ns );
   void (*module_deinit)();
   FeriteModule *next;
};

typedef struct _ferite_regex FeriteRegex;
struct _ferite_regex
{
   char       *pattern;         /* original string pattern */
   int         type;            /* type -> match or replace */
   int         pcre_options;    /* pcre options */
   int         fergx_options;   /* regex options we have to implement */
   void       *compiled_re;     /* compiled regex */
   char       *compile_buf;     /* the actual buffer to compile */
   char       *swap_buf;        /* string to swap with */
   void       *extra_info;      /* extra information */
};

typedef struct _array_item FeriteArrayItem;

struct _array_item {
	int index;
	short int in_hash;
	FeriteHashBucket *var;
	FeriteArrayItem *next;
	FeriteArrayItem *prev;
};

struct _unified_array {
	FeriteHash *hash;
	FeriteArrayItem *linear;
	FeriteIterator *iter;
	int size;
};	

#endif /* __FERITE_STRUCTS_H__ */
