/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __FERITE_UTILS_H__
#define __FERITE_UTILS_H__

#define fstrdup( var ) __ferite_strdup( var )

char *__ferite_stroflen(char c, int l);
char *__ferite_lowercase( char *str );
char *__ferite_strip_whitespace( char *str );
int   __ferite_find_string( char *haystack, char *needle );
char *__ferite_copy_string( char *str, int from, int to );
char *__ferite_delete_string( char *str, int from, int to );
char *__ferite_insert_string( char *str, char *istr, int pos );
char *__ferite_replace_string( char *str, char *pattern, char *data );
char *__ferite_strdup( char *str );


FeriteString *__ferite_str_new( int length );
int           __ferite_str_cmp( FeriteString *str1, FeriteString *str2 );
int           __ferite_str_ncmp( FeriteString *str1, FeriteString *str2, int size );
int           __ferite_str_cpy( FeriteString *str1, FeriteString *str2 );
int           __ferite_str_ncpy( FeriteString *str1, FeriteString *str2, int size );
int           __ferite_str_cat( FeriteString *str1, FeriteString *str2 );
int           __ferite_str_ncat( FeriteString *str1, FeriteString *str2, int size );
int           __ferite_str_find( FeriteString *str, char *token );
int           __ferite_str_delete( FeriteString *str, int from, int to );
int           __ferite_str_insert( FeriteString *str, FeriteString *data, int pos );
int           __ferite_str_replace( FeriteString *str, FeriteString *what, FeriteString *with );
FeriteString *__ferite_str_dup( FeriteString *str );
FeriteString *__ferite_str_copy( FeriteString *str, int from, int to );


/* shpouldn't really be here, but i suck, so it is */
void __ferite_delete_scripts( FeriteScript *script );
char *__ferite_user_home_dir( int uid );
char **__ferite_file_dir( char *dir, int *num );
void __ferite_file_dir_free( char **l, int num );
int __ferite_item_in_list( char **list, int size, char *item );
FILE *__ferite_fopen( char *filename, char *mode );
		     
#endif /* __FERITE_UTILS_H__ */
