/* This file has been automatically generated by builder part of the ferite distribution */
/* file: console_Console.c */
/* namespace: Console */

#include <ferite.h>       /* we need this without a doubt */
#include "console_header.h"  /* this is the module header */

FE_NS_FUNCTION( console_Console_printf )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, str );

   { /* Main function body. */
 
	   FeriteVariable *ptr;
	   int current = 1, i = 0;
	   
	   for( i = 0; i < strlen( str ) && params[current] != NULL; i++ )
	   {
		  ptr = params[current];
		  if( str[i] == '%' )
		  {
			 i++;
			 if( ptr == NULL )
			 {
				ffree( str );
				FE_RETURN_VOID;
			 }
			 
			 switch( str[i] )
			 {
			  case '%':
				printf( "%%" );
				break;
			  case 'n':
				switch( ptr->type )
				{
				 case F_VAR_LONG:
				   printf( "%ld", VAI(ptr) );
				   break;
				 case F_VAR_DOUBLE:
				   printf( "%f", VAF(ptr) );
				   break;
				 default:
				}
				break;
			  case 's':
				printf( "%s", (VAS(ptr) == NULL ? "" : VAS(ptr)) );
				break;
			  case 'o':
				printf( "Object[%s@%p]", VAO(ptr)->name, VAO(ptr) );
				break;
			 }
			 current++;
		  }
		  else
			printf( "%c", str[i] );
	   }
	   ffree( str );
	   FE_RETURN_VOID;
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( console_Console_readln )
{

   { /* Main function body. */
 
		char *buf;
		FeriteVariable *retval;

		buf = fmalloc( 8096 );
		memset( buf, '\0', 8096 );

		if( ferite_get_parameter_count( params ) > 0 )
			ferite_error( script, "Console::readln does not take any parameters\n" );

		fgets( buf, 8096, stdin );
		buf[strlen(buf)-1] = '\0';
		retval = __ferite_create_string_variable( "Console_readln_return", buf );

		ffree( buf );

		FE_RETURN_VAR( retval );
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( console_Console_println )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, str );

   { /* Main function body. */
 
		printf( "%s\n", str );
		ffree( str );
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( console_Console_print )
{
   char *str = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, str );

   { /* Main function body. */
 
		printf( "%s", str );
		ffree( str );
	
   }
   FE_RETURN_VOID;
}

