/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  file_Directory.c */
/* class: Directory */

#include <ferite.h>       /* we need this without a doubt */
#include "file_header.h"  /* this is the module header */

FE_NS_FUNCTION( file_Directory_lastErrno )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   FE_RETURN_LONG( (long)DirObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_symlsToArray )
{
   double sorted;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &sorted, &super, &self );

   { /* Main function body. */
 
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_close )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   int ret;
	   
	   if( !DirObj->dp )
	   {
		  DirObj->err=EBADF;
		  FE_RETURN_LONG( (long)DirObj->err );
	   }
	   
	   errno=0;
	   ret=closedir( DirObj->dp );
	   DirObj->err=errno;
	   DirObj->dp= 0;
	   FE_RETURN_LONG( (long)DirObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_remind )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 	
	   char *buf="";
	   FeriteVariable *var;
	   
	   if(DirObj->pathspec) buf=DirObj->pathspec;
	   var = fe_new_str( "Directory::remind", DirObj->pathspec );
	   FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_open )
{
   char *dir = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, dir, &super, &self );

   { /* Main function body. */
 
	   if( DirObj->dp )
	   {
		  /*  REUSING EXISTING OBJECT - CLEAN UP FIRST..  */
		  closedir( DirObj->dp );
		  DirObj->dp=0;
		  ffree( DirObj->pathspec );
		  DirObj->pathspec=0;
	   }
	   errno=0;
	   DirObj->dp= opendir( dir );
	   if( !DirObj->dp )
	   {
		  DirObj->err=errno;
		  FE_RETURN_LONG( (long)DirObj->err );
	   }
	   
	   /*  Set up the rest of the object..  */
	   DirObj->pathspec= fstrdup(dir);
	   if(!DirObj->pathspec)
	   {
		  DirObj->err=ENOMEM;
		  FE_RETURN_LONG( (long)DirObj->err );
	   }

	   DirObj->err=0;
	   ffree( dir );
	   FE_RETURN_LONG( (long)DirObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_dirsToArray )
{
   double sorted;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &sorted, &super, &self );

   { /* Main function body. */
 
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_seek )
{
   double off;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &off, &super, &self );

   { /* Main function body. */
 
	   if( !DirObj->dp )
	   {
		  DirObj->err=EBADF;
		  FE_RETURN_LONG( (long)DirObj->err );
	   }
	   seekdir( DirObj->dp, (off_t)off );
	   DirObj->err=errno=0;
	   FE_RETURN_LONG( (long)DirObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_Directory )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   DirObj= fmalloc(sizeof(DirData));
	   if(!DirObj)
	   {
		  DirObj->err=ENOMEM;
		  DirException("Directory()");
	   }
	   
	   /*  Initialize the allocated structure.  */
	   DirObj->dp=0;
	   DirObj->pathspec= 0;
	   DirObj->err= 0;
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_delete )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   if( !DirObj->pathspec )
	   {
		  DirObj->err=EBADF;
	   }
	   else
	   {
		  closedir( DirObj->dp );
		  DirObj->err=errno=0;
		  if( !rmdir(DirObj->pathspec) )
		  {
			 DirObj->err=errno;
			 ffree( DirObj->pathspec );
			 DirObj->pathspec=0;
			 DirObj->dp= 0;
		  }
		  else
			DirObj->err=errno;
	   }
	   FE_RETURN_LONG( (long)DirObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_toArray )
{
   double sorted;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &sorted, &super, &self );

   { /* Main function body. */
   
	   FeriteVariable *var, *array;
	   struct dirent **ret;
	   int N, i;
	   char name[20];
	   
	   array = __ferite_create_uarray_variable( "Directory::toArray", 100 );
	   if( !DirObj->dp )
	   {
		  DirObj->err=EBADF;
	   }
	   else
	   {
		  ret=realscan(DirObj->pathspec, 0, 
					   (void*)(sorted ?
#ifdef USING_SOLARIS
							   NULL
#else
							   alphasort 
#endif
							   : NULL ), &N);
		  
#ifdef DIR_DEBUG
		  printf("%d ALL Entries:\n");
		  for(i=0; i<N; i++)
			printf("%.2d [%s]\n", i, ret[i]->d_name );
#endif
		  for(i=0; i<N; i++)
		  {
			 sprintf( name,"hash-%d",i );
			 var = fe_new_str( name, ret[i]->d_name );
			 __ferite_uarray_add( script, VAUA(array), var, NULL, i);
			 free(ret[i]); /*  this is ugly.  */
		  }
		  free(ret); /*  and so is this.  */
		  
/* This just sucks. See above, it works.
 fprintf(stderr, "dir:: PRE scancleanup()\n");
 scancleanup(&ret, N);
 fprintf(stderr, "dir:: POST scancleanup()\n");
 */
	   }
	   FE_RETURN_VAR( array );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_read )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   struct dirent *ret;
	   FeriteVariable *var;
	   char *buf="";
	   
	   if( !DirObj->dp )
	   {
		  DirObj->err=EBADF;
	   }
	   else
	   {
		  errno=0;
		  ret = readdir( DirObj->dp );
		  if( !ret )
			DirObj->err=errno;
		  else
		  {
			 DirObj->err=0;
			 buf=ret->d_name;
		  }
	   }
	   var = fe_new_str( "Directory::read()", buf );
	   FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_socksToArray )
{
   double sorted;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &sorted, &super, &self );

   { /* Main function body. */
 
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_strerror )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
   
	   char buf[1024];
	   FeriteVariable *var;
	   
	   switch(DirObj->err)
	   {
	    case -1:	sprintf(buf,"%d: Generic Error", DirObj->err); break;
	    case  0:	sprintf(buf,"%d: Success", DirObj->err); break;
	    default:	sprintf(buf,"%d: %s", DirObj->err, strerror(DirObj->err) );
		  break;
		  
	   }
	   var = fe_new_str( "Directory::strerror", buf );
	   FE_RETURN_VAR( var );
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_position )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
  
	   off_t ret= -1;
	   if( !DirObj->dp )
	   {
		  DirObj->err=EBADF;
		  FE_RETURN_LONG( (long)ret );
	   }
	   errno=0;
	   ret=telldir( DirObj->dp );
	   if(ret<0)
		 DirObj->err=errno;
	   else DirObj->err=0;
	   FE_RETURN_LONG( (long)ret );
	
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_Destructor )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   if(DirObj->pathspec) ffree(DirObj->pathspec);
	   ffree(DirObj);
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_insert )
{
   char *dir = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *mask = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 4, dir, mask, &super, &self );

   { /* Main function body. */
 	
	   int oldmask, newmask=0;
	   mode_t modes;
	   if( !DirObj->dp )
	   {
		  DirObj->err=EBADF;
	   }
	   else
	   {
		  if(*mask)
		  { 
			 char *ow, *gr, *ot;
			 ow=gr=ot=0;
			 ow=mask;
			 gr= (strlen(mask)>3 ? mask+3 : 0);
			 ot= (strlen(mask)>6 ? mask+6 : 0);
			 modes= perm2int( ow, gr, ot);
			 newmask= masksense(modes);
			 oldmask= umask(newmask);
		  }
		  DirObj->err=errno=0;
		  if( mkdir(dir, modes) )
			DirObj->err=errno;
		  if(newmask)	umask(oldmask);
	   }
	   ffree( dir );
	   ffree( mask );
	   FE_RETURN_LONG( (long)DirObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_filesToArray )
{
   double sorted;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &sorted, &super, &self );

   { /* Main function body. */
 
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_rewind )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
 
	   if( !DirObj->dp )
	   {
		  DirObj->err=EBADF;
		  FE_RETURN_LONG( (long)DirObj->err );
	   }
	   rewinddir( DirObj->dp );
	   DirObj->err=errno=0;
	   FE_RETURN_LONG( (long)DirObj->err );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( file_Directory_fifosToArray )
{
   double sorted;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &sorted, &super, &self );

   { /* Main function body. */
 
   }
   FE_RETURN_VOID;
}

