/* This file has been automatically generated by builder part of the ferite distribution */
/* file: system_Environment.c */
/* namespace: Environment */

#include <ferite.h>       /* we need this without a doubt */
#include "system_header.h"  /* this is the module header */

FE_NS_FUNCTION( system_Environment_read )
{
   char *key = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, key );

   { /* Main function body. */
 
        char *ev_value = NULL;
        FeriteVariable *returnValue = NULL;

        if( (ev_value = getenv(key)) != NULL )
            returnValue = fe_new_str( "Environment::read-return", ev_value );
        else
            returnValue = fe_new_str( "Environment::read-return", "" );
        ffree( key );
        FE_RETURN_VAR( returnValue );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_Environment_write )
{
   char *key = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );
   char *value = fcalloc( strlen(VAS(params[1]))+1, sizeof(char) );

   ferite_get_parameters( params, 2, key, value );

   { /* Main function body. */
 
	   /* Solaris is a PITA - it doesn't seem to have a setenv this is the work around */
#ifdef USING_SOLARIS
	   char *buf = memset( fmalloc( strlen(key) + strlen(value) + 2 ), '\0', strlen(key) + strlen(value) + 2 );
	   sprintf( buf, "%s=%s", key, value );
	   putenv( buf );
	   ffree( buf );
#else
	   setenv( key, value, 1 );
#endif	   
	   ffree( key );
	   ffree( value );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_Environment_del )
{
   char *key = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, key );

   { /* Main function body. */
 
#ifdef USING_SOLARIS
	   ferite_warning( script, "WARNING: Environment::del('%s') does not work under Solaris\n", key );
#else
	   unsetenv( key );
#endif
	   ffree( key );
    
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_Environment_toArray )
{

   { /* Main function body. */
 
	   FeriteVariable *var = NULL, *val = NULL;
	   char *currentValue = NULL;
	   char *name, *value;
	   int i = 0;
#ifdef USING_DARWIN
	         char **environ = *_NSGetEnviron();
#endif
	   var = __ferite_create_uarray_variable("Environment::toArray-element", 50 );
	   while( (currentValue = environ[i++]) != NULL ){
		  name = memset( fmalloc( strlen(currentValue)+1 ), '\0', strlen(currentValue)+1 );
		  value = memset( fmalloc( strlen(currentValue)+1 ), '\0', strlen(currentValue)+1 );
		  
		  strncpy( name, currentValue, __ferite_find_string( currentValue, "=" ) );
		  strcpy( value, currentValue + __ferite_find_string( currentValue, "=" ) + 1 );
		  val = fe_new_str( name, value );
		  __ferite_uarray_add( script, VAUA(var), val, name, -1 );
		  
		  ffree( name );
		  ffree( value );
	   }
	   FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

