/* This file has been automatically generated by builder part of the ferite distribution */
/* file: system_User.c */
/* namespace: User */

#include <ferite.h>       /* we need this without a doubt */
#include "system_header.h"  /* this is the module header */

FE_NS_FUNCTION( system_User_nameUid )
{
   double owner;

   ferite_get_parameters( params, 1, &owner );

   { /* Main function body. */
 
	  struct passwd *him= getpwuid( (uid_t)owner );
	  char *buf="";
	  FeriteVariable *var;
	  if(him)
	    buf=him->pw_name;
	  var = fe_new_str( "ownerName", buf );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_nameGid )
{
   double group;

   ferite_get_parameters( params, 1, &group );

   { /* Main function body. */
 
	  struct group *him= getgrgid( (gid_t)group );
	  char *buf="";
	  FeriteVariable *var;
	  if(him)
	    buf=him->gr_name;
	  var = fe_new_str( "groupName", buf );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_logid )
{

   { /* Main function body. */
   
	  struct passwd *me = getpwuid(getuid());
	  FeriteVariable *var = fe_new_str( "User::logid()", me->pw_name );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_tgid )
{

   { /* Main function body. */
 
	  struct stat statbuf;
	  
	  if( !script->filename || strcmp(script->filename, "-e") )
	  {
		 if( !stat(script->filename, &statbuf) )
		 {
			if( (statbuf.st_mode&S_ISUID) || (statbuf.st_mode&S_ISGID) )
			{
			   FE_RETURN_LONG( statbuf.st_gid );
			}
		 }
		 else fprintf(stderr, "FAILED stat(\"%s\")\n", script->filename);
	  }
	  FE_RETURN_LONG( -1 );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_tuid )
{

   { /* Main function body. */
 
	  struct stat statbuf;
	  
	  if( !script->filename || strcmp(script->filename, "-e") )
	  {
		 if( !stat(script->filename, &statbuf) )
		 {
			if( (statbuf.st_mode&S_ISUID) || (statbuf.st_mode&S_ISGID) )
			{
			   FE_RETURN_LONG( statbuf.st_uid );
			}
		 }
		 else fprintf(stderr, "FAILED stat(\"%s\")\n", script->filename);
	  }
	  FE_RETURN_LONG( -1 );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_egid )
{

   { /* Main function body. */
 
	  FE_RETURN_LONG( getegid() );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_euid )
{

   { /* Main function body. */
 
	  FE_RETURN_LONG( geteuid() ); 
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_rgid )
{

   { /* Main function body. */
 
	  struct passwd *me = getpwuid(getuid());
	  FE_RETURN_LONG( me->pw_gid ); 
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_ruid )
{

   { /* Main function body. */
 
	  struct passwd *me = getpwuid(getuid());
	  FE_RETURN_LONG( me->pw_uid ); 
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_home )
{

   { /* Main function body. */
   
	  struct passwd *me = getpwuid(getuid());
	  FeriteVariable *var = fe_new_str( "User::home()", me->pw_dir );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_name )
{

   { /* Main function body. */
   
	  struct passwd *me = getpwuid(getuid());
	  FeriteVariable *var = fe_new_str( "User::nane()", me->pw_gecos );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_uidOf )
{
   char *owner = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, owner );

   { /* Main function body. */
 
	  long ret=-1;
	  struct passwd *him= getpwnam( owner );
	  ffree( owner );
	  if(him)
	    ret=him->pw_uid;
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_gidOf )
{
   char *group = fcalloc( strlen(VAS(params[0]))+1, sizeof(char) );

   ferite_get_parameters( params, 1, group );

   { /* Main function body. */
 	
	  long ret=-1;
	  struct group *him= getgrnam( group );
	  ffree( group );
	  if(him)
	    ret=him->gr_gid;
	  FE_RETURN_LONG( ret );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_shell )
{

   { /* Main function body. */
   
	  struct passwd *me = getpwuid(getuid());
	  FeriteVariable *var = fe_new_str( "User::shell()", me->pw_shell );
	  FE_RETURN_VAR( var );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_setEffectiveUser )
{
   double uid;
   double gid;

   ferite_get_parameters( params, 2, &uid, &gid );

   { /* Main function body. */
 
	  setegid( (gid_t)((long)gid) );
	  seteuid( (uid_t)((long)uid) );
   
   }
   FE_RETURN_VOID;
}

FE_NS_FUNCTION( system_User_groups )
{

   { /* Main function body. */
 	  
	  struct group *gp;
	  FeriteVariable *var;
	  FeriteVariable *array = __ferite_create_uarray_variable( "User::groups()", 10 );
	  char name[128], **p;
	  struct passwd *me = getpwuid(getuid());
	  int i = 0;
	  
	  while( gp = getgrent() )
	  {
		 char **p = gp->gr_mem;
		 if( !strcmp(gp->gr_name, me->pw_name ) )
		 {
			   sprintf( name,"hash-%d",i );
			   var = fe_new_str( name, gp->gr_name );
			   __ferite_uarray_add( script, VAUA(array), var, NULL, i++);			
		 }
		 else while( *p )
		 {
			if( !strcmp( *p, me->pw_name ) )
			{
			   sprintf( name,"hash-%d",i );
			   var = fe_new_str( name, gp->gr_name );
			   __ferite_uarray_add( script, VAUA(array), var, NULL, i++);
			}
			p++;
		 }
	  }
	  endgrent();
	  FE_RETURN_VAR( array );
   
   }
   FE_RETURN_VOID;
}

