/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *   
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity 
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *    
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER 
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "ferite.h"

FeriteOp *__ferite_create_op()
{
   FeriteOp *ptr;
   
   FE_ENTER_FUNCTION;
   ptr = fmalloc( sizeof( FeriteOp ) );
   ptr->OP_TYPE = F_OP_NOP;
   ptr->op = NULL;
   ptr->opdata = NULL;
   FE_LEAVE_FUNCTION( ptr );
}

FeriteOpcodeList *__ferite_create_opcode_list( int size )
{
   FeriteOpcodeList *ptr;
   
   FE_ENTER_FUNCTION;
   ptr = fmalloc( sizeof( FeriteOpcodeList ) );
   ptr->size = size;
   ptr->filename = NULL;
   ptr->current_op_loc = 0;
   ptr->list = fmalloc( sizeof( FeriteOp * ) * size );
   ptr->list[0] = __ferite_create_op();
   ptr->current_op = ptr->list[0];
   ptr->list[1] = NULL;
   FE_LEAVE_FUNCTION( ptr );
}

FeriteOp *__ferite_get_next_op( FeriteOpcodeList *oplist )
{
   FE_ENTER_FUNCTION;
   oplist->current_op_loc++;
   if( !(oplist->current_op_loc < oplist->size) )
   {
      /* we have run out of space 
       * - double oplist->size
       * - realloc */
      oplist->size *= 2;
      oplist->list = frealloc( oplist->list, sizeof(FeriteOp *) * oplist->size );
      oplist->list[oplist->current_op_loc] = NULL;
   }
   if( oplist->list[oplist->current_op_loc] == NULL )
     oplist->list[oplist->current_op_loc] = __ferite_create_op();
   oplist->current_op = oplist->list[oplist->current_op_loc];
   oplist->list[oplist->current_op_loc + 1] = NULL;
   FE_LEAVE_FUNCTION( oplist->list[oplist->current_op_loc] );
}

FeriteOp *__ferite_current_op( FeriteOpcodeList *oplist )
{
   FE_ENTER_FUNCTION;
   FE_LEAVE_FUNCTION( oplist->list[oplist->current_op_loc] );
}

/* returns the address of the next operator with out incrmenting the internal
 * program counter */
FeriteOp *__ferite_get_next_op_address( FeriteOpcodeList *oplist )
{
   FE_ENTER_FUNCTION;
   if( !((oplist->current_op_loc+1) < oplist->size) )
   {
      /* we have run out of space 
       * - double oplist->size
       * - realloc */
      oplist->size *= 2;
      oplist->list = frealloc( oplist->list, sizeof(FeriteOp *) * oplist->size );
      oplist->list[oplist->current_op_loc+1] = NULL;
   }
   if( oplist->list[oplist->current_op_loc+1] == NULL )
     oplist->list[oplist->current_op_loc+1] = __ferite_create_op();
   oplist->list[oplist->current_op_loc + 2] = NULL;
   FE_LEAVE_FUNCTION( oplist->list[oplist->current_op_loc+1] );
}

/* returns the index of the next operator with out incrmenting the internal
 * program counter */
int __ferite_get_next_op_loc( FeriteOpcodeList *oplist )
{
   FE_ENTER_FUNCTION;
   if( !((oplist->current_op_loc+1) < oplist->size) )
   {
      /* we have run out of space 
       * - double oplist->size
       * - realloc */
      oplist->size *= 2;
      oplist->list = frealloc( oplist->list, sizeof(FeriteOp *) * oplist->size );
      oplist->list[oplist->current_op_loc+1] = NULL;
   }
   if( oplist->list[oplist->current_op_loc+1] == NULL )
     oplist->list[oplist->current_op_loc+1] = __ferite_create_op();
   oplist->list[oplist->current_op_loc + 2] = NULL;
   FE_LEAVE_FUNCTION( oplist->current_op_loc+1 );
}

void __ferite_delete_opcode_list( FeriteScript *script, FeriteOpcodeList *oplist )
{
   int i = 0, currentVar = 0, canFree = 0;
   FeriteVariable *ptr;
   void **freed_variables = fcalloc( sizeof(void *) * oplist->size, sizeof(char) );
   
   /* we only free instructions and compiled in constants - eg strings and stuff */
   FE_ENTER_FUNCTION;
   if( oplist->filename != NULL )
	 ffree( oplist->filename );
   
   for( i = 0; oplist->list[i] != NULL; i++ )
   {
      FUD(("Freeing instruction: %d\n", i ));
      switch( oplist->list[i]->OP_TYPE )
      {
       case F_OP_PUSH:
		 ptr = (FeriteVariable *)(oplist->list[i]->opdata);
		 if( ptr != NULL ){
			currentVar = 0;
			canFree = 1;
			while( freed_variables[currentVar] != NULL )
			{
/*			   printf( "check variable %d %p\n", currentVar, freed_variables[currentVar] );*/
			   if( ptr == freed_variables[currentVar] )
			   {
				  canFree = 0;
				  break;
			   }
			   currentVar++;
			}
			if( ptr->flags.compiled && canFree )
			{
			   __ferite_variable_destroy( script, ptr );
			   freed_variables[currentVar] = ptr;
			}
		 }
		 ffree( oplist->list[i] );
		 break;
       case F_OP_JMP:
       case F_OP_BNE:
       case F_OP_BIE:
       case F_OP_ERR:
       case F_OP_POP:
       case F_OP_NOP:
       case F_OP_EXIT:
       case F_OP_UNARY:
       case F_OP_BINARY:
	   case F_OP_NEWOBJ:
		 ffree( oplist->list[i] );
		 break;
       case F_OP_FUNCTION:
       case F_OP_METHOD:
       case F_OP_PUSHVAR:
		 ffree( oplist->list[i]->opdata );
		 ffree( oplist->list[i] );
		 break;
       case F_OP_RGX:
		 __ferite_delete_regex( oplist->list[i]->opdata );
		 ffree( oplist->list[i] );
		 break;
       default:
		 ffree( oplist->list[i] );
      }
   }
   ffree( oplist->list );
   ffree( oplist );
   ffree( freed_variables );
   FE_LEAVE_FUNCTION( NOWT );
}

void __ferite_opcode_dump( FeriteOpcodeList *oplist )
{
   int i = 0;
   
   FE_ENTER_FUNCTION;
   printf( "Offset\t Address\n" );
   for( i = 0; oplist->list[i] != NULL; i++ )
   {
      switch( oplist->list[i]->OP_TYPE )
      {
       case F_OP_PUSH:
		 printf( "[%d]\t [%p] PUSH        %s\n", i, (void *)(oplist->list[i]), ((FeriteVariable *)oplist->list[i]->opdata)->name );
		 break;
       case F_OP_POP:
		 printf( "[%d]\t [%p] POP\n", i, (void *)(oplist->list[i]) );
		 break;
       case F_OP_NOP:
		 printf( "[%d]\t [%p] NOP\n", i, (void *)(oplist->list[i]) );
		 break;
       case F_OP_UNARY:
		 printf( "[%d]\t [%p] UNARYOP     %p\n", i, (void *)(oplist->list[i]), oplist->list[i]->op );
		 break;
       case F_OP_BINARY:
		 printf( "[%d]\t [%p] BINARYOP    %p\n", i, (void *)(oplist->list[i]), oplist->list[i]->op );
		 break;
       case F_OP_FUNCTION:
		 printf( "[%d]\t [%p] FUNCTION    %s\n", i, (void *)(oplist->list[i]), (char *)oplist->list[i]->opdata );
		 break;
       case F_OP_METHOD:
		 printf( "[%d]\t [%p] METHOD      %s\n", i, (void *)(oplist->list[i]), (char *)oplist->list[i]->opdata );
		 break;
       case F_OP_JMP:
		 printf( "[%d]\t [%p] JMP         %ld\n", i, (void *)(oplist->list[i]), oplist->list[i]->addr );
		 break;
       case F_OP_BNE:
		 printf( "[%d]\t [%p] BNE         %ld\n", i, (void *)(oplist->list[i]), oplist->list[i]->addr );
		 break;
       case F_OP_BIE:
		 printf( "[%d]\t [%p] BIE         %ld\n", i, (void *)(oplist->list[i]), oplist->list[i]->addr );
		 break;
       case F_OP_EXIT:
		 printf( "[%d]\t [%p] EXIT\n", i, (void *)(oplist->list[i]) );
		 break;
       case F_OP_NEWOBJ:
		 printf( "[%d]\t [%p] NEWOBJ\n", i, (void *)(oplist->list[i]) );
		 break;
       case F_OP_PUSHVAR:
		 printf( "[%d]\t [%p] PUSHVAR     %s(%p)\n", i, (void *)(oplist->list[i]), (char *)oplist->list[i]->opdata, oplist->list[i]->opdata );
		 break;
       case F_OP_RGX:
		 printf( "[%d]\t [%p] RGX         %s\n", i, (void *)(oplist->list[i]), ((FeriteRegex*)(oplist->list[i]->opdata))->pattern );
		 break;
       case F_OP_ERR:
		 printf( "[%d]\t [%p] ERR         %ld\n", i, (void *)(oplist->list[i]), oplist->list[i]->addr );
		 break;
       default:
		 printf( "[%d]\t [%p] UKNOWNOP(%d)\n", i, (void *)(oplist->list[i]), oplist->list[i]->OP_TYPE );
      }
   }
   FE_LEAVE_FUNCTION( NOWT );
}
