/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.Control;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.GraphicsModeControl;
import visad.VisADException;
import visad.java2d.DisplayRendererJ2D;
import visad.util.Util;

public class GraphicsModeControlJ2D
extends GraphicsModeControl {
    static final String[] LINE_STYLE = new String[]{"solid", "dash", "dot", "dash-dot"};
    private float lineWidth = 1.0f;
    private float pointSize = 1.0f;
    private int lineStyle = 0;
    private int colorMode;
    private boolean pointMode = false;
    private boolean textureEnable = true;
    private boolean scaleEnable = false;
    private int transparencyMode = 0;
    private int projectionPolicy = 0;
    private int polygonMode = 0;
    private boolean missingTransparent = true;
    private int curvedSize = 10;
    private float polygonOffset = Float.NaN;
    private float polygonOffsetFactor = 0.0f;
    private boolean adjustProjectionSeam = true;
    private int texture3DMode = 0;
    private boolean cacheAppearances = false;
    private boolean mergeGeometries = false;

    public GraphicsModeControlJ2D(DisplayImpl d) {
        super(d);
    }

    public boolean getMode2D() {
        return this.getDisplayRenderer().getMode2D();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float width) throws VisADException, RemoteException {
        if (width < 1.0f) {
            throw new DisplayException("GraphicsModeControlJ2D.setLineWidth: width < 1.0");
        }
        if (Util.isApproximatelyEqual(width, this.lineWidth)) {
            return;
        }
        this.lineWidth = width;
        DisplayRendererJ2D dr = (DisplayRendererJ2D)this.getDisplayRenderer();
        dr.setLineWidth(width);
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setLineWidth(float width, boolean noChange) {
        if (width >= 1.0f) {
            this.lineWidth = width;
        }
    }

    public float getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(float size) throws VisADException, RemoteException {
        if (size < 1.0f) {
            throw new DisplayException("GraphicsModeControlJ2D.setPointSize: size < 1.0");
        }
        if (Util.isApproximatelyEqual(size, this.pointSize)) {
            return;
        }
        this.pointSize = size;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setPointSize(float size, boolean noChange) {
        if (size >= 1.0f) {
            this.pointSize = size;
        }
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int style) throws VisADException, RemoteException {
        if (style != 0 && style != 1 && style != 2 && style != 3) {
            style = 0;
        }
        if (style == this.lineStyle) {
            return;
        }
        this.lineStyle = style;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setLineStyle(int style, boolean noChange) {
        if (style != 0 && style != 1 && style != 2 && style != 3) {
            style = 0;
        }
        this.lineStyle = style;
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(int mode) throws VisADException, RemoteException {
        if (mode != 0 && mode != 1) {
            mode = 0;
        }
        if (mode == this.colorMode) {
            return;
        }
        this.colorMode = mode;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public boolean getPointMode() {
        return this.pointMode;
    }

    public void setPointMode(boolean mode) throws VisADException, RemoteException {
        if (mode == this.pointMode) {
            return;
        }
        this.pointMode = mode;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setTextureEnable(boolean enable) throws VisADException, RemoteException {
        if (enable == this.textureEnable) {
            return;
        }
        this.textureEnable = enable;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public boolean getTextureEnable() {
        return this.textureEnable;
    }

    public void setScaleEnable(boolean enable) throws VisADException, RemoteException {
        if (enable == this.scaleEnable) {
            return;
        }
        this.scaleEnable = enable;
        this.getDisplayRenderer().setScaleOn(enable);
        this.changeControl(true);
    }

    public boolean getScaleEnable() {
        return this.scaleEnable;
    }

    public int getTransparencyMode() {
        return this.transparencyMode;
    }

    public void setTransparencyMode(int mode) throws VisADException, RemoteException {
        if (mode != 0) {
            throw new DisplayException("GraphicsModeControlJ2D.setTransparencyMode: bad mode");
        }
        this.transparencyMode = mode;
    }

    public void setProjectionPolicy(int policy) throws VisADException, RemoteException {
        if (policy != 0) {
            throw new DisplayException("GraphicsModeControlJ2D.setProjectionPolicy: bad policy");
        }
        this.projectionPolicy = policy;
    }

    public int getProjectionPolicy() {
        return this.projectionPolicy;
    }

    public void setPolygonMode(int mode) throws VisADException, RemoteException {
        if (mode != 0) {
            throw new DisplayException("GraphicsModeControlJ2D.setPolygonMode: bad mode");
        }
        this.polygonMode = mode;
    }

    public void setPolygonMode(int mode, boolean noChange) {
        if (mode == 0) {
            this.polygonMode = mode;
        }
    }

    public int getPolygonMode() {
        return this.polygonMode;
    }

    public void setPolygonOffset(float polygonOffset) throws VisADException, RemoteException {
        if (polygonOffset != 0.0f && !Float.isNaN(polygonOffset)) {
            throw new DisplayException("GraphicsModeControlJ2D.setPolygonOffset not supported");
        }
        this.polygonOffset = polygonOffset;
    }

    public void setPolygonOffset(float polygonOffset, boolean noChange) {
        if (polygonOffset == 0.0f || Float.isNaN(polygonOffset)) {
            this.polygonOffset = polygonOffset;
        }
    }

    public float getPolygonOffset() {
        return this.polygonOffset;
    }

    public void setPolygonOffsetFactor(float polygonOffsetFactor) throws VisADException, RemoteException {
        if (polygonOffsetFactor != 0.0f) {
            throw new DisplayException("GraphicsModeControlJ2D.setPolygonOffsetFactor not supported");
        }
        this.polygonOffsetFactor = polygonOffsetFactor;
    }

    public void setPolygonOffsetFactor(float polygonOffsetFactor, boolean noChange) {
        if (polygonOffsetFactor == 0.0f) {
            this.polygonOffsetFactor = polygonOffsetFactor;
        }
    }

    public float getPolygonOffsetFactor() {
        return this.polygonOffsetFactor;
    }

    public boolean getMissingTransparent() {
        return this.missingTransparent;
    }

    public void setMissingTransparent(boolean missing) throws VisADException, RemoteException {
        if (missing) {
            throw new DisplayException("GraphicsModeControlJ2D.setMissingTransparent: must be false");
        }
        this.missingTransparent = missing;
    }

    public int getCurvedSize() {
        return this.curvedSize;
    }

    public void setCurvedSize(int curved_size) {
        this.curvedSize = curved_size;
    }

    public void setAdjustProjectionSeam(boolean adjust) throws VisADException, RemoteException {
        if (adjust == this.adjustProjectionSeam) {
            return;
        }
        this.adjustProjectionSeam = adjust;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public boolean getAdjustProjectionSeam() {
        return this.adjustProjectionSeam;
    }

    public void setTexture3DMode(int mode) throws VisADException, RemoteException {
        if (this.texture3DMode == mode) {
            return;
        }
        this.texture3DMode = mode;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setCacheAppearances(boolean cache) {
        this.cacheAppearances = cache;
    }

    public boolean getCacheAppearances() {
        return this.cacheAppearances;
    }

    public void setMergeGeometries(boolean merge) {
        this.mergeGeometries = merge;
    }

    public boolean getMergeGeometries() {
        return this.mergeGeometries;
    }

    public int getTexture3DMode() {
        return this.texture3DMode;
    }

    public Object clone() {
        GraphicsModeControlJ2D mode = new GraphicsModeControlJ2D(this.getDisplay());
        mode.lineWidth = this.lineWidth;
        mode.pointSize = this.pointSize;
        mode.lineStyle = this.lineStyle;
        mode.pointMode = this.pointMode;
        mode.textureEnable = this.textureEnable;
        mode.scaleEnable = this.scaleEnable;
        mode.transparencyMode = this.transparencyMode;
        mode.projectionPolicy = this.projectionPolicy;
        mode.missingTransparent = this.missingTransparent;
        mode.polygonMode = this.polygonMode;
        mode.curvedSize = this.curvedSize;
        mode.polygonOffset = this.polygonOffset;
        mode.polygonOffsetFactor = this.polygonOffsetFactor;
        mode.adjustProjectionSeam = this.adjustProjectionSeam;
        mode.texture3DMode = this.texture3DMode;
        mode.cacheAppearances = this.cacheAppearances;
        mode.mergeGeometries = this.mergeGeometries;
        return mode;
    }

    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof GraphicsModeControlJ2D)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        GraphicsModeControlJ2D rmtCtl = (GraphicsModeControlJ2D)rmt;
        boolean changed = false;
        boolean redisplay = false;
        if (!Util.isApproximatelyEqual(this.lineWidth, rmtCtl.lineWidth)) {
            changed = true;
            redisplay = true;
            this.lineWidth = rmtCtl.lineWidth;
        }
        if (!Util.isApproximatelyEqual(this.pointSize, rmtCtl.pointSize)) {
            changed = true;
            redisplay = true;
            this.pointSize = rmtCtl.pointSize;
        }
        if (this.lineStyle != rmtCtl.lineStyle) {
            changed = true;
            redisplay = true;
            this.lineStyle = rmtCtl.lineStyle;
        }
        if (this.pointMode != rmtCtl.pointMode) {
            changed = true;
            redisplay = true;
            this.pointMode = rmtCtl.pointMode;
        }
        if (this.textureEnable != rmtCtl.textureEnable) {
            changed = true;
            redisplay = true;
            this.textureEnable = rmtCtl.textureEnable;
        }
        if (this.scaleEnable != rmtCtl.scaleEnable) {
            changed = true;
            this.scaleEnable = rmtCtl.scaleEnable;
            this.getDisplayRenderer().setScaleOn(this.scaleEnable);
        }
        if (this.transparencyMode != rmtCtl.transparencyMode) {
            changed = true;
            this.transparencyMode = rmtCtl.transparencyMode;
        }
        if (this.projectionPolicy != rmtCtl.projectionPolicy) {
            changed = true;
            this.projectionPolicy = rmtCtl.projectionPolicy;
        }
        if (this.polygonMode != rmtCtl.polygonMode) {
            changed = true;
            this.polygonMode = rmtCtl.polygonMode;
        }
        if (this.missingTransparent != rmtCtl.missingTransparent) {
            changed = true;
            this.missingTransparent = rmtCtl.missingTransparent;
        }
        if (this.curvedSize != rmtCtl.curvedSize) {
            changed = true;
            this.curvedSize = rmtCtl.curvedSize;
        }
        if (this.adjustProjectionSeam != rmtCtl.adjustProjectionSeam) {
            changed = true;
            redisplay = true;
            this.adjustProjectionSeam = rmtCtl.adjustProjectionSeam;
        }
        if (this.texture3DMode != rmtCtl.texture3DMode) {
            changed = true;
            redisplay = true;
            this.texture3DMode = rmtCtl.texture3DMode;
        }
        if (this.cacheAppearances != rmtCtl.cacheAppearances) {
            changed = true;
            this.cacheAppearances = rmtCtl.cacheAppearances;
        }
        if (this.mergeGeometries != rmtCtl.mergeGeometries) {
            changed = true;
            this.mergeGeometries = rmtCtl.mergeGeometries;
        }
        if (changed) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
        if (redisplay) {
            this.getDisplay().reDisplayAll();
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GraphicsModeControlJ2D gmc = (GraphicsModeControlJ2D)o;
        boolean changed = false;
        if (!Util.isApproximatelyEqual(this.lineWidth, gmc.lineWidth)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.pointSize, gmc.pointSize)) {
            return false;
        }
        if (this.lineStyle != gmc.lineStyle) {
            return false;
        }
        if (this.pointMode != gmc.pointMode) {
            return false;
        }
        if (this.textureEnable != gmc.textureEnable) {
            return false;
        }
        if (this.scaleEnable != gmc.scaleEnable) {
            return false;
        }
        if (this.transparencyMode != gmc.transparencyMode) {
            return false;
        }
        if (this.projectionPolicy != gmc.projectionPolicy) {
            return false;
        }
        if (this.polygonMode != gmc.polygonMode) {
            return false;
        }
        if (this.missingTransparent != gmc.missingTransparent) {
            return false;
        }
        if (this.curvedSize != gmc.curvedSize) {
            return false;
        }
        if (this.adjustProjectionSeam != gmc.adjustProjectionSeam) {
            return false;
        }
        if (this.texture3DMode != gmc.texture3DMode) {
            return false;
        }
        if (this.cacheAppearances != gmc.cacheAppearances) {
            return false;
        }
        return this.mergeGeometries == gmc.mergeGeometries;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("GraphicsModeControlJ2D[");
        buf.append("lw ");
        buf.append(this.lineWidth);
        buf.append(",ps ");
        buf.append(this.pointSize);
        buf.append(",ls ");
        buf.append(LINE_STYLE[this.lineStyle]);
        buf.append(this.pointMode ? "pm" : "!pm");
        buf.append(this.textureEnable ? "te" : "!te");
        buf.append(this.scaleEnable ? "se" : "!se");
        buf.append(this.missingTransparent ? "mt" : "!mt");
        buf.append(",tm ");
        buf.append(this.transparencyMode);
        buf.append(",pp ");
        buf.append(this.projectionPolicy);
        buf.append(",pm ");
        buf.append(this.polygonMode);
        buf.append(",cs ");
        buf.append(this.curvedSize);
        buf.append(",po ");
        buf.append(this.polygonOffset);
        buf.append(",pof ");
        buf.append(this.polygonOffsetFactor);
        buf.append(this.adjustProjectionSeam ? "as" : "!as");
        buf.append(",t3dm ");
        buf.append(this.texture3DMode);
        buf.append(",ca ");
        buf.append(this.cacheAppearances);
        buf.append(",mg ");
        buf.append(this.mergeGeometries);
        buf.append(']');
        return buf.toString();
    }
}

