/* rectangle.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* contains functions assoc. with rectangle composition */
/*
 * $Log: rectangle.c,v $
 * Revision 1.2  2000/12/06 20:56:03  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.5  2000/02/18 21:18:57  moz
 * polyline.pic usage changed.
 *
 * Revision 1.4  2000/02/17 22:14:35  moz
 * x1,y1 static. Compiler fixes.
 *
 * Revision 1.3  1999/11/15 02:05:38  moz
 * Name change.
 *
 * Revision 1.2  1999/05/19 17:08:24  moz
 * 1.0 Checkin.
 *
 * Revision 1.1  1999/03/30 00:05:52  moz
 * Initial revision
 *
 */    

/* see mouse_button.c for general behaviour */  
 
#include "include/figurine.h"  
#include "include/extern.h"
 
static long x1=0;
static long y1=0;

static Boolean held=FALSE;

void 
commit_rectangle(View *view, long x, long y)
{
	Object *ob; 
	VPoint *p1; 
	long x2,y2; 
	 
	if (view->gridon)
		{
		x2 = GXP2D(x,view);
		y2 = GYP2D(y,view);
		}
	else
		{
		x2 = XP2D(x,view);
		y2 = YP2D(y,view);
		};
		 
	ob = (Object *)malloc(sizeof(Object));
	if (ob==NULL)
		return;
	
	if (view->roundbox)
		ob->type = ROUNDBOX;
	else 
		ob->type = POLYGON;
		 
	ob->ticket = ob_ticket++;
	ob->derries = NULL; 
	ob->depth = view->doc->ob_depth--; 
	ob->ls = view->linestyle; 
	ob->lw = view->linewidth; 
	ob->es = view->endstyle;
	ob->js = view->joinstyle;
	ob->colour = view->colour; 
	ob->fillcolour = view->fillcolour; 
	/* constrain */
 	if (state.control_down) 
 		constrain_rectangle(x1, y1, &x2,&y2); 

	normalise_rectangle(&x1, &y1, &x2, &y2); 
	ob->bbox.x1 = x1;
	ob->bbox.y1 = y1;
	ob->bbox.x2 = x2; 
	ob->bbox.y2 = y2;
	ob->farrow = NULL;
	ob->barrow = NULL;

	if (view->fillon)
		ob->fs =  view->fillstyle;
	else
		ob->fs = NONE;
	
	if (view->roundbox)
		ob->ob.roundbox.radius = view->roundsize;
	else
		{
		ob->ob.polyline.pic = NULL;
		p1 = (VPoint *)malloc(sizeof(VPoint));
		p1->x = 0;
		p1->y = 0;
		p1->derried = FALSE; 
		ob->ob.polyline.points = create_list(0,0,(void *)p1);
		p1 = (VPoint *)malloc(sizeof(VPoint));
		p1->x = x2-ob->bbox.x1;
		p1->y = 0;
		p1->derried = FALSE; 
		ob->ob.polyline.points = add_to_list(ob->ob.polyline.points,1,0,(void *)p1);
		p1 = (VPoint *)malloc(sizeof(VPoint));
		p1->x = x2-ob->bbox.x1;
		p1->y = y2-ob->bbox.y1;
		p1->derried = FALSE; 
		ob->ob.polyline.points = add_to_list(ob->ob.polyline.points,2,0,(void *)p1);
		p1 = (VPoint *)malloc(sizeof(VPoint));
		p1->x = 0;
		p1->y = y2-ob->bbox.y1;
		p1->derried = FALSE; 
		ob->ob.polyline.points = add_to_list(ob->ob.polyline.points,3,0,(void *)p1);

		};

	view->doc->o = add_object(view->doc->o, &view->doc->lo, ob);
	register_undo(UNDO_PASTE,ob,view->doc); 
	 
	send_redraw_object(view,ob); 
}

void 
rectangle_button(BEvent *bev, View *view)
{
	 
	if (((held && bev->button==Button2) || bev->button==Button3) && state.busy_drawing )
		{
		/* cancel the current rectangle */ 
		if (!held) 
			XUngrabPointer(display,CurrentTime);
		
		toggle_rectangle(view, bev->x, bev->y);
			 
		state.busy_drawing = FALSE;
		held = FALSE;
		}
	else if (bev->button==Button1)
		{
		if (!P_IN_DOC(bev->x, bev->y, view) && state.busy_drawing)
			{
			/* ok, cancel the rectangle  we're drawing  */
			state.busy_drawing = FALSE;
			 
			if (!held)
				XUngrabPointer(display,CurrentTime);
			else 
				held = FALSE;
			
			toggle_rectangle(view, bev->x, bev->y);
			}
		else
			{
			switch (bev->type)
				{
				case BUTTON_HELD:
					
					if (state.busy_drawing)
						{

						}
					else
						{
						/* start drawing */
						state.busy_drawing = TRUE;
						held = TRUE;
						if (view->gridon)
							{
							x1 = GXP2D(bev->x,view);
							y1 = GYP2D(bev->y,view);
							}
						else
							{
							x1 = XP2D(bev->x,view);
							y1 = YP2D(bev->y,view);
							};	
						
 						toggle_rectangle(view, bev->x, bev->y);  
						}; 

					break; /* BUTTON_HELD  */ 

				case BUTTON_CLICKED:

					if (held)
						{
						XGrabPointer(display, view->draw_window->win, False, ButtonPressMask | ButtonReleaseMask | PointerMotionMask | ButtonMotionMask 
										 | Button1MotionMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime); 
						}
					else
						{
						XUngrabPointer(display,CurrentTime);
						toggle_rectangle(view, bev->x, bev->y);
					
						commit_rectangle(view, bev->x, bev->y);

						state.busy_drawing=FALSE;
						}; 
					 
					held = FALSE; 
					break;
					 
					  
				case BUTTON_RELEASED:
					
					toggle_rectangle(view, bev->x, bev->y);
					 
					commit_rectangle(view, bev->x, bev->y);
					held = FALSE;
					state.busy_drawing=FALSE;

					break;
				};
			}; 
		}; 
}

void 
toggle_rectangle(View *view, int x, int y)
{
	long xa1,ya1, x2,y2;
	VLine l;
	VLine *pl;
	Boolean clipped; 

	if (view->gridon)
		{
		x2 = GXP2D(x, view);
		y2 = GYP2D(y, view);
		}
	else
		{
		x2 = XP2D(x, view);
		y2 = YP2D(y, view);
		};
	
	xa1 = x1;
	ya1 = y1;

	xa1 = XD2P(xa1,view);
	ya1 = YD2P(ya1,view);
	x2 = XD2P(x2,view);
	y2 = YD2P(y2,view);
	/* constrain */
 	if (state.control_down) 
 		constrain_rectangle(xa1, ya1, &x2,&y2); 

	/* must clip each line of rectangle  */

	l.x1 = xa1; l.y1 = ya1; l.x2 = x2; l.y2 = ya1;
   pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h, &l, &clipped, 0);
   if (pl!=NULL)
       XDrawLine(display,view->draw_window->win, blackxorgc, pl->x1, pl->y1, pl->x2, pl->y2);    
	
	l.x1 = x2; l.y1 = ya1; l.x2 = x2; l.y2 = y2;
   pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h, &l, &clipped, 0);
   if (pl!=NULL)
       XDrawLine(display,view->draw_window->win, blackxorgc, pl->x1, pl->y1, pl->x2, pl->y2);    
	
	l.x1 = x2; l.y1 = y2; l.x2 = xa1; l.y2 = y2;
   pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h, &l, &clipped, 0);
   if (pl!=NULL)
       XDrawLine(display,view->draw_window->win, blackxorgc, pl->x1, pl->y1, pl->x2, pl->y2);    
	
	l.x1 = xa1; l.y1 = y2; l.x2 = xa1; l.y2 = ya1;
   pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h, &l, &clipped, 0);
   if (pl!=NULL)
       XDrawLine(display,view->draw_window->win, blackxorgc, pl->x1, pl->y1, pl->x2, pl->y2);    
}

void 
draw_roundbox(Object *ob, View *view, GC gc, long x, long y, double rx, double ry)
{
	long ox1,oy1,ox2,oy2, r; 
	VLine line; 
	VLine *pl;
	Boolean clipped; 
	 
	if (ob->lw==0 && gc!=blackxorgc)
		return;

	if (state.tied_corner!=NOTSCALING)
			corner_magic(ob, &x, &y, rx, ry);          

	rx = abs(rx);
	ry = abs(ry); 

	ox1 = XD2P(x,view);
	oy1 = YD2P(y,view);
	ox2 = XD2P(R(ob->bbox.x2-ob->bbox.x1,rx)+x,view);
	oy2 = YD2P(R(ob->bbox.y2-ob->bbox.y1,ry)+y,view);
	r = I2P(((double)ob->ob.roundbox.radius)/80.0,view);

	if (r>((ox2-ox1)/2) || r>((oy2-oy1)/2)) 
		r = min(((ox2-ox1)/2),((oy2-oy1)/2));

	if (ob->fs!=NONE && gc!=blackxorgc)
		{
		XFillArc(display,view->draw_window->win,fillgc,ox1,oy1,(ulong)2*r,(ulong)2*r,90*64,90*64);
		XFillArc(display,view->draw_window->win,fillgc,ox2-2*r,oy2-2*r,(ulong)2*r,(ulong)2*r,0,-90*64);
		XFillArc(display,view->draw_window->win,fillgc,ox2-2*r,oy1,(ulong)2*r,(ulong)2*r,0,90*64); 
		XFillArc(display,view->draw_window->win,fillgc,ox1,oy2-2*r,(ulong)2*r,(ulong)2*r,-180*64,90*64); 
		XFillRectangle(display,view->draw_window->win,fillgc,ox1+r,oy1,(ulong)ox2-(ox1+2*r),(ulong)oy2-oy1);
		XFillRectangle(display,view->draw_window->win,fillgc,ox1,oy1+r,(ulong)r,(ulong)oy2-(oy1+2*r)); 
		XFillRectangle(display,view->draw_window->win,fillgc,ox2-r,oy1+r,(ulong)r,(ulong)oy2-(oy1+2*r)); 
		}; 
	
	if (gc==blackxorgc || ob->lw!=0)
		{
		line.x1 = ox1+r; line.y1 = oy1; line.x2=ox2-r; line.y2=oy1;
		pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h, &line, &clipped, 2*ob->lw);   
		if (pl!=NULL) 
			XDrawLine(display,view->draw_window->win,gc, pl->x1, pl->y1, pl->x2, pl->y2);
			 
		line.x1 = ox2; line.y1 = oy1+r; line.x2=ox2; line.y2=oy2-r;
		pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h, &line, &clipped, 2*ob->lw);   
		if (pl!=NULL) 
			XDrawLine(display,view->draw_window->win,gc, pl->x1, pl->y1, pl->x2, pl->y2);
			 
		line.x1 = ox2-r; line.y1 = oy2; line.x2=ox1+r; line.y2=oy2;
		pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h, &line, &clipped, 2*ob->lw);   
		if (pl!=NULL) 
			XDrawLine(display,view->draw_window->win,gc, pl->x1, pl->y1, pl->x2, pl->y2);
			 
		line.x1 = ox1; line.y1 = oy2-r; line.x2=ox1; line.y2=oy1+r;
		pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h, &line, &clipped, 2*ob->lw);   
		if (pl!=NULL) 
			XDrawLine(display,view->draw_window->win,gc, pl->x1, pl->y1, pl->x2, pl->y2);
		
		XDrawArc(display,view->draw_window->win,gc,ox1,oy1,(ulong)2*r,(ulong)2*r,90*64,90*64);
		XDrawArc(display,view->draw_window->win,gc,ox2-2*r,oy2-2*r,(ulong)2*r,(ulong)2*r,0,-90*64);
		XDrawArc(display,view->draw_window->win,gc,ox2-2*r,oy1,(ulong)2*r,(ulong)2*r,0,90*64); 
		XDrawArc(display,view->draw_window->win,gc,ox1,oy2-2*r,(ulong)2*r,(ulong)2*r,-180*64,90*64); 
		};	
}
