/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

/* 
 *** file menu applet
 *** Copyright (C) 2001 Benjamin Kahn <xkahn@ximian.com>
 *** 
 *** This program is free software; you can redistribute it and/or
 *** modify it under the terms of the GNU General Public License
 *** as published by the Free Software Foundation; either version 2
 *** of the License, or (at your option) any later version.
 *** 
 *** This program is distributed in the hope that it will be useful,
 *** but WITHOUT ANY WARRANTY; without even the implied warranty of
 *** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *** GNU General Public License for more details.
 *** 
 *** You should have received a copy of the GNU General Public License
 *** along with this program; if not, write to the Free Software
 *** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 *** 02111-1307, USA.
 ***/

#include <gnome.h>
#include <applet-widget.h>
#include <config.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>

#include "main.h"
#include "scroll-menu.h"


void 
restore_grabs (GtkWidget *w,gpointer data) {
        GtkWidget *menu = GTK_WIDGET (data);
	/* Stolen from menu.c from the gnome panel */
	GdkCursor *cursor=gdk_cursor_new(GDK_ARROW);
	GTK_MENU_SHELL(menu)->have_xgrab=
		(gdk_pointer_grab (menu->window, TRUE,
			GDK_BUTTON_PRESS_MASK |
			GDK_BUTTON_RELEASE_MASK |
			GDK_ENTER_NOTIFY_MASK |
			GDK_LEAVE_NOTIFY_MASK,
			NULL, cursor, 0) == 0);
	gtk_grab_add(GTK_WIDGET(menu));
	gdk_cursor_destroy (cursor);
}

gboolean
maybe_popup_menu (GtkWidget *widget, GdkEventButton *event, void *parent_menu)
{
	gchar *file_path;
	GtkWidget *document_popup;

	file_path = (gchar *) gtk_object_get_data (GTK_OBJECT (widget), "full_path");

	/*	printf ("Trying to handle the activate event!\n");*/

	if (event->button == 3) {
		/*		printf ("Would have gotten here!\n");*/
		document_popup = create_document_menu (file_path);
		gtk_signal_connect(GTK_OBJECT(document_popup),"deactivate",
				GTK_SIGNAL_FUNC(restore_grabs),parent_menu);
		gtk_signal_emit_stop_by_name (GTK_OBJECT (widget), "button_press_event");
		gtk_menu_popup (GTK_MENU (document_popup), 
				NULL, NULL, NULL, NULL,
				event->button, event->time);
		return TRUE;
	} 
	
	return FALSE;
}

GtkWidget * 
create_document_menu (char *file_path) 
{
	GnomeVFSResult result;
	GnomeVFSFileInfo *file_info;
	GnomeVFSMimeApplication *application;

	GtkWidget *menuitem;
	GtkWidget *document_popup;

	GList *applications;

	char *file_name;

	document_popup = scroll_menu_new ();

	/* Detect the file type. */
	
	file_info = gnome_vfs_file_info_new ();
	result = gnome_vfs_get_file_info ((char *) file_path, file_info, (GNOME_VFS_FILE_INFO_GET_MIME_TYPE
								 | GNOME_VFS_FILE_INFO_FOLLOW_LINKS));
	if (result != GNOME_VFS_OK) {
		fprintf (stderr, "file_menu_applet: %s: %s\n",
			 file_path, gnome_vfs_result_to_string (result));
		return NULL;
	}
	
	/* Find application */
	application = gnome_vfs_mime_get_default_application ((char *)file_info->mime_type);

	file_name = strrchr (file_path, '/');
	if (file_name)
		file_name += 1;
	else
		file_name = file_path;

	if (application) {
		menuitem = pixmap_menu_item_new (g_strconcat ("Open '", file_name, "' with ", application->name, NULL), NULL, 0);
		gtk_menu_append (GTK_MENU (document_popup), menuitem);

		gtk_object_set_data (GTK_OBJECT (menuitem), "full_path", (gpointer) file_path);

		gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
			    GTK_SIGNAL_FUNC (exec_document_wrap), (gpointer) NULL);

		gtk_widget_show (menuitem);

		applications = gnome_vfs_mime_get_short_list_applications ((char *)file_info->mime_type);
		
		if (applications) {
			GtkWidget *appmenu;
			GtkWidget *appmenuitem;
			
			menuitem = pixmap_menu_item_new ("Open With...", NULL, 0);
			gtk_menu_append (GTK_MENU (document_popup), menuitem);
			
			gtk_widget_show (menuitem);

			appmenu = scroll_menu_new ();
			gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), GTK_MENU (appmenu));

			gtk_widget_show (appmenu);

			while (applications) {
				appmenuitem = pixmap_menu_item_new (((GnomeVFSMimeApplication *) applications->data)->name, NULL, 0);

				gtk_object_set_data (GTK_OBJECT (appmenuitem), "full_path", (gpointer) file_path);
				gtk_signal_connect (GTK_OBJECT (appmenuitem), "activate",
						    GTK_SIGNAL_FUNC (exec_document_wrap), (gpointer) applications->data);
 
				gtk_widget_show (appmenuitem);

				gtk_menu_append (GTK_MENU (appmenu), appmenuitem);
				
				applications = applications->next;
			}
		}

	}

	menuitem = pixmap_menu_item_new (g_strconcat ("Copy '", file_name, "' to ...", NULL), NULL, 0);
	gtk_menu_append (GTK_MENU (document_popup), menuitem);
	gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
			    GTK_SIGNAL_FUNC (show_copy_dialog), 
			    (gpointer) file_path);
	gtk_widget_show (menuitem);

	menuitem = pixmap_menu_item_new (g_strconcat ("Move '", file_name, "' to ...", NULL), NULL, 0);
	gtk_menu_append (GTK_MENU (document_popup), menuitem);
	gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
			    GTK_SIGNAL_FUNC (show_move_dialog), 
			    (gpointer) file_path);
	gtk_widget_show (menuitem);

	menuitem = pixmap_menu_item_new (g_strconcat ("Rename '", file_name, "' to...", NULL), NULL, 0);
	gtk_menu_append (GTK_MENU (document_popup), menuitem);
	gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
			    GTK_SIGNAL_FUNC (show_rename_dialog), 
			    (gpointer) file_path);
	gtk_widget_show (menuitem);

	menuitem = pixmap_menu_item_new (g_strconcat ("Delete '", file_name, "'", NULL), NULL, 0);
	gtk_menu_append (GTK_MENU (document_popup), menuitem);
	gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
			    GTK_SIGNAL_FUNC (delete_file),
			    (gpointer) file_path);
	gtk_widget_show (menuitem);

	if (application) {
		menuitem = pixmap_menu_item_new ("Change Handler Application..", NULL, 0);
	} else {
		menuitem = pixmap_menu_item_new ("Add Handler Application...", NULL, 0);
	}
	gtk_menu_append (GTK_MENU (document_popup), menuitem);
	gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
			    GTK_SIGNAL_FUNC (show_handler),
			    (gpointer) file_info->mime_type);
	gtk_widget_show (menuitem);

	return document_popup;
}

