#!fish
# Maven fish auto completion
#
# Possible calls to mvn
#
## Lifecycle
# mvn $lifecycle(s)
#
# Attention: Multiple lifecycles can be given
#
### Samples
# mvn clean
# mvn clean install
# mvn install
#
#
## Plugins
# mvn $plugin:$goal
### Samples
# mvn jboss:start
# mvn ejb:ejb
# mvn jboss:start ejb:ejb
# Attention: Multiple plugins can be given


# Default lifecycles
complete -c mvn -f -a 'pre-clean clean post-clean validate initialize generate-sources process-sources generate-resources process-resources compile process-classes generate-test-sources process-test-sources generate-test-resources process-test-resources test-compile process-test-classes testprepare-package package pre-integration-test integration-test post-integration-test verify install deploy pre-site site post-site site-deploy'

# All options form mvn --help
complete -c mvn -f -o am -l also-make                        -d "If project list is specified, also build projects required by the list"
complete -c mvn -f -o amd -l also-make-dependents            -d "If project list is specified, also build projects that depend on projects on the list"
complete -c mvn -f -o B -l batch-mode                        -d "Run in non-interactive (batch) mode"
complete -c mvn -r -f -o b -l builder                      -d "The id of the build strategy to use."
complete -c mvn -f -o C -l strict-checksums                  -d "Fail the build if checksums don't match"
complete -c mvn -f -o c -l lax-checksums                     -d "Warn if checksums don't match"
complete -c mvn -f -o cpu -l check-plugin-updates            -d "Ineffective, only kept for backward compatibility"
complete -c mvn -f -o D -l define                      -d "Define a system property"
complete -c mvn -f -o e -l errors                            -d "Produce execution error messages"
complete -c mvn -f -o emp -l encrypt-master-password   -d "Encrypt master security password"
complete -c mvn -f -o ep -l encrypt-password           -d "Encrypt server password"
complete -c mvn -r -o f -l file                        -d "Force the use of an alternate POM file (or directory with pom.xml)."
complete -c mvn -f -o fae -l fail-at-end                     -d "Only fail the build afterwards; allow all non-impacted builds to continue"
complete -c mvn -f -o ff -l fail-fast                        -d "Stop at first failure in reactorized builds"
complete -c mvn -f -o fn -l fail-never                       -d "NEVER fail the build, regardless of project result"
complete -c mvn -r -o gs -l global-settings            -d "Alternate path for the global settings file"
complete -c mvn -f -o h -l help                              -d "Display help information"
complete -c mvn -r -o l -l log-file                    -d "Log file to where all build output will go."
complete -c mvn -f -o llr -l legacy-local-repository         -d "Use Maven 2 Legacy Local Repository behaviour, ie no use of _remote.repositories. Can also be activated by using -Dmaven.legacyLocalRepo=true"
complete -c mvn -f -o N -l non-recursive                     -d "Do not recurse into sub-projects"
complete -c mvn -f -o npr -l no-plugin-registry              -d "Ineffective, only kept for backward compatibility"
complete -c mvn -f -o npu -l no-plugin-updates               -d "Ineffective, only kept for backward compatibility"
complete -c mvn -f -o nsu -l no-snapshot-updates             -d "Suppress SNAPSHOT updates"
complete -c mvn -f -o o -l offline                           -d "Work offline"
complete -c mvn -r -f -o pl -l projects                   -d "Comma-delimited list of specified reactor projects to build instead of all projects. A project can be specified by [groupId]:artifactId or by its relative path."
complete -c mvn -f -o q -l quiet                             -d "Quiet output - only show errors"
complete -c mvn -r -f -o rf -l resume-from                -d "Resume reactor from specified project"
complete -c mvn -r -o s -l settings                    -d "Alternate path for the user settings file"
complete -c mvn -r -f -o T -l threads                     -d "Thread count, for instance 2.0C where C is core multiplied"
complete -c mvn -r -o t -l toolchains                  -d "Alternate path for the user toolchains file"
complete -c mvn -f -o U -l update-snapshots                  -d "Forces a check for missing releases and updated snapshots on remote repositories"
complete -c mvn -f -o up -l update-plugins                   -d "Ineffective, only kept for backward compatibility"
complete -c mvn -f -o V -l show-version                      -d "Display version information WITHOUT stopping build"
complete -c mvn -f -o v -l version                           -d "Display version information"
complete -c mvn -f -o X -l debug                             -d "Produce execution debug output"

#
#
# Profiles
#
#
function __fish_mvn_profiles_from_settings
  grep -e "<profile>" -A 1 ~/.m2/settings.xml | grep -e "<id>.*</id>" | sed 's/.*<id>//' | sed 's/<\/id>.*//g'
end

#TODO search pom.xml hierarchy
function __fish_mvn_profiles_from_pom
  [ -e pom.xml ]; and grep -e "<profile>" -A 1 pom.xml | grep -e "<id>.*</id>" | sed 's/.*<id>//' | sed 's/<\/id>.*//g'
end

complete -c mvn -f -r -o P -l activate-profiles -a "(__fish_mvn_profiles_from_pom) (__fish_mvn_profiles_from_settings)"    -d "Comma-delimited list of profiles to activate"


#default properties for some plugins / profiles
complete -c mvn -o DskipTests                             -d "Skipping JUnit Tests"
complete -c mvn -o DbuildInstaller                        -d "Build installer (if profile is available in project)"
complete -c mvn -o DperformRelease                        -d "Use release profile (create javadoc and attach sources)"
complete -c mvn -o Dmaven.surefire.debug                  -d "Run surefire tests with debugging on port 5005"
complete -c mvn -o Dmaven.javadoc.skip                  -d "Skip Javadoc generation"


#
# Plugin configurations
#


# More plugins
complete -c mvn -a "clean:clean" -d "Goal which cleans the build. This attempts to clean a project's working directory of the files that were generated at build-time. By default, it discovers and deletes the directories configured in project.build.directory, project.build.outputDirectory, project.build.testOutputDirectory, and project.reporting.outputDirectory.  Files outside the default may also be included in the deletion by configuring the filesets tag. "
complete -c mvn -a "clean:help" -d "Display help information on maven-clean-plugin. Call mvn clean:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "compiler:compile" -d "Compiles application sources"
complete -c mvn -a "compiler:help" -d "Display help information on maven-compiler-plugin. Call mvn compiler:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "compiler:testCompile" -d "Compiles application test sources."
complete -c mvn -a "deploy:help" -d "Display help information on maven-deploy-plugin. Call mvn deploy:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "deploy:deploy-file" -d "Installs the artifact in the remote repository."
complete -c mvn -a "deploy:deploy" -d "Deploys an artifact to remote repository."
complete -c mvn -a "failsafe:help" -d "Display help information on maven-failsafe-plugin. Call mvn failsafe:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "failsafe:integration-test" -d "Run integration tests using Surefire."
complete -c mvn -a "failsafe:verify" -d "Verify integration tests ran using Surefire."
complete -c mvn -a "install:install" -d "Installs the project's main artifact, and any other artifacts attached by other plugins in the lifecycle, to the local repository."
complete -c mvn -a "install:help" -d "Display help information on maven-install-plugin. Call mvn install:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "install:install-file" -d "Installs a file in the local repository."
complete -c mvn -a "resources:testResources" -d "Copy resources for the test source code to the test output directory. Always uses the project.build.testResources element to specify the resources to copy."
complete -c mvn -a "resources:copy-resources" -d "Copy resources of the configured plugin attribute resources"
complete -c mvn -a "resources:help" -d "Display help information on maven-resources-plugin. Call mvn resources:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "resources:resources" -d "Copy resources for the main source code to the main output directory. Always uses the project.build.resources element to specify the resources to copy."
complete -c mvn -a "site:attach-descriptor" -d "Adds the site descriptor (site.xml) to the list of files to be installed/deployed. For Maven-2.x this is enabled by default only when the project has pom packaging since it will be used by modules inheriting, but this can be enabled for other projects packaging if needed. This default execution has been removed from the built-in lifecycle of Maven 3.x for pom-projects. Users that actually use those projects to provide a common site descriptor for sub modules will need to explicitly define this goal execution to restore the intended behavior."
complete -c mvn -a "site:deploy" -d "Deploys the generated site using wagon supported protocols to the site URL specified in the <distributionManagement> section of the POM. For scp protocol, the website files are packaged by wagon into zip archive, then the archive is transfered to the remote host, next it is un-archived which is much faster than making a file by file copy. "
complete -c mvn -a "site:effective-site" -d "Displays the effective site descriptor as an XML for this build, after inheritance and interpolation of site.xml."
complete -c mvn -a "site:help" -d "Display help information on maven-site-plugin. Call mvn site:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "site:jar" -d "Bundles the site output into a JAR so that it can be deployed to a repository."
complete -c mvn -a "site:run" -d "Starts the site up, rendering documents as requested for faster editing. It uses Jetty as the web server."
complete -c mvn -a "site:site" -d "Generates the site for a single project. Note that links between module sites in a multi module build will not work, since local build directory structure doesn't match deployed site. "
complete -c mvn -a "site:stage" -d "Deploys the generated site to a local staging or mock directory based on the site URL specified in the <distributionManagement> section of the POM. It can be used to test that links between module sites in a multi-module build work. "
complete -c mvn -a "site:stage-deploy" -d "Deploys the generated site to a staging or mock URL to the site URL specified in the <distributionManagement> section of the POM, using wagon supported protocols"
complete -c mvn -a "surefire:help" -d "Display help information on maven-surefire-plugin. Call mvn surefire:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "surefire:test" -d "Run tests using Surefire."
complete -c mvn -a "verifier:help" -d "Display help information on maven-verifier-plugin. Call mvn verifier:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "verifier:verify" -d "Verifies the existence or non-existence of files/directories and optionally checks file content against a regular expression."
complete -c mvn -a "ear:ear" -d "Builds J2EE Enterprise Archive (EAR) files."
complete -c mvn -a "ear:generate-application-xml" -d "Generates the EAR deployment descriptor file(s)."
complete -c mvn -a "ear:help" -d "Display help information on maven-ear-plugin. Call mvn ear:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "ejb:ejb" -d "Build an EJB (and optional client) from the current project."
complete -c mvn -a "ejb:help" -d "Display help information on maven-ejb-plugin. Call mvn ejb:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "jar:help" -d "Display help information on maven-jar-plugin. Call mvn jar:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "jar:jar" -d "Build a JAR from the current project."
complete -c mvn -a "jar:test-jar" -d "Build a JAR of the test classes for the current project."
complete -c mvn -a "rar:help" -d "Display help information on maven-rar-plugin. Call mvn rar:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "rar:rar" -d "Builds J2EE Resource Adapter Archive (RAR) files."
complete -c mvn -a "shade:help" -d "Display help information on maven-shade-plugin. Call mvn shade:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "shade:shade" -d "Mojo that performs shading delegating to the Shader component."
complete -c mvn -a "source:aggregate" -d "Aggregate sources for all modules in an aggregator project."
complete -c mvn -a "source:jar" -d "This plugin bundles all the sources into a jar archive."
complete -c mvn -a "source:test-jar-no-fork" -d "This goal bundles all the test sources into a jar archive. This goal functions the same as the test-jar goal but does not fork the build, and is suitable for attaching to the build lifecycle."
complete -c mvn -a "source:test-jar" -d "This plugin bundles all the test sources into a jar archive."
complete -c mvn -a "source:generated-test-jar" -d "This plugin bundles all the test sources into a jar archive."
complete -c mvn -a "source:help" -d "Display help information on maven-source-plugin. Call mvn source:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "source:jar-no-fork" -d "This goal bundles all the sources into a jar archive. This goal functions the same as the jar goal but does not fork the build and is suitable for attaching to the build lifecycle."
complete -c mvn -a "changelog:changelog" -d "Generate a changelog report."
complete -c mvn -a "changelog:file-activity" -d "Generate a file activity report."
complete -c mvn -a "changelog:dev-activity" -d "Generate a developer activity report."
complete -c mvn -a "changelog:help" -d "Display help information on maven-changelog-plugin. Call mvn changelog:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "changes:changes-validate" -d "Goal which validate the changes.xml file."
complete -c mvn -a "changes:changes-check" -d "Goal which checks that the changes.xml file has the necessary data to generate an announcement or a report for the current release."
complete -c mvn -a "changes:github-report" -d "Goal which downloads issues from GitHub and generates a report."
complete -c mvn -a "changes:announcement-generate" -d "Goal which generate an announcement from the announcement template."
complete -c mvn -a "changes:trac-report" -d "Goal which downloads issues from the Issue Tracking System and generates a report."
complete -c mvn -a "changes:changes-report" -d "Goal which creates a nicely formatted Changes Report in html format from a changes.xml file."
complete -c mvn -a "changes:announcement-mail" -d "Goal which sends an announcement through email."
complete -c mvn -a "changes:jira-report" -d "Goal which downloads issues from the Issue Tracking System and generates a report."
complete -c mvn -a "changes:help" -d "Display help information on maven-changes-plugin. Call mvn changes:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "checkstyle:check" -d "Performs Checkstyle analysis and outputs violations or a count of violations to the console, potentially failing the build. It can also be configured to re-use an earlier analysis."
complete -c mvn -a "checkstyle:checkstyle" -d "A reporting task that performs Checkstyle analysis and generates an HTML report on any violations that Checkstyle finds."
complete -c mvn -a "checkstyle:checkstyle-aggregate" -d "A reporting task that performs Checkstyle analysis and generates an aggregate HTML report on the violations that Checkstyle finds in a multi-module reactor build."
complete -c mvn -a "checkstyle:help" -d "Display help information on maven-checkstyle-plugin. Call mvn checkstyle:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "doap:generate" -d "Generate a Description of a Project (DOAP) file from the main information found in a POM. Note: The generated file is tailored for use by projects at Apache."
complete -c mvn -a "doap:help" -d "Display help information on maven-doap-plugin. Call mvn doap:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "docck:check" -d "Checks a plugin's documentation for the standard minimums."
complete -c mvn -a "docck:help" -d "Display help information on maven-docck-plugin. Call mvn docck:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "javadoc:aggregate" -d "Generates documentation for the Java code in an aggregator project using the standard Javadoc Tool."
complete -c mvn -a "javadoc:aggregate-jar" -d "Bundles the Javadoc documentation for main Java code in an aggregator project into a jar using the standard Javadoc Tool."
complete -c mvn -a "javadoc:fix" -d "Fix Javadoc documentation and tags for the Java code for the project. See Where Tags Can Be Used."
complete -c mvn -a "javadoc:help" -d "Display help information on maven-javadoc-plugin. Call mvn javadoc:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "javadoc:jar" -d "Bundles the Javadoc documentation for main Java code in an NON aggregator project into a jar using the standard Javadoc Tool."
complete -c mvn -a "javadoc:javadoc" -d "Generates documentation for the Java code in an NON aggregator project using the standard Javadoc Tool."
complete -c mvn -a "javadoc:javadoc-no-fork" -d "Generates documentation for the Java code in an NON aggregator project using the standard Javadoc Tool. Note that this goal does require generation of sources before site generation, e.g. by invoking mvn clean deploy site."
complete -c mvn -a "javadoc:resource-bundle" -d "Bundle AbstractJavadocMojo.javadocDirectory, along with javadoc configuration options such as taglet, doclet, and link information into a deployable artifact. This artifact can then be consumed by the javadoc plugin mojos when used by the includeDependencySources option, to generate javadocs that are somewhat consistent with those generated in the original project itself."
complete -c mvn -a "javadoc:test-aggregate" -d "Generates documentation for the Java Test code in an aggregator project using the standard Javadoc Tool."
complete -c mvn -a "javadoc:test-aggregate-jar" -d "Bundles the Javadoc documentation for Java Test code in an aggregator project into a jar using the standard Javadoc Tool."
complete -c mvn -a "javadoc:test-fix" -d "Fix Javadoc documentation and tags for the Test Java code for the project. See Where Tags Can Be Used."
complete -c mvn -a "javadoc:test-jar" -d "Bundles the Javadoc documentation for test Java code in an NON aggregator project into a jar using the standard Javadoc Tool."
complete -c mvn -a "javadoc:test-javadoc" -d "Generates documentation for the Java Test code in an NON aggregator project using the standard Javadoc Tool."
complete -c mvn -a "javadoc:test-javadoc-no-fork" -d "Generates documentation for the Java Test code in an NON aggregator project using the standard Javadoc Tool. Note that this goal does require generation of test sources before site generation, e.g. by invoking mvn clean deploy site."
complete -c mvn -a "javadoc:test-resource-bundle" -d "Bundle TestJavadocJar.testJavadocDirectory, along with javadoc configuration options from AbstractJavadocMojo such as taglet, doclet, and link information into a deployable artifact. This artifact can then be consumed by the javadoc plugin mojos when used by the includeDependencySources option, to generate javadocs that are somewhat consistent with those generated in the original project itself."
complete -c mvn -a "jxr:aggregate" -d "Generates a combined JXR report in an aggregating project."
complete -c mvn -a "jxr:help" -d "Display help information on maven-jxr-plugin. Call mvn jxr:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "jxr:jxr" -d "Creates an html-based, cross referenced version of Java source code for a project."
complete -c mvn -a "jxr:test-aggregate" -d "Generates a combined JXR report for test code in an aggregating project."
complete -c mvn -a "jxr:test-jxr" -d "Creates an html-based, cross referenced version of Java source code for a project's test sources."
complete -c mvn -a "linkcheck:linkcheck" -d "Generates a Linkcheck report."
complete -c mvn -a "linkcheck:help" -d "Display help information on maven-linkcheck-plugin. Call mvn linkcheck:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "pmd:check" -d "Fail the build if there were any PMD violations in the source code."
complete -c mvn -a "pmd:cpd" -d "Creates a report for PMD's CPD tool. See http://pmd.sourceforge.net/cpd.html for more detail."
complete -c mvn -a "pmd:cpd-check" -d "Fail the build if there were any CPD violations in the source code."
complete -c mvn -a "pmd:help" -d "Display help information on maven-pmd-plugin. Call mvn pmd:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "pmd:pmd" -d "Creates a PMD report."
complete -c mvn -a "project-info-reports:cim" -d "Generates the Project Continuous Integration System report."
complete -c mvn -a "project-info-reports:dependencies" -d "Generates the Project Dependencies report."
complete -c mvn -a "project-info-reports:dependency-convergence" -d "Generates the Dependency Convergence report for reactor builds."
complete -c mvn -a "project-info-reports:dependency-info" -d "Generates code snippets to be added to build tools."
complete -c mvn -a "project-info-reports:dependency-management" -d "Generates the Project Dependency Management report."
complete -c mvn -a "project-info-reports:distribution-management" -d "Generates the Project Distribution Management report."
complete -c mvn -a "project-info-reports:help" -d "Display help information on maven-project-info-reports-plugin. Call mvn project-info-reports:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "project-info-reports:index" -d "Generates the project index page."
complete -c mvn -a "project-info-reports:issue-tracking" -d "Generates the Project Issue Tracking report."
complete -c mvn -a "project-info-reports:license" -d "Generates the Project License report."
complete -c mvn -a "project-info-reports:mailing-list" -d "Generates the Mailing List report."
complete -c mvn -a "project-info-reports:modules" -d "Generates the Project Modules report."
complete -c mvn -a "project-info-reports:plugin-management" -d "Generates the Project Plugin Management report."
complete -c mvn -a "project-info-reports:plugins" -d "Generates the Project Plugins report."
complete -c mvn -a "project-info-reports:project-team" -d "Generates the Project Team report."
complete -c mvn -a "project-info-reports:scm" -d "Generates the Project Source Code Management (SCM) report."
complete -c mvn -a "project-info-reports:summary" -d "Generates the project information reports summary."
complete -c mvn -a "surefire-report:failsafe-report-only" -d "Creates a nicely formatted Failsafe Test Report in html format. This goal does not run the tests, it only builds the reports. See http://jira.codehaus.org/browse/SUREFIRE-257"
complete -c mvn -a "surefire-report:help" -d "Display help information on maven-surefire-report-plugin. Call mvn surefire-report:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "surefire-report:report" -d "Creates a nicely formatted Surefire Test Report in html format."
complete -c mvn -a "surefire-report:report-only" -d "Creates a nicely formatted Surefire Test Report in html format. This goal does not run the tests, it only builds the reports. This is a workaround for http://jira.codehaus.org/browse/SUREFIRE-257"
complete -c mvn -a "ant:ant" -d "Generate Ant build files."
complete -c mvn -a "ant:clean" -d "Clean all Ant build files."
complete -c mvn -a "ant:help" -d "Display help information on maven-ant-plugin. Call mvn ant:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "antrun:help" -d "Display help information on maven-antrun-plugin. Call mvn antrun:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "antrun:run" -d "Maven AntRun Mojo. This plugin provides the capability of calling Ant tasks from a POM by running the nested Ant tasks inside the <tasks/> parameter. It is encouraged to move the actual tasks to a separate build.xml file and call that file with an <ant/> task."
complete -c mvn -a "archetype:crawl" -d "Crawl a Maven repository (filesystem, not HTTP) and creates a catalog file."
complete -c mvn -a "archetype:create" -d "The archetype creation goal looks for an archetype with a given groupId, artifactId, and version and retrieves it from the remote repository. Once the archetype is retrieved, it is then processed against a set of user parameters to create a working Maven project."
complete -c mvn -a "archetype:create-from-project" -d "Creates an archetype project from the current project.  This goal reads your source and resource files, the values of its parameters, and properties you specify in a .property file, and uses them to create a Maven archetype project using the maven-archetype packaging. If you build the resulting project, it will create the archetype. You can then use this archetype to create new projects that resemble the original.  The maven-archetype-plugin uses Velocity to expand template files, and this documentation talks about 'Velocity Properties', which are values substituted into Velocity templates. See The Velocity User's Guide for more information.  This goal modifies the text of the files of the current project to form the Velocity template files that make up the archetype.  GAV  The GAV values for the current project are replaced by properties: groupId, artifactId, and version. The user chooses new values for these when generating a project from the archetype. package  All the files under one specified Java (or cognate) package are relocated to a project that the user chooses when generating a project. References to the class name are replaced by a property reference. For example, if the current project's sources are in the package org.apache.saltedpeanuts, then any example of the string org.apache.saltedpeanuts is replaced with the Velocity property reference \${packageName}. When the user generates a project, this is in turn replaced by his or her choice of a package. custom properties  You may identify additional strings that should be replaced by parameters. To add custom properties, you must use the propertyFile parameter to specify a property file. See the documentation for propertyFile for the details.  Note that you may need to edit the results of this goal. This goal has no way to exclude unwanted files, or add copyright notices to the Velocity templates, or add more complex elements to the archetype metadata file.  This goal also generates a simple integration-test that exercises the generated archetype. "
complete -c mvn -a "archetype:generate" -d "Generates a new project from an archetype, or updates the actual project if using a partial archetype. If the project is fully generated, it is generated in a directory corresponding to its artifactId. If the project is updated with a partial archetype, it is done in the current directory."
complete -c mvn -a "archetype:help" -d "Display help information on maven-archetype-plugin. Call mvn archetype:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "archetype:integration-test" -d "Execute the archetype integration tests, consisting in generating projects from the current archetype and optionally comparing generated projects with reference copy.  Each IT consists of a sub-directory in src/test/resources/projects containing:  - a goal.txt file, containing a list of goals to run against the generated project (can be empty, content ignored before maven-archetype-plugin 2.1), - an archetype.properties file, containing properties for project generation, - an optional reference/ directory containing a reference copy of the expected project created from the IT. Notice that it is expected to be run as part as of a build after the package phase and not directly as a goal from CLI."
complete -c mvn -a "archetype:jar" -d "Build a JAR from the current Archetype project."
complete -c mvn -a "archetype:update-local-catalog" -d "Updates the local catalog"
complete -c mvn -a "assembly:assembly" -d "Assemble an application bundle or distribution using an assembly descriptor from the command line. This goal will force Maven to build all included POMs up to the package phase BEFORE the assembly is processed. NOTE: This goal should ONLY be run from the command line, and if building a multimodule project it should be used from the root POM. Use the assembly:single goal for binding your assembly to the lifecycle. "
complete -c mvn -a "assembly:attached" -d "Assemble an application bundle or distribution from an assembly descriptor, WITHOUT first forcing Maven to build all POMs to the package phase (as is required by the assembly:assembly goal). NOTE: This goal should ONLY be run from the command line, and if building a multimodule project it should be used from the root POM. Use the assembly:single goal for binding your assembly to the lifecycle."
complete -c mvn -a "assembly:directory" -d "Like the assembly:attached goal, assemble an application bundle or distribution using an assembly descriptor from the command line. This goal will force Maven to build all included POMs up to the package phase BEFORE the assembly is processed. This goal differs from assembly:assembly in that it ignores the <formats/> section of the assembly descriptor, and forces the assembly to be created as a directory in the project's build-output directory (usually ./target). This goal is also functionally equivalent to using the assembly:assembly goal in conjunction with the dir assembly format. NOTE: This goal should ONLY be run from the command line, and if building a multimodule project it should be used from the root POM. Use the assembly:directory-single goal for binding your assembly to the lifecycle."
complete -c mvn -a "assembly:directory-inline" -d "Like the assembly:attached goal, assemble an application bundle or distribution from an assembly descriptor, WITHOUT first forcing Maven to build all POMs to the package phase (as is required by the assembly:assembly goal). This goal differs from assembly:attached in that it ignores the <formats/> section of the assembly descriptor, and forces the assembly to be created as a directory in the project's build-output directory (usually ./target). This goal is also functionally equivalent to using the assembly:attached goal in conjunction with the dir assembly format. NOTE: This goal should ONLY be run from the command line, and if building a multimodule project it should be used from the root POM. Use the assembly:directory-single goal for binding your assembly to the lifecycle."
complete -c mvn -a "assembly:directory-single" -d "Like the assembly:attached goal, assemble an application bundle or distribution from an assembly descriptor. This goal is suitable either for binding to the lifecycle or calling directly from the command line (provided all required files are available before the build starts, or are produced by another goal specified before this one on the command line). This goal differs from assembly:single in that it ignores the <formats/> section of the assembly descriptor, and forces the assembly to be created as a directory in the project's build-output directory (usually ./target)."
complete -c mvn -a "assembly:help" -d "Display help information on maven-assembly-plugin. Call mvn assembly:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "assembly:single" -d "Assemble an application bundle or distribution from an assembly descriptor. This goal is suitable either for binding to the lifecycle or calling directly from the command line (provided all required files are available before the build starts, or are produced by another goal specified before this one on the command line)."
complete -c mvn -a "assembly:unpack" -d "Unpack project dependencies. Currently supports dependencies of type jar and zip."
complete -c mvn -a "dependency:analyze" -d "Analyzes the dependencies of this project and determines which are: used and declared; used and undeclared; unused and declared. This goal is intended to be used standalone, thus it always executes the test-compile phase - use the dependency:analyze-only goal instead when participating in the build lifecycle. By default, maven-dependency-analyzer is used to perform the analysis, with limitations due to the fact that it works at bytecode level, but any analyzer can be plugged in through analyzer parameter. "
complete -c mvn -a "dependency:analyze-dep-mgt" -d "This mojo looks at the dependencies after final resolution and looks for mismatches in your dependencyManagement section. In versions of maven prior to 2.0.6, it was possible to inherit versions that didn't match your dependencyManagement. See MNG-1577 for more info. This mojo is also useful for just detecting projects that override the dependencyManagement directly. Set ignoreDirect to false to detect these otherwise normal conditions."
complete -c mvn -a "dependency:analyze-duplicate" -d "Analyzes the <dependencies/> and <dependencyManagement/> tags in the pom.xml and determines the duplicate declared dependencies."
complete -c mvn -a "dependency:analyze-only" -d "Analyzes the dependencies of this project and determines which are: used and declared; used and undeclared; unused and declared. This goal is intended to be used in the build lifecycle, thus it assumes that the test-compile phase has been executed - use the dependency:analyze goal instead when running standalone. By default, maven-dependency-analyzer is used to perform the analysis, with limitations due to the fact that it works at bytecode level, but any analyzer can be plugged in through analyzer parameter. "
complete -c mvn -a "dependency:analyze-report" -d "Analyzes the dependencies of this project and produces a report that summarizes which are: used and declared; used and undeclared; unused and declared."
complete -c mvn -a "dependency:build-classpath" -d "This goal will output a classpath string of dependencies from the local repository to a file or log."
complete -c mvn -a "dependency:copy" -d "Goal that copies a list of artifacts from the repository to defined locations."
complete -c mvn -a "dependency:copy-dependencies" -d "Goal that copies the project dependencies from the repository to a defined location."
complete -c mvn -a "dependency:display-ancestors" -d "Displays all ancestor POMs of the project. This may be useful in a continuous integration system where you want to know all parent poms of the project."
complete -c mvn -a "dependency:get" -d "Resolves a single artifact, eventually transitively, from the specified remote repositories. Caveat: will always check thecentral repository defined in the super pom. You could use a mirror entry in your settings.xml"
complete -c mvn -a "dependency:go-offline" -d "Goal that resolves all project dependencies, including plugins and reports and their dependencies."
complete -c mvn -a "dependency:help" -d "Display help information on maven-dependency-plugin. Call mvn dependency:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "dependency:list" -d "Displays the list of dependencies for this project."
complete -c mvn -a "dependency:list-repositories" -d "Goal that resolves all project dependencies and then lists the repositories used by the build and by the transitive dependencies"
complete -c mvn -a "dependency:properties" -d "Goal that sets a property pointing to the artifact file for each project dependency. For each dependency (direct and transitive) a project property will be set which follows the groupId:artifactId:type:[classifier] form and contains the path to the resolved artifact."
complete -c mvn -a "dependency:purge-local-repository" -d "Remove the project dependencies from the local repository, and optionally re-resolve them."
complete -c mvn -a "dependency:resolve" -d "Goal that resolves the project dependencies from the repository."
complete -c mvn -a "dependency:resolve-plugins" -d "Goal that resolves all project plugins and reports and their dependencies."
complete -c mvn -a "dependency:sources" -d "Goal that resolves the project source dependencies from the repository."
complete -c mvn -a "dependency:tree" -d "Displays the dependency tree for this project."
complete -c mvn -a "dependency:unpack" -d "Goal that retrieves a list of artifacts from the repository and unpacks them in a defined location."
complete -c mvn -a "dependency:unpack-dependencies" -d "Goal that unpacks the project dependencies from the repository to a defined location."
complete -c mvn -a "enforcer:display-info" -d "This goal displays the current platform information."
complete -c mvn -a "enforcer:enforce" -d "This goal executes the defined enforcer-rules once per module."
complete -c mvn -a "enforcer:help" -d "Display help information on maven-enforcer-plugin. Call mvn enforcer:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "gpg:help" -d "Display help information on maven-gpg-plugin. Call mvn gpg:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "gpg:sign" -d "Sign project artifact, the POM, and attached artifacts with GnuPG for deployment."
complete -c mvn -a "gpg:sign-and-deploy-file" -d "Signs artifacts and installs the artifact in the remote repository."
complete -c mvn -a "help:expressions" -d "Displays the supported Plugin expressions used by Maven."
complete -c mvn -a "help:active-profiles" -d "Displays a list of the profiles which are currently active for this build."
complete -c mvn -a "help:effective-settings" -d "Displays the calculated settings as XML for this project, given any profile enhancement and the inheritance of the global settings into the user-level settings."
complete -c mvn -a "help:system" -d "Displays a list of the platform details like system properties and environment variables."
complete -c mvn -a "help:effective-pom" -d "Displays the effective POM as an XML for this build, with the active profiles factored in."
complete -c mvn -a "help:help" -d "Display help information on maven-help-plugin. Call mvn help:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "help:all-profiles" -d "Displays a list of available profiles under the current project. Note: it will list all profiles for a project. If a profile comes up with a status inactive then there might be a need to set profile activation switches/property."
complete -c mvn -a "help:describe" -d "Displays a list of the attributes for a Maven Plugin and/or goals (aka Mojo - Maven plain Old Java Object)."
complete -c mvn -a "help:evaluate" -d "Evaluates Maven expressions given by the user in an interactive mode."
complete -c mvn -a "invoker:help" -d "Display help information on maven-invoker-plugin. Call mvn invoker:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "invoker:install" -d "Installs the project artifacts of the main build into the local repository as a preparation to run the sub projects. More precisely, all artifacts of the project itself, all its locally reachable parent POMs and all its dependencies from the reactor will be installed to the local repository."
complete -c mvn -a "invoker:integration-test" -d "Searches for integration test Maven projects, and executes each, collecting a log in the project directory, will never fail the build, designed to be used in conjunction with the verify mojo."
complete -c mvn -a "invoker:report" -d "Generate a report based on the results of the Maven invocations. Note: This mojo doesn't fork any lifecycle, if you have a clean working copy, you have to use a command like mvn clean integration-test site to ensure the build results are present when this goal is invoked."
complete -c mvn -a "invoker:run" -d "Searches for integration test Maven projects, and executes each, collecting a log in the project directory, and outputting the results to the command line."
complete -c mvn -a "invoker:verify" -d "Checks the results of maven-invoker-plugin based integration tests and fails the build if any tests failed."
complete -c mvn -a "jarsigner:help" -d "Display help information on maven-jarsigner-plugin. Call mvn jarsigner:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "jarsigner:sign" -d "Signs a project artifact and attachments using jarsigner."
complete -c mvn -a "jarsigner:verify" -d "Checks the signatures of a project artifact and attachments using jarsigner."
complete -c mvn -a "patch:apply" -d "Apply one or more patches to project sources."
complete -c mvn -a "patch:help" -d "Display help information on maven-patch-plugin. Call mvn patch:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "pdf:help" -d "Display help information on maven-pdf-plugin. Call mvn pdf:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "pdf:pdf" -d "Generates a PDF document for a project."
complete -c mvn -a "plugin:updateRegistry" -d "Update the user plugin registry (if it's in use) to reflect the version we're installing."
complete -c mvn -a "plugin:report" -d "Generates the Plugin's documentation report."
complete -c mvn -a "plugin:xdoc" -d "Generate Xdoc files for the project mojos or goals."
complete -c mvn -a "plugin:addPluginArtifactMetadata" -d "Inject any plugin-specific artifact metadata to the project's artifact, for subsequent installation and deployment. It is used: 1. to add the latest metadata (which is plugin-specific) for shipping alongside the plugin's artifact 2. to define plugin mapping in the group "
complete -c mvn -a "plugin:help" -d "Display help information on maven-plugin-plugin. Call mvn plugin:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "plugin:helpmojo" -d "Generates a HelpMojo class."
complete -c mvn -a "plugin:descriptor" -d "Generate a plugin descriptor. Note: Since 3.0, for Java 5 plugin annotations support, default phase defined by this goal is after the 'compilation' of any scripts. This doesn't override the default binding coded at generate-resources phase in Maven core."
complete -c mvn -a "release:perform" -d "Perform a release from SCM, either from a specified tag, or the tag representing the previous release in the working copy created by release:prepare. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/perform-release.html."
complete -c mvn -a "release:rollback" -d "Rollback changes made by a previous release. This requires that the previous release descriptor release.properties is still available in the local working copy. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/rollback-release.html."
complete -c mvn -a "release:prepare-with-pom" -d "Prepare for a release in SCM, fully resolving dependencies for the purpose of producing a 'release POM'."
complete -c mvn -a "release:stage" -d "Perform a release from SCM to a staging repository. If no goals are given, these default to deploy or deploy site:stage-deploy, if the project has a <distributionManagement>/<site> element. If the goals contain site-deploy or site:deploy, these are overridden with site:stage-deploy."
complete -c mvn -a "release:update-versions" -d "Update the POM versions for a project. This performs the normal version updates of the release:prepare goal without making other modifications to the SCM such as tagging. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/update-versions.html."
complete -c mvn -a "release:prepare" -d "Prepare for a release in SCM. Steps through several phases to ensure the POM is ready to be released and then prepares SCM to eventually contain a tagged version of the release and a record in the local copy of the parameters used. This can be followed by a call to release:perform. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/prepare-release.html."
complete -c mvn -a "release:clean" -d "Clean up after a release preparation. This is done automatically after a successful release:perform, so is best served for cleaning up a failed or abandoned release, or a dry run. Note that only the working copy is cleaned up, no previous steps are rolled back. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/clean-release.html."
complete -c mvn -a "release:help" -d "Display help information on maven-release-plugin. Call mvn release:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "release:branch" -d "Branch a project in SCM, using the same steps as the release:prepare goal, creating a branch instead of a tag. For more info see http://maven.apache.org/plugins/maven-release-plugin/examples/branch.html."
complete -c mvn -a "remote-resources:process" -d "Pull down resourceBundles containing remote resources and process the resources contained inside. When that is done the resources are injected into the current (in-memory) Maven project, making them available to the process-resources phase.  Resources that end in '.vm' are treated as velocity templates. For those, the '.vm' is stripped off for the final artifact name and it's fed through velocity to have properties expanded, conditions processed, etc... Resources that don't end in '.vm' are copied 'as is'."
complete -c mvn -a "remote-resources:help" -d "Display help information on maven-remote-resources-plugin. Call mvn remote-resources:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "remote-resources:bundle" -d "Bundle up resources that should be considered as a remote-resource."
complete -c mvn -a "repository:bundle-create" -d "Goal which creates an upload bundle for a project built with Maven."
complete -c mvn -a "repository:bundle-pack" -d "Packs artifacts already available in a local repository in a bundle for an upload requests. It requires that the artifact has a POM in the local repository. It will check for mandatory elements, asking interactively for missing values. Can be used to generate bundles for third parties artifacts that have been manually added to the local repository."
complete -c mvn -a "repository:help" -d "Display help information on maven-repository-plugin. Call mvn repository:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "scm:status" -d "Display the modification status of the files in the configured scm url."
complete -c mvn -a "scm:branch" -d "Branch the project."
complete -c mvn -a "scm:validate" -d "Validate scm connection string."
complete -c mvn -a "scm:checkin" -d "Commit changes to the configured scm url."
complete -c mvn -a "scm:diff" -d "Display the difference of the working copy with the latest copy in the configured scm url."
complete -c mvn -a "scm:update" -d "Update the local working copy with the latest source from the configured scm url."
complete -c mvn -a "scm:add" -d "Add a file set to the project."
complete -c mvn -a "scm:remove" -d "Mark a set of files for deletion."
complete -c mvn -a "scm:unedit" -d "Unedit/unlock a set of files."
complete -c mvn -a "scm:bootstrap" -d "Pull the project source from the configured scm and execute the configured goals."
complete -c mvn -a "scm:checkout" -d "Get a fresh copy of the latest source from the configured scm url."
complete -c mvn -a "scm:tag" -d "Tag the project."
complete -c mvn -a "scm:edit" -d "Edit/lock a set of files."
complete -c mvn -a "scm:check-local-modification" -d "This mojo will fail the build if there is any local modifications"
complete -c mvn -a "scm:list" -d "Get the list of project files."
complete -c mvn -a "scm:changelog" -d "Dump changelog contents to console. It is mainly used to test maven-scm-api's changelog command."
complete -c mvn -a "scm:help" -d "Display help information on maven-scm-plugin. Call mvn scm:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "scm:export" -d "Get a fresh exported copy of the latest source from the configured scm url."
complete -c mvn -a "scm:update-subprojects" -d "Updates all projects in a multi project build. This is useful for users who have adopted the flat project structure where the aggregator project is a sibling of the sub projects rather than sitting in the parent directory."
complete -c mvn -a "scm-publish:publish-scm" -d "Publish a content to scm. By default, content is taken from default site staging directory \${project.build.directory}/staging. Can be used without project, so usable to update any SCM with any content."
complete -c mvn -a "scm-publish:help" -d "Display help information on maven-scm-publish-plugin. Call mvn scm-publish:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "scm-publish:scmpublish" -d "Empty goal, provided only to set loose the lifecycle."
complete -c mvn -a "stage:copy" -d "Copies artifacts from one repository to another repository."
complete -c mvn -a "stage:help" -d "Display help information on maven-stage-plugin. Call mvn stage:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "toolchains:help" -d "Display help information on maven-toolchains-plugin. Call mvn toolchains:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "toolchains:toolchain" -d "Check that toolchains requirements are met by currently configured toolchains and store the selected toolchains in build context for later retrieval by other plugins."
complete -c mvn -a "eclipse:clean" -d "Deletes the .project, .classpath, .wtpmodules files and .settings folder used by Eclipse."
complete -c mvn -a "eclipse:configure-workspace" -d "Configures The following Eclipse Workspace features: - Adds the classpath variable MAVEN_REPO to Eclipse. - Optionally load Eclipse code style file via a URL. "
complete -c mvn -a "eclipse:eclipse" -d "Generates the following eclipse configuration files: - .project and .classpath files - .setting/org.eclipse.jdt.core.prefs with project specific compiler settings - various configuration files for WTP (Web Tools Project), if the parameter wtpversion is set to a valid version (WTP configuration is not generated by default) If this goal is run on a multiproject root, dependencies between modules will be configured as direct project dependencies in Eclipse (unless useProjectReferences is set to false)."
complete -c mvn -a "eclipse:help" -d "Display help information on maven-eclipse-plugin. Call mvn eclipse:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "eclipse:install-plugins" -d "Install plugins resolved from the Maven repository system into an Eclipse instance."
complete -c mvn -a "eclipse:myeclipse" -d "Generates MyEclipse configuration files"
complete -c mvn -a "eclipse:myeclipse-clean" -d "Deletes configuration files used by MyEclipse"
complete -c mvn -a "eclipse:rad" -d "Generates the rad-6 configuration files."
complete -c mvn -a "eclipse:rad-clean" -d "Deletes the config files used by Rad-6. the files .j2ee and the file .websettings"
complete -c mvn -a "eclipse:remove-cache" -d "Removes the not-available marker files from the repository."
complete -c mvn -a "eclipse:resolve-workspace-dependencies" -d "For all projects currently part of the workspace, all references to the M2_REPO classpath variable are resolved. Note: not the projects of the reactor are inspected for unresolved artifacts, but the projects that are part of the workspace. "
complete -c mvn -a "eclipse:to-maven" -d "Add eclipse artifacts from an eclipse installation to the local repo. This mojo automatically analize the eclipse directory, copy plugins jars to the local maven repo, and generates appropriate poms. This is the official central repository builder for Eclipse plugins, so it has the necessary default values. For customized repositories see MakeArtifactsMojo Typical usage: mvn eclipse:to-maven -DdeployTo=maven.org::default::scpexe://repo1.maven.org/home/maven/repository-staging/to-ibiblio/eclipse-staging -DeclipseDir=."
complete -c mvn -a "jboss-packaging:har-exploded" -d "Builds a deployable JBoss Hibernate exploded Archive."
complete -c mvn -a "jboss-packaging:esb" -d "Builds a deployable JBoss ESB Archive."
complete -c mvn -a "jboss-packaging:esb-exploded" -d "Builds a deployable JBoss ESB exploded Archive."
complete -c mvn -a "jboss-packaging:aop" -d "Builds a deployable JBoss AOP Archive."
complete -c mvn -a "jboss-packaging:spring" -d "Builds a deployable JBoss Spring Archive."
complete -c mvn -a "jboss-packaging:har" -d "Builds a deployable JBoss Hibernate Archive. Note that in versions of jboss prior to 4.0.3 the deployment descriptor for a HAR was 'hibernate-service.xml'. In 4.0.3 this changed to use 'jboss-service.xml' similar to the SAR format. In JBoss 5 and above, the HAR deployment descriptor can be any file with a name that matches the pattern '*-hibernate.xml'. If the parameter 'deploymentDescriptorFile' is not set, this goal will first look for 'jboss-service.xml', then 'hibernate-service.xml' and if those are not found, it will search for a file ending with * '-hibernate.xml'"
complete -c mvn -a "jboss-packaging:help" -d "Display help information on jboss-packaging-maven-plugin. Call   mvn jboss-packaging:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "jboss-packaging:par" -d "Builds a deployable JBoss Process Archive."
complete -c mvn -a "jboss-packaging:sar" -d "Builds a deployable JBoss Service Archive."
complete -c mvn -a "jboss-packaging:sar-inplace" -d "Builds a deployable JBoss Service in place exploded Archive."
complete -c mvn -a "jboss-packaging:sar-exploded" -d "Builds a deployable JBoss Service exploded Archive."
complete -c mvn -a "was6:wsAdmin" -d "The wsadmin goal executes the WebSphere command-line administration tool with the specified arguments."
complete -c mvn -a "was6:wsListApps" -d "Lists all the applications installed on a WebSphere Server or Cell. This goal is a wrapper for the AdminApp.list() command of the wsadmin tool. Refer to the wsadmin documentation for information on this operation."
complete -c mvn -a "was6:wsStartServer" -d "Starts a standalone server instance. This is not used to start a server controlled by DeploymentManager. Therefore, this goal is useful for the Base Application Server, and to start the Node Agent and/or DeploymentManager. If you wish to start a server managed by the Deployment Manager, use the wsadmin task to execute a scripting command."
complete -c mvn -a "was6:wsStartApp" -d "The wsStartApplication goal enables you to start an existing or newly installed application on a WebSphere Server or in a WebSphere Cell."
complete -c mvn -a "was6:clean" -d "Cleans out temporary resources and generated sources."
complete -c mvn -a "was6:wsStopServer" -d "This goal enables you to stop a standalone server instance. This is not used to stop a server controlled by DeploymentManager. Therefore, this task is useful for the Base Application Server, and to stop the Node Agent and/or DeploymentManager. If you wish to stop a server managed by the Deployment Manager, use the wsadmin task to execute a scripting command."
complete -c mvn -a "was6:wsStopApp" -d "The wsStopApp goal enables you to stop an existing or newly installed application on a WebSphere Server or in a WebSphere Cell. This goal is a wrapper for the ApplicationManager.stopApplication() command of the wsadmin tool. Refer to the wsadmin documentation for information on this operation."
complete -c mvn -a "was6:servicedeploy" -d "Executes the ServiceDeploy command against an archive file (Ear, Zip or Jar) to produce an ear file that can be deployed on Process Server. Reference Documentation can be found IBM WebSphere Enterprise Service Bus, Version 6.1, IBM WebSphere Process Server, Version 6.1. "
complete -c mvn -a "was6:installApp" -d "Installs an EAR into WebSphere Application Server."
complete -c mvn -a "was6:wsDefaultBindings" -d "This goal enables you to generate default IBM WebSphere Bindings for the specified EAR file. The goal provides options to control how the bindings are generated and mimics the options provided by the WebSphere Application Install wizards. The goal binds to the package phase by default."
complete -c mvn -a "was6:endpointEnabler" -d "Executes the endpoint enabler ant task on the EAR archive."
complete -c mvn -a "was6:wsdl2java" -d "Creates Java classes and deployment descriptor templates from a Web Services Description Language (WSDL) file. See Developerworks article for background. "
complete -c mvn -a "was6:help" -d "Display help information on was6-maven-plugin. Call   mvn was6:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "was6:ejbdeploy" -d "Generates EJB RMIC stub sources. This goal will fork a parallel life cycle up to package phase. This is required because an archive is required as input to the underlying tasks."
complete -c mvn -a "was6:wsUninstallApp" -d "Enables you to uninstall an existing application from a WebSphere Server or Cell. This goal builds upon the wsadmin task and shares many of the same attributes. This task is a wrapper for the AdminApp.uninstall() command of the wsadmin tool."
complete -c mvn -a "weblogic:stop" -d "Stop an artifact on Weblogic server(s) or cluster(s)."
complete -c mvn -a "weblogic:start" -d "Start an artifact on Weblogic server(s) or cluster(s)."
complete -c mvn -a "weblogic:undeploy" -d "Undeploy artifacts from Weblogic server(s) or cluster(s)."
complete -c mvn -a "weblogic:appc" -d "Run the weblogic appc compiler against an artifact."
complete -c mvn -a "weblogic:clientgen9" -d "Runs Client Gen on a given WSDL. This client gen uses the BEA refactored client gen tool first appearing in weblogic 9. This is the preferred client gen tool for Weblogic 9.0 and newer."
complete -c mvn -a "weblogic:listapps" -d "List the atifacts on Weblogic server(s) or cluster(s)."
complete -c mvn -a "weblogic:help" -d "Display help information on weblogic-maven-plugin. Call   mvn weblogic:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "weblogic:wsdlgen" -d "This class generates wsdl from ear/war package"
complete -c mvn -a "weblogic:redeploy" -d "Redeploy artifact on Weblogic server(s) or cluster(s)."
complete -c mvn -a "weblogic:jwsc" -d "Runs the JWSC compiler task for web service enabled code."
complete -c mvn -a "weblogic:servicegen" -d "Runs Service Gen on a given WSDL."
complete -c mvn -a "weblogic:deploy" -d "Deploy an artifact to Weblogic servers(s) or cluster(s)."
complete -c mvn -a "antlr:help" -d "Display help information on antlr-maven-plugin. Call   mvn antlr:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "antlr:html" -d "Generates Antlr documentation from grammar files."
complete -c mvn -a "antlr:generate" -d "Generates files based on grammar files with Antlr tool."
complete -c mvn -a "aspectj:aspectj-report" -d "Creates an AspectJ HTML report using the ajdoc tool and format."
complete -c mvn -a "aspectj:compile" -d "Weaves all main classes."
complete -c mvn -a "aspectj:EclipseAjcMojo" -d "Create eclipse configuration of aspectJ"
complete -c mvn -a "aspectj:help" -d "Display help information on aspectj-maven-plugin. Call mvn aspectj:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "aspectj:test-compile" -d "Weaves all test classes."
complete -c mvn -a "axistools:java2wsdl" -d "A Plugin for generating WSDL files using Axis Java2WSDL."
complete -c mvn -a "axistools:help" -d "Display help information on axistools-maven-plugin. Call   mvn axistools:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "axistools:wsdl2java" -d "A Plugin for generating stubs for WSDL files using Axis WSDL2Java."
complete -c mvn -a "axistools:admin" -d "Utility for turning xml into Axis deployment operations (wraps org.apache.axis.utils.Admin)"
complete -c mvn -a "castor:help" -d "Display help information on castor-maven-plugin. Call   mvn castor:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "castor:mappings" -d "A mojo that uses Castor MappingTool to generate mapping files from a set of Classes. MappingTool."
complete -c mvn -a "castor:mapping" -d "A mojo that uses Castor MappingTool to generate mapping files from a single Class. MappingTool."
complete -c mvn -a "castor:generate" -d "A mojo that uses Castor to generate a collection of javabeans from an XSD. Detailed explanations of many of these can be found in the details for the Castor SourceGenerator."
complete -c mvn -a "commons-attributes:compile" -d "Commons-attributes compiler."
complete -c mvn -a "commons-attributes:test-compile" -d "Commons-attributes compiler for tests."
complete -c mvn -a "gwt:debug" -d "Runs the project with a debugger port hook (optionally suspended)."
complete -c mvn -a "gwt:mergewebxml" -d "Merges GWT servlet elements into deployment descriptor (and non GWT servlets into shell). If you use scanRemoteServiceRelativePathAnnotation you must bind this mojo to at least compile phase Because the classpath scanner need to see compile classes "
complete -c mvn -a "gwt:help" -d "Display help information on gwt-maven-plugin. Call mvn gwt:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "gwt:compile" -d "Invokes the GWT Compiler for the project source. See compiler options : http://www.gwtproject.org/doc/latest/DevGuideCompilingAndDebugging.html#DevGuideCompilerOptions"
complete -c mvn -a "gwt:source-jar" -d "Add GWT java source code and module descriptor as resources to project jar. Alternative to gwt:resources for better Eclipse projects synchronization."
complete -c mvn -a "gwt:resources" -d "Copy GWT java source code and module descriptor as resources in the build outputDirectory. Alternative to declaring a <resource> in the POM with finer filtering as the module descriptor is read to detect sources to be copied."
complete -c mvn -a "gwt:compile-report" -d "see http://code.google.com/webtoolkit/doc/latest/DevGuideCompileReport.html#Usage"
complete -c mvn -a "gwt:css" -d "Creates CSS interfaces for css files. Will use the utility tool provided in gwt sdk which create a corresponding Java interface for accessing the classnames used in the file."
complete -c mvn -a "gwt:run-codeserver" -d "Runs GWT modules with Super Dev Mode."
complete -c mvn -a "gwt:eclipseTest" -d "Goal which creates Eclipse lauch configurations for GWTTestCases."
complete -c mvn -a "gwt:test" -d "Mimic surefire to run GWTTestCases during integration-test phase, until SUREFIRE-508 is fixed"
complete -c mvn -a "gwt:clean" -d "Cleanup the webapp directory for GWT module compilation output"
complete -c mvn -a "gwt:generateAsync" -d "Goal which generate Async interface."
complete -c mvn -a "gwt:i18n" -d "Creates I18N interfaces for constants and messages files."
complete -c mvn -a "gwt:run" -d "Runs the project in the GWT (Classic or Super) Dev Mode for development."
complete -c mvn -a "gwt:eclipse" -d "Goal which creates Eclipse lauch configurations for GWT modules."
complete -c mvn -a "hibernate3:hbm2doc" -d "'hbm2doc' generates html documentation a'la javadoc for the database schema."
complete -c mvn -a "hibernate3:hbm2hbmxml" -d "'hbm2hbmxml' generates a set of .hbm files. Intended to be used together with a 'jdbcconfiguration' when performing reverse engineering, but can be used with any kind of configuration. e.g. to convert from annotation based pojo's to hbm.xml."
complete -c mvn -a "hibernate3:hbm2dao" -d "'hbm2dao' generates a set of DAOs."
complete -c mvn -a "hibernate3:query" -d "'query' is used to execute a HQL query statements and optionally send the output to a file. Can be used for verifying the mappings and for basic data extraction."
complete -c mvn -a "hibernate3:instrument" -d "Goal for 'cglib' or 'javassist' instrumentation."
complete -c mvn -a "hibernate3:run" -d "'AntRun' wrapper."
complete -c mvn -a "hibernate3:hbmtemplate" -d "'hbmtemplate' generic exporter that can be controlled by a user provided template or class."
complete -c mvn -a "hibernate3:hbm2cfgxml" -d "'hbm2cfgxml' generates a hibernate.cfg.xml. Intended to be used together with a 'jdbcconfiguration' when performing reverse engineering, but can be used with any kind of configuration. The 'hbm2cfgxml' will contain the properties used and adds mapping entries for each mapped class."
complete -c mvn -a "hibernate3:hbm2ddl" -d "'hbm2ddl' lets you run schemaexport and schemaupdate which generates the appropriate SQL DDL and allow you to store the result in a file or export it directly to the database. Remember that if a custom naming strategy is needed it is placed on the configuration element."
complete -c mvn -a "hibernate3:help" -d "Display help information on hibernate3-maven-plugin. Call   mvn hibernate3:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "hibernate3:hbmlint" -d "'hbmlint' scans mappings for errors."
complete -c mvn -a "hibernate3:hbm2java" -d "'hbm2java' is a java code generator. Options for controlling wether JDK 5 syntax can be used and wether the POJO should be annotated with EJB3/Hibernate Annotations."
complete -c mvn -a "idlj:generate-test" -d "Process CORBA IDL test files in IDLJ."
complete -c mvn -a "idlj:help" -d "Display help information on idlj-maven-plugin. Call   mvn idlj:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "idlj:generate" -d "Process CORBA IDL files in IDLJ."
complete -c mvn -a "javacc:jjtree" -d "Parses a JJTree grammar file (*.jjt) and transforms it to Java source files and a JavaCC grammar file. Please see the JJTree Reference Documentation for more information."
complete -c mvn -a "javacc:jtb" -d "Parses a JTB file and transforms it into source files for an AST and a JavaCC grammar file which automatically builds the AST.  Note: JTB requires Java 1.5 or higher. This goal will not work with earlier versions of the JRE."
complete -c mvn -a "javacc:jjdoc" -d "JJDoc takes a JavaCC parser specification and produces documentation for the BNF grammar. This mojo will search the source directory for all *.jj files and run JJDoc once for each file it finds. Each of these output files, along with an index.html file will be placed in the site directory (target/site/jjdoc), and a link will be created in the 'Project Reports' menu of the generated site."
complete -c mvn -a "javacc:jtb-javacc" -d "Preprocesses ordinary grammar files (*.jtb) with JTB and passes the output to JavaCC in order to finally generate a parser with parse tree actions.  Note: JTB requires Java 1.5 or higher. This goal will not work with earlier versions of the JRE."
complete -c mvn -a "javacc:help" -d "Display help information on javacc-maven-plugin. Call  mvn javacc:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "javacc:jjtree-javacc" -d "Preprocesses decorated grammar files (*.jjt) with JJTree and passes the output to JavaCC in order to finally generate a parser with parse tree actions."
complete -c mvn -a "javacc:javacc" -d "Parses a JavaCC grammar file (*.jj) and transforms it to Java source files. Detailed information about the JavaCC options can be found on the JavaCC website."
complete -c mvn -a "jaxb2:help" -d "Display help information on jaxb2-maven-plugin. Call mvn jaxb2:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "jaxb2:schemagen" -d "Mojo that creates XML schema(s) from compile-scope Java sources or binaries by invoking the JAXB SchemaGenerator. This implementation is tailored to use the JAXB Reference Implementation from project Kenai.  Note that the SchemaGenerationMojo was completely re-implemented for the 2.x versions. Its configuration semantics and parameter set is not necessarily backwards compatible with the 1.x plugin versions. If you are upgrading from version 1.x of the plugin, read the documentation carefully. "
complete -c mvn -a "jaxb2:testSchemagen" -d "Mojo that creates XML schema(s) from test-scope Java testSources or binaries by invoking the JAXB SchemaGenerator. This implementation is tailored to use the JAXB Reference Implementation from project Kenai.  Note that the TestSchemaGenerationMojo was completely re-implemented for the 2.x versions. Its configuration semantics and parameter set is not backwards compatible with the 1.x plugin versions. If you are upgrading from version 1.x of the plugin, read the documentation carefully. "
complete -c mvn -a "jaxb2:testXjc" -d "Mojo that creates test-scope Java source or binaries from XML schema(s) by invoking the JAXB XJC binding compiler. This implementation is tailored to use the JAXB Reference Implementation from project Kenai.  Note that the TestXjcMojo was completely re-implemented for the 2.x versions. Its configuration semantics and parameter set is not necessarily backwards compatible with the 1.x plugin versions. If you are upgrading from version 1.x of the plugin, read the documentation carefully. "
complete -c mvn -a "jaxb2:xjc" -d "Mojo that creates compile-scope Java source or binaries from XML schema(s) by invoking the JAXB XJC binding compiler. This implementation is tailored to use the JAXB Reference Implementation from project Kenai.  Note that the XjcMojo was completely re-implemented for the 2.x versions. Its configuration semantics and parameter set is not necessarily backwards compatible with the 1.x plugin versions. If you are upgrading from version 1.x of the plugin, read the documentation carefully. "
complete -c mvn -a "jpox:enhance" -d ""
complete -c mvn -a "jpox:schema-create" -d "Generates the Schema from the JDO mappings and the enhanced class files."
complete -c mvn -a "jpox:schema-dbinfo" -d "Provides detailed information about the database - limits and datatypes support. Currently this seems to be printing out the information for each of available database datatypes twice. "
complete -c mvn -a "jpox:schema-delete" -d "Deletes all database tables required for a set of JDO MetaData files (and enhanced classes) from the database schema."
complete -c mvn -a "jpox:schema-info" -d "Provides a detailed information about the database schema. The output is written to console/terminal. "
complete -c mvn -a "jpox:schema-validate" -d "Validates all database tables required for a set of JDO MetaData files (and classes) for correct structure. The output is written to console/terminal. "
complete -c mvn -a "jslint:test-jslint" -d "Goal which reports on the test source files using JSLint."
complete -c mvn -a "jslint:jslint" -d "Goal which reports on the source files using JSLint."
complete -c mvn -a "jslint:help" -d "Display help information on jslint-maven-plugin. Call   mvn jslint:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "js-import:test-generate-html" -d "Test goal implementation of the generate html mojo."
complete -c mvn -a "js-import:generate-html" -d "Main goal implementation of the generate html mojo."
complete -c mvn -a "js-import:test-import-js" -d "Test goal implementation of the import mojo."
complete -c mvn -a "js-import:import-js" -d "Main goal implementation of the import mojo."
complete -c mvn -a "js-import:help" -d "Display help information on js-import-maven-plugin. Call   mvn js-import:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "jspc:compile" -d ""
complete -c mvn -a "jspc:testCompile" -d ""
complete -c mvn -a "openjpa:test-enhance" -d "Processes Application model classes and enhances them by running Open JPA Enhancer tool."
complete -c mvn -a "openjpa:help" -d "Display help information on openjpa-maven-plugin. Call   mvn openjpa:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "openjpa:enhance" -d "Processes Application model classes and enhances them by running Open JPA Enhancer tool. This basically only acts as a container for the xdoclet stuff since all the required functionality is already in the AbstratOpenJpaEnhancerMojo."
complete -c mvn -a "openjpa:schema" -d "Executes the schema generation via the OpenJPA MappingTool."
complete -c mvn -a "openjpa:sql" -d "Executes the SQL generation via the OpenJPA MappingTool."
complete -c mvn -a "rmic:help" -d "Display help information on rmic-maven-plugin. Call   mvn rmic:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "rmic:test-rmic" -d "Compiles rmi stubs and skeleton classes from a remote implementation class. By default runs against files in the test-classes directory."
complete -c mvn -a "rmic:rmic" -d "Compiles rmi stubs and skeleton classes from a remote implementation class."
complete -c mvn -a "rmic:package" -d "Creates a jar containing the rmic generated classes."
complete -c mvn -a "sablecc:generate" -d "A plugin for processing grammar files in SableCC."
complete -c mvn -a "sqlj:sqlj" -d "Translates SQLJ source code using the SQLJ Translator."
complete -c mvn -a "sqlj:clean" -d "Cleans out generated stale resources."
complete -c mvn -a "sqlj:help" -d "Display help information on sqlj-maven-plugin. Call mvn sqlj:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "xdoclet:help" -d "Display help information on xdoclet-maven-plugin. Call  mvn xdoclet:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "xdoclet:xdoclet" -d "Runs XDoclet."
complete -c mvn -a "xmlbeans:xmlbeans-test" -d "A Maven 2 plugin which parses xsd files and produces a corresponding object model based on the Apache XML Beans parser.  The plugin produces two sets of output files referred to as generated sources and generated classes. The former is then compiled to the build outputDirectory. The latter is generated in this directory.  Note that the descriptions for the goal's parameters have been blatently copied from http://xmlbeans.apache.org/docs/2.0.0/guide/antXmlbean.html for convenience. "
complete -c mvn -a "xmlbeans:help" -d "Display help information on xmlbeans-maven-plugin. Call  mvn xmlbeans:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "xmlbeans:xmlbeans" -d "A Maven 2 plugin which parses xsd files and produces a corresponding object model based on the Apache XML Beans parser.  The plugin produces two sets of output files referred to as generated sources and generated classes. The former is then compiled to the build outputDirectory. The latter is generated in this directory.  Note that the descriptions for the goal's parameters have been blatently copied from http://xmlbeans.apache.org/docs/2.0.0/guide/antXmlbean.html for convenience. "
complete -c mvn -a "nbm:autoupdate" -d "Create the NetBeans auto update site definition."
complete -c mvn -a "nbm:branding" -d "Package branding resources for NetBeans platform/IDE based application. The format of branding resources is the same as in NetBeans Ant-based projects. The src/main/nbm-branding folder of the project is assumed to contain the branding content. Within the directory, the following folder structure is assumed: - 1. pick the IDE/platform module which contents you want to brand. eg. org-openide-windows.jar - 2. locate the jar within the IDE/platform installation and it's cluster, eg. modules/org-openide-windows.jar - 3. create the same folder structure in src/main/nbm-branding, make folder with the module's jar name as well. eg. create folder by name modules/org-openide-windows.jar - 4. within that folder place your branding modifications at the same location, as if they were withn the jar, eg. org/openide/windows/ui/Bundle.properties and place the changed bundle keys there. "
complete -c mvn -a "nbm:build-installers" -d "Build installers for Mavenized NetBeans application. Creates installers for supported operating systems and packages each installer as a deployable artifact. See a how-to on customizing the installer. "
complete -c mvn -a "nbm:cluster" -d "Create the NetBeans module clusters from reactor. Semi-deprecated; used only for standalone modules and 'suites'."
complete -c mvn -a "nbm:cluster-app" -d "Create the NetBeans module clusters/application for the 'nbm-application' packaging projects"
complete -c mvn -a "nbm:help" -d "Display help information on nbm-maven-plugin. Call mvn nbm:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "nbm:manifest" -d "Goal for generating NetBeans module system specific manifest entries, part of nbm lifecycle/packaging. In order to have the generated manifest picked up by the maven-jar-plugin, one shall add the following configuration snippet to maven-jar-plugin. <plugin> <groupId>org.apache.maven.plugins</groupId> <artifactId>maven-jar-plugin</artifactId> <version>2.2</version> <configuration> <useDefaultManifestFile>true</useDefaultManifestFile> </configuration> </plugin> "
complete -c mvn -a "nbm:nbm" -d "Create the NetBeans module artifact (nbm file), part of 'nbm' lifecycle/packaging."
complete -c mvn -a "nbm:run-ide" -d "Run NetBeans IDE with additional custom module clusters, to be used in conjunction with nbm:cluster. Semi-deprecated; used only for standalone modules and 'suites'."
complete -c mvn -a "nbm:run-platform" -d "Run a branded application on top of NetBeans Platform. To be used with projects with nbm-application packaging only and the project needs to be built first."
complete -c mvn -a "nbm:standalone-zip" -d "Create a standalone application out of the composed clusters of nbm-application"
complete -c mvn -a "nbm:webstart-app" -d "Create webstartable binaries for a 'nbm-application'."
complete -c mvn -a "clirr:clirr" -d "Generate a report from the Clirr output."
complete -c mvn -a "clirr:check-arbitrary" -d "Check for compatibility between two arbitrary artifact sets."
complete -c mvn -a "clirr:help" -d "Display help information on clirr-maven-plugin. Call mvn clirr:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "clirr:check" -d "Check for compatibility with previous version."
complete -c mvn -a "clirr:check-no-fork" -d "Check for compatibility with previous version without forking the project"
complete -c mvn -a "cobertura:check" -d "Check the coverage percentages for unit tests from the last instrumentation, and optionally fail the build if the targets are not met. To fail the build you need to set configuration/check/haltOnFailure=true in the plugin's configuration."
complete -c mvn -a "cobertura:check-integration-test" -d "Check the coverage percentages for unit tests and integration tests from the last instrumentation, and optionally fail the build if the targets are not met. To fail the build you need to set configuration/check/haltOnFailure=true in the plugin's configuration."
complete -c mvn -a "cobertura:clean" -d "Clean up the files that Cobertura Maven Plugin has created during instrumentation."
complete -c mvn -a "cobertura:cobertura" -d "Instrument the compiled classes, run the unit tests and generate a Cobertura report."
complete -c mvn -a "cobertura:cobertura-integration-test" -d "Instrument the compiled classes, run the unit tests and integration tests and generate a Cobertura report."
complete -c mvn -a "cobertura:dump-datafile" -d "Output the contents of Cobertura's data file to the command line."
complete -c mvn -a "cobertura:help" -d "Display help information on cobertura-maven-plugin. Call mvn cobertura:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "cobertura:instrument" -d "Instrument the compiled classes."
complete -c mvn -a "scmchangelog:report" -d "Goal which produces a changelog report based on the Subversion logs."
complete -c mvn -a "scmchangelog:help" -d "Display help information on scmchangelog-maven-plugin. Call  mvn scmchangelog:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "sonar:help" -d "Display help information on sonar-maven-plugin. Call mvn sonar:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "sonar:sonar" -d "Analyze project. SonarQube server must be started."
complete -c mvn -a "taglist:taglist" -d "Scans the source files for tags and generates a report on their occurrences."
complete -c mvn -a "taglist:help" -d "Display help information on taglist-maven-plugin. Call  mvn taglist:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "javancss:check" -d "Check the build if for any Method with a ccn greater than a limit in the source code. Fails the build if told so."
complete -c mvn -a "javancss:help" -d "Display help information on javancss-maven-plugin. Call mvn javancss:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "javancss:report" -d "Generates a JavaNCSS report based on this module's source code."
complete -c mvn -a "jdepend:generate-no-fork" -d "Run JDepend and generate a site report. Goal which generate the JDepend metrics."
complete -c mvn -a "jdepend:help" -d "Display help information on jdepend-maven-plugin. Call mvn jdepend:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "jdepend:generate" -d "Run JDepend and generate a site report. Goal which generate the JDepend metrics."
complete -c mvn -a "codenarc:codenarc" -d "Create a CodeNarc Report."
complete -c mvn -a "codenarc:help" -d "Display help information on codenarc-maven-plugin. Call   mvn codenarc:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "findbugs:check" -d ""
complete -c mvn -a "findbugs:findbugs" -d ""
complete -c mvn -a "findbugs:gui" -d ""
complete -c mvn -a "findbugs:help" -d "Display help information on findbugs-maven-plugin. Call mvn findbugs:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "fitnesse:remotecall" -d "This goal uses the fitnesse.runner.TestRunner class for getting result of a remote FitNesse web page execution. It's possible to define several pages and/or servers."
complete -c mvn -a "fitnesse:help" -d "Display help information on fitnesse-maven-plugin. Call   mvn fitnesse:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "fitnesse:run" -d "This goal uses the fitnesse.runner.TestRunner class for calling a remote FitNesse web page and executes the tests or suites locally into a forked JVM. It's possible to define several pages and/or servers."
complete -c mvn -a "fitnesse:fitnesse" -d "Generates a FitNesse report from a FitNesse web server. The generated report is an external report generated FitNesse itself. If the project use Clover for code coverage and if FitNesse has clover dependency (ie use the ArtifactId-Version-clover.jar), the code executed during the FitNesse execution (phase integration-test) will be had to the unit-test code coverage. See the clover example."
complete -c mvn -a "selenium:start-server" -d "Start the Selenium server."
complete -c mvn -a "selenium:xvfb" -d "Starts an Xvfb instance suitable for handling X11 displays for headless systems. Use this in combonation with the start-server goal to allow browsers to be launched on headless unix systems. Optionally uses 'xauth' to setup authentication for the Xvfb instance to allow running tests using the frame buffer server when another X server is already running. "
complete -c mvn -a "selenium:stop-server" -d "Stop the Selenium server."
complete -c mvn -a "selenium:selenese" -d "Run a suite of HTML Selenese tests."
complete -c mvn -a "selenium:help" -d "Display help information on selenium-maven-plugin. Call   mvn selenium:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "webtest:help" -d "Display help information on webtest-maven-plugin. Call   mvn webtest:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "webtest:verify-filecontent" -d "Allows grepping through a set of files to find particular text strings and fail the build if one or matches are found. This is useful for checking HTML files ('an application error occured') or logfiles to decide if any exception are silently ignored by the web application."
complete -c mvn -a "webtest:clean" -d "Remove temporary data from running the Canoo WebTests. The following directories are deleted - resultpath - reportdirectory "
complete -c mvn -a "webtest:test" -d "Runs a Canoo WebTest defined in an ANT script."
complete -c mvn -a "webtest:loop" -d "Runs a Canoo WebTest in a loop until an error or failure occurs. This is handy when load testing and running the Canoo WebTests in parallel to ensure that the application still works."
complete -c mvn -a "webtest:info" -d "Prints the configuration settings."
complete -c mvn -a "webtest:report" -d "Creates the HTML report for a test run based on XSLT."
complete -c mvn -a "webtest:verify-result" -d "Checks the webtest result file for test failures and throws an exception if one or more tests failed. This is useful when 'haltonfailure' and 'haltonerror' are set to 'false' thereby indicating a successful build even in the case that nothing worked. Invoking 'webtest:verify' allows to fail the build later on behalf of the user."
complete -c mvn -a "chronos-jmeter:jmeter" -d "Invokes JMeter. JMeter is invoked by spawning a separate process to make it possible to control startup parameters. Can also be used by specifying a .jtl file as input and (possibly) a garbage collection logfile."
complete -c mvn -a "chronos-jmeter:check" -d "Checks the latest performancetests to verify that performance targets have been met. Extends abstract baseclass inside the reporting plugin to avoid duplication of code."
complete -c mvn -a "chronos-jmeter:jmetergui" -d "Invokes the JMeter gui. The purpose is to create a testplan with the artifacts of the current project in the classpath. This is necessary if the testplan should contain unittests or javaclases from the project."
complete -c mvn -a "chronos-jmeter:jmeteroutput" -d "Analyzes output from JMeter. Is used by specifying one or more .jtl files as input and (possibly) a garbage collection logfile."
complete -c mvn -a "chronos-jmeter:help" -d "Display help information on chronos-jmeter-maven-plugin. Call   mvn chronos-jmeter:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "chronos-jmeter:savehistory" -d "Save a snapshot of the currently executed test to enable later historic reports."
complete -c mvn -a "chronos-surefire:help" -d "Display help information on chronos-surefire-maven-plugin. Call   mvn chronos-surefire:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "chronos-surefire:collect" -d "Goal which collects the execution of each performed unittest, and compares the execution time to previous measured execution times for the same test. If the new execution time is larger then the old ones, the build will fail with a list of non-complient tests."
complete -c mvn -a "chronos-report:historyreport" -d "Creates a historic report of performance test results."
complete -c mvn -a "chronos-report:report" -d "Creates a report of the currently executed performancetest in html format."
complete -c mvn -a "chronos-report:help" -d "Display help information on chronos-report-maven-plugin. Call   mvn chronos-report:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "animal-sniffer:build" -d "Generates an API Signature from at least one of: the java runtime, the module dependencies and the module classes."
complete -c mvn -a "animal-sniffer:check" -d "Checks the classes compiled by this module."
complete -c mvn -a "animal-sniffer:help" -d "Display help information on animal-sniffer-maven-plugin. Call mvn animal-sniffer:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "appassembler:generate-daemons" -d "Generates JSW based daemon wrappers."
complete -c mvn -a "appassembler:assemble" -d "Assembles the artifacts and generates bin scripts for the configured applications"
complete -c mvn -a "appassembler:create-repository" -d "Creates an appassembler repository. Note that this is deliberately a bit more specific than the assembly plugin version - if that could generate a flat layout and exclude JARs, it may be a suitable replacement."
complete -c mvn -a "appassembler:help" -d "Display help information on appassembler-maven-plugin. Call mvn appassembler:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "build-helper:parse-version" -d "Parse a version string and set properties containing the component parts of the version. This mojo sets the following properties:   [propertyPrefix].majorVersion   [propertyPrefix].minorVersion   [propertyPrefix].incrementalVersion   [propertyPrefix].qualifier   [propertyPrefix].buildNumber Where the propertyPrefix is the string set in the mojo parameter. Note that the behaviour of the parsing is determined by org.apache.maven.artifact.versioning.DefaultArtifactVersion An osgi compatible version will also be created and made available through the property:   [propertyPrefix].osgiVersion This version is simply the original version string with the first instance of '-' replaced by '.' For example, 1.0.2-beta-1 will be converted to 1.0.2.beta-1"
complete -c mvn -a "build-helper:bsh-property" -d "Define one or many properties as a result of a Beanshell script invocation. Like gmaven-plugin, some variables are defined: - project: the actual Maven project, - session: the executing MavenSession, - settings: the executing Settings. "
complete -c mvn -a "build-helper:add-resource" -d "Add more resource directories to the POM."
complete -c mvn -a "build-helper:maven-version" -d "Store the maven core version in a property maven.version."
complete -c mvn -a "build-helper:attach-artifact" -d "Attach additional artifacts to be installed and deployed."
complete -c mvn -a "build-helper:add-test-source" -d "Add test source directories to the POM."
complete -c mvn -a "build-helper:released-version" -d "Resolve the latest released version of this project. This mojo sets the following properties:   [propertyPrefix].version   [propertyPrefix].majorVersion   [propertyPrefix].minorVersion   [propertyPrefix].incrementalVersion Where the propertyPrefix is the string set in the mojo parameter."
complete -c mvn -a "build-helper:local-ip" -d "Retrieve current host IP address and place it under a configurable project property"
complete -c mvn -a "build-helper:reserve-network-port" -d "Reserve a list of random and not in use network ports and place them in a configurable project properties."
complete -c mvn -a "build-helper:remove-project-artifact" -d "Remove project's artifacts from local repository. Useful to keep only one copy of large local snapshot, for example: installer, for disk space optimization purpose."
complete -c mvn -a "build-helper:add-source" -d "Add more source directories to the POM."
complete -c mvn -a "build-helper:add-test-resource" -d "Add more test resource directories to the POM."
complete -c mvn -a "build-helper:cpu-count" -d "Retrieve number of CPUs with project factor, and place it under a configurable project property"
complete -c mvn -a "build-helper:timestamp-property" -d "Sets a property based on the current date and time."
complete -c mvn -a "build-helper:regex-properties" -d "Sets a property by applying a regex replacement rule to a supplied value. This is similar to regex-property goal with support for multiple regex settings using RegexPropertyConfig"
complete -c mvn -a "build-helper:regex-property" -d "Sets a property by applying a regex replacement rule to a supplied value."
complete -c mvn -a "build-helper:help" -d "Display help information on build-helper-maven-plugin. Call mvn build-helper:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "buildnumber:create-timestamp" -d "This mojo is designed to give you a timestamp available through one or more properties. Only a single timestamp is created for each execution of the mojo. This timestamp can be format into one or more strings which are then saved to properties."
complete -c mvn -a "buildnumber:create" -d "This mojo is designed to give you a build number. So when you might make 100 builds of version 1.0-SNAPSHOT, you can differentiate between them all. The build number is based on the revision number retrieved from SCM. It is known to work with Subversion, GIT, and Mercurial.  This mojo can also check to make sure that you have checked everything into SCM, before issuing the build number. That behaviour can be suppressed, and then the latest local build number is used.  Build numbers are not automatically reflected in your artifact's filename, but can be added to the metadata. You can access the build number in your pom with \${buildNumber}. You can also access \${timestamp} and the SCM branch of the build (if applicable) in \${SCMBranch}  Note that there are several doFoo parameters. These parameters (doCheck, doUpdate, etc) are the first thing evaluated. If there is no matching expression, we get the default-value. If there is (ie -Dmaven.buildNumber.doUpdate=false), we get that value. So if the XML contains <doCheck>true</doCheck>, then normally that's the final value of the param in question. However, this mojo reverses that behaviour, such that the command line parameters get the last say. "
complete -c mvn -a "buildnumber:help" -d "Display help information on buildnumber-maven-plugin. Call mvn buildnumber:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "buildnumber:hgchangeset" -d "Goal which sets project properties for changeSet and changeSetDate from the current Mercurial repository."
complete -c mvn -a "cassandra:help" -d "Display help information on cassandra-maven-plugin. Call mvn cassandra:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "cassandra:load" -d "Loads a cassandra-cli bscript into a Cassandra instance."
complete -c mvn -a "cassandra:delete" -d "Deletes the Cassandra home directory that we create for running Cassandra."
complete -c mvn -a "cassandra:start-cluster" -d "Starts a Cassandra instance in the background."
complete -c mvn -a "cassandra:cu-load" -d "Loads a CassandraUnit DataSet into a Cassandra instance."
complete -c mvn -a "cassandra:stop-cluster" -d "Stops a background Cassandra instance."
complete -c mvn -a "cassandra:repair" -d "Runs nodetool repair on a Cassandra instance."
complete -c mvn -a "cassandra:cql-exec" -d "Executes cql statements from maven."
complete -c mvn -a "cassandra:stop" -d "Stops a background Cassandra instance."
complete -c mvn -a "cassandra:flush" -d "Runs nodetool flush on a Cassandra instance."
complete -c mvn -a "cassandra:run" -d "Runs Cassandra in the foreground."
complete -c mvn -a "cassandra:start" -d "Starts a Cassandra instance in the background."
complete -c mvn -a "cassandra:cleanup" -d "Runs nodetool cleanup on a Cassandra instance."
complete -c mvn -a "cassandra:compact" -d "Runs nodetool compact on a Cassandra instance."
complete -c mvn -a "ditaot:help" -d "Display help information on ditaot-maven-plugin. Call mvn ditaot:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "ditaot:version" -d "Display DITA Open Toolkit's built-in version, with option to insert a custom version found under \${dita.dir}/ditaotVersionPath, via version property to Maven's \${versionName}. It is mainly used with maven-enforcer-plugin for build validation purpose."
complete -c mvn -a "ditaot:eclipse" -d "Generate http://www.dita-op.org's Eclipse configuration to allow editing, previewing DITA under Eclipse IDE."
complete -c mvn -a "ditaot:print-help" -d "Display DITA Open Toolkit's common Ant properties usage. This can be used a reference for antProperties used by dita:run goal."
complete -c mvn -a "ditaot:chm2web" -d "Convert DITA Open Toolkit's Microsoft CHM output file, produced by htmlhelp transtype, to pure HTML set of files. Require commercial chm2web utility from A!K Research Labs"
complete -c mvn -a "ditaot:run" -d "Execute DITA Open Toolkit's Ant command line to transform DITA files to desired output format.  Behind the scene, antProperties are temporarily stored under \${dita.temp.dir}/properties.temp to be used with  ant -f \${dita.dir}/build.xml -propertyFile \${dita.temp.dir}/properties.temp "
complete -c mvn -a "exec:exec" -d "A Plugin for executing external programs."
complete -c mvn -a "exec:help" -d "Display help information on exec-maven-plugin. Call mvn exec:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "exec:java" -d "Executes the supplied java class in the current VM with the enclosing project's dependencies as classpath."
complete -c mvn -a "keytool:clean" -d "A Mojo that deletes a generated keystore file."
complete -c mvn -a "keytool:exportCertificate" -d "To export a certificate from a keystore. Implemented as a wrapper around the SDK keytool -export command. See keystore documentation."
complete -c mvn -a "keytool:changeKeyPassword" -d "To change the key password of an entry of a keystore. Implemented as a wrapper around the SDK keytool -keypasswd command. See keystore documentation."
complete -c mvn -a "keytool:generateSecretKey" -d "To generate a secret key into a keystore. Implemented as a wrapper around the SDK keytool -genseckey command. See keystore documentation."
complete -c mvn -a "keytool:importKeystore" -d "To import all entries of a keystore to another keystore. Implemented as a wrapper around the SDK keytool -importkeystore command. Note This operation was not implemented by the keytool before jdk 1.6. See keystore documentation."
complete -c mvn -a "keytool:changeStorePassword" -d "To change the store password of a keystore. Implemented as a wrapper around the SDK keytool -storepasswd command. See keystore documentation."
complete -c mvn -a "keytool:importCertificate" -d "To import a certificate into a keystore. Implemented as a wrapper around the SDK keytool -import (jdk 1.5) or keytool -importcert (jdk 1.6) command. See keystore documentation. Since version 1.2, this mojo replace the mojo import."
complete -c mvn -a "keytool:generateCertificateRequest" -d "To generate certificate request. Implemented as a wrapper around the SDK keytool -certreq command. See keystore documentation."
complete -c mvn -a "keytool:list" -d "To list entries in a keystore. Implemented as a wrapper around the SDK keytool -list (jdk 1.5) command. See keystore documentation."
complete -c mvn -a "keytool:printCertificateRequest" -d "To print the content of a certificate request. Implemented as a wrapper around the SDK keytool -printcertreq command. Note This operation was not implemented by the keytool before jdk 1.7. See keystore documentation."
complete -c mvn -a "keytool:printCertificate" -d "To print the content of a certificate. Implemented as a wrapper around the SDK keytool -printcert command. See keystore documentation."
complete -c mvn -a "keytool:deleteAlias" -d "To delete an entry alias from a keystore. Implemented as a wrapper around the SDK keytool -delete command. See keystore documentation."
complete -c mvn -a "keytool:help" -d "Display help information on keytool-maven-plugin. Call mvn keytool:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "keytool:generateKeyPair" -d "To generate a key pair into a keystore. Implemented as a wrapper around the SDK keytool -genkey (jdk 1.5) keytool -genkeypair (jdk 1.6) command. See keystore documentation."
complete -c mvn -a "keytool:changeAlias" -d "To change an entry alias into a keystore. Implemented as a wrapper around the SDK keytool -keyclone (jdk 1.5) or keytool -changealias (jdk 1.6) command. See keystore documentation."
complete -c mvn -a "keytool:printCRLFile" -d "To print the content of a CRL file. Implemented as a wrapper around the SDK keytool -printcrl command. Note This operation was not implemented by the keytool before jdk 1.7. See keystore documentation."
complete -c mvn -a "keytool:generateCertificate" -d "To generate certificate from a certificate request from a keystore. Implemented as a wrapper around the SDK keytool -gencert command. Note This operation was not implemented by the keytool before jdk 1.7. See keystore documentation."
complete -c mvn -a "latex:help" -d "Display help information on latex-maven-plugin. Call   mvn latex:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "latex:latex" -d "LaTeX documents building goal."
complete -c mvn -a "license:third-party-report" -d "Generates a report of all third-parties detected in the module."
complete -c mvn -a "license:check-file-header" -d "The goal to check if the state of header on project source files."
complete -c mvn -a "license:add-third-party" -d "Goal to generate the third-party license file. This file contains a list of the dependencies and their licenses. Each dependency and its license is displayed on a single line in the format    (<license-name>) <project-name> <groupId>:<artifactId>:<version> - <project-url> The directory containing the license database file is added to the classpath as an additional resource."
complete -c mvn -a "license:update-project-license" -d "Updates (or creates) the main project license file according to the given license defines as licenseName. Can also generate a bundled license file (to avoid collision names in class-path). This file is by default generated in META-INF class-path directory."
complete -c mvn -a "license:help" -d "Display help information on license-maven-plugin. Call mvn license:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "license:aggregate-add-third-party" -d "This goal forks executions of the add-third-party goal for all the leaf projects of the tree of modules below the point where it is executed. Note that this plugin sets a specific name, 'add-third-party', for the forked executions in the individual projects. From command level, then even though the execution of this goal is named 'default-cli', the forked executions have the name 'add-third-party'. Thus, to use the pluginManagement element of the POM to set options, you have to name the execution 'add-third-party', not 'default-cli'."
complete -c mvn -a "license:license-list" -d "Display all available licenses."
complete -c mvn -a "license:comment-style-list" -d "Displays all the available comment style to box file headers."
complete -c mvn -a "license:update-file-header" -d "The goal to update (or add) the header on project source files. This goal replace the update-header goal which can not deal with Copyright. This goal use a specific project file descriptor project.xml to describe all files to update for a whole project."
complete -c mvn -a "license:download-licenses" -d "Download the license files of all the current project's dependencies, and generate a summary file containing a list of all dependencies and their licenses."
complete -c mvn -a "ounce:report" -d "Generate the scan results as part of the site."
complete -c mvn -a "ounce:application" -d "This mojo generates an Ounce application file. It will automatically include all child modules as projects. This list make be modified using the includes and excludes patterns. Projects that are external to this build may be included directly using the externalProjects list. External Applications may also be included. All of their modules will be inherted as part of this application file. Those projects may also be filtered upon import."
complete -c mvn -a "ounce:scan" -d "This mojo allows an on demand scan of an application and the optional publishing of the results."
complete -c mvn -a "ounce:project-only" -d "This mojo generates an Ounce project file. It does not fork the build like the 'project' mojo and is instead intended to be bound in a pom for automatic execution. If you would rather have the project generated on demand via the command line, use the project goal instead."
complete -c mvn -a "ounce:project" -d "This mojo generates an Ounce project file. It forks the build and executes the process-sources phase so that any plugins that may generate sources and attach new source folders to the project will execute and those source folders will be automatically included in the generated project. This mojo is intended to be executed from the command line. If you would rather have the project built automatically during your build, use the project-only goal instead."
complete -c mvn -a "ounce:help" -d "Display help information on ounce-maven-plugin. Call   mvn ounce:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "rpm:attached-rpm" -d "Construct the RPM file and attaches it as a secondary artifact."
complete -c mvn -a "rpm:help" -d "Display help information on rpm-maven-plugin. Call mvn rpm:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "rpm:rpm" -d "Construct the RPM file."
complete -c mvn -a "rpm:version" -d "Makes the rpm version and release attributes available as properties."
complete -c mvn -a "siteskinner:skin" -d "Call mvn siteskinner:skin on a maven project. This will check out the latest releases project. Next it will add/replace the skin of the site.xml with the skin of the current project. Finally it will invoke a mvn site on the checked out project. Now you can verify the pages and run mvn site:deploy on the checked out project."
complete -c mvn -a "siteskinner:help" -d "Display help information on siteskinner-maven-plugin. Call mvn siteskinner:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "sql:help" -d "Display help information on sql-maven-plugin. Call   mvn sql:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "sql:execute" -d "Executes SQL against a database."
complete -c mvn -a "truezip:list" -d "List all files in the archive."
complete -c mvn -a "truezip:ls" -d "Display an archive's list to console. Note: inner archive file length always show 0 byte long. See TrueZip javadoc for details. Example:  - mvn truezip:ls -Dfrom=a.zip   "
complete -c mvn -a "truezip:cp" -d "Copy an archive/directory to another archive/directory. Mainly used from command line to unpack/pack any known archive type. Example:  - mvn truezip:cp -Dfrom=a.zip -Dto=b - mvn truezip:cp -Dfrom=b -Dto=b.zip   "
complete -c mvn -a "truezip:remove" -d "Remove a set of files from an existing archive."
complete -c mvn -a "truezip:copy" -d "Copy a set of files in and out of an existing archive."
complete -c mvn -a "truezip:move" -d "Move a single file or multiple files (via FileSet) between archives or directories."
complete -c mvn -a "truezip:help" -d "Display help information on truezip-maven-plugin. Call mvn truezip:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "truezip:update" -d "Update open archives immediately, flush cached data to disk."
complete -c mvn -a "versions:commit" -d "Removes the initial backup of the pom, thereby accepting the changes."
complete -c mvn -a "versions:compare-dependencies" -d "Compare dependency versions of the current project to dependencies or dependency management of a remote repository project. Can optionally update locally the project instead of reporting the comparison"
complete -c mvn -a "versions:dependency-updates-report" -d "Generates a report of available updates for the dependencies of a project."
complete -c mvn -a "versions:display-dependency-updates" -d "Displays all dependencies that have newer versions available."
complete -c mvn -a "versions:display-parent-updates" -d "Displays any updates of the project's parent project"
complete -c mvn -a "versions:display-plugin-updates" -d "Displays all plugins that have newer versions available."
complete -c mvn -a "versions:display-property-updates" -d "Displays properties that are linked to artifact versions and have updates available."
complete -c mvn -a "versions:force-releases" -d "Replaces any -SNAPSHOT versions with a release version, older if necessary (if there has been a release)."
complete -c mvn -a "versions:help" -d "Display help information on versions-maven-plugin. Call mvn versions:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "versions:lock-snapshots" -d "Attempts to resolve unlocked snapshot dependency versions to the locked timestamp versions used in the build. For example, an unlocked snapshot version like '1.0-SNAPSHOT' could be resolved to '1.0-20090128.202731-1'. If a timestamped snapshot is not available, then the version will remained unchanged. This would be the case if the dependency is only available in the local repository and not in a remote snapshot repository."
complete -c mvn -a "versions:plugin-updates-report" -d "Generates a report of available updates for the plugins of a project."
complete -c mvn -a "versions:property-updates-report" -d "Generates a report of available updates for properties of a project which are linked to the dependencies and/or plugins of a project."
complete -c mvn -a "versions:resolve-ranges" -d "Attempts to resolve dependency version ranges to the specific version being used in the build. For example a version range of '[1.0, 1.2)' would be resolved to the specific version currently in use '1.1'."
complete -c mvn -a "versions:revert" -d "Restores the pom from the initial backup."
complete -c mvn -a "versions:set" -d "Sets the current project's version and based on that change propagates that change onto any child modules as necessary."
complete -c mvn -a "versions:unlock-snapshots" -d "Attempts to resolve unlocked snapshot dependency versions to the locked timestamp versions used in the build. For example, an unlocked snapshot version like '1.0-SNAPSHOT' could be resolved to '1.0-20090128.202731-1'. If a timestamped snapshot is not available, then the version will remained unchanged. This would be the case if the dependency is only available in the local repository and not in a remote snapshot repository."
complete -c mvn -a "versions:update-child-modules" -d "Scans the current projects child modules, updating the versions of any which use the current project to the version of the current project."
complete -c mvn -a "versions:update-parent" -d "Sets the parent version to the latest parent version."
complete -c mvn -a "versions:update-properties" -d "Sets properties to the latest versions of specific artifacts."
complete -c mvn -a "versions:update-property" -d "Sets a property to the latest version in a given range of associated artifacts."
complete -c mvn -a "versions:use-latest-releases" -d "Replaces any release versions with the latest release version."
complete -c mvn -a "versions:use-latest-snapshots" -d "Replaces any release versions with the latest snapshot version (if it has been deployed)."
complete -c mvn -a "versions:use-latest-versions" -d "Replaces any version with the latest version."
complete -c mvn -a "versions:use-next-releases" -d "Replaces any release versions with the next release version (if it has been released)."
complete -c mvn -a "versions:use-next-snapshots" -d "Replaces any release versions with the next snapshot version (if it has been deployed)."
complete -c mvn -a "versions:use-next-versions" -d "Replaces any version with the latest version."
complete -c mvn -a "versions:use-reactor" -d "Replaces any versions with the corresponding version from the reactor."
complete -c mvn -a "versions:use-releases" -d "Replaces any -SNAPSHOT versions with the corresponding release version (if it has been released)."
complete -c mvn -a "vfs:copy" -d "Copy files from one VFS to another VFS"
complete -c mvn -a "vfs:help" -d "Display help information on vfs-maven-plugin. Call mvn vfs:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "vfs:list" -d "Display file list of a virtual file system."
complete -c mvn -a "vfs:merge-maven-repositories" -d "Merge Maven repository from one VFS to another VFS"
complete -c mvn -a "vfs:move" -d "Move files from a virtual file system to another"
complete -c mvn -a "vfs:remove" -d "Remove files from a virtual file system"
complete -c mvn -a "xml:validate" -d "The ValidatorMojo's task is the validation of XML files against a given schema."
complete -c mvn -a "xml:help" -d "Display help information on xml-maven-plugin. Call   mvn xml:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "xml:transform" -d "The TransformMojo is used for transforming a set of files using a common stylesheet."
complete -c mvn -a "nexus-staging:rc-release" -d "Releases a single closed Nexus staging repository into a permanent Nexus repository for general consumption."
complete -c mvn -a "nexus-staging:close" -d "Closes a Nexus staging repository."
complete -c mvn -a "nexus-staging:deploy" -d "Alternative deploy mojo, that will select proper DeployStrategy to perform deploys. Hence, this mojo might function in same was as maven-deploy-plugin's deploy mojo, but also might do deferred deploy or staging."
complete -c mvn -a "nexus-staging:promote" -d "Promotes a closed Nexus staging repository into a Nexus Build Promotion Profile."
complete -c mvn -a "nexus-staging:deploy-staged" -d "Deploys the (previously) locally staged artifacts from nexus-staging repository, that were staged using DeployMojo and having the DeployMojo.skipRemoteStaging flag set to true."
complete -c mvn -a "nexus-staging:rc-drop" -d "Drops a Nexus staging repository that is either open or closed."
complete -c mvn -a "nexus-staging:rc-promote" -d "Promotes a closed Nexus staging repository into a Nexus Build Promotion Profile."
complete -c mvn -a "nexus-staging:help" -d "Display help information on nexus-staging-maven-plugin. Call mvn nexus-staging:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "nexus-staging:drop" -d "Drops a Nexus staging repository that is either open or closed."
complete -c mvn -a "nexus-staging:deploy-staged-repository" -d "Deploys the (previously) staged artifacts from some local repository, that were staged using maven-deploy-plugin together with switch altDeploymentRepository for cases when POM modifications are not possible for some reason. In contrast to DeployMojo and DeployStagedMojo mojos, this mojo takes an 'image' of the previously deployed (to local FS) in some previous build, and uploads the whole directory (with all files and subdirectories) 'as-is' to a staging repository on Nexus. Naturally, this will would work only for a build of a released project (like a tag checkout). Since POM is not editable -- otherwise you would not be using this but the DeployMojo --, the intent with this Mojo is to be called directly, fully parameterized. At least, you have to set nexusUrl, serverId, stagingProfileId (also stagingRepositoryId if needed) and repositoryDirectory parameters on CLI."
complete -c mvn -a "nexus-staging:release" -d "Releases a single closed Nexus staging repository into a permanent Nexus repository for general consumption."
complete -c mvn -a "nexus-staging:rc-list" -d "Lists staging repositories accessible by current user available on Nexus."
complete -c mvn -a "nexus-staging:rc-list-profiles" -d "Lists staging profiles accessible by current user available on Nexus."
complete -c mvn -a "nexus-staging:rc-close" -d "Closes a Nexus staging repository."
complete -c mvn -a "appengine:vacuum_indexes" -d "Delete unused indexes from application."
complete -c mvn -a "appengine:devserver_start" -d "Starts the App Engine development server and does not wait."
complete -c mvn -a "appengine:backends_start" -d "Start the specified backend."
complete -c mvn -a "appengine:devserver_stop" -d "Stops the App Engine development server."
complete -c mvn -a "appengine:backends_rollback" -d "Roll back a previously in-progress update."
complete -c mvn -a "appengine:start_module_version" -d "Start the specified module version."
complete -c mvn -a "appengine:migrate_traffic" -d "Change the default version, but more gently than set_default_version."
complete -c mvn -a "appengine:update_dispatch" -d "Update application dispatch.xml."
complete -c mvn -a "appengine:endpoints_get_client_lib" -d "App Engine endpoints get-client-lib … command."
complete -c mvn -a "appengine:debug" -d "Debug the specified VM Runtime instance."
complete -c mvn -a "appengine:set_default_version" -d "Set the default serving version."
complete -c mvn -a "appengine:enhance" -d "Runs the datanucleus enhancer."
complete -c mvn -a "appengine:update" -d "Create or update an app version."
complete -c mvn -a "appengine:create-property" -d "Maven project version is dot based, e.g '1.9.15' , whereas appengine-web.xml is dash based, e.g. '1-9-15' This goal creates a Maven property with a correct app engine version."
complete -c mvn -a "appengine:backends_configure" -d "Configure the specified backend."
complete -c mvn -a "appengine:update_cron" -d "Update application cron jobs."
complete -c mvn -a "appengine:devserver" -d "Runs the App Engine development server."
complete -c mvn -a "appengine:backends_delete" -d "Delete the specified backend."
complete -c mvn -a "appengine:backends_update" -d "Update the specified backend or all backends."
complete -c mvn -a "appengine:update_indexes" -d "Update application indexes."
complete -c mvn -a "appengine:update_queues" -d "Update application task queue definitions."
complete -c mvn -a "appengine:stop_module_version" -d "Stop the specified module version."
complete -c mvn -a "appengine:rollback" -d "Rollback an in-progress update."
complete -c mvn -a "appengine:update_dos" -d "Update application DoS protection configuration."
complete -c mvn -a "appengine:endpoints_get_discovery_doc" -d "App Engine endpoints get-discovery-doc command."
complete -c mvn -a "appengine:backends_stop" -d "Stop the specified backend."
complete -c mvn -a "android:aar" -d "Creates an Android Archive (aar) file. "
complete -c mvn -a "android:apk" -d "Creates the apk file. By default signs it with debug keystore. Change that by setting configuration parameter <sign><debug>false</debug></sign>."
complete -c mvn -a "android:apklib" -d "Creates the apklib file. apklib files do not generate deployable artifacts."
complete -c mvn -a "android:clean" -d ""
complete -c mvn -a "android:connect" -d "Connect external IP addresses to the ADB server."
complete -c mvn -a "android:deploy" -d "Deploys the apk(s) of the current project(s) to all attached devices and emulators. Automatically skips other projects in a multi-module build that do not use packaging apk without terminating. Deploymnet is automatically performed when running mvn integration-test (or mvn install) on a project with instrumentation tests."
complete -c mvn -a "android:deploy-apk" -d "Deploys a specified Android application apk to attached devices and emulators. By default it will deploy to all, but a subset or single one can be configured with the device and devices parameters.This goal can be used in non-android projects and as standalone execution on the command line. "
complete -c mvn -a "android:deploy-dependencies" -d "Deploys all directly declared dependencies of <type>apk</type> in this project's pom. Usually used in a project with instrumentation tests, to deploy the apk to test onto the device before running the deploying and running the instrumentation tests apk. Automatically performed when running mvn integration-test (or mvn install) on a project with instrumentation tests."
complete -c mvn -a "android:devices" -d "DevicesMojo lists all attached devices and emulators found with the android debug bridge. It uses the same naming convention for the emulator as used in other places in the Android Maven Plugin and adds the status of the device in the list. TODO The goal is very simple and could be enhanced for better display, a verbose option to display and to take the android.device paramter into account."
complete -c mvn -a "android:dex" -d "Converts compiled Java classes to the Android dex format."
complete -c mvn -a "android:disconnect" -d "Disconnect external IP addresses from the ADB server."
complete -c mvn -a "android:emma" -d "After compiled Java classes use emma tool"
complete -c mvn -a "android:emulator-start" -d "EmulatorStartMojo can start the Android Emulator with a specified Android Virtual Device (avd)."
complete -c mvn -a "android:emulator-stop" -d "EmulatorStartMojo can stop the Android Emulator with a specified Android Virtual Device (avd)."
complete -c mvn -a "android:emulator-stop-all" -d "EmulatorStopeAllMojo will stop all attached devices."
complete -c mvn -a "android:generate-sources" -d "Generates R.java based on resources specified by the resources configuration parameter. Generates java files based on aidl files."
complete -c mvn -a "android:help" -d "Display help information on android-maven-plugin. Call mvn android:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "android:instrument" -d "Runs the instrumentation apk on device."
complete -c mvn -a "android:internal-integration-test" -d "Internal. Do not use. Called automatically when the lifecycle reaches phase integration-test. Figures out whether to call goals in this phase; and if so, calls android:instrument."
complete -c mvn -a "android:internal-pre-integration-test" -d "Internal. Do not use. Called automatically when the lifecycle reaches phase pre-integration-test. Figures out whether to call goals in this phase; and if so, calls android:deploy-dependencies and android:deploy."
complete -c mvn -a "android:lint" -d "LintMojo can run the lint command against the project. Implements parsing parameters from pom or command line arguments and sets useful defaults as well. Warning, if you use android.lint.enableClasspath and/or android.lint.enableLibraries the behavior of this goal will vary depending on the phase where this goal is executed. See android.lint.classpath/lintClassPath and android.lint.libraries/lintLibraries for more details."
complete -c mvn -a "android:manifest-merger" -d "Manifest Merger V2 AndroidManifest.xml file. http://tools.android.com/tech-docs/new-build-system/user-guide/manifest-merger"
complete -c mvn -a "android:manifest-update" -d "Updates various version attributes present in the AndroidManifest.xml file."
complete -c mvn -a "android:monkey" -d "Can execute tests using UI/Application Exerciser Monkey. Implements parsing parameters from pom or command line arguments and sets useful defaults as well. This goal will invoke Android Monkey exerciser. If the application crashes during the exercise, this goal can fail the build. A typical usage of this goal can be found at Quality tools for Android project."
complete -c mvn -a "android:monkeyrunner" -d "Can execute monkey runner programs. Implements parsing parameters from pom or command line arguments and sets useful defaults as well. This goal will invoke monkey runner scripts. If the application crashes during the exercise, this goal can fail the build. A typical usage of this goal can be found at Quality tools for Android project."
complete -c mvn -a "android:ndk-build" -d ""
complete -c mvn -a "android:proguard" -d "Processes both application and dependency classes using the ProGuard byte code obfuscator, minimzer, and optimizer. For more information, see https://proguard.sourceforge.net."
complete -c mvn -a "android:publish-apk" -d ""
complete -c mvn -a "android:publish-listing" -d ""
complete -c mvn -a "android:pull" -d "Copy file or directory from all the attached (or specified) devices/emulators."
complete -c mvn -a "android:push" -d "Copy file to all the attached (or specified) devices/emulators."
complete -c mvn -a "android:redeploy" -d "Undeploys and the deploys (= redeploys) the apk(s) of the current project(s) to all attached devices and emulators. Automatically skips other projects in a multi-module build that do not use packaging apk without terminating. "
complete -c mvn -a "android:redeploy-apk" -d "Reploys a specified Android application apk to attached devices and emulators. By default it will deploy to all, but a asubset or single one can be configured with the device and devices parameters. This simply tries to undeploy the APK first and then deploy it again. This goal can be used in non-android projects and as standalone execution on the command line. "
complete -c mvn -a "android:run" -d "Runs the first Activity shown in the top-level launcher as determined by its Intent filters. Android provides a component-based architecture, which means that there is no 'main' function which serves as an entry point to the APK. There's an homogeneous collection of Activity(es), Service(s), Receiver(s), etc.  The Android top-level launcher (whose purpose is to allow users to launch other applications) uses the Intent resolution mechanism to determine which Activity(es) to show to the end user. Such activities are identified by at least:  - Action type: android.intent.action.MAIN - Category: android.intent.category.LAUNCHER    And are declared in AndroidManifest.xml as such:  <activity android:name='.ExampleActivity'>     <intent-filter>         <action android:name='android.intent.action.MAIN' />         <category android:name='android.intent.category.LAUNCHER' />     </intent-filter> </activity>  This Mojo will try to to launch the first activity of this kind found in AndroidManifest.xml. In case multiple activities satisfy the requirements listed above only the first declared one is run. In case there are no 'Launcher activities' declared in the manifest or no activities declared at all, this goal aborts throwing an error.  The device parameter is taken into consideration so potentially the Activity found is started on all attached devices. The application will NOT be deployed and running will silently fail if the application is not deployed. "
complete -c mvn -a "android:uiautomator" -d "Can execute tests using ui uiautomator. Implements parsing parameters from pom or command line arguments and sets useful defaults as well. This goal is meant to execute a special java project dedicated to UI testing via UIAutomator. It will build the jar of the project, dex it and send it to dalvik cache of a rooted device or to an emulator. If you use a rooted device, refer to this thread on stack over flow.  The tests are executed via ui automator. A surefire compatible test report can be generated and its location will be logged during build.  To use this goal, you will need to place the uiautomator.jar file (part of the Android SDK >= 16) on a nexus repository.  A typical usage of this goal can be found at Quality tools for Android project."
complete -c mvn -a "android:undeploy" -d "Undeploys the apk(s) of the current project(s) to all attached devices and emulators. Automatically skips other projects in a multi-module build that do not use packaging apk without terminating. Deploymnet is automatically performed when running mvn integration-test (or mvn install) on a project with instrumentation tests."
complete -c mvn -a "android:undeploy-apk" -d "Undeploys a specified Android application apk from attached devices and emulators. By default it will undeploy from all, but a subset or single one can be configured with the device and devices parameters. You can supply the package of the application and/or an apk file. This goal can be used in non-android projects and as standalone execution on the command line. "
complete -c mvn -a "android:unpack" -d "Unpack libraries code and dependencies into target. This can be useful for using the proguard maven plugin to provide the input jars. Although it is encouraged to use the proguard mojo of the android maven plugin."
complete -c mvn -a "android:zipalign" -d "ZipalignMojo can run the zipalign command against the apk. Implements parsing parameters from pom or command line arguments and sets useful defaults as well."
complete -c mvn -a "liquibase:releaseLocks" -d "Removes any Liquibase updater locks from the current database."
complete -c mvn -a "liquibase:tag" -d "Writes a Liquibase tag to the database."
complete -c mvn -a "liquibase:dropAll" -d "Drops all database objects in the configured schema(s). Note that functions, procedures and packages are not dropped."
complete -c mvn -a "liquibase:updateSQL" -d "Generates the SQL that is required to update the database to the current version as specified in the DatabaseChangeLogs."
complete -c mvn -a "liquibase:listLocks" -d "Lists all Liquibase updater locks on the current database."
complete -c mvn -a "liquibase:migrate" -d "Liquibase Migration Maven plugin. This plugin allows for DatabaseChangeLogs to be applied to a database as part of a Maven build process."
complete -c mvn -a "liquibase:changelogSync" -d "Marks all unapplied changes to the database as applied in the change log."
complete -c mvn -a "liquibase:clearCheckSums" -d "Clears all checksums in the current changelog, so they will be recalculated next update."
complete -c mvn -a "liquibase:dbDoc" -d "Generates dbDocs against the database."
complete -c mvn -a "liquibase:rollbackSQL" -d "Generates the SQL that is required to rollback the database to the specified pointing attributes 'rollbackCount', 'rollbackTag'"
complete -c mvn -a "liquibase:status" -d "Prints which changesets need to be applied to the database."
complete -c mvn -a "liquibase:changelogSyncSQL" -d "Generates SQL that marks all unapplied changes as applied."
complete -c mvn -a "liquibase:updateTestingRollback" -d "Applies the DatabaseChangeLogs to the database, testing rollback. This is done by updating the database, rolling it back then updating it again."
complete -c mvn -a "liquibase:help" -d "Display help information on liquibase-maven-plugin. Call   mvn liquibase:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "liquibase:rollback" -d "Invokes Liquibase rollbacks on a database."
complete -c mvn -a "liquibase:futureRollbackSQL" -d "Generates the SQL that is required to rollback the database to current state after the next update."
complete -c mvn -a "liquibase:diff" -d "Generates a diff between the specified database and the reference database. The output is either a report or a changelog depending on the value of the diffChangeLogFile parameter."
complete -c mvn -a "liquibase:update" -d "Applies the DatabaseChangeLogs to the database. Useful as part of the build process."
complete -c mvn -a "liquibase:generateChangeLog" -d "Generates SQL that marks all unapplied changes as applied."
complete -c mvn -a "liquibase:migrateSQL" -d "Creates an SQL migration script using the provided DatabaseChangeLog(s) comparing what already exists in the database to what is defined in the DataBaseChangeLog(s)."
complete -c mvn -a "jgitflow:feature-deploy" -d ""
complete -c mvn -a "jgitflow:release-finish" -d ""
complete -c mvn -a "jgitflow:hotfix-start" -d ""
complete -c mvn -a "jgitflow:hotfix-finish" -d ""
complete -c mvn -a "jgitflow:feature-finish" -d ""
complete -c mvn -a "jgitflow:build-number" -d ""
complete -c mvn -a "jgitflow:release-start" -d ""
complete -c mvn -a "jgitflow:feature-start" -d ""
complete -c mvn -a "spring-boot:help" -d "Display help information on spring-boot-maven-plugin. Call mvn spring-boot:help -Ddetail=true -Dgoal=<goal-name> to display parameter details."
complete -c mvn -a "spring-boot:repackage" -d "Repackages existing JAR and WAR archives so that they can be executed from the command line using java -jar. With layout=NONE can also be used simply to package a JAR with nested dependencies (and no main class, so not executable)."
complete -c mvn -a "spring-boot:run" -d "Run an executable archive application."
