/********************************************************************************
*                                                                               *
*                      O p e n G L   S p h e r e   O b j e c t                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 1999,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* Contributed by: Angel-Ventura Mendo Gomez <ventura@labri.u-bordeaux.fr>       *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXGLSphere.cpp,v 1.8 2001/04/27 14:30:32 jeroen Exp $                    *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXVec.h"
#include "FXHVec.h"
#include "FXQuat.h"
#include "FXHMat.h"
#include "FXRange.h"
#include "FXString.h"
#include "FXSize.h"
#include "FXPoint.h"
#include "FXRectangle.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXSettings.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXObjectList.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXWindow.h"
#include "FXCursor.h"
#include "FXCanvas.h"
#include "FXGLCanvas.h"
#include "FXDC.h"
#include "FXDCPrint.h"
#include "FXGLViewer.h"
#include "FXGLObject.h"
#include "FXComposite.h"
#include "FXShell.h"
#include "FXTooltip.h"
#include "FXGLShape.h"
#include "FXGLSphere.h"


// GLU versions prior to 1.1 have GLUquadric
#if !defined(GLU_VERSION_1_1) && !defined(GLU_VERSION_1_2) && !defined(GLU_VERSION_1_3)
#define GLUquadricObj GLUquadric
#endif

// Sphere fidelity
#define FXGLSPHERE_SLICES_NUMBER                20
#define FXGLSPHERE_STACKS_NUMBER                20


// Object implementation
FXIMPLEMENT(FXGLSphere,FXGLShape,NULL,0)


// Create sphere
FXGLSphere::FXGLSphere(void):radius(0.5f){
  FXTRACE((100,"FXGLSphere::FXGLSphere\n"));
  range[0][0]=-radius; range[0][1]=radius;
  range[1][0]=-radius; range[1][1]=radius;
  range[2][0]=-radius; range[2][1]=radius;
  }


// Create initialized sphere
FXGLSphere::FXGLSphere(FXfloat x,FXfloat y,FXfloat z,FXfloat r):
  FXGLShape(x,y,z,SHADING_SMOOTH|STYLE_SURFACE),radius(r){
  FXTRACE((100,"FXGLSphere::FXGLSphere\n"));
  range[0][0]=-radius; range[0][1]=radius;
  range[1][0]=-radius; range[1][1]=radius;
  range[2][0]=-radius; range[2][1]=radius;
  }


// Create initialized sphere
FXGLSphere::FXGLSphere(FXfloat x,FXfloat y,FXfloat z,FXfloat r,const FXMaterial& mtl):
  FXGLShape(x,y,z,SHADING_SMOOTH|STYLE_SURFACE,mtl,mtl),radius(r){
  FXTRACE((100,"FXGLSphere::FXGLSphere\n"));
  range[0][0]=-radius; range[0][1]=radius;
  range[1][0]=-radius; range[1][1]=radius;
  range[2][0]=-radius; range[2][1]=radius;
  }


// Copy constructor
FXGLSphere::FXGLSphere(const FXGLSphere& orig):FXGLShape(orig){
  FXTRACE((100,"FXGLSphere::FXGLSphere\n"));
  radius=orig.radius;
  }


// Draw
void FXGLSphere::drawshape(FXGLViewer*){
#ifdef HAVE_OPENGL
  GLUquadricObj* quad=gluNewQuadric();
  gluQuadricDrawStyle(quad,(GLenum)GLU_FILL);
  /*
    if (shading==FXGLShape::ID_SHADESMOOTH){
    gluQuadricNormals(quad,(GLenum)GLU_SMOOTH);
    gluQuadricOrientation(quad,(GLenum)GLU_OUTSIDE);
    }
  */
  gluSphere(quad,radius,FXGLSPHERE_SLICES_NUMBER,FXGLSPHERE_STACKS_NUMBER);
  gluDeleteQuadric(quad);
#endif
  }


// Copy this object
FXGLObject* FXGLSphere::copy(){
  return new FXGLSphere(*this);
  }


// Save object to stream
void FXGLSphere::save(FXStream& store) const {
  FXGLShape::save(store);
  store << radius;
  }


// Load object from stream
void FXGLSphere::load(FXStream& store){
  FXGLShape::load(store);
  store >> radius;
  }


// Destroy
FXGLSphere::~FXGLSphere(){
  FXTRACE((100,"FXGLSphere::~FXGLSphere\n"));
  }
