=======================
Installation de Freeciv
=======================

Ce document dcrit comment compiler et installer Freeciv.


0. Pr-requis :
===============

Freeciv a un certain nombre de pr-requis. Cependant,  part le premier
pr-requis, le processus de configuration est suffisamment intelligent
pour savoir si votre systme convient. Dans le doute, essayez.

 - Unix (ou similaire)

   Le systme d'exploitation Unix, un quivalent comme Linux ou FreeBSD
   ou un systme qui propose un mode s'approchant d'Unix, comme EMX sous
   OS/2 ou la bote  outils Cygnus Cygwin sous Windows (voir
   http://sourceware.cygnus.com/cygwin/). Le support des sockets TCP/IP
   de style BSD est primordial, ainsi qu'un shell compatible Bourne
   comme GNU "bash" (la plupart des Unices remplissent le contrat...).

 - Un compilateur C ANSI

   Freeciv est crit en C (presque) ANSI et trs portable. Les
   architectures 32 et 64 bits sont supportes. Vous ne pouvez pas
   utiliser un compilateur C "K&R" ou un compilateur C++.

   Le dveloppement de Freeciv se fait avant tout avec "gcc",
   l'excellent compilateur C du projet GNU. Les distributions peuvent
   tre compiles avec gcc ou la plupart des autres compilateurs (comme
   le compilateur C de Solaris). Les versions de dveloppement et les
   snapshots CVS ne fonctionneront pas sans gcc,  moins que vous
   utilisiez l'option "--disable-cvs-deps" de configure. Consultez la
   section ci-dessous pour plus de renseignements.

 - Un programme "make"

   Les dveloppeurs de Freeciv utilisent en gnral "gmake", le
   programme make de GNU.

   Les versions stables de Freeciv sont conues pour avoir des makefiles
   qui fonctionnent avec la plupart des programmes make. Les versions de
   dveloppement et les snapshots CVS comportent des choses (comme les
   dpendances) qui utilisent les fonctionnalits avances de
   gmake. Gmake est donc ncessaire dans ce cas,  moins que vous
   n'utilisiez l'option "--disable-cvs-deps" de configure. Consultez la
   section ci-dessous pour plus de renseignements.

   Vous pouvez vrifier que vous avez GNU make sur votre systme en
   tapant :

    % make -v                   [si a ne marche pas, essayez "gmake -v"]

   "GNU Make" devrait alors s'afficher quelque part.


1. Pr-requis pour les clients :
================================

Le client Freeciv existe sous deux formes diffrentes : une qui utilise
la bibliothque Athena ("Xaw") et une autre qui utilise la bibliothque
Gtk+. Les deux ont des pr-requis diffrents, expliqus sparment
ci-dessous. Votre systme aura besoin de satisfaire au moins un des deux
ensembles de pr-requis.

Notez que certains systmes ont des paquetages spars pour les mmes
bibliothques : un pour la bibliothque elle-mme et un de
"dveloppement" (c'est  dire pour la compilation de programmes qui
utilisent ces bibliothques). Pour compiler Freeciv sur de tels
systmes, vous aurez besoin des paquetages appropris de "dveloppement"
(attention, utilisateurs de Red Hat : on parle de vous :-) ).


1a. Pr-requis pour le client Xaw :
===================================

 - X11

   Le client Xaw est un programme X11, ce qui fait que vous devrez avoir
   un moyen de lancer des programmes X11 (la plupart des Unices en sont
   capable).

   Si la configuration de Freeciv ne peut pas trouver X11 sur votre
   systme, vous aurez peut-tre besoin des options --x-includes=RP et
   --x-libraries=RP.

 - La bibliothque "Athena"

   Cette bibliothque (aussi connue sous le nom de "Xaw") est en gnral
   fournie en standard avec le reste de X11, mais certaines plateformes
   (HP-UX 10, par exemple) n'en proposent qu'une version limite.

   Pour compiler le client en utilisant la bibliothque "Xaw", utilisez
   l'option "--enable-client=xaw" du script configure. Consultez la
   section ci-dessous pour plus de renseignements  propos du script
   configure.

   La plupart des Unices modernes (comme Linux) proposent une variante
   appele "Xaw3d" qui a une apparence "3D" plus moderne. Si vous voulez
   compiler avec Xaw3d, utilisez l'option "--with-xaw-3d" de configure.

   Il y a aussi d'autres variantes de Xaw, comme Nextaw. Freeciv ne
   fonctionne pas avec celles-ci, bien qu'il soit sans doute possible de
   le modifier de la mme faon que pour Xaw3D. Un autre outil,
   "xaw_wrappers", peut tre utile, mais son utilisation dpasse le
   cadre de ce document.

 - La bibliothque "Xpm"

   Cette bibliothque est essentielle pour la gestion des icones et des
   bitmaps. Elle est largement utilise et fournie sur la plupart des
   machines Unix modernes, bien qu'elle puisse tre absente sur des
   Unices traditionnels ou plus vieux (par exemple Solaris).

   Lorsque vous lancez le script configure de Freeciv, il peut tre
   ncessaire que vous utilisiez l'option "--with-xpm-prefix=RP" (RP
   dsignant le nom du rpertoire contenant les sous-rpertoires
   "include" et "lib" o on peut trouver Xpm).

   Si le processus de configuration de Freeciv vous indique que vous
   n'avez pas la bibliothque Xpm, vous pouvez l'obtenir ici :

     ftp://koala.inria.fr/pub/xpm/xpm-3.4k.tar.gz
     ftp://ftp.x.org/contrib/libraries/xpm-3.4k.tar.gz

   Installez la comme vous feriez pour n'importe quel autre
   paquetage. Si vous ne pouvez pas l'installer dans un rpertoire
   systme standard, utilisez l'option --with-xpm-prefix comme dcrit
   plus haut.

   Si vous avez des problmes pour installer libXpm sous Solaris, ou que
   vous ne voulez pas l'installer en tant que root, consultez la section
   "Notes de Reiner pour l'installation de libXpm sous Solaris" vers la
   fin de ce document.


1b. Pr-requis pour le client Gtk+ :
====================================

 - La bibliothque "Glib"

   La bibliothque Glib fournit des fonctions non graphiques utilises
   par les bibliothques "Gdk" et "Gtk+", comme les tables de hachage,
   les listes simplement chanes, etc.

   Freeciv ncessite une version de "Glib" suprieure ou gale  1.2.1.

   Si le processus de configuration de Freeciv vous indique que vous
   n'avez pas la bibliothque Glib, vous pouvez l'obtenir ici :

     ftp://ftp.gtk.org/pub/gtk/v1.2/glib-1.2.6.tar.gz

 - La bibliothque "Gtk+"

   La bibliothque "Gtk+" a t crite pour le logiciel de graphisme
   GIMP. Depuis, elle a gagn en popularit comme bote  outils libre
   et facile  programmer. La bibliothque "Gtk+" est accompagne de la
   bibliothque "Gdk" qui fournit une couche d'abstraction au-dessus de
   X11 et implmente des fonctions pour le dessin de base, les fentres,
   etc.

   Freeciv ncessite une version de "Gtk+" suprieure ou gale  1.2.1.

   Si le processus de configuration de Freeciv vous indique que vous
   n'avez pas la bibliothque Gtk+, vous pouvez l'obtenir ici :

     ftp://ftp.gtk.org/pub/gtk/v1.2/gtk+-1.2.6.tar.gz

 - La bibliothque "Imlib"

   Cette bibliothque est essentielle pour la gestion des bitmaps. Elle
   est galement utilise par le projet GNOME.

   Freeciv ncessite une version de "Imlib" suprieure ou gale  1.9.2.

   Si le processus de configuration de Freeciv vous indique que vous
   n'avez pas la bibliothque Imlib, vous pouvez l'obtenir ici :

     ftp://ftp.gnome.org/pub/GNOME/stable/sources/imlib/imlib-1.9.7.tar.gz

   (la documentation d'Imlib indique que vous avez besoin d'autres
   bibliothques pour profiter de certaines fonctionnalits, mais aucune
   de celles-ci n'est ncessaire au client Freeciv)

Si vous devez faire tout ceci vous-mme, faites les compilations et les
installlations dans l'ordre suivant : Glib, Gtk+, Imlib.


2. Gnrer le Makefile :
========================

Avant de compiler Freeciv, vous devez gnrer un Makefile. Ce makefile
est conu pour correspondre aux fonctionnalits disponibles sur votre
machine.

La configuration est faite en utilisant le script "configure" de GNU.

Pour utiliser "configure", rendez vous dans le rpertoire racine de la
distribution de Freeciv et tapez :

 % ./configure

Ce script tentera ensuite de dterminer les fonctionnalits prsentes
(et absentes) sur votre systme. Il devrait imprimer une page ou deux de
diagnostics sur votre machine puis s'arrter.

Si vous dsirez de l'aide sur les diverses options acceptes par le
script configure, utilisez l'option --help comme ceci :

 % ./configure --help

Si vous compilez une version de dveloppement ou un snapshot CVS et que
vous n'avez ni GNU Make ni gcc, utilisez l'option "--disable-cvs-deps"
de configure. Vous en aurez particulirement besoin si vous utilisez les
programmes cc et make de Solaris.

Notez que, dans ce cas, la vrification des dpendances est
dsactive. Si vous modifiez un fichier .h de Freeciv par la suite pour
une raison quelconque, vous devrez faire un "make clean" avant de faire
"make" pour vous assurer que tout se compile correctement.

"--disable-cvs-deps" n'a pas d'effet avec une version stable.

Par dfaut, le script configure choisira le client Gtk+ s'il trouve les
bibliothques requises. Sinon, c'est le client Xaw qui sera
compil. Vous pouvez "forcer" le choix du client du client Xaw en
utilisant l'option "--enable-client=xaw".

Si vous voulez modifier les options du compilateur, positionnez la
variable d'environnement CFLAGS avec de lancer "configure". Par exemple :

 % CFLAGS="-O -g -pipe" ./configure   [avec le Bourne shell ou bash]

ou

 % setenv CFLAGS "-O -g -pipe"
 % ./configure                        [avec le C shell or tcsh]

Si vous voulez pouvoir utiliser un "core dump", nous vous suggrons
d'utiliser l'option "-g" dans CFLAGS.

Lorsque vous installerez Freeciv (plus tard), les composants du jeu
seront copis par dfaut dans les sous-rpertoires de /usr/local. Si
vous voulez utilisez un autre prfixe d'installation que /usr/local,
vous devez le prciser de la faon suivante :

 % ./configure --prefix=/opt/freeciv

Si, pour une raison quelconque, l'utilisation de "configure" vous pose
problme, suivez ces tapes :

  - Lisez la section des pr-requis attentivement pour dterminer si
    votre systme possde tout ce dont vous avez besoin.

  - Si vous voulez compiler la version Gtk+ du client : assurez-vous que
    vous avez les bibliothques Gtk+, Gdk, Glib et Imlib sur votre
    systme. Vrifiez ensuite que le script configure peut les trouver,
    soit en les installant aux endroits standards sur votre systme,
    soit en utilisant les options en ligne de commande adquates de
    configure (voir ./configure --help).

  - Si vous voulez compiler la version Xaw du client : assurez-vous que
    vous avez les bibliothques Xpm et Xaw sur votre systme. Vrifiez
    ensuite que le script configure peut les trouver, soit en les
    installant aux endroits standards sur votre systme, soit en
    utilisant les options en ligne de commande adquates de configure
    (voir ./configure --help).

  - Si le problme provient de "gettext", veuillez lire la section
    "Localisation" plus bas, afin de connatre les alternatives
    possibles.

  - Dites le nous, pour que nous puissions corriger le problme dans la
    prochaine version !

    Envoyez un e-mail  la liste de diffusion freeciv-dev, en expliquant
    ce que vous avez fait et quel rsultat vous avez obtenu. Il peut
    tre utile d'inclure ce que le script configure a affich, ainsi que
    le contenu des fichiers "config.status", "config.cache" et
    "config.log", qui sont gnrs par le script configure.

    Vous pouvez en savoir plus  propos de la liste de diffusion
    freeciv-dev sur notre site web,  l'adresse http://www.freeciv.org/

Notez que, depuis Freeciv 1.7.2, nous avons cess d'utiliser Imake et
que, depuis Freeciv 1.8.1, nous n'incluons plus le Makefile.noimake "de
secours".


3. Compiler Freeciv
===================

Si tout s'est bien droul jusqu' prsent, alors la compilation de
Freeciv devrait tre aussi facile que de taper "make" (ou, de
prfrence, "gmake").

Si vous avez des problmes, lisez le fichier BUGS et suivez les conseils
scrupuleusement. Si le problme vient de "gettext", veuillez lire la
section "Localisation" ci-dessous afin de connatre les alternatives.

Aprs la compilation, les choses suivantes sont importantes :

  - les binaires "client/civclient" et "server/civserver" ;
  - le rpertoire "data/", qui contient les graphismes et les scnarios ;
  - le rpertoire "po/", qui contient les fichiers de localisation ;
  - les scripts "civ" et "ser".

Il est parfaitement possible de jouer  Freeciv depuis ce rpertoire,
sans l'installer. Si vous faites ceci, les scripts "civ" et "ser" seront
utiles, bien qu'ils ne soient pas aussi ncessaires qu'ils aient pu
l'tre.

Consultez le fichier README.fr pour plus de renseignements.

[ Cependant, vous ne pouvez pas utilisez la localisation en jouant 
Freeciv depuis le rpertoire des sources ; vous devez installer Freeciv
pour cela. ]


4. Installation:
================

Pour installer Freeciv, il faut que les composants mentionns dans la
section "Compiler Freeciv" soient installs. Ils doivent tre copis
dans un rpertoire tel que /usr/local (par dfaut), /usr/games/,
/usr/games/freeciv, /usr/local/freeciv ou n'importe quel rpertoire de
votre choix.

Taper "make install" devrait tout installer correctement sur votre
machine. Vous pouvez utiliser l'option --prefix=RP de configure (voir
la section "Gnrer le Makefile") pour vous assurer que les fichiers
sont l o vous les voulez.

Lorsque le client et le server Freeciv sont lancs, ils ont besoin de
trouver certains fichiers dans le rpertoire "data". Par dfaut, Freeciv
cherche, dans l'ordre, dans les rpertoires suivants pour trouver les
fichiers de donnes : le rpertoire courant, le sous-rpertoire "data"
du rpertoire courant, le sous-rpertoire ".freeciv" du rpertoire
personnel de l'utilisateur et l'endroit o sont placs les fichiers en
lanant "make install". Vous pouvez forcer le chemin de recherche 
l'aide de la variable d'environnement FREECIV_PATH, qui doit tre
positionne sur un simple rpertoire ou une liste de rpertoires spars
par des ":".

Par exemple :

  % setenv FREECIV_PATH "/usr/games/freeciv/data:./data"
  (pour les utilisateurs de csh, tcsh, etc.)

  % FREECIV_PATH="/usr/games/freeciv/data:./data"; export FREECIV_PATH
  (pour les utilisateurs de sh, bash, ksh, zsh, etc.)

Notez que vous devez gnralement installer Freeciv si vous voulez
utiliser la localisation. Consultez le fichier README.fr pour plus de
renseignements.

Enfin, si vous avez choisi d'utiliser le client Xaw et que vous avez la
permission de vous connecter en tant qu'utilisateur 'root', vous pouvez
copier le fichier de ressource data/Freeciv dans le rpertoire
app-defaults (qui se trouve en gnral dans /usr/lib/X11).


5. Notes de Reiner sur l'installation sous Solaris
==================================================

Solaris (2.5 et suivants) a sa propre version de X dans /usr/openwin, sa
propre version de make dans /usr/ccs/bin/make et son propre compilateur
(qui doit tre achet sparment) qui, si vous l'avez, est dans
/opt/SUNWspro/bin. Solaris ne fournit pas la bibliothque XPM, qui est
requise pour le client Xaw ; il ne fournit rien de ce qui est requis
pour imlib, gdk et gtk (ncessaires pour le client GTK+). Cependant,
avec un peu de patience, tout peut tre compil sans problme.

Pour plus de renseignements sur l'installation de XPM sous Solaris,
consultez la section suivante.

Un certain nombre d'installations de Solaris ont dj MIT X (en gnral
dans /usr/X11), GNU make, le compilateur gcc et la bibliothque XPM
installe quelque part. La commande standard "./configure && make" peut
ne pas trouver la bibliothque XPM et a des chances de se tromper entre
les diffrentes versions.

Assurez-vous que vos variables d'environnement, en particulier $PATH et
$LD_LIBRARY_PATH et les options de ./configure ne pointent pas sur un
ensemble inconsistant de logiciels et la compilation se passera bien.

Une recette simple pour compiler avec Sun X, Sun make et Sun cc,
considrant que les bibliothques xpm sont elle-mmes  un endroit non
standard (/chemin/vers/xpm) :

  % setenv PATH /opt/SUNWspro/bin:/usr/ccs/bin:/bin
  % unsetenv LD_LIBRARY_PATH
  % ./configure --with-xpm-prefix=/chemin/vers/xpm
                --disable-cvs-deps --with-included-gettext
  % make

"--disable-cvs-deps" empche ./configure de gnrer des Makefiles
spcifiques  GNU make. Les symptmes sont :

  make: Fatal error in reader:
        Makefile, line 214: = missing from replacement macro reference
  make: Fatal error: Command failed for target `all-recursive'

Alternativement, vous pouvez rgler votre $PATH pour que ./configure
n'utilise que des outils GNU. Freeciv compile avec MIT X et avec
certaines combinaisons d'outils GNU et Sun. La recette exacte dpendent
de votre installation locale.


6. Notes de Reiner sur l'installation de libXpm sous Solaris :
==============================================================

Lorsque j'tais root sur mon systme Solaris, je ne voulais *quand mme*
pas installer des logiciels supplmentaires en tant que root. C'est mal.

Malheureusement, la procdure d'installation de libXpm part du principe
que l'installation se fait dans /usr/openwin, qui appartient 
root. Mais ce n'est pas trs dur  contourner.

Remarques :

 - Assurez-vous que /usr/ucb/install est dans votre $PATH avant
   /usr/bin/install, sinon 'make install' ne marchera, et renverra des
   messages d'erreur tranges ;
 - L'endroit dans lequel vous voulez installer peut tre spcifi avec
   $DESTDIR. Cependant, l'installation se fera dans
   $DESTDIR/$OPENWINDIR, donc le sous-rpertoire $OPENWINDIR
   supplmentaire devra tre pris en compte (modifier la valeur de
   $OPENWINHOME ne fonctionne pas).

La procdure :

 - Rcuprez les sources, de-tarez les, rendez vous dans le rpertoire
   des sources, et faites :
     % setenv MYXPMDEST /usr/local   # ou l'endroit o vous voulez installer
     % xmkmf; make Makefiles includes depend; make
     % setenv PATH /usr/local/bin:/usr/ucb:$PATH
     % make DESTDIR=$MYXPMDEST install
     % make DESTDIR=$MYXPMDEST install.man
     % cd $MYXPMDEST; mv ./$OPENWINHOME/* .; rm -rf ./$OPENWINHOME

   ( Si vous utilisez sh, bash, ksh, zsh, etc, remplacez les "setenv"
     ci-dessus par :
     % MYXPMDEST=/usr/local; export MYXPMDEST
     % PATH=/usr/local/bin:/usr/ucb:$PATH
   )

 - Vous pouvez maintenant configurer Freeciv ainsi :
     % ./configure --with-xpm-prefix=$MYXPMDEST

   qui ajoutera les options -I/-L/-R qui conviennent aux commandes de
   compilations et d'dition de liens.


7. Localisation :
=================

Freeciv utilise le systme "gettext" pour la localisation.

Si vous rencontrez des problmes avec gettext en configurant ou
compilant Freeciv, il y a un certain nombre de choses que vous pouvez
tenter :

1. Si vous n'avez pas besoin de la localisation, dsactivez la en
   utilisant l'option "--disable-nls" de ./configure :

      % ./configure --disable-nls
      % make

2. Si vous voulez la localisation, essayez la version de gettext incluse
   dans Freeciv en utilisant l'option "--with-included-gettext" de
   ./configure :

      % ./configure --with-included-gettext
      % make

3. Enfin, vous pouvez essayer d'installer la dernire version de GNU
      gettext. Elle peut tre obtenue ici :
      ftp://prep.ai.mit.edu/gnu/gettext/gettext-0.10.35.tar.gz

** FIN **
