//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: MeshWriter.cpp,v 1.7 2004/04/22 15:30:41 delpinux Exp $

#include <Mesh.hpp>

#include <MeshWriter.hpp>

#include <fstream>
#include <Structured3DMesh.hpp>
#include <MeshOfTetrahedra.hpp>
#include <MeshOfHexahedra.hpp>

#include <SurfaceMeshOfTriangles.hpp>
#include <SurfaceMeshOfQuadrangles.hpp>

template <typename MeshType>
void MeshWriter::__saveElements(const MeshType& m)
{
  typedef typename MeshType::ElementGeometry CellType;

  __os << m.numberOfCells() << __cr;

  for (size_t i = 0; i<m.numberOfCells(); ++i) {
    const CellType& c = m.cell(i);

    for (size_t j=0; j<CellType::NumberOfVertices; ++j) {
      __os << m.vertexNumber(c(j))+1 << ' ';
    }

    __os << c.reference() << __cr;
  }
}


void MeshWriter::__proceed()
{
  __os << "MeshVersionFormatted 1" << __cr;
  __os << "Dimension" << __cr;
  __os << 3 << __cr;

  __os << "Vertices " << (*__mesh).numberOfVertices() << __cr;

  for (size_t i=0; i<(*__mesh).numberOfVertices(); ++i) {
    const TinyVector<3>& X = (*__mesh).vertex(i);
    __os << X[0] << ' ' <<  X[1] << ' ' << X[2]
	 << ' ' << (*__mesh).vertex(i).reference() << __cr;
  }

  switch ((*__mesh).type()) {
  case Mesh::cartesianHexahedraMesh: {
    Structured3DMesh& M = static_cast<Structured3DMesh&>((*__mesh));
    __os << "Hexahedra ";
    this->__saveElements(M);
    if (M.hasSurfaceMesh()) {
      __os << "Quadrilaterals ";
      this->__saveElements(M.surfaceMesh());
    }
    break;
  }
  case Mesh::hexahedraMesh: {
    MeshOfHexahedra& M = static_cast<MeshOfHexahedra&>((*__mesh));
    __os << "Hexahedra ";
    this->__saveElements(M);
    if (M.hasSurfaceMesh()) {
      __os << "Quadrilaterals ";
      this->__saveElements(M.surfaceMesh());
    }
    break;
  }
  case Mesh::tetrahedraMesh: {
    MeshOfTetrahedra& M = static_cast<MeshOfTetrahedra&>((*__mesh));
    __os << "Tetrahedra ";
    this->__saveElements(M);
    if (M.hasSurfaceMesh()) {
      __os << "Triangles ";
      this->__saveElements<SurfaceMeshOfTriangles>(M.surfaceMesh());
    }
    break;
  }
  case Mesh::surfaceMeshTriangles: {
    SurfaceMeshOfTriangles& S
      = static_cast<SurfaceMeshOfTriangles&>((*__mesh));
    __os << "Triangles ";
    this->__saveElements(S);
    break;
  }
  case Mesh::surfaceMeshQuadrangles: {
    SurfaceMeshOfQuadrangles& S
      = static_cast<SurfaceMeshOfQuadrangles&>((*__mesh));
    __os << "Quadrilaterals ";
    this->__saveElements(S);
    break;
  }
  default: {
    fferr(0) << __FILE__ << ':' << __LINE__ << ": Not implemented\n";
    std::exit(1);
  }
  }

  __os << "End" << __cr;
}
