//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VariationalOperatorAlphaUV.hpp,v 1.3 2004/07/11 22:37:06 delpinux Exp $

#ifndef VARIATIONAL_OPERATOR_ALPHA_U_V_HPP
#define VARIATIONAL_OPERATOR_ALPHA_U_V_HPP

#include <VariationalBilinearOperator.hpp>
#include <UserFunction.hpp>

class VariationalAlphaUVOperator
  : public VariationalBilinearOperator
{
private:
  ReferenceCounting<UserFunction> __Alpha; /**< Mass term \f$\alpha\f$ */

public:

  /** 
   * Access to \f$\alpha\f$
   * 
   * @return *__Alpha
   */
  const UserFunction& alpha() const
  {
    return *__Alpha;
  }

  /** 
   * "Multiplies" the operator by a function
   * 
   * @param u the given function
   * 
   * @return the new operator
   */
  ReferenceCounting<VariationalBilinearOperator>
  operator * (ConstReferenceCounting<UserFunction> u) const
  {
    VariationalAlphaUVOperator* newOperator = new VariationalAlphaUVOperator(*this);
    (*newOperator).__Alpha = new MulUserFunction(__Alpha, u);
    return newOperator;
  }

  /** 
   * Constructor
   * 
   * @param unknownNumber 
   * @param testFunctionNumber 
   * @param alpha 
   * 
   * @return 
   */
  VariationalAlphaUVOperator(const size_t unknownNumber,
			     const size_t testFunctionNumber,
			     ReferenceCounting<UserFunction> alpha)
    : VariationalBilinearOperator(VariationalBilinearOperator::alphaUV,
				  unknownNumber, testFunctionNumber),
      __Alpha(alpha)
  {
    ;
  }

  /** 
   * Copy constructor
   * 
   * @param V 
   * 
   */
  VariationalAlphaUVOperator(const VariationalAlphaUVOperator& V)
    : VariationalBilinearOperator(V),
      __Alpha(V.__Alpha)
  {
    ;
  }

  /** 
   * 
   * Destructor
   * 
   */
  ~VariationalAlphaUVOperator()
  {
    ;
  }
};

#endif // VARIATIONAL_OPERATOR_ALPHA_U_V_HPP

