/* SQLGetTypeInfo() */

DROP TABLE tds_typeinfo
go

CREATE TABLE tds_typeinfo (
TYPE_NAME	VARCHAR(255) NOT NULL,
DATA_TYPE	SMALLINT NOT NULL,
COLUMN_SIZE	INTEGER NOT NULL,
LITERAL_PREFIX	VARCHAR(3) NULL,
LITERAL_SUFFIX	VARCHAR(3) NULL,
CREATE_PARAMS	VARCHAR(255) NULL,
NULLABLE	SMALLINT NOT NULL,
CASE_SENSITIVE	SMALLINT NOT NULL,
SEARCHABLE	SMALLINT NOT NULL,
UNSIGNED_ATTRIBUTE	SMALLINT NULL,
FIXED_PREC_SCALE	SMALLINT NOT NULL,
AUTO_UNIQUE_VALUE	SMALLINT NULL,
LOCAL_TYPE_NAME	VARCHAR(255) NULL,
MINIMUM_SCALE	SMALLINT NULL,
MAXIMUM_SCALE	SMALLINT NULL,
SQL_DATA_TYPE	SMALLINT NOT NULL,
SQL_DATETIME_SUB	SMALLINT NULL,
NUM_PREC_RADIX	INTEGER NULL,
INTERVAL_PRECISION	SMALLINT NULL
)
go

/* SQL_CHAR */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'CHAR',	/* TYPE_NAME */
1,	/* DATA_TYPE */
255,	/* COLUMN_SIZE */
"'",	/* LITERAL_PREFIX */
"'",	/* LITERAL_SUFFIX */
'length',	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
1,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_NUMERIC */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'NUMERIC',	/* TYPE_NAME */
2,	/* DATA_TYPE */
20,	/* COLUMN_SIZE */
NULL,	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
2,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_DECIMAL */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'DECIMAL',	/* TYPE_NAME */
3,	/* DATA_TYPE */
20,	/* COLUMN_SIZE */
NULL,	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
3,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_INTEGER */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'INTEGER',	/* TYPE_NAME */
4,	/* DATA_TYPE */
4,	/* COLUMN_SIZE */
NULL,	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
4,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_SMALLINT */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'SMALLINT',	/* TYPE_NAME */
5,	/* DATA_TYPE */
2,	/* COLUMN_SIZE */
NULL,	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
5,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_FLOAT */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'FLOAT',	/* TYPE_NAME */
6,	/* DATA_TYPE */
8,	/* COLUMN_SIZE */
NULL,	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
6,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_REAL */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'REAL',	/* TYPE_NAME */
7,	/* DATA_TYPE */
4,	/* COLUMN_SIZE */
NULL,	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
7,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_DOUBLE */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'FLOAT',	/* TYPE_NAME */
8,	/* DATA_TYPE */
8,	/* COLUMN_SIZE */
NULL,	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
8,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_TIMESTAMP */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'DATETIME',	/* TYPE_NAME */
11,	/* DATA_TYPE */
8,	/* COLUMN_SIZE */
"'",	/* LITERAL_PREFIX */
"'",	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
11,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_VARCHAR */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'VARCHAR',	/* TYPE_NAME */
12,	/* DATA_TYPE */
255,	/* COLUMN_SIZE */
"'",	/* LITERAL_PREFIX */
"'",	/* LITERAL_SUFFIX */
'length',	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
12,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_LONGVARCHAR */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'TEXT',	/* TYPE_NAME */
-1,	/* DATA_TYPE */
4000,	/* COLUMN_SIZE */
"'",	/* LITERAL_PREFIX */
"'",	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
0, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
-1,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_VARBINARY */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'BINARY',	/* TYPE_NAME */
-2,	/* DATA_TYPE */
255,	/* COLUMN_SIZE */
"0x",	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
-2,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_VARBINARY */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'VARBINARY',	/* TYPE_NAME */
-3,	/* DATA_TYPE */
255,	/* COLUMN_SIZE */
"0x",	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
-3,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_LONGVARBINARY */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'VARBINARY',	/* TYPE_NAME */
-4,	/* DATA_TYPE */
255,	/* COLUMN_SIZE */
"0x",	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
-4,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_BIGINT */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'BIGINT',	/* TYPE_NAME */
-5,	/* DATA_TYPE */
4,	/* COLUMN_SIZE */
NULL,	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
-5,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_TINYINT */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'TINYINT',	/* TYPE_NAME */
-6,	/* DATA_TYPE */
1,	/* COLUMN_SIZE */
NULL,	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
1,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
-6,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

/* SQL_BIT */
INSERT INTO tds_typeinfo (
TYPE_NAME, 
DATA_TYPE,
COLUMN_SIZE,
LITERAL_PREFIX,
LITERAL_SUFFIX,
CREATE_PARAMS,
NULLABLE,
CASE_SENSITIVE,
SEARCHABLE,
UNSIGNED_ATTRIBUTE,
FIXED_PREC_SCALE,
AUTO_UNIQUE_VALUE,
LOCAL_TYPE_NAME,
MINIMUM_SCALE,
MAXIMUM_SCALE,
SQL_DATA_TYPE,
SQL_DATETIME_SUB,
NUM_PREC_RADIX,
INTERVAL_PRECISION
) VALUES (
'BIT',	/* TYPE_NAME */
-7,	/* DATA_TYPE */
1,	/* COLUMN_SIZE */
NULL,	/* LITERAL_PREFIX */
NULL,	/* LITERAL_SUFFIX */
NULL,	/* CREATE_PARAMS */
0,	/* NULLABLE */
1,	/* CASE_SENSITIVE */
1, 	/* SEARCHABLE */
NULL,	/* UNSIGNED_ATTRIBUTE */
0,	/* FIXED_PREC_SCALE */
NULL,	/* AUTO_UNIQUE_VALUE */
NULL,	/* LOCAL_TYPE_NAME */
NULL,	/* MINIMUM_SCALE */
NULL,	/* MAXIMUM_SCALE */
-7,	/* SQL_DATA_TYPE */
NULL,	/* SQL_DATETIME_SUB */
NULL,	/* NUM_PREC_RADIX */
NULL	/* INTERVAL_PRECISION */
)
go

