/* phonebook.c generated by valac 0.14.2, the Vala compiler
 * generated from phonebook.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <fsobasics.h>
#include <freesmartphone.h>
#include <gio/gio.h>


#define FSO_GSM_TYPE_PHONEBOOK_STORAGE (fso_gsm_phonebook_storage_get_type ())
#define FSO_GSM_PHONEBOOK_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_GSM_TYPE_PHONEBOOK_STORAGE, FsoGsmPhonebookStorage))
#define FSO_GSM_PHONEBOOK_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_GSM_TYPE_PHONEBOOK_STORAGE, FsoGsmPhonebookStorageClass))
#define FSO_GSM_IS_PHONEBOOK_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_GSM_TYPE_PHONEBOOK_STORAGE))
#define FSO_GSM_IS_PHONEBOOK_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_GSM_TYPE_PHONEBOOK_STORAGE))
#define FSO_GSM_PHONEBOOK_STORAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_GSM_TYPE_PHONEBOOK_STORAGE, FsoGsmPhonebookStorageClass))

typedef struct _FsoGsmPhonebookStorage FsoGsmPhonebookStorage;
typedef struct _FsoGsmPhonebookStorageClass FsoGsmPhonebookStorageClass;
typedef struct _FsoGsmPhonebookStoragePrivate FsoGsmPhonebookStoragePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FSO_GSM_TYPE_PHONEBOOK_HANDLER (fso_gsm_phonebook_handler_get_type ())
#define FSO_GSM_PHONEBOOK_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_GSM_TYPE_PHONEBOOK_HANDLER, FsoGsmPhonebookHandler))
#define FSO_GSM_IS_PHONEBOOK_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_GSM_TYPE_PHONEBOOK_HANDLER))
#define FSO_GSM_PHONEBOOK_HANDLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FSO_GSM_TYPE_PHONEBOOK_HANDLER, FsoGsmPhonebookHandlerIface))

typedef struct _FsoGsmPhonebookHandler FsoGsmPhonebookHandler;
typedef struct _FsoGsmPhonebookHandlerIface FsoGsmPhonebookHandlerIface;

struct _FsoGsmPhonebookStorage {
	FsoFrameworkAbstractObject parent_instance;
	FsoGsmPhonebookStoragePrivate * priv;
};

struct _FsoGsmPhonebookStorageClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _FsoGsmPhonebookStoragePrivate {
	gchar* imsi;
	gchar* storagedir;
};

struct _FsoGsmPhonebookHandlerIface {
	GTypeInterface parent_iface;
	void (*syncWithSim) (FsoGsmPhonebookHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*syncWithSim_finish) (FsoGsmPhonebookHandler* self, GAsyncResult* _res_);
	FsoGsmPhonebookStorage* (*get_storage) (FsoGsmPhonebookHandler* self);
	void (*set_storage) (FsoGsmPhonebookHandler* self, FsoGsmPhonebookStorage* value);
};


static gpointer fso_gsm_phonebook_storage_parent_class = NULL;
static gchar* fso_gsm_phonebook_storage_storagedirprefix;
static gchar* fso_gsm_phonebook_storage_storagedirprefix = NULL;

#define FSO_GSM_PB_STORAGE_DEFAULT_STORAGE_DIR "/tmp/fsogsmd/pb"
#define FSO_GSM_PB_STORAGE_DIRECTORY_PERMISSIONS ((((((((gint) S_IRUSR) | S_IWUSR) | S_IXUSR) | S_IRGRP) | S_IXGRP) | S_IROTH) | S_IXOTH)
GType fso_gsm_phonebook_storage_get_type (void) G_GNUC_CONST;
#define FSO_GSM_PHONEBOOK_STORAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_GSM_TYPE_PHONEBOOK_STORAGE, FsoGsmPhonebookStoragePrivate))
enum  {
	FSO_GSM_PHONEBOOK_STORAGE_DUMMY_PROPERTY
};
void fso_gsm_phonebook_storage_setStorageDir (const gchar* dirname);
static gchar* fso_gsm_phonebook_storage_real_repr (FsoFrameworkAbstractObject* base);
FsoGsmPhonebookStorage* fso_gsm_phonebook_storage_new (const gchar* imsi);
FsoGsmPhonebookStorage* fso_gsm_phonebook_storage_construct (GType object_type, const gchar* imsi);
#define FSO_GSM_CONFIG_SECTION "fsogsm"
void fso_gsm_phonebook_storage_clean (FsoGsmPhonebookStorage* self);
void fso_gsm_phonebook_storage_writePhonebookEntry (FsoGsmPhonebookStorage* self, FreeSmartphoneGSMSIMEntry* entry, const gchar* filename);
void fso_gsm_phonebook_storage_addPhonebook (FsoGsmPhonebookStorage* self, const gchar* cat, gint mindex, gint maxdex, FreeSmartphoneGSMSIMEntry* phonebook, int phonebook_length1);
FreeSmartphoneGSMSIMEntry* fso_gsm_phonebook_storage_phonebook (FsoGsmPhonebookStorage* self, const gchar* cat, gint mindex, gint maxdex, int* result_length1);
static void _vala_FreeSmartphoneGSMSIMEntry_array_free (FreeSmartphoneGSMSIMEntry* array, gint array_length);
static void _vala_array_add26 (FreeSmartphoneGSMSIMEntry** array, int* length, int* size, const FreeSmartphoneGSMSIMEntry* value);
static void fso_gsm_phonebook_storage_finalize (GObject* obj);
GType fso_gsm_phonebook_handler_get_type (void) G_GNUC_CONST;
void fso_gsm_phonebook_handler_syncWithSim (FsoGsmPhonebookHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fso_gsm_phonebook_handler_syncWithSim_finish (FsoGsmPhonebookHandler* self, GAsyncResult* _res_);
FsoGsmPhonebookStorage* fso_gsm_phonebook_handler_get_storage (FsoGsmPhonebookHandler* self);
void fso_gsm_phonebook_handler_set_storage (FsoGsmPhonebookHandler* self, FsoGsmPhonebookStorage* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


void fso_gsm_phonebook_storage_setStorageDir (const gchar* dirname) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (dirname != NULL);
	_tmp0_ = dirname;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (fso_gsm_phonebook_storage_storagedirprefix);
	fso_gsm_phonebook_storage_storagedirprefix = _tmp1_;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* fso_gsm_phonebook_storage_real_repr (FsoFrameworkAbstractObject* base) {
	FsoGsmPhonebookStorage * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	self = (FsoGsmPhonebookStorage*) base;
	_tmp1_ = self->priv->imsi;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp2_ = self->priv->imsi;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("<", _tmp3_, ">", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("<>");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}


FsoGsmPhonebookStorage* fso_gsm_phonebook_storage_construct (GType object_type, const gchar* imsi) {
	FsoGsmPhonebookStorage * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	FsoFrameworkSmartKeyFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	FsoFrameworkLogger* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	g_return_val_if_fail (imsi != NULL, NULL);
	self = (FsoGsmPhonebookStorage*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = imsi;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->imsi);
	self->priv->imsi = _tmp1_;
	_tmp2_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp3_ = fso_framework_smart_key_file_stringValue (_tmp2_, FSO_GSM_CONFIG_SECTION, "pb_storage_dir", FSO_GSM_PB_STORAGE_DEFAULT_STORAGE_DIR);
	_g_free0 (fso_gsm_phonebook_storage_storagedirprefix);
	fso_gsm_phonebook_storage_storagedirprefix = _tmp3_;
	_tmp4_ = fso_gsm_phonebook_storage_storagedirprefix;
	_tmp5_ = imsi;
	_tmp6_ = g_build_filename (_tmp4_, _tmp5_, NULL);
	_g_free0 (self->priv->storagedir);
	self->priv->storagedir = _tmp6_;
	_tmp7_ = self->priv->storagedir;
	g_mkdir_with_parents (_tmp7_, FSO_GSM_PB_STORAGE_DIRECTORY_PERMISSIONS);
	_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp9_ = self->priv->storagedir;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = g_strconcat ("Created w/ storage dir ", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	fso_framework_logger_info (_tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
	return self;
}


FsoGsmPhonebookStorage* fso_gsm_phonebook_storage_new (const gchar* imsi) {
	return fso_gsm_phonebook_storage_construct (FSO_GSM_TYPE_PHONEBOOK_STORAGE, imsi);
}


void fso_gsm_phonebook_storage_clean (FsoGsmPhonebookStorage* self) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->storagedir;
	fso_framework_file_handling_removeTree (_tmp0_);
}


void fso_gsm_phonebook_storage_writePhonebookEntry (FsoGsmPhonebookStorage* self, FreeSmartphoneGSMSIMEntry* entry, const gchar* filename) {
	FreeSmartphoneGSMSIMEntry _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	FreeSmartphoneGSMSIMEntry _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* text;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = *entry;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = *entry;
	_tmp4_ = _tmp3_.number;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat (_tmp2_, ":", _tmp5_, NULL);
	text = _tmp6_;
	_tmp7_ = filename;
	fso_framework_file_handling_write (text, _tmp7_, TRUE);
	_g_free0 (text);
}


void fso_gsm_phonebook_storage_addPhonebook (FsoGsmPhonebookStorage* self, const gchar* cat, gint mindex, gint maxdex, FreeSmartphoneGSMSIMEntry* phonebook, int phonebook_length1) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* pbhash;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* pbdir;
	const gchar* _tmp13_;
	FreeSmartphoneGSMSIMEntry* _tmp14_;
	gint _tmp14__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cat != NULL);
	_tmp0_ = cat;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = mindex;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = maxdex;
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp1_, "_", _tmp4_, "_", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	pbhash = _tmp9_;
	_tmp10_ = self->priv->storagedir;
	_tmp11_ = pbhash;
	_tmp12_ = g_build_filename (_tmp10_, _tmp11_, NULL);
	pbdir = _tmp12_;
	_tmp13_ = pbdir;
	g_mkdir_with_parents (_tmp13_, FSO_GSM_PB_STORAGE_DIRECTORY_PERMISSIONS);
	_tmp14_ = phonebook;
	_tmp14__length1 = phonebook_length1;
	{
		FreeSmartphoneGSMSIMEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = _tmp14_;
		entry_collection_length1 = _tmp14__length1;
		for (entry_it = 0; entry_it < _tmp14__length1; entry_it = entry_it + 1) {
			FreeSmartphoneGSMSIMEntry _tmp15_ = {0};
			FreeSmartphoneGSMSIMEntry entry = {0};
			free_smartphone_gsm_sim_entry_copy (&entry_collection[entry_it], &_tmp15_);
			entry = _tmp15_;
			{
				const gchar* _tmp16_;
				FreeSmartphoneGSMSIMEntry _tmp17_;
				gint _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gchar* filename;
				FreeSmartphoneGSMSIMEntry _tmp23_;
				const gchar* _tmp24_;
				_tmp16_ = pbdir;
				_tmp17_ = entry;
				_tmp18_ = _tmp17_.index;
				_tmp19_ = g_strdup_printf ("%03u", (guint) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_build_filename (_tmp16_, _tmp20_, NULL);
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp20_);
				filename = _tmp22_;
				_tmp23_ = entry;
				_tmp24_ = filename;
				fso_gsm_phonebook_storage_writePhonebookEntry (self, &_tmp23_, _tmp24_);
				_g_free0 (filename);
				free_smartphone_gsm_sim_entry_destroy (&entry);
			}
		}
	}
	_g_free0 (pbdir);
	_g_free0 (pbhash);
}


static void _vala_FreeSmartphoneGSMSIMEntry_array_free (FreeSmartphoneGSMSIMEntry* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			free_smartphone_gsm_sim_entry_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _vala_array_add26 (FreeSmartphoneGSMSIMEntry** array, int* length, int* size, const FreeSmartphoneGSMSIMEntry* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FreeSmartphoneGSMSIMEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


FreeSmartphoneGSMSIMEntry* fso_gsm_phonebook_storage_phonebook (FsoGsmPhonebookStorage* self, const gchar* cat, gint mindex, gint maxdex, int* result_length1) {
	FreeSmartphoneGSMSIMEntry* result = NULL;
	FreeSmartphoneGSMSIMEntry* _tmp0_ = NULL;
	FreeSmartphoneGSMSIMEntry* pb;
	gint pb_length1;
	gint _pb_size_;
	GDir* dir = NULL;
	GDir* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* entry;
	gchar* pbdirname;
	const gchar* _tmp30_;
	FreeSmartphoneGSMSIMEntry* _tmp87_;
	gint _tmp87__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cat != NULL, NULL);
	_tmp0_ = g_new0 (FreeSmartphoneGSMSIMEntry, 0);
	pb = _tmp0_;
	pb_length1 = 0;
	_pb_size_ = pb_length1;
	{
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GDir* _tmp4_ = NULL;
		GDir* _tmp5_;
		GDir* _tmp6_;
		_tmp1_ = self->priv->storagedir;
		_tmp2_ = g_build_filename (_tmp1_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_dir_open (_tmp3_, (guint) 0, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch50_g_file_error;
			}
			_g_dir_close0 (dir);
			pb = (_vala_FreeSmartphoneGSMSIMEntry_array_free (pb, pb_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_dir_close0 (dir);
		dir = _tmp6_;
	}
	goto __finally50;
	__catch50_g_file_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		FreeSmartphoneGSMSIMEntry* _tmp13_;
		gint _tmp13__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("Can't open phonebook: ", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		fso_framework_logger_error (_tmp7_, _tmp12_);
		_g_free0 (_tmp12_);
		_tmp13_ = pb;
		_tmp13__length1 = pb_length1;
		if (result_length1) {
			*result_length1 = _tmp13__length1;
		}
		result = _tmp13_;
		_g_error_free0 (e);
		_g_dir_close0 (dir);
		return result;
	}
	__finally50:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (dir);
		pb = (_vala_FreeSmartphoneGSMSIMEntry_array_free (pb, pb_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp14_ = dir;
	_tmp15_ = g_dir_read_name (_tmp14_);
	_tmp16_ = g_strdup (_tmp15_);
	entry = _tmp16_;
	pbdirname = NULL;
	while (TRUE) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_;
		GDir* _tmp27_;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		_tmp17_ = entry;
		if (!(_tmp17_ != NULL)) {
			break;
		}
		_tmp18_ = entry;
		_tmp19_ = cat;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = g_strconcat (_tmp20_, "_", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_str_has_prefix (_tmp18_, _tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		if (_tmp24_) {
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = entry;
			_tmp26_ = g_strdup (_tmp25_);
			_g_free0 (pbdirname);
			pbdirname = _tmp26_;
			break;
		}
		_tmp27_ = dir;
		_tmp28_ = g_dir_read_name (_tmp27_);
		_tmp29_ = g_strdup (_tmp28_);
		_g_free0 (entry);
		entry = _tmp29_;
	}
	_tmp30_ = pbdirname;
	if (_tmp30_ != NULL) {
		GDir* pbdir = NULL;
		GDir* _tmp45_;
		const gchar* _tmp46_ = NULL;
		gchar* _tmp47_;
		gchar* entry2;
		{
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_;
			GDir* _tmp35_ = NULL;
			GDir* _tmp36_;
			GDir* _tmp37_;
			_tmp31_ = self->priv->storagedir;
			_tmp32_ = pbdirname;
			_tmp33_ = g_build_filename (_tmp31_, _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_dir_open (_tmp34_, (guint) 0, &_inner_error_);
			_tmp36_ = _tmp35_;
			_g_free0 (_tmp34_);
			_tmp37_ = _tmp36_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch51_g_file_error;
				}
				_g_dir_close0 (pbdir);
				_g_free0 (pbdirname);
				_g_free0 (entry);
				_g_dir_close0 (dir);
				pb = (_vala_FreeSmartphoneGSMSIMEntry_array_free (pb, pb_length1), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_dir_close0 (pbdir);
			pbdir = _tmp37_;
		}
		goto __finally51;
		__catch51_g_file_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp38_;
			GError* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			FreeSmartphoneGSMSIMEntry* _tmp44_;
			gint _tmp44__length1;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp38_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp39_ = e;
			_tmp40_ = _tmp39_->message;
			_tmp41_ = string_to_string (_tmp40_);
			_tmp42_ = g_strconcat ("Can't open phonebook: ", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			fso_framework_logger_error (_tmp38_, _tmp43_);
			_g_free0 (_tmp43_);
			_tmp44_ = pb;
			_tmp44__length1 = pb_length1;
			if (result_length1) {
				*result_length1 = _tmp44__length1;
			}
			result = _tmp44_;
			_g_error_free0 (e);
			_g_dir_close0 (pbdir);
			_g_free0 (pbdirname);
			_g_free0 (entry);
			_g_dir_close0 (dir);
			return result;
		}
		__finally51:
		if (_inner_error_ != NULL) {
			_g_dir_close0 (pbdir);
			_g_free0 (pbdirname);
			_g_free0 (entry);
			_g_dir_close0 (dir);
			pb = (_vala_FreeSmartphoneGSMSIMEntry_array_free (pb, pb_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp45_ = pbdir;
		_tmp46_ = g_dir_read_name (_tmp45_);
		_tmp47_ = g_strdup (_tmp46_);
		entry2 = _tmp47_;
		while (TRUE) {
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_;
			gchar* contents;
			const gchar* _tmp56_;
			gchar** _tmp57_;
			gchar** _tmp58_ = NULL;
			gchar** components;
			gint components_length1;
			gint _components_size_;
			gchar** _tmp59_;
			gint _tmp59__length1;
			GDir* _tmp84_;
			const gchar* _tmp85_ = NULL;
			gchar* _tmp86_;
			_tmp48_ = entry2;
			if (!(_tmp48_ != NULL)) {
				break;
			}
			_tmp49_ = self->priv->storagedir;
			_tmp50_ = pbdirname;
			_tmp51_ = entry2;
			_tmp52_ = g_build_filename (_tmp49_, _tmp50_, _tmp51_, NULL);
			_tmp53_ = _tmp52_;
			_tmp54_ = fso_framework_file_handling_read (_tmp53_);
			_tmp55_ = _tmp54_;
			_g_free0 (_tmp53_);
			contents = _tmp55_;
			_tmp56_ = contents;
			_tmp58_ = _tmp57_ = g_strsplit (_tmp56_, ":", 0);
			components = _tmp58_;
			components_length1 = _vala_array_length (_tmp57_);
			_components_size_ = components_length1;
			_tmp59_ = components;
			_tmp59__length1 = components_length1;
			if (_tmp59__length1 == 2) {
				const gchar* _tmp60_;
				gint _tmp61_ = 0;
				gint index;
				gboolean _tmp62_ = FALSE;
				gint _tmp63_;
				gint _tmp64_;
				gboolean _tmp67_;
				_tmp60_ = entry2;
				_tmp61_ = atoi (_tmp60_);
				index = _tmp61_;
				_tmp63_ = mindex;
				_tmp64_ = index;
				if (_tmp63_ <= _tmp64_) {
					gint _tmp65_;
					gint _tmp66_;
					_tmp65_ = index;
					_tmp66_ = maxdex;
					_tmp62_ = _tmp65_ <= _tmp66_;
				} else {
					_tmp62_ = FALSE;
				}
				_tmp67_ = _tmp62_;
				if (_tmp67_) {
					FreeSmartphoneGSMSIMEntry* _tmp68_;
					gint _tmp68__length1;
					gint _tmp69_;
					gchar** _tmp70_;
					gint _tmp70__length1;
					const gchar* _tmp71_;
					gchar** _tmp72_;
					gint _tmp72__length1;
					const gchar* _tmp73_;
					FreeSmartphoneGSMSIMEntry _tmp74_ = {0};
					_tmp68_ = pb;
					_tmp68__length1 = pb_length1;
					_tmp69_ = index;
					_tmp70_ = components;
					_tmp70__length1 = components_length1;
					_tmp71_ = _tmp70_[0];
					_tmp72_ = components;
					_tmp72__length1 = components_length1;
					_tmp73_ = _tmp72_[1];
					free_smartphone_gsm_sim_entry_init (&_tmp74_, _tmp69_, _tmp71_, _tmp73_);
					_vala_array_add26 (&pb, &pb_length1, &_pb_size_, &_tmp74_);
				}
			} else {
				FsoFrameworkLogger* _tmp75_;
				const gchar* _tmp76_;
				const gchar* _tmp77_ = NULL;
				const gchar* _tmp78_;
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_;
				const gchar* _tmp81_ = NULL;
				gchar* _tmp82_ = NULL;
				gchar* _tmp83_;
				_tmp75_ = ((FsoFrameworkAbstractObject*) self)->logger;
				_tmp76_ = self->priv->storagedir;
				_tmp77_ = string_to_string (_tmp76_);
				_tmp78_ = pbdirname;
				_tmp79_ = string_to_string (_tmp78_);
				_tmp80_ = entry2;
				_tmp81_ = string_to_string (_tmp80_);
				_tmp82_ = g_strconcat ("Invalid format in Phonebook entry at ", _tmp77_, "/", _tmp79_, "/", _tmp81_, NULL);
				_tmp83_ = _tmp82_;
				fso_framework_logger_warning (_tmp75_, _tmp83_);
				_g_free0 (_tmp83_);
			}
			_tmp84_ = pbdir;
			_tmp85_ = g_dir_read_name (_tmp84_);
			_tmp86_ = g_strdup (_tmp85_);
			_g_free0 (entry2);
			entry2 = _tmp86_;
			components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (contents);
		}
		_g_free0 (entry2);
		_g_dir_close0 (pbdir);
	}
	_tmp87_ = pb;
	_tmp87__length1 = pb_length1;
	if (result_length1) {
		*result_length1 = _tmp87__length1;
	}
	result = _tmp87_;
	_g_free0 (pbdirname);
	_g_free0 (entry);
	_g_dir_close0 (dir);
	return result;
}


static void fso_gsm_phonebook_storage_class_init (FsoGsmPhonebookStorageClass * klass) {
	gchar* _tmp0_;
	fso_gsm_phonebook_storage_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoGsmPhonebookStoragePrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = fso_gsm_phonebook_storage_real_repr;
	G_OBJECT_CLASS (klass)->finalize = fso_gsm_phonebook_storage_finalize;
	_tmp0_ = g_strdup (FSO_GSM_PB_STORAGE_DEFAULT_STORAGE_DIR);
	_g_free0 (fso_gsm_phonebook_storage_storagedirprefix);
	fso_gsm_phonebook_storage_storagedirprefix = _tmp0_;
}


static void fso_gsm_phonebook_storage_instance_init (FsoGsmPhonebookStorage * self) {
	self->priv = FSO_GSM_PHONEBOOK_STORAGE_GET_PRIVATE (self);
}


static void fso_gsm_phonebook_storage_finalize (GObject* obj) {
	FsoGsmPhonebookStorage * self;
	self = FSO_GSM_PHONEBOOK_STORAGE (obj);
	_g_free0 (self->priv->imsi);
	_g_free0 (self->priv->storagedir);
	G_OBJECT_CLASS (fso_gsm_phonebook_storage_parent_class)->finalize (obj);
}


/**
 * @class PhonebookStorage
 *
 * A high level persistent PB Storage abstraction.
 */
GType fso_gsm_phonebook_storage_get_type (void) {
	static volatile gsize fso_gsm_phonebook_storage_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_phonebook_storage_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoGsmPhonebookStorageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_gsm_phonebook_storage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoGsmPhonebookStorage), 0, (GInstanceInitFunc) fso_gsm_phonebook_storage_instance_init, NULL };
		GType fso_gsm_phonebook_storage_type_id;
		fso_gsm_phonebook_storage_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "FsoGsmPhonebookStorage", &g_define_type_info, 0);
		g_once_init_leave (&fso_gsm_phonebook_storage_type_id__volatile, fso_gsm_phonebook_storage_type_id);
	}
	return fso_gsm_phonebook_storage_type_id__volatile;
}


void fso_gsm_phonebook_handler_syncWithSim (FsoGsmPhonebookHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FSO_GSM_PHONEBOOK_HANDLER_GET_INTERFACE (self)->syncWithSim (self, _callback_, _user_data_);
}


void fso_gsm_phonebook_handler_syncWithSim_finish (FsoGsmPhonebookHandler* self, GAsyncResult* _res_) {
	FSO_GSM_PHONEBOOK_HANDLER_GET_INTERFACE (self)->syncWithSim_finish (self, _res_);
}


FsoGsmPhonebookStorage* fso_gsm_phonebook_handler_get_storage (FsoGsmPhonebookHandler* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_GSM_PHONEBOOK_HANDLER_GET_INTERFACE (self)->get_storage (self);
}


void fso_gsm_phonebook_handler_set_storage (FsoGsmPhonebookHandler* self, FsoGsmPhonebookStorage* value) {
	g_return_if_fail (self != NULL);
	FSO_GSM_PHONEBOOK_HANDLER_GET_INTERFACE (self)->set_storage (self, value);
}


static void fso_gsm_phonebook_handler_base_init (FsoGsmPhonebookHandlerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_object ("storage", "storage", "storage", FSO_GSM_TYPE_PHONEBOOK_STORAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * @interface PhonebookHandler
 */
GType fso_gsm_phonebook_handler_get_type (void) {
	static volatile gsize fso_gsm_phonebook_handler_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_phonebook_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoGsmPhonebookHandlerIface), (GBaseInitFunc) fso_gsm_phonebook_handler_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType fso_gsm_phonebook_handler_type_id;
		fso_gsm_phonebook_handler_type_id = g_type_register_static (G_TYPE_INTERFACE, "FsoGsmPhonebookHandler", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (fso_gsm_phonebook_handler_type_id, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT);
		g_once_init_leave (&fso_gsm_phonebook_handler_type_id__volatile, fso_gsm_phonebook_handler_type_id);
	}
	return fso_gsm_phonebook_handler_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



