/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ExecBgr.cc,v 1.17 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <fcntl.h>

#include <gtk--.h>

#include "ExecBgr.hh"

#include "fwbuilder/Tools.hh"

using namespace libfwbuilder;


G_LOCK_DEFINE_STATIC (pgm_status);

ExecBgr::ExecBgr() : BackgroundOp()
{
    pgm_pid    = 0;
    pgm_status = 0            ;
    error      = NULL         ;
}

/*
 * Executed from background thread.
 * it is safe to use logger here.
 */
void ExecBgr::run_impl(Logger *logger)   throw(FWException)
{
    char    str[2048];
    FILE    *fd;
    const char *argv[64];

    string::size_type b,e;
    unsigned          i;

    i=0;
    b=e=0;

    argv[i++]=cxx_strdup( command.c_str() );

    do 
    {
	b=args.find_first_not_of(" ",b);

	e=args.find(' ',b);
	if (e!=string::npos) {
	    argv[i++]=cxx_strdup( args.substr(b,e-b).c_str() );
	} else {
	    argv[i++]=cxx_strdup( args.substr(b).c_str() );
	}
	b=e+1;
    } while ( e!=string::npos && i<(sizeof(argv)/sizeof(char*))  );
    argv[i]=NULL;

  /* Side effect: our popen stores child's PID in pgm_pid */

//    if(access(command.c_str() , R_OK )!=0) {
//	set_pgm_status(-1);
//	throw FWException("Could not execute '"+command+"'");
//    }

    if ( (fd=popen(command.c_str(),argv,"r"))==NULL ) {
	set_pgm_status(-1);
	throw FWException("Could not execute '"+command+"'");
    }

    set_running_flag();

    while(fgets(str, sizeof(str)-1 , fd )!=NULL) 
    {
        BackgroundOp_data.push_back(str);
        *logger << str;

	usleep(500);

	// in case we should stop prematurely (user clicked the button)
	if(get_stop_program_flag()) 
        {
	    if (pgm_pid!=0) 
            {
		*logger << "Killing child program pid=" << pgm_pid << "\n";
		kill(pgm_pid,SIGKILL);
		pgm_pid=0;
	    }
            
	    break;
	}
    }

    set_pgm_status( pclose(fd) );
    pgm_pid=0;

    for (i=0; argv[i]!=NULL; i++)
	delete argv[i];
}

pthread_t ExecBgr::start_operation(ostream *logger, string c, string a)   throw(FWException)
{
    command = c;
    args    = a;

    if (command=="")    
        throw FWException("Empty command");

    *logger << "Executing '" << command << " " << args << "'\n";
     
    BackgroundOp_data.clear();

    return BackgroundOp::start_operation(logger);
}

int  ExecBgr::get_pgm_status()
{
    int ret;
    G_LOCK(pgm_status);
    ret=pgm_status;
    G_UNLOCK(pgm_status);
    return ret;
}

void  ExecBgr::set_pgm_status( int status )
{
    G_LOCK(pgm_status);
    pgm_status=status;
    G_UNLOCK(pgm_status);
}

int ExecBgr::get_str_num() 
{ 
    return BackgroundOp_data.size(); 
}

vector<string>::iterator  ExecBgr::begin()
{
    return(BackgroundOp_data.begin());
}

vector<string>::iterator  ExecBgr::end()
{
    return(BackgroundOp_data.end());
}

string ExecBgr::front()
{
    return( *BackgroundOp_data.begin() );
}







