/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ExecDialog.cc,v 1.5 2001/09/22 01:39:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"

#include "ExecDialog.hh"

using namespace libfwbuilder;



ExecDialog::ExecDialog(const string &cmplr, 
		       const string &a,
		       const string &f_name, 
		       const string &o_name,
		       const string &w_dir)
{
    compiler  = cmplr  ;
    args      = a      ;
    file_name = f_name ;
    obj_name  = o_name ;
    wdir      = w_dir  ;


    brd=manage(new BackgroundRunWidget(true) );
    add(*brd);

    set_usize(400,250);
    set_position(GTK_WIN_POS_CENTER);
    set_policy(true, true, false);

    show_all();
}

int ExecDialog::execute()
{
    string a;

    a="-f "+file_name;
    if(wdir!="") 
	a+=" -d "+wdir;

    a+=args;

    a+=" "+obj_name;

    /*
    if(args=="")      {
	args="-f "+file_name;
	if(wdir!="") 
            args+=" -d "+wdir;
	args+=" "+obj_name;
    }
    */
    
    try
    {
        brd->execute(compiler, a);

	Gtk::Main::grab_add(*this);
	Gtk::Main::run();
	Gtk::Main::grab_remove(*this);

        return 0;
    } catch(const FWException &ex)
    {
        return -1; //TODO: more meaningful number
    }
}







