/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWObjectDatabaseGUI.hh,v 1.6 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _FWOBJECTDATABASEGUI_HH
#define _FWOBJECTDATABASEGUI_HH

#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/Group.hh"
#include "fwbuilder/XMLTools.hh"

#include "MessageDialog.hh"

class libfwbuilder::Group;

class FWObjectDatabaseGUI : public libfwbuilder::FWObjectDatabase
{
    private:

    protected:

    public:

    static const string DB_TEMPLATE_FILE_NAME ;

    FWObjectDatabaseGUI();
    FWObjectDatabaseGUI(const string &filename) throw(libfwbuilder::FWException);

    virtual ~FWObjectDatabaseGUI();

    // --- XML import/export ---

    /**
     *   this is the main "Create" method:
     *   it creates instance of FWObject of given type
     */
    virtual libfwbuilder::FWObject *create(const string &type);
    
    // --- Load/Save ---
    
    virtual void save           (                       ) throw(libfwbuilder::FWException);
    virtual void load           (const string &f        ) throw(libfwbuilder::FWException);
    virtual void saveAs         (                       ) throw(libfwbuilder::FWException);
    virtual bool saveIfModified (                       ) throw(libfwbuilder::FWException);
    virtual void saveFile       (const string &filename ) throw(libfwbuilder::FWException);
    
    void                    copyToScratchPad();
    libfwbuilder::FWObject* getScratchCopy(libfwbuilder::FWObject *obj);

/*
 * the following methods create an object and put it in appropriate
 * place in the tree. Unlike FWObjectDatabase, class
 * FWObjectDatabaseGUI has knowledge of the tree structure used in
 * Firewall Builder; these methods enforce this knowlege
 */
    static libfwbuilder::FWObject*  newFirewall();
    static libfwbuilder::FWObject*  newHost();
    static libfwbuilder::FWObject*  newNetwork();
    static libfwbuilder::FWObject*  newObjectGroup();
    static libfwbuilder::FWObject*  newIPService();
    static libfwbuilder::FWObject*  newICMPService();
    static libfwbuilder::FWObject*  newTCPService();
    static libfwbuilder::FWObject*  newUDPService();
    static libfwbuilder::FWObject*  newCustomService();
    static libfwbuilder::FWObject*  newServiceGroup();
    static libfwbuilder::FWObject*  newInterval();

/**
 * This method checks if object obj can be placed in the tree branch
 * target.  This method uses knowledge about tree structure used in
 * Firewall builder
 *
 */
    static bool validateObjectForPositionInTree(libfwbuilder::FWObject* target,
						libfwbuilder::FWObject* obj);

/**
 * This method places new object obj in the tree branch designated by
 * ID "where_id", but first it checks if this object is appropriate in
 * that branch.  This method also creates a copy in scratch pad tree.
 */    
    static libfwbuilder::FWObject*  newObject(const string& where_id , 
					      libfwbuilder::FWObject *obj);



    static libfwbuilder::Group     *ScratchPad;
    
    static FWObjectDatabaseGUI* getInstance() { return  dynamic_cast<FWObjectDatabaseGUI*>(db); }

};

class MessageBoxUpgradePredicate: public libfwbuilder::XMLTools::UpgradePredicate
{
    public:
    virtual bool operator()(const string &msg) const 
    { 
        return MessageDialog::YesNo(msg)==MessageDialog::OK_YES;
    }
};

#endif











