/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FileSel.cc,v 1.7 2001/09/22 01:39:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <string>

#include "FileSel.hh"
#include "Preferences.hh"

using namespace libfwbuilder;


FileSel::FileSel(const string &title,const string &dir,const string &filext) : 
    Gtk::FileSelection(title)
{
    string  cmpl;

    if (dir!="")   cmpl=dir+"/"+filext;
    else           cmpl=filext;

    complete(cmpl);

//  set_filename("fwbuilder.xml");

    get_ok_button()->clicked.connect(slot(this, &FileSel::file_ok_sel));
    get_cancel_button()->clicked.connect(hide.slot());
    hide.connect(Gtk::Main::quit.slot());
    show();
}

string& FileSel::run()
{
  Gtk::Main::grab_add(*this);
  Gtk::Main::run();
  Gtk::Main::grab_remove(*this);
  return(file_choice);
}

void FileSel::file_ok_sel() 
{
  file_choice=get_filename();
  Gtk::Main::quit();
}
