/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: HostDialog.hh,v 1.11 2001/12/19 02:18:46 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _HOSTDIALOG_HH
#  include "HostDialog_glade.hh"
#  define _HOSTDIALOG_HH
#include "glademm_support.hh"

#include "fwbuilder/FWOptions.hh"


class IPAddressWidget;

class HostDialog : public HostDialog_glade
{   
        
    friend class HostDialog_glade;

    void on_dns_lookup();
    void on_changed();

    void on_new_if_clicked();
    void on_del_if_clicked();
    void on_snmp_get_clicked();
    void on_snmp_get_released();
    void on_snmp_get_descr_released();
    void on_edit_clicked();
    void on_if_list_select_row(gint row, gint column, GdkEvent *event);

    void showInterfaces();

    libfwbuilder::FWOptions* options;

    libfwbuilder::Interface* getSelectedInterface();
    libfwbuilder::Interface* getInterfaceByRow(int row);

    IPAddressWidget*   obj_addr;

    vector<class DialogOption> object_parameters;
    vector<class DialogOption> common_options;

public:

    HostDialog(libfwbuilder::FWObject *obj);

    virtual void wrk2dlg();
    virtual bool dlg2wrk();

};
#endif

