/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ListOfIcons.cc,v 1.26 2001/12/29 10:06:35 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "config.h"

#include "glademm_support.hh"

#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/FWReference.hh"
#include "BuiltinDialog.hh"
#include "ListOfIcons.hh"
#include "helpers.hh"

using namespace libfwbuilder;

/*
 *   this class uses my own widget IconList and adds support for some
 *   additional events to it (vk)
 */
ListOfIcons::ListOfIcons(gint icon_width ,gint icon_height,bool allow_popup_menu )
{
    set_icon_width( icon_width );
    set_icon_height( icon_height );
    popup=allow_popup_menu;
    show();
}

ListOfIcons::~ListOfIcons()
{
//    IconList::clear();
}


void ListOfIcons::set_data_changed_flag(bool flag)
{
    BuiltinDialog *b= (BuiltinDialog *)find_widget("BuiltinDialog",this);
    b->data_changed_flag(flag);
}

gint ListOfIcons::button_press_event_impl(GdkEventButton* ev)
{
    IconList::button_press_event_impl(ev);

    if ( ev->type==GDK_2BUTTON_PRESS && ev->button==1 && get_selected()>=0) 
	open_item( get_icon_data( get_selected() ) );    // this is signal

    return(true);
}


gint ListOfIcons::button_release_event_impl(GdkEventButton* ev)
{
    IconList::button_release_event_impl(ev);

    string   *id=NULL;
    
    if (get_selected()!=-1) 
	id=(string*)(get_icon_data( get_selected() ));

    if (id!=NULL && ev->type == GDK_BUTTON_RELEASE  && ev->button==3 ) {
	if (! popup ) return(true);   // popup menu disabled
    	popup_menu(id);
    }
    return(true);
}

gint ListOfIcons::key_press_event_impl(GdkEventKey* ev)
{
    IconList::key_press_event_impl(ev);

    if (ev->keyval==GDK_Return && get_selected()>=0)
	open_item( get_icon_data( get_selected() ) );    // this is signal

    return false;
}

void ListOfIcons::clear()
{
    IconList::clear();
}


gint ListOfIcons::getCount()
{
    return( IconList::get_size() );
}

void ListOfIcons::addObject(FWObject *obj)
{
    int            icn;

    if (obj==NULL) return;

    if ( ! checkObjectId( obj->getId() ) ) {

	icn=append( Resources::getXPMIconFileName(obj, "") , obj->getName() );

	// We return pointer to actuall string residing
	// within other object holding it's ID.
	// If this object is deleted, this string
	// becomes invalid.
	// We assume here that this would not happen, while
	// this dialogue is running.
	// (lord)
	set_icon_data(icn, (void*)&obj->getId());

    }
}

int  ListOfIcons::findIcon(const string& id)
{
    string id2;
    for (int i=0; i<getCount(); ++i) {
	id2=getObjectId(i);
	if (id==id2) return i;
    }
    return -1;
}

void ListOfIcons::removeObject(const string& id)
{
    int s=findIcon(id);
    assert(s!=-1);

    remove(s);
    select_icon(s-1);
}

bool     ListOfIcons::checkObjectId(const string& id)
{
    string id2;
    for (int i=0; i<getCount(); ++i) {
	id2=getObjectId(i);
	if (id==id2) return true;
    }
    return false;
}

string   ListOfIcons::getObjectId(int no)
{
    string     *id=(string*)(get_icon_data(no));
    if (id==NULL) return "";
    return (*id);
}


