/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: StandardRulesDruid.hh,v 1.20 2001/12/22 22:40:05 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _SR_DRUID_HH
#define _SR_DRUID_HH

#include "config.h"

#include "Druid.hh"

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/RuleElement.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/Interface.hh"

#include "ASDruidP05Dialog.hh"
#include "ASDruidP10Dialog.hh"
#include "ASDruidP11Dialog.hh"
#include "ASDruidP12Dialog.hh"
#include "ASDruidP20Dialog.hh"
#include "ASDruidP30Dialog.hh"
#include "ASDruidP40Dialog.hh"
#include "ASDruidP44Dialog.hh"
#include "ASDruidP47Dialog.hh"
#include "ASDruidP49Dialog.hh"

// #include "Interface.hh"


/*
 *    Druid for generation of anti-spoofing rules
 */


class StandardRulesDruid : public Druid {

    libfwbuilder::FWObject         *fw_object;
    string                          fw_id;

    ASDruidP05Dialog *p05;
    ASDruidP10Dialog *p10;
    ASDruidP11Dialog *p11;
    ASDruidP12Dialog *p12;
    ASDruidP20Dialog *p20;
    ASDruidP30Dialog *p30;
    ASDruidP40Dialog *p40;
    ASDruidP44Dialog *p44;
    ASDruidP47Dialog *p47;
    ASDruidP49Dialog *p49;

    int _fillRuleElement(libfwbuilder::RuleElement *rel,Gtk::CList *lst);
    int _fillRuleElementP20(libfwbuilder::RuleElement *rel);
    int _fillRuleElementP49net(libfwbuilder::RuleElement *rel);
    int _fillRuleElementP49dmz(libfwbuilder::RuleElement *rel);

    bool _checkObjectsList(Gtk::CList *lst);

    void _fillClistObjects(Gtk::CList &clist,
			   vector<libfwbuilder::FWObject*> &lst);
    void _fillClistInterfaces(Gtk::CList &clist,
			      libfwbuilder::Firewall *fw_object,
			      int  only_ext);

    libfwbuilder::Interface* findLoopbackInterface();
    libfwbuilder::Interface* findNonLoopbackInterface();

    void generateRulesForHostProtection();
    void generateRulesForNetProtection();
    void generateRulesForNetAndDMZProtection();

    public:

    StandardRulesDruid(const string &obj_id ,const string &t,const string& l);

    virtual gboolean on_next();
    virtual gboolean on_back();
    virtual gboolean on_cancel();
    virtual void     on_finish();


};


#endif
