/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TimeDialog.cc,v 1.13 2001/12/27 06:48:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

// generated 2000/12/16 13:26:54 PST by vadim@voyager.
// using glademm V0.5.9
//
// newer (non customized) versions of this file go to TimeDialog.cc_glade

// This file is for your program, I won't touch it again!

#include "TimeDialog.hh"
#include "fwbuilder/FWObject.hh"
#include "MessageDialog.hh"
#include "helpers.hh"

using namespace libfwbuilder;

TimeDialog::TimeDialog(FWObject *obj)
{
    object=obj;
}

void TimeDialog::wrk2dlg()
{
    name->set_text(object->getName());

    comment->set_point(0);
    comment->forward_delete( comment->get_length() );
    comment->insert(object->getComment());

    min1->set_value( object->getInt("from_minute"));
    hour1->set_value( object->getInt("from_hour"));
    day1->set_value( object->getInt("from_day"));
    month1->set_value( object->getInt("from_month"));
    year1->set_value( object->getInt("from_year"));
    dayofweek1->set_value( object->getInt("from_weekday"));

    min2->set_value( object->getInt("to_minute"));
    hour2->set_value( object->getInt("to_hour"));
    day2->set_value( object->getInt("to_day"));
    month2->set_value( object->getInt("to_month"));
    year2->set_value( object->getInt("to_year"));
    dayofweek2->set_value( object->getInt("to_weekday"));

}

bool TimeDialog::dlg2wrk()
{
/*
 *  check if name is valid
 */
    if ( ! checkObjectName(name->get_text()) ) return(false);

    object->setName( name->get_text() );
    object->setComment( comment->get_chars(0,comment->get_length()) );

    object->setInt( "from_minute"   ,   min1->get_value_as_int() );
    object->setInt( "from_hour"  ,   hour1->get_value_as_int() );
    object->setInt( "from_day"   ,   day1->get_value_as_int() );
    object->setInt( "from_month" ,   month1->get_value_as_int() );
    object->setInt( "from_year"  ,   year1->get_value_as_int() );
    object->setInt( "from_weekday" , dayofweek1->get_value_as_int() );

    object->setInt( "to_minute"   ,   min2->get_value_as_int() );
    object->setInt( "to_hour"  ,   hour2->get_value_as_int() );
    object->setInt( "to_day"   ,   day2->get_value_as_int() );
    object->setInt( "to_month" ,   month2->get_value_as_int() );
    object->setInt( "to_year"  ,   year2->get_value_as_int() );
    object->setInt( "to_weekday" , dayofweek2->get_value_as_int() );

    return(true);
}

void TimeDialog::on_changed()
{
  data_changed_flag(true);
}





