/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ipfilter.c,v 1.8 2001/05/29 21:32:09 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Puplic License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "ipfilter.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

FILE *ipf_file;
FILE *ipnat_file;

struct ipf_group {
    int  igroup_no,ogroup_no;
    char interface[64];
};

struct ipf_group groups[64];

int group_counter=100;
int total_subrules;

int   generate_input_output_groups_for_any=1;

const char* INPUT   = NULL;
const char* OUTPUT  = NULL;
const char* FORWARD = NULL;
const char* RETURN  = NULL;



char* createNewGroup(elementaryRule *erule , int temp_rule)
{
    char  str[1024];
    char *cp;
    
    sprintf(str,"%d",group_counter);
    group_counter++;

    cp=strdup(str);
    return cp;
}

void initializeStandardGroups()
{
    INPUT   = "1";
    OUTPUT  = "2";
    FORWARD = "3";
    RETURN  = "RETURN";
}


void prologue(xmlNodePtr firewall,xmlNodePtr fw_options)
{
    int        gr;
    char       iface[32],iaddr[32];
    xmlNodePtr c1;
    char       ipfFileName[256];
    char       ipnatFileName[256];


    generate_input_output_groups_for_any = 0; /* does not apply in ipfilter */
    

    strcpy(ipfFileName,"ipf.conf");
    strcpy(ipnatFileName,"ipnat.conf");
    
    
    if ( (ipf_file=fopen(ipfFileName,"w"))==NULL ||
	 (ipnat_file=fopen(ipnatFileName,"w"))==NULL ) {
	printf("Error: Could not open output files for writing\n");
	exit(1);
    }
/*
 *   find "external" interface or interfaces of the firewall. This
 *   version of compiler does not support multiple external interfaces
 * */
    gr=0;
    for (c1=firewall->xmlChildrenNode; c1; c1=c1->next) {
	strcpy(iface,"");

	if (isElement(c1,"Interface")) {
	    strcpy(iface,getName(c1));
	    strcpy(iaddr,getStr(c1,"address"));

	    fprintf(ipf_file,"#\n");
	    fprintf(ipf_file,"# Interface %s, incoming packets: group %s\n",
		    iface , INPUT);
	    fprintf(ipf_file,
		    "block in quick from any to %s head %s\n",iaddr,INPUT);

	    fprintf(ipf_file,"#\n");
	    fprintf(ipf_file,"# Interface %s, outgoig packets: group %s\n",
		    iface , OUTPUT);
	    fprintf(ipf_file,
		    "block out quick from %s to any head %s\n",iaddr,OUTPUT);
	}
    }

    fprintf(ipf_file,"#\n");
    fprintf(ipf_file,"# Forwarding packets: group %s\n", FORWARD);
    fprintf(ipf_file,
	    "block in quick from any to any head %s\n",FORWARD);
}


void epilogue(xmlNodePtr firewall,xmlNodePtr fw_options)
{
    fclose(ipf_file);
    fclose(ipnat_file);
}

void processSrcAndDst(xmlNodePtr obj,char *buff)
{
    char *addr, *netm;

    addr=xmlGetProp(obj,"address");
    netm=xmlGetProp(obj,"netmask");

    if (addr && strlen(addr)==0) return;
    
    if (isElement(obj,"Network")) {
	sprintf(buff,"%s mask %s",getStr(obj,"address"),getStr(obj,"netmask"));
	if (strcmp(buff,"0.0.0.0 mask 0.0.0.0")==0) strcpy(buff,"0/0");
	return;
    } 
    if (isAnyNetwork(obj)) {
	strcpy(buff,"0/0");
	return;
    }
    strcpy(buff,getStr(obj,"address") );

}

void processSrc(xmlNodePtr src,elementaryRule *erule)
{
    char str[80];

    processSrcAndDst(erule->src,str);
    erule->t->p_src=strdup(str);
}

void processDst(xmlNodePtr dst,elementaryRule *erule)
{
    char str[80];
    processSrcAndDst(erule->dst,str);
    erule->t->p_dst=strdup(str);
}


void processTCPorUDP(xmlNodePtr srv,elementaryRule *erule)
{
    char *n;
    char sps[32],spe[32],dps[32],dpe[32];
    char sports[64], dports[64];
    
    strcpy(sps,"");
    strcpy(spe,"");
    strcpy(dps,"");
    strcpy(dpe,"");
    strcpy(sports,"");
    strcpy(dports,"");

    if (isElement(erule->srv, "UDPService")) {
	erule->t->p_proto      = "udp";
    }
    
    if (isElement(erule->srv, "TCPService")) {
	erule->t->p_proto      = "tcp";
    }
    
    if (isElement(erule->srv, "TCP") || isElement(erule->srv, "UDP")) {
	n=xmlGetProp(erule->srv,"src_range_start");
	if (n && strcmp(n,"0")!=0) strcpy(sps,n);
	
	n=xmlGetProp(erule->srv,"src_range_end");
	if (n && strcmp(n,"0")!=0) strcpy(spe,n);

	n=xmlGetProp(erule->srv,"dst_range_start");
	if (n && strcmp(n,"0")!=0) strcpy(dps,n);

	n=xmlGetProp(erule->srv,"dst_range_end");
	if (n && strcmp(n,"0")!=0) strcpy(dpe,n);
    }

    if ( strlen(spe)!=0 ) {
	if ( strcmp(sps,spe)==0 )
	    sprintf(sports,"port = %s",sps);
	else
	    sprintf(sports,"port %s >< %s",sps,spe);
    }
    else
	if ( strlen(sps)!=0) sprintf(sports,"port = %s",sps);

    
    if ( strlen(dpe)!=0 ) {
	if (strcmp(dps,dpe)==0)
	    sprintf(dports,"port = %s",dps);
	else
	    sprintf(dports,"port %s >< %s",dps,dpe);
    }
    else
	if (strlen(dps)!=0) sprintf(dports,"port = %s",dps);

    erule->t->p_sprt=strdup(sports);
    erule->t->p_dprt=strdup(dports);
}

void processIP(xmlNodePtr srv,elementaryRule *erule)
{
    erule->t->p_proto = strdup( getStr(erule->srv,"protocol_num") );

    if (getBool(erule->srv,"fragm"))       addOptionCode(erule->t,"with fragm");
    if (getBool(erule->srv,"short_fragm")) addOptionCode(erule->t,"with short");
}


void processICMP(xmlNodePtr srv,elementaryRule *erule)
{
    erule->t->p_proto      = "icmp";
    erule->t->p_icmp_type  = strdup( getStr(erule->srv,"type") );
    erule->t->p_icmp_code  = strdup( getStr(erule->srv,"type") );
}




void processNATRule(xmlNodePtr firewall,
			   xmlNodePtr rule,
			   const char *comment,
			   GSList    *subrules)
{
}





