/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: listOfLibraries.cpp,v 1.10 2004/08/23 02:34:50 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/FWObjectDatabase.h"

#include "FWBSettings.h"
#include "upgradePredicate.h"
#include "listOfLibraries.h"

#include "qobject.h"
#include <qdir.h>
#include <qfile.h>

#include <iostream>

using namespace std;
using namespace libfwbuilder;

listOfLibraries::listOfLibraries()
{
// build list of available libraries

/* first read user's preferences. User may want to load some libraries
 * that we usually find but do not load by default (e.g. templates)
 */

    add(sysfname,true);
    add(tempfname);

#ifdef _WIN32
    QString dir = appRootDir + "/lib";
#else
    QString dir = QString(getenv("HOME")) + "/.fwbuilder/lib";
#endif

    QDir d(dir, "*.fwb" );
    for (unsigned int i=0; i<d.count(); ++i)
        add( (dir + "/" + d[i]).latin1() );

    load();
}

void listOfLibraries::load()
{
    int N = st->getInt("Libraries/num");
    for (int i=0; i<N; ++i)
    {
        QString lp;
        QString s;
        bool    l;

        lp = QString("Libraries/lib%1_path").arg(i);
        s = st->getStr( lp );

        lp = QString("Libraries/lib%1_load").arg(i);
        l = st->getBool( lp );

        add( s.latin1() , l );
    }
}

void listOfLibraries::save()
{
    st->setInt("Libraries/num", size() );

    int n = 0;
    for (list<libData>::iterator i=begin(); i!=end(); ++i,++n)
    {
        QString lp;

        lp = QString("Libraries/lib%1_path").arg(n);
        st->setStr( lp , i->path.c_str() );

        lp = QString("Libraries/lib%1_load").arg(n);
        st->setBool( lp , i->load );
    }
}

class findPathPredicate {
    string p;
    public:
    findPathPredicate(const string &_p):p(_p){}
    bool operator()(const libData &ld) { return ld.path==p; }
};

class findNamePredicate {
    string p;
    public:
    findNamePredicate(const string &_p):p(_p){}
    bool operator()(const libData &ld) { return ld.name==p; }
};

class findIdPredicate {
    string p;
    public:
    findIdPredicate(const string &_p):p(_p){}
    bool operator()(const libData &ld) { return ld.id==p; }
};

list<libData>::iterator listOfLibraries::add(const string &path, bool load)
{
    string name;
    string id;

//    for (list<libData>::iterator i=begin(); i!=end(); ++i)
//        if (i->path == path) return i;

    list<libData>::iterator it;
    if ( (it=std::find_if(begin(),end(),findPathPredicate(path)))!=end())
        return it;

    if ( ! QFile::exists(path.c_str()) ) return end();

/* need to read library file to get library name and ID should not use
 * FWObjectDatabase::load because the library may be from the old
 * version and may need to be upgraded, but if it is in RCS, then
 * upgrade procedure just creates writable file instead of proper RCS
 * checkout 
 */
#if 0
    MessageBoxUpgradePredicate upgrade_predicate;

    FWObjectDatabase *ndb = new FWObjectDatabase();
    ndb->load( path, &upgrade_predicate,librespath);
    FWObject *lib=ndb->getFirstByType(Library::TYPENAME);
    if (lib==NULL)
    {
        QMessageBox::critical(
            NULL,"Firewall Builder", 
            QObject::tr("Library file %1 is corrupted.").arg(path.c_str()),
            "&Continue", QString::null, QString::null,
            0, 1 );
        return end();
    }
    name=lib->getName();
    id  =lib->getId();
#endif

    QFile lf(path.c_str());
    if ( lf.open( IO_ReadOnly) )
    {
        QTextStream lfs(&lf);
        QString     s;
        while ( !lfs.eof() )
        {
            s = lfs.readLine();

            if ( s.find( "<Library ", 0)>=0 )
            {
                int i1 = s.find( "name=\"", 0 );
                if (i1<0) continue;
                i1 += 6;
                int i2 = s.find( "\"", i1 );
                name = s.mid(i1,i2-i1).latin1();

                i1 = s.find( "id=\"", 0 );
                if (i1<0) continue;
                i1 += 4;
                i2 = s.find( "\"", i1 );
                id = s.mid(i1,i2-i1).latin1();

                break;
            }
        }
        lf.close();
    }

    if (id == STANDARD_LIB) return end();
    if (id == DELETED_LIB)  return end();

//    for (list<libData>::iterator i=begin(); i!=end(); ++i)
//    {
//        if (i->id == id )  return i;
//    }

    if ( (it=std::find_if(begin(),end(),findIdPredicate(id)))!=end())
        return it;

    list<libData>::iterator i1=insert(end(),libData( id, name, path, false) );
    i1->load=load;

    return i1;
}

void listOfLibraries::setLoad(const string &libPath, bool f)
{
//    for (list<libData>::iterator i=begin(); i!=end(); ++i)
//    {
//        if (i->path == libPath) { i->load=f; break; }
//    }
    list<libData>::iterator it;
    if ( (it=std::find_if(begin(),end(),findPathPredicate(libPath)))!=end())
        it->load=f;
}

bool listOfLibraries::getLoad(const string &libPath)
{
//    for (list<libData>::iterator i=begin(); i!=end(); ++i)
//    {
//        if (i->path == libPath) { return (i->load); }
//    }

    list<libData>::iterator it;
    if ( (it=std::find_if(begin(),end(),findPathPredicate(libPath)))!=end())
        return it->load;

    return false;
}

bool listOfLibraries::isLoaded(const string &libName)
{
//    for (list<libData>::iterator i=begin(); i!=end(); ++i)
//    {
//        if (i->name == libName ) { return (i->load); }
//    }

    list<libData>::iterator it;
    if ( (it=std::find_if(begin(),end(),findNamePredicate(libName)))!=end())
        return it->load;

    return false;
}

bool listOfLibraries::isKnown(const string &id)
{
//    for (list<libData>::iterator i=begin(); i!=end(); ++i)
//    {
//        if (i->id == id ) return true;
//    }

    list<libData>::iterator it;
    if ( (it=std::find_if(begin(),end(),findIdPredicate(id)))!=end())
        return it->load;

    return false;
}

