#ifndef __SUPPORT_H__
#define __SUPPORT_H__

#include <config.h>

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#include <stdlib.h>

/*
 *
 * Global variables
 *
 */

extern char *program_name;

/*
 *
 * Scalar datatypes
 *
 */
 
/* bool:
 * Boolean type (use TRUE and FALSE).
 */
typedef int8_t bool;

/* FALSE:
 * TRUE:
 * Boolean values.
 */
#define FALSE	    0
#define TRUE	    (!FALSE)

/* BOOL_TO_INT:
 * INT_TO_BOOL:
 * The correct way to transform a bool to an int or the other way.
 */
#define BOOL_TO_INT(b)	    ((b) ? 1 : 0)
#define INT_TO_BOOL(b)	    ((b) == 0 ? FALSE : TRUE)

/*
 *
 * Function declarations
 *
 */

void xasprintf(char **result, char *format, ...);
bool xstrtoi(char *str, int *result);
char *xstrdup(char *str);
void *xmalloc(size_t size);
void *xrealloc(void *memory, size_t size);
void assert_memory(bool expression);
char lastchar(char *str);
int ilog2l(long value);
bool bad_offset(void *memory, size_t total_size, void *offset, size_t size);
bool is_directory(char *filename);
void put_error(char *format, ...);
unsigned int vec(char *vector, int offset, int size);

#endif /* __SUPPORT_H__ */
